# mypy-boto3-codeguru-reviewer

Mypy-friendly auto-generated type annotations for `boto3 codeguru-reviewer 1.10.34` service.
More information can be found [here](https://github.com/vemel/mypy_boto3).

- [mypy-boto3-codeguru-reviewer](#mypy-boto3-codeguru-reviewer)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `codeguru-reviewer` service.

```bash
pip install boto3-stubs[mypy-boto3-codeguru-reviewer]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking.

```python
import boto3

from mypy_boto3 import codeguru_reviewer
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_codeguru_reviewer as codeguru_reviewer

# Use this client as usual, now mypy can check if your code is valid.
client: codeguru_reviewer.Client = boto3.client("codeguru-reviewer")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: codeguru_reviewer.Client = session.client("codeguru-reviewer")


# Paginators need type annotation on creation
list_repository_associations_paginator: codeguru_reviewer.ListRepositoryAssociationsPaginator = client.get_paginator("list_repository_associations")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- Latest version of `boto3` is used.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from latest documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Code is processed by [black](https://github.com/psf/black) for readability.

## Submodules

- `master` - Install `mypy-boto3` package.