# Version: 6.1
# Architecture: amd64
import vstruct
from vstruct.primitives import *

ETW_THREAD_FLAG = v_enum()
ETW_THREAD_FLAG.ETW_THREAD_FLAG_HAD_INPUT = 0
ETW_THREAD_FLAG.ETW_THREAD_FLAG_HAD_VISIBLE_WINDOWS = 1
ETW_THREAD_FLAG.ETW_THREAD_FLAG_HAS_NEW_INPUT = 2
ETW_THREAD_FLAG.ETW_THREAD_FLAG_MAX = 3


TOUCHSTATE = v_enum()
TOUCHSTATE.TOUCHSTATE_INVALID = -1
TOUCHSTATE.TOUCHSTATE_NONE = 0
TOUCHSTATE.TOUCHSTATE_DOWN = 1
TOUCHSTATE.TOUCHSTATE_MOVE = 2
TOUCHSTATE.TOUCHSTATE_UPOUTOFRANGE = 3
TOUCHSTATE.TOUCHSTATE_INAIR = 4
TOUCHSTATE.TOUCHSTATE_INAIRMOVE = 5
TOUCHSTATE.TOUCHSTATE_INAIROUTOFRANGE = 6
TOUCHSTATE.TOUCHSTATE_COUNT = 7


PS_STD_HANDLE_STATE = v_enum()
PS_STD_HANDLE_STATE.PsNeverDuplicate = 0
PS_STD_HANDLE_STATE.PsRequestDuplicate = 1
PS_STD_HANDLE_STATE.PsAlwaysDuplicate = 2
PS_STD_HANDLE_STATE.PsMaxStdHandleStates = 3


WHEA_ERROR_SEVERITY = v_enum()
WHEA_ERROR_SEVERITY.WheaErrSevRecoverable = 0
WHEA_ERROR_SEVERITY.WheaErrSevFatal = 1
WHEA_ERROR_SEVERITY.WheaErrSevCorrected = 2
WHEA_ERROR_SEVERITY.WheaErrSevInformational = 3


D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED = v_enum()
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_UNINITIALIZED = 0
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_HD15 = 1
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_DVI = 2
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_HDMI = 3
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_HDMI2 = 4
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_SVIDEO_4PIN = 5
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_SVIDEO_7PIN = 6
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_RCA_COMPOSITE = 7
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_RCA_3COMPONENT = 8
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_BNC = 9
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_RF = 10
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_SDTVDONGLE = 11
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_INTERNAL = 12
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY_DEPRECATED.D3DKMDT_VOT_DEPRECATED_OTHER = 255


D3DKMDT_MONITOR_FREQUENCY_RANGE_CONSTRAINT = v_enum()
D3DKMDT_MONITOR_FREQUENCY_RANGE_CONSTRAINT.D3DKMDT_MFRC_UNINITIALIZED = 0
D3DKMDT_MONITOR_FREQUENCY_RANGE_CONSTRAINT.D3DKMDT_MFRC_ACTIVESIZE = 1
D3DKMDT_MONITOR_FREQUENCY_RANGE_CONSTRAINT.D3DKMDT_MFRC_MAXPIXELRATE = 2


WOW64_SHARED_INFORMATION = v_enum()
WOW64_SHARED_INFORMATION.SharedNtdll32LdrInitializeThunk = 0
WOW64_SHARED_INFORMATION.SharedNtdll32KiUserExceptionDispatcher = 1
WOW64_SHARED_INFORMATION.SharedNtdll32KiUserApcDispatcher = 2
WOW64_SHARED_INFORMATION.SharedNtdll32KiUserCallbackDispatcher = 3
WOW64_SHARED_INFORMATION.SharedNtdll32LdrHotPatchRoutine = 4
WOW64_SHARED_INFORMATION.SharedNtdll32ExpInterlockedPopEntrySListFault = 5
WOW64_SHARED_INFORMATION.SharedNtdll32ExpInterlockedPopEntrySListResume = 6
WOW64_SHARED_INFORMATION.SharedNtdll32ExpInterlockedPopEntrySListEnd = 7
WOW64_SHARED_INFORMATION.SharedNtdll32RtlUserThreadStart = 8
WOW64_SHARED_INFORMATION.SharedNtdll32pQueryProcessDebugInformationRemote = 9
WOW64_SHARED_INFORMATION.SharedNtdll32EtwpNotificationThread = 10
WOW64_SHARED_INFORMATION.SharedNtdll32BaseAddress = 11
WOW64_SHARED_INFORMATION.Wow64SharedPageEntriesCount = 12


REG_NOTIFY_CLASS = v_enum()
REG_NOTIFY_CLASS.RegNtDeleteKey = 0
REG_NOTIFY_CLASS.RegNtPreDeleteKey = 0
REG_NOTIFY_CLASS.RegNtSetValueKey = 1
REG_NOTIFY_CLASS.RegNtPreSetValueKey = 1
REG_NOTIFY_CLASS.RegNtDeleteValueKey = 2
REG_NOTIFY_CLASS.RegNtPreDeleteValueKey = 2
REG_NOTIFY_CLASS.RegNtSetInformationKey = 3
REG_NOTIFY_CLASS.RegNtPreSetInformationKey = 3
REG_NOTIFY_CLASS.RegNtRenameKey = 4
REG_NOTIFY_CLASS.RegNtPreRenameKey = 4
REG_NOTIFY_CLASS.RegNtEnumerateKey = 5
REG_NOTIFY_CLASS.RegNtPreEnumerateKey = 5
REG_NOTIFY_CLASS.RegNtEnumerateValueKey = 6
REG_NOTIFY_CLASS.RegNtPreEnumerateValueKey = 6
REG_NOTIFY_CLASS.RegNtQueryKey = 7
REG_NOTIFY_CLASS.RegNtPreQueryKey = 7
REG_NOTIFY_CLASS.RegNtQueryValueKey = 8
REG_NOTIFY_CLASS.RegNtPreQueryValueKey = 8
REG_NOTIFY_CLASS.RegNtQueryMultipleValueKey = 9
REG_NOTIFY_CLASS.RegNtPreQueryMultipleValueKey = 9
REG_NOTIFY_CLASS.RegNtPreCreateKey = 10
REG_NOTIFY_CLASS.RegNtPostCreateKey = 11
REG_NOTIFY_CLASS.RegNtPreOpenKey = 12
REG_NOTIFY_CLASS.RegNtPostOpenKey = 13
REG_NOTIFY_CLASS.RegNtKeyHandleClose = 14
REG_NOTIFY_CLASS.RegNtPreKeyHandleClose = 14
REG_NOTIFY_CLASS.RegNtPostDeleteKey = 15
REG_NOTIFY_CLASS.RegNtPostSetValueKey = 16
REG_NOTIFY_CLASS.RegNtPostDeleteValueKey = 17
REG_NOTIFY_CLASS.RegNtPostSetInformationKey = 18
REG_NOTIFY_CLASS.RegNtPostRenameKey = 19
REG_NOTIFY_CLASS.RegNtPostEnumerateKey = 20
REG_NOTIFY_CLASS.RegNtPostEnumerateValueKey = 21
REG_NOTIFY_CLASS.RegNtPostQueryKey = 22
REG_NOTIFY_CLASS.RegNtPostQueryValueKey = 23
REG_NOTIFY_CLASS.RegNtPostQueryMultipleValueKey = 24
REG_NOTIFY_CLASS.RegNtPostKeyHandleClose = 25
REG_NOTIFY_CLASS.RegNtPreCreateKeyEx = 26
REG_NOTIFY_CLASS.RegNtPostCreateKeyEx = 27
REG_NOTIFY_CLASS.RegNtPreOpenKeyEx = 28
REG_NOTIFY_CLASS.RegNtPostOpenKeyEx = 29
REG_NOTIFY_CLASS.RegNtPreFlushKey = 30
REG_NOTIFY_CLASS.RegNtPostFlushKey = 31
REG_NOTIFY_CLASS.RegNtPreLoadKey = 32
REG_NOTIFY_CLASS.RegNtPostLoadKey = 33
REG_NOTIFY_CLASS.RegNtPreUnLoadKey = 34
REG_NOTIFY_CLASS.RegNtPostUnLoadKey = 35
REG_NOTIFY_CLASS.RegNtPreQueryKeySecurity = 36
REG_NOTIFY_CLASS.RegNtPostQueryKeySecurity = 37
REG_NOTIFY_CLASS.RegNtPreSetKeySecurity = 38
REG_NOTIFY_CLASS.RegNtPostSetKeySecurity = 39
REG_NOTIFY_CLASS.RegNtCallbackObjectContextCleanup = 40
REG_NOTIFY_CLASS.RegNtPreRestoreKey = 41
REG_NOTIFY_CLASS.RegNtPostRestoreKey = 42
REG_NOTIFY_CLASS.RegNtPreSaveKey = 43
REG_NOTIFY_CLASS.RegNtPostSaveKey = 44
REG_NOTIFY_CLASS.RegNtPreReplaceKey = 45
REG_NOTIFY_CLASS.RegNtPostReplaceKey = 46
REG_NOTIFY_CLASS.MaxRegNtNotifyClass = 47


DEVICE_RELATION_TYPE = v_enum()
DEVICE_RELATION_TYPE.BusRelations = 0
DEVICE_RELATION_TYPE.EjectionRelations = 1
DEVICE_RELATION_TYPE.PowerRelations = 2
DEVICE_RELATION_TYPE.RemovalRelations = 3
DEVICE_RELATION_TYPE.TargetDeviceRelation = 4
DEVICE_RELATION_TYPE.SingleBusRelations = 5
DEVICE_RELATION_TYPE.TransportRelations = 6


D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_TYPE = v_enum()
D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_TYPE.D3DKMDT_VPPMT_UNINITIALIZED = 0
D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_TYPE.D3DKMDT_VPPMT_NOPROTECTION = 1
D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_TYPE.D3DKMDT_VPPMT_MACROVISION_APSTRIGGER = 2
D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_TYPE.D3DKMDT_VPPMT_MACROVISION_FULLSUPPORT = 3
D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_TYPE.D3DKMDT_VPPMT_NOTSPECIFIED = 255


IO_ALLOCATION_ACTION = v_enum()
IO_ALLOCATION_ACTION.KeepObject = 1
IO_ALLOCATION_ACTION.DeallocateObject = 2
IO_ALLOCATION_ACTION.DeallocateObjectKeepRegisters = 3


_unnamed_13236 = v_enum()
_unnamed_13236.DMM_DIAG_INFO_VISTA_BETA2_VERSION = 4097
_unnamed_13236.DMM_DIAG_INFO_VISTA_RC1_VERSION = 4098
_unnamed_13236.DMM_DIAG_INFO_VISTA_RTM_VERSION = 4099
_unnamed_13236.DMM_DIAG_INFO_WIN7_MQ_VERSION = 8192
_unnamed_13236.DMM_DIAG_INFO_WIN7_M3_VERSION = 8193
_unnamed_13236.DMM_DIAG_INFO_VERSION = 8193


BUS_QUERY_ID_TYPE = v_enum()
BUS_QUERY_ID_TYPE.BusQueryDeviceID = 0
BUS_QUERY_ID_TYPE.BusQueryHardwareIDs = 1
BUS_QUERY_ID_TYPE.BusQueryCompatibleIDs = 2
BUS_QUERY_ID_TYPE.BusQueryInstanceID = 3
BUS_QUERY_ID_TYPE.BusQueryDeviceSerialNumber = 4
BUS_QUERY_ID_TYPE.BusQueryContainerID = 5


PROFILE_MAP = v_enum()
PROFILE_MAP.PMAP_COLORS = 0
PROFILE_MAP.PMAP_CURSORS = 1
PROFILE_MAP.PMAP_WINDOWSM = 2
PROFILE_MAP.PMAP_WINDOWSU = 3
PROFILE_MAP.PMAP_DESKTOP = 4
PROFILE_MAP.PMAP_ICONS = 5
PROFILE_MAP.PMAP_FONTS = 6
PROFILE_MAP.PMAP_TRUETYPE = 7
PROFILE_MAP.PMAP_KBDLAYOUT = 8
PROFILE_MAP.PMAP_INPUT = 9
PROFILE_MAP.PMAP_SUBSYSTEMS = 10
PROFILE_MAP.PMAP_BEEP = 11
PROFILE_MAP.PMAP_MOUSE = 12
PROFILE_MAP.PMAP_KEYBOARD = 13
PROFILE_MAP.PMAP_STICKYKEYS = 14
PROFILE_MAP.PMAP_KEYBOARDRESPONSE = 15
PROFILE_MAP.PMAP_MOUSEKEYS = 16
PROFILE_MAP.PMAP_TOGGLEKEYS = 17
PROFILE_MAP.PMAP_TIMEOUT = 18
PROFILE_MAP.PMAP_SOUNDSENTRY = 19
PROFILE_MAP.PMAP_SHOWSOUNDS = 20
PROFILE_MAP.PMAP_AEDEBUG = 21
PROFILE_MAP.PMAP_NETWORK = 22
PROFILE_MAP.PMAP_METRICS = 23
PROFILE_MAP.PMAP_UKBDLAYOUT = 24
PROFILE_MAP.PMAP_UKBDLAYOUTTOGGLE = 25
PROFILE_MAP.PMAP_WINLOGON = 26
PROFILE_MAP.PMAP_KEYBOARDPREF = 27
PROFILE_MAP.PMAP_SCREENREADER = 28
PROFILE_MAP.PMAP_HIGHCONTRAST = 29
PROFILE_MAP.PMAP_IMECOMPAT = 30
PROFILE_MAP.PMAP_IMM = 31
PROFILE_MAP.PMAP_POOLLIMITS = 32
PROFILE_MAP.PMAP_COMPAT32 = 33
PROFILE_MAP.PMAP_SETUPPROGRAMNAMES = 34
PROFILE_MAP.PMAP_INPUTMETHOD = 35
PROFILE_MAP.PMAP_MOUCLASS_PARAMS = 36
PROFILE_MAP.PMAP_KBDCLASS_PARAMS = 37
PROFILE_MAP.PMAP_COMPUTERNAME = 38
PROFILE_MAP.PMAP_TS = 39
PROFILE_MAP.PMAP_TABLETPC = 40
PROFILE_MAP.PMAP_MEDIACENTER = 41
PROFILE_MAP.PMAP_TS_EXCLUDE_DESKTOP_VERSION = 42
PROFILE_MAP.PMAP_WOW64_COMPAT32 = 43
PROFILE_MAP.PMAP_WOW64_IMECOMPAT = 44
PROFILE_MAP.PMAP_SERVERR2 = 45
PROFILE_MAP.PMAP_STARTER = 46
PROFILE_MAP.PMAP_ACCESS = 47
PROFILE_MAP.PMAP_AUDIODESCRIPTION = 48
PROFILE_MAP.PMAP_CONTROL = 49
PROFILE_MAP.PMAP_LAST = 49


NT_PRODUCT_TYPE = v_enum()
NT_PRODUCT_TYPE.NtProductWinNt = 1
NT_PRODUCT_TYPE.NtProductLanManNt = 2
NT_PRODUCT_TYPE.NtProductServer = 3


DMM_VIDPNCHANGE_TYPE = v_enum()
DMM_VIDPNCHANGE_TYPE.DMM_CVR_UNINITIALIZED = 0
DMM_VIDPNCHANGE_TYPE.DMM_CVR_UPDATEMODALITY = 1
DMM_VIDPNCHANGE_TYPE.DMM_CVR_ADDPATH = 2
DMM_VIDPNCHANGE_TYPE.DMM_CVR_ADDPATHS = 3
DMM_VIDPNCHANGE_TYPE.DMM_CVR_REMOVEPATH = 4
DMM_VIDPNCHANGE_TYPE.DMM_CVR_REMOVEALLPATHS = 5


DEVICE_POWER_STATE = v_enum()
DEVICE_POWER_STATE.PowerDeviceUnspecified = 0
DEVICE_POWER_STATE.PowerDeviceD0 = 1
DEVICE_POWER_STATE.PowerDeviceD1 = 2
DEVICE_POWER_STATE.PowerDeviceD2 = 3
DEVICE_POWER_STATE.PowerDeviceD3 = 4
DEVICE_POWER_STATE.PowerDeviceMaximum = 5


WHEA_ERROR_SOURCE_TYPE = v_enum()
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeMCE = 0
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeCMC = 1
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeCPE = 2
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeNMI = 3
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypePCIe = 4
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeGeneric = 5
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeINIT = 6
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeBOOT = 7
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeSCIGeneric = 8
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeIPFMCA = 9
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeIPFCMC = 10
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeIPFCPE = 11
WHEA_ERROR_SOURCE_TYPE.WheaErrSrcTypeMax = 12


DXGK_DIAG_CODE_POINT_TYPE = v_enum()
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_NONE = 0
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_RECOMMEND_FUNC_VIDPN = 1
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_OS_RECOMMENDED_VIDPN = 2
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_SDC_LOG_FAILURE = 3
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_SDC_INVALIDATE_ERROR = 4
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CDS_LOG_FAILURE = 5
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CDS_FAILURE_DB = 7
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_RETRIEVE_BTL = 8
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_RETRIEVE_DB = 9
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_QDC_LOG_FAILURE = 10
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_POWER_ON_GDI = 11
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_POWER_OFF_GDI = 12
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_POWER_ON_MONITOR = 13
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_POWER_OFF_MONITOR = 14
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_POWER_DIM_MONITOR = 15
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_POWER_UNDIM_MONITOR = 16
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_BACKTRACK = 17
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_CLOSEST_TARGET_MODE = 18
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_NO_EXACT_SOURCE_MODE = 19
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_NO_EXACT_TARGET_MODE = 20
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_SOURCE_MODE_NOT_PINNED = 21
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_TARGET_MODE_NOT_PINNED = 22
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_RESTARTED = 23
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_TDR = 24
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_ACPI_EVENT_NOTIFICATION = 25
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CREATEMDEV_USE_DEFAULT_MODE = 26
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CONNECTED_SET_LOG_FAILURE = 27
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_INVALIDATE_DXGK_MODE_CACHE = 28
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_REBUILD_DXGK_MODE_CACHE = 29
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CREATEFUNVIDPN_RELAX_REFRESH_MATCH = 30
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CREATEFUNVIDPN_CCDBML_FAIL_VISTABML_SUCCESSED = 31
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_BEST_SOURCE_MODE = 32
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_BML_BEST_TARGET_MODE = 33
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_ADD_DEVICE = 34
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_START_ADAPTER = 35
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_STOP_ADAPTER = 36
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CHILD_POLLING = 37
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CHILD_POLLING_TARGET = 38
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_INDICATE_CHILD_STATUS = 39
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_HANDLE_IRP = 40
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CHANGE_UNSUPPORTED_MONITOR_MODE_FLAG = 41
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_ACPI_NOTIFY_CALLBACK = 42
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_EXCLUDE_EVICTALL_DISABLEGDI = 43
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_EXCLUDE_EVICTALL_ENABLEGDI = 44
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_EXCLUDE_MODESWITCH = 45
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_SYNC_MONITOR_EVENT = 46
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_PNP_NOTIFY_GDI = 47
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_PNP_ENABLE_VGA = 48
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_TDR_SWITCH_GDI = 49
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_CREATE_DEVICE_FAILED = 50
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_DEVICE_REMOVED = 51
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_DRVASSERTMODE_TRUE_FAILED = 52
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_RECREATE_DEVICE_FAILED = 53
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CDD_MAPSHADOWBUFFER_FAILED = 54
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_COMMIT_VIDPN_LOG_FAILURE = 55
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_DRIVER_RECOMMEND_LOG_FAILURE = 56
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_SDC_ENFORCED_CLONE_PATH_INVALID_SOURCE_IDX = 57
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_DRVPROBEANDCAPTURE_FAILED = 58
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_DXGKCDDENABLE_OPTIMIZED_MODE_CHANGE = 59
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_DXGKSETDISPLAYMODE_OPTIMIZED_MODE_CHANGE = 60
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_MON_DEPART_GETRECENTTOP_FAIL = 61
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_MON_ARRIVE_INC_ADD_FAIL = 62
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CCD_DATABASE_PERSIST = 63
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_CCD_DATABASE_PERSIST_NO_CONNECTIVITY_HASH = 64
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_MAX = 64
DXGK_DIAG_CODE_POINT_TYPE.DXGK_DIAG_CODE_POINT_TYPE_FORCE_UINT32 = -1


DMM_VIDPN_MONITOR_TYPE = v_enum()
DMM_VIDPN_MONITOR_TYPE.DMM_VMT_UNINITIALIZED = 0
DMM_VIDPN_MONITOR_TYPE.DMM_VMT_PHYSICAL_MONITOR = 1
DMM_VIDPN_MONITOR_TYPE.DMM_VMT_BOOT_PERSISTENT_MONITOR = 2
DMM_VIDPN_MONITOR_TYPE.DMM_VMT_PERSISTENT_MONITOR = 3
DMM_VIDPN_MONITOR_TYPE.DMM_VMT_TEMPORARY_MONITOR = 4
DMM_VIDPN_MONITOR_TYPE.DMM_VMT_SIMULATED_MONITOR = 5


D3DDDI_VIDEO_SIGNAL_SCANLINE_ORDERING = v_enum()
D3DDDI_VIDEO_SIGNAL_SCANLINE_ORDERING.D3DDDI_VSSLO_UNINITIALIZED = 0
D3DDDI_VIDEO_SIGNAL_SCANLINE_ORDERING.D3DDDI_VSSLO_PROGRESSIVE = 1
D3DDDI_VIDEO_SIGNAL_SCANLINE_ORDERING.D3DDDI_VSSLO_INTERLACED_UPPERFIELDFIRST = 2
D3DDDI_VIDEO_SIGNAL_SCANLINE_ORDERING.D3DDDI_VSSLO_INTERLACED_LOWERFIELDFIRST = 3
D3DDDI_VIDEO_SIGNAL_SCANLINE_ORDERING.D3DDDI_VSSLO_OTHER = 255


D3DKMDT_MONITOR_ORIENTATION = v_enum()
D3DKMDT_MONITOR_ORIENTATION.D3DKMDT_MO_UNINITIALIZED = 0
D3DKMDT_MONITOR_ORIENTATION.D3DKMDT_MO_0DEG = 1
D3DKMDT_MONITOR_ORIENTATION.D3DKMDT_MO_90DEG = 2
D3DKMDT_MONITOR_ORIENTATION.D3DKMDT_MO_180DEG = 3
D3DKMDT_MONITOR_ORIENTATION.D3DKMDT_MO_270DEG = 4


D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY = v_enum()
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_UNINITIALIZED = -2
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_OTHER = -1
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_HD15 = 0
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_SVIDEO = 1
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_COMPOSITE_VIDEO = 2
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_COMPONENT_VIDEO = 3
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_DVI = 4
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_HDMI = 5
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_LVDS = 6
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_D_JPN = 8
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_SDI = 9
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_DISPLAYPORT_EXTERNAL = 10
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_DISPLAYPORT_EMBEDDED = 11
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_UDI_EXTERNAL = 12
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_UDI_EMBEDDED = 13
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_SDTVDONGLE = 14
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_INTERNAL = -2147483648
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_SVIDEO_4PIN = 1
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_SVIDEO_7PIN = 1
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_RF = 2
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_RCA_3COMPONENT = 3
D3DKMDT_VIDEO_OUTPUT_TECHNOLOGY.D3DKMDT_VOT_BNC = 3


PS_CREATE_STATE = v_enum()
PS_CREATE_STATE.PsCreateInitialState = 0
PS_CREATE_STATE.PsCreateFailOnFileOpen = 1
PS_CREATE_STATE.PsCreateFailOnSectionCreate = 2
PS_CREATE_STATE.PsCreateFailExeFormat = 3
PS_CREATE_STATE.PsCreateFailMachineMismatch = 4
PS_CREATE_STATE.PsCreateFailExeName = 5
PS_CREATE_STATE.PsCreateSuccess = 6
PS_CREATE_STATE.PsCreateMaximumStates = 7


EVENT_TYPE = v_enum()
EVENT_TYPE.NotificationEvent = 0
EVENT_TYPE.SynchronizationEvent = 1


D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE = v_enum()
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_UNINITIALIZED = 0
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_PRIMARY = 1
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_SECONDARY = 2
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_TERTIARY = 3
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_QUATERNARY = 4
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_QUINARY = 5
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_SENARY = 6
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_SEPTENARY = 7
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_OCTONARY = 8
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_NONARY = 9
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_DENARY = 10
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_MAX = 32
D3DKMDT_VIDPN_PRESENT_PATH_IMPORTANCE.D3DKMDT_VPPI_NOTSPECIFIED = 255


PS_IFEO_KEY_STATE = v_enum()
PS_IFEO_KEY_STATE.PsReadIFEOAllValues = 0
PS_IFEO_KEY_STATE.PsSkipIFEODebugger = 1
PS_IFEO_KEY_STATE.PsSkipAllIFEO = 2
PS_IFEO_KEY_STATE.PsMaxIFEOKeyStates = 3


D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE = v_enum()
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_RenderCommandBuffer = 0
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_DeferredCommandBuffer = 1
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_SystemCommandBuffer = 2
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_MmIoFlipCommandBuffer = 3
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_WaitCommandBuffer = 4
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_SignalCommandBuffer = 5
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_DeviceCommandBuffer = 6
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_SoftwareCommandBuffer = 7
D3DKMT_QUERYSTATISTICS_QUEUE_PACKET_TYPE.D3DKMT_QueuePacketTypeMax = 8


INTERLOCKED_RESULT = v_enum()
INTERLOCKED_RESULT.ResultNegative = 1
INTERLOCKED_RESULT.ResultZero = 0
INTERLOCKED_RESULT.ResultPositive = 2


D3DKMDT_VIDPN_PRESENT_PATH_CONTENT = v_enum()
D3DKMDT_VIDPN_PRESENT_PATH_CONTENT.D3DKMDT_VPPC_UNINITIALIZED = 0
D3DKMDT_VIDPN_PRESENT_PATH_CONTENT.D3DKMDT_VPPC_GRAPHICS = 1
D3DKMDT_VIDPN_PRESENT_PATH_CONTENT.D3DKMDT_VPPC_VIDEO = 2
D3DKMDT_VIDPN_PRESENT_PATH_CONTENT.D3DKMDT_VPPC_NOTSPECIFIED = 255


THRESHOLD_SELECTOR = v_enum()
THRESHOLD_SELECTOR.ThresholdMouse = 0
THRESHOLD_SELECTOR.ThresholdPen = 1
THRESHOLD_SELECTOR.ThresholdMouseDragOut = 2
THRESHOLD_SELECTOR.ThresholdPenDragOut = 3
THRESHOLD_SELECTOR.ThresholdMouseSideMove = 4
THRESHOLD_SELECTOR.ThresholdPenSideMove = 5
THRESHOLD_SELECTOR.ThresholdAlways = 6
THRESHOLD_SELECTOR.ThresholdLast = 7


POOL_TYPE = v_enum()
POOL_TYPE.NonPagedPool = 0
POOL_TYPE.PagedPool = 1
POOL_TYPE.NonPagedPoolMustSucceed = 2
POOL_TYPE.DontUseThisType = 3
POOL_TYPE.NonPagedPoolCacheAligned = 4
POOL_TYPE.PagedPoolCacheAligned = 5
POOL_TYPE.NonPagedPoolCacheAlignedMustS = 6
POOL_TYPE.MaxPoolType = 7
POOL_TYPE.NonPagedPoolSession = 32
POOL_TYPE.PagedPoolSession = 33
POOL_TYPE.NonPagedPoolMustSucceedSession = 34
POOL_TYPE.DontUseThisTypeSession = 35
POOL_TYPE.NonPagedPoolCacheAlignedSession = 36
POOL_TYPE.PagedPoolCacheAlignedSession = 37
POOL_TYPE.NonPagedPoolCacheAlignedMustSSession = 38


DMM_CLIENT_TYPE = v_enum()
DMM_CLIENT_TYPE.DMM_CT_UNINITIALIZED = 0
DMM_CLIENT_TYPE.DMM_CT_CDD_NOPATHDATA = 1
DMM_CLIENT_TYPE.DMM_CT_USERMODE = 2
DMM_CLIENT_TYPE.DMM_CT_CDD_PATHDATA = 3
DMM_CLIENT_TYPE.DMM_CT_DXGPORT = 4


FSINFOCLASS = v_enum()
FSINFOCLASS.FileFsVolumeInformation = 1
FSINFOCLASS.FileFsLabelInformation = 2
FSINFOCLASS.FileFsSizeInformation = 3
FSINFOCLASS.FileFsDeviceInformation = 4
FSINFOCLASS.FileFsAttributeInformation = 5
FSINFOCLASS.FileFsControlInformation = 6
FSINFOCLASS.FileFsFullSizeInformation = 7
FSINFOCLASS.FileFsObjectIdInformation = 8
FSINFOCLASS.FileFsDriverPathInformation = 9
FSINFOCLASS.FileFsVolumeFlagsInformation = 10
FSINFOCLASS.FileFsMaximumInformation = 11


D3DKMT_QUERYSTATISTICS_DMA_PACKET_TYPE = v_enum()
D3DKMT_QUERYSTATISTICS_DMA_PACKET_TYPE.D3DKMT_ClientRenderBuffer = 0
D3DKMT_QUERYSTATISTICS_DMA_PACKET_TYPE.D3DKMT_ClientPagingBuffer = 1
D3DKMT_QUERYSTATISTICS_DMA_PACKET_TYPE.D3DKMT_SystemPagingBuffer = 2
D3DKMT_QUERYSTATISTICS_DMA_PACKET_TYPE.D3DKMT_SystemPreemptionBuffer = 3
D3DKMT_QUERYSTATISTICS_DMA_PACKET_TYPE.D3DKMT_DmaPacketTypeMax = 4


MODE = v_enum()
MODE.KernelMode = 0
MODE.UserMode = 1
MODE.MaximumMode = 2


SM_STORAGE_MODIFIER = v_enum()
SM_STORAGE_MODIFIER.SmStorageActual = 0
SM_STORAGE_MODIFIER.SmStorageNonActual = 1


DMM_MONITOR_PRESENCE_EVENT_TYPE = v_enum()
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_UNINITIALIZED = 0
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_ADDMONITOR = 1
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_REMOVEMONITOR = 2
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_DRIVERARRIVAL = 3
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_DRIVERQUERYREMOVE = 4
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_DRIVERREMOVECANCELLED = 5
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_DRIVERREMOVECOMPLETE = 6
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_DEVICENODEREADY = 7
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_EDIDCHANGE = 8
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_MONITORDISABLE = 9
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_MONITORENABLE = 10
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_ADAPTERADD = 11
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_ADAPTERREMOVAL = 12
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_INVALIDATION = 13
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_ADDSIMULATEDMONITOR = 1073741825
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_REMOVESIMULATEDMONITOR = 1073741826
DMM_MONITOR_PRESENCE_EVENT_TYPE.DMM_MPET_MAXVALID = 1073741826


WINDOW_ARRANGEMENT_COMMAND = v_enum()
WINDOW_ARRANGEMENT_COMMAND.WARR_MOVE_FIRST = 10
WINDOW_ARRANGEMENT_COMMAND.WARR_RESTORE_UP = 10
WINDOW_ARRANGEMENT_COMMAND.WARR_RESTORE_DOWN = 11
WINDOW_ARRANGEMENT_COMMAND.WARR_VRESTORE_UP = 12
WINDOW_ARRANGEMENT_COMMAND.WARR_VRESTORE_DOWN = 13
WINDOW_ARRANGEMENT_COMMAND.WARR_VMAXIMIZE_RIGHT = 14
WINDOW_ARRANGEMENT_COMMAND.WARR_VMAXIMIZE_LEFT = 15
WINDOW_ARRANGEMENT_COMMAND.WARR_MOVE_NEXT_MONITOR_LEFT = 16
WINDOW_ARRANGEMENT_COMMAND.WARR_MOVE_NEXT_MONITOR_RIGHT = 17
WINDOW_ARRANGEMENT_COMMAND.WARR_MOVE_LAST = 18


OB_OPEN_REASON = v_enum()
OB_OPEN_REASON.ObCreateHandle = 0
OB_OPEN_REASON.ObOpenHandle = 1
OB_OPEN_REASON.ObDuplicateHandle = 2
OB_OPEN_REASON.ObInheritHandle = 3
OB_OPEN_REASON.ObMaxOpenReason = 4


DMM_MODE_PRUNING_ALGORITHM = v_enum()
DMM_MODE_PRUNING_ALGORITHM.DMM_MPA_UNINITIALIZED = 0
DMM_MODE_PRUNING_ALGORITHM.DMM_MPA_GDI = 1
DMM_MODE_PRUNING_ALGORITHM.DMM_MPA_VISTA = 2
DMM_MODE_PRUNING_ALGORITHM.DMM_MPA_GDI_VISTA_UNION = 3
DMM_MODE_PRUNING_ALGORITHM.DMM_MPA_MAXVALID = 3


DEVICE_TEXT_TYPE = v_enum()
DEVICE_TEXT_TYPE.DeviceTextDescription = 0
DEVICE_TEXT_TYPE.DeviceTextLocationInformation = 1


POWER_STATE_TYPE = v_enum()
POWER_STATE_TYPE.SystemPowerState = 0
POWER_STATE_TYPE.DevicePowerState = 1


PS_ATTRIBUTE_NUM = v_enum()
PS_ATTRIBUTE_NUM.PsAttributeParentProcess = 0
PS_ATTRIBUTE_NUM.PsAttributeDebugObject = 1
PS_ATTRIBUTE_NUM.PsAttributeToken = 2
PS_ATTRIBUTE_NUM.PsAttributeClientId = 3
PS_ATTRIBUTE_NUM.PsAttributeTebAddress = 4
PS_ATTRIBUTE_NUM.PsAttributeImageName = 5
PS_ATTRIBUTE_NUM.PsAttributeImageInfo = 6
PS_ATTRIBUTE_NUM.PsAttributeMemoryReserve = 7
PS_ATTRIBUTE_NUM.PsAttributePriorityClass = 8
PS_ATTRIBUTE_NUM.PsAttributeErrorMode = 9
PS_ATTRIBUTE_NUM.PsAttributeStdHandleInfo = 10
PS_ATTRIBUTE_NUM.PsAttributeHandleList = 11
PS_ATTRIBUTE_NUM.PsAttributeGroupAffinity = 12
PS_ATTRIBUTE_NUM.PsAttributePreferredNode = 13
PS_ATTRIBUTE_NUM.PsAttributeIdealProcessor = 14
PS_ATTRIBUTE_NUM.PsAttributeUmsThread = 15
PS_ATTRIBUTE_NUM.PsAttributeExecuteOptions = 16
PS_ATTRIBUTE_NUM.PsAttributeMax = 17


IRQ_PRIORITY = v_enum()
IRQ_PRIORITY.IrqPriorityUndefined = 0
IRQ_PRIORITY.IrqPriorityLow = 1
IRQ_PRIORITY.IrqPriorityNormal = 2
IRQ_PRIORITY.IrqPriorityHigh = 3


D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS = v_enum()
D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS.D3DKMT_AllocationPriorityClassMinimum = 0
D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS.D3DKMT_AllocationPriorityClassLow = 1
D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS.D3DKMT_AllocationPriorityClassNormal = 2
D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS.D3DKMT_AllocationPriorityClassHigh = 3
D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS.D3DKMT_AllocationPriorityClassMaximum = 4
D3DKMT_QUERYSTATISTICS_ALLOCATION_PRIORITY_CLASS.D3DKMT_MaxAllocationPriorityClass = 5


D3DKMDT_MONITOR_CAPABILITIES_ORIGIN = v_enum()
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_UNINITIALIZED = 0
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_DEFAULTMONITORPROFILE = 1
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_MONITORDESCRIPTOR = 2
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_MONITORDESCRIPTOR_REGISTRYOVERRIDE = 3
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_SPECIFICCAP_REGISTRYOVERRIDE = 4
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_DRIVER = 5
D3DKMDT_MONITOR_CAPABILITIES_ORIGIN.D3DKMDT_MCO_MAXVALID = 5


D3DKMDT_PIXEL_VALUE_ACCESS_MODE = v_enum()
D3DKMDT_PIXEL_VALUE_ACCESS_MODE.D3DKMDT_PVAM_UNINITIALIZED = 0
D3DKMDT_PIXEL_VALUE_ACCESS_MODE.D3DKMDT_PVAM_DIRECT = 1
D3DKMDT_PIXEL_VALUE_ACCESS_MODE.D3DKMDT_PVAM_PRESETPALETTE = 2
D3DKMDT_PIXEL_VALUE_ACCESS_MODE.D3DKMDT_PVAM_SETTABLEPALETTE = 3
D3DKMDT_PIXEL_VALUE_ACCESS_MODE.D3DKMDT_PVAM_MAXVALID = 3


SECURITY_OPERATION_CODE = v_enum()
SECURITY_OPERATION_CODE.SetSecurityDescriptor = 0
SECURITY_OPERATION_CODE.QuerySecurityDescriptor = 1
SECURITY_OPERATION_CODE.DeleteSecurityDescriptor = 2
SECURITY_OPERATION_CODE.AssignSecurityDescriptor = 3


D3DKMDT_TEXT_RENDERING_FORMAT = v_enum()
D3DKMDT_TEXT_RENDERING_FORMAT.D3DKMDT_TRF_UNINITIALIZED = 0


RTL_GENERIC_COMPARE_RESULTS = v_enum()
RTL_GENERIC_COMPARE_RESULTS.GenericLessThan = 0
RTL_GENERIC_COMPARE_RESULTS.GenericGreaterThan = 1
RTL_GENERIC_COMPARE_RESULTS.GenericEqual = 2


SYSTEM_POWER_STATE = v_enum()
SYSTEM_POWER_STATE.PowerSystemUnspecified = 0
SYSTEM_POWER_STATE.PowerSystemWorking = 1
SYSTEM_POWER_STATE.PowerSystemSleeping1 = 2
SYSTEM_POWER_STATE.PowerSystemSleeping2 = 3
SYSTEM_POWER_STATE.PowerSystemSleeping3 = 4
SYSTEM_POWER_STATE.PowerSystemHibernate = 5
SYSTEM_POWER_STATE.PowerSystemShutdown = 6
SYSTEM_POWER_STATE.PowerSystemMaximum = 7


D3DKMDT_VIDPN_SOURCE_MODE_TYPE = v_enum()
D3DKMDT_VIDPN_SOURCE_MODE_TYPE.D3DKMDT_RMT_UNINITIALIZED = 0
D3DKMDT_VIDPN_SOURCE_MODE_TYPE.D3DKMDT_RMT_GRAPHICS = 1
D3DKMDT_VIDPN_SOURCE_MODE_TYPE.D3DKMDT_RMT_TEXT = 2


FILE_INFORMATION_CLASS = v_enum()
FILE_INFORMATION_CLASS.FileDirectoryInformation = 1
FILE_INFORMATION_CLASS.FileFullDirectoryInformation = 2
FILE_INFORMATION_CLASS.FileBothDirectoryInformation = 3
FILE_INFORMATION_CLASS.FileBasicInformation = 4
FILE_INFORMATION_CLASS.FileStandardInformation = 5
FILE_INFORMATION_CLASS.FileInternalInformation = 6
FILE_INFORMATION_CLASS.FileEaInformation = 7
FILE_INFORMATION_CLASS.FileAccessInformation = 8
FILE_INFORMATION_CLASS.FileNameInformation = 9
FILE_INFORMATION_CLASS.FileRenameInformation = 10
FILE_INFORMATION_CLASS.FileLinkInformation = 11
FILE_INFORMATION_CLASS.FileNamesInformation = 12
FILE_INFORMATION_CLASS.FileDispositionInformation = 13
FILE_INFORMATION_CLASS.FilePositionInformation = 14
FILE_INFORMATION_CLASS.FileFullEaInformation = 15
FILE_INFORMATION_CLASS.FileModeInformation = 16
FILE_INFORMATION_CLASS.FileAlignmentInformation = 17
FILE_INFORMATION_CLASS.FileAllInformation = 18
FILE_INFORMATION_CLASS.FileAllocationInformation = 19
FILE_INFORMATION_CLASS.FileEndOfFileInformation = 20
FILE_INFORMATION_CLASS.FileAlternateNameInformation = 21
FILE_INFORMATION_CLASS.FileStreamInformation = 22
FILE_INFORMATION_CLASS.FilePipeInformation = 23
FILE_INFORMATION_CLASS.FilePipeLocalInformation = 24
FILE_INFORMATION_CLASS.FilePipeRemoteInformation = 25
FILE_INFORMATION_CLASS.FileMailslotQueryInformation = 26
FILE_INFORMATION_CLASS.FileMailslotSetInformation = 27
FILE_INFORMATION_CLASS.FileCompressionInformation = 28
FILE_INFORMATION_CLASS.FileObjectIdInformation = 29
FILE_INFORMATION_CLASS.FileCompletionInformation = 30
FILE_INFORMATION_CLASS.FileMoveClusterInformation = 31
FILE_INFORMATION_CLASS.FileQuotaInformation = 32
FILE_INFORMATION_CLASS.FileReparsePointInformation = 33
FILE_INFORMATION_CLASS.FileNetworkOpenInformation = 34
FILE_INFORMATION_CLASS.FileAttributeTagInformation = 35
FILE_INFORMATION_CLASS.FileTrackingInformation = 36
FILE_INFORMATION_CLASS.FileIdBothDirectoryInformation = 37
FILE_INFORMATION_CLASS.FileIdFullDirectoryInformation = 38
FILE_INFORMATION_CLASS.FileValidDataLengthInformation = 39
FILE_INFORMATION_CLASS.FileShortNameInformation = 40
FILE_INFORMATION_CLASS.FileIoCompletionNotificationInformation = 41
FILE_INFORMATION_CLASS.FileIoStatusBlockRangeInformation = 42
FILE_INFORMATION_CLASS.FileIoPriorityHintInformation = 43
FILE_INFORMATION_CLASS.FileSfioReserveInformation = 44
FILE_INFORMATION_CLASS.FileSfioVolumeInformation = 45
FILE_INFORMATION_CLASS.FileHardLinkInformation = 46
FILE_INFORMATION_CLASS.FileProcessIdsUsingFileInformation = 47
FILE_INFORMATION_CLASS.FileNormalizedNameInformation = 48
FILE_INFORMATION_CLASS.FileNetworkPhysicalNameInformation = 49
FILE_INFORMATION_CLASS.FileIdGlobalTxDirectoryInformation = 50
FILE_INFORMATION_CLASS.FileIsRemoteDeviceInformation = 51
FILE_INFORMATION_CLASS.FileAttributeCacheInformation = 52
FILE_INFORMATION_CLASS.FileNumaNodeInformation = 53
FILE_INFORMATION_CLASS.FileStandardLinkInformation = 54
FILE_INFORMATION_CLASS.FileRemoteProtocolInformation = 55
FILE_INFORMATION_CLASS.FileMaximumInformation = 56


EXCEPTION_DISPOSITION = v_enum()
EXCEPTION_DISPOSITION.ExceptionContinueExecution = 0
EXCEPTION_DISPOSITION.ExceptionContinueSearch = 1
EXCEPTION_DISPOSITION.ExceptionNestedException = 2
EXCEPTION_DISPOSITION.ExceptionCollidedUnwind = 3


D3DKMDT_VIDPN_PRESENT_PATH_SCALING = v_enum()
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_UNINITIALIZED = 0
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_IDENTITY = 1
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_CENTERED = 2
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_STRETCHED = 3
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_ASPECTRATIOCENTEREDMAX = 4
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_CUSTOM = 5
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_RESERVED1 = 253
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_UNPINNED = 254
D3DKMDT_VIDPN_PRESENT_PATH_SCALING.D3DKMDT_VPPS_NOTSPECIFIED = 255


DEVICE_USAGE_NOTIFICATION_TYPE = v_enum()
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeUndefined = 0
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypePaging = 1
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeHibernation = 2
DEVICE_USAGE_NOTIFICATION_TYPE.DeviceUsageTypeDumpFile = 3


D3DDDI_GAMMARAMP_TYPE = v_enum()
D3DDDI_GAMMARAMP_TYPE.D3DDDI_GAMMARAMP_UNINITIALIZED = 0
D3DDDI_GAMMARAMP_TYPE.D3DDDI_GAMMARAMP_DEFAULT = 1
D3DDDI_GAMMARAMP_TYPE.D3DDDI_GAMMARAMP_RGB256x3x16 = 2
D3DDDI_GAMMARAMP_TYPE.D3DDDI_GAMMARAMP_DXGI_1 = 3


EX_POOL_PRIORITY = v_enum()
EX_POOL_PRIORITY.LowPoolPriority = 0
EX_POOL_PRIORITY.LowPoolPrioritySpecialPoolOverrun = 8
EX_POOL_PRIORITY.LowPoolPrioritySpecialPoolUnderrun = 9
EX_POOL_PRIORITY.NormalPoolPriority = 16
EX_POOL_PRIORITY.NormalPoolPrioritySpecialPoolOverrun = 24
EX_POOL_PRIORITY.NormalPoolPrioritySpecialPoolUnderrun = 25
EX_POOL_PRIORITY.HighPoolPriority = 32
EX_POOL_PRIORITY.HighPoolPrioritySpecialPoolOverrun = 40
EX_POOL_PRIORITY.HighPoolPrioritySpecialPoolUnderrun = 41


WHEA_ERROR_PACKET_DATA_FORMAT = v_enum()
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatIPFSalRecord = 0
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatXPFMCA = 1
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatMemory = 2
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatPCIExpress = 3
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatNMIPort = 4
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatPCIXBus = 5
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatPCIXDevice = 6
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatGeneric = 7
WHEA_ERROR_PACKET_DATA_FORMAT.WheaDataFormatMax = 8


DISPLAYCONFIG_SCANLINE_ORDERING = v_enum()
DISPLAYCONFIG_SCANLINE_ORDERING.DISPLAYCONFIG_SCANLINE_ORDERING_UNSPECIFIED = 0
DISPLAYCONFIG_SCANLINE_ORDERING.DISPLAYCONFIG_SCANLINE_ORDERING_PROGRESSIVE = 1
DISPLAYCONFIG_SCANLINE_ORDERING.DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED = 2
DISPLAYCONFIG_SCANLINE_ORDERING.DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_UPPERFIELDFIRST = 2
DISPLAYCONFIG_SCANLINE_ORDERING.DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_LOWERFIELDFIRST = 3
DISPLAYCONFIG_SCANLINE_ORDERING.DISPLAYCONFIG_SCANLINE_ORDERING_FORCE_UINT32 = -1


TP_CALLBACK_PRIORITY = v_enum()
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_HIGH = 0
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_NORMAL = 1
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_LOW = 2
TP_CALLBACK_PRIORITY.TP_CALLBACK_PRIORITY_INVALID = 3


SECURITY_IMPERSONATION_LEVEL = v_enum()
SECURITY_IMPERSONATION_LEVEL.SecurityAnonymous = 0
SECURITY_IMPERSONATION_LEVEL.SecurityIdentification = 1
SECURITY_IMPERSONATION_LEVEL.SecurityImpersonation = 2
SECURITY_IMPERSONATION_LEVEL.SecurityDelegation = 3


D3DKMDT_VIDEO_SIGNAL_STANDARD = v_enum()
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_UNINITIALIZED = 0
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_VESA_DMT = 1
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_VESA_GTF = 2
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_VESA_CVT = 3
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_IBM = 4
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_APPLE = 5
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_NTSC_M = 6
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_NTSC_J = 7
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_NTSC_443 = 8
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_B = 9
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_B1 = 10
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_G = 11
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_H = 12
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_I = 13
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_D = 14
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_N = 15
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_NC = 16
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_B = 17
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_D = 18
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_G = 19
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_H = 20
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_K = 21
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_K1 = 22
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_L = 23
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_SECAM_L1 = 24
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_EIA_861 = 25
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_EIA_861A = 26
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_EIA_861B = 27
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_K = 28
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_K1 = 29
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_L = 30
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_PAL_M = 31
D3DKMDT_VIDEO_SIGNAL_STANDARD.D3DKMDT_VSS_OTHER = 255


D3DKMDT_COLOR_BASIS = v_enum()
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_UNINITIALIZED = 0
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_INTENSITY = 1
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_SRGB = 2
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_SCRGB = 3
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_YCBCR = 4
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_YPBPR = 5
D3DKMDT_COLOR_BASIS.D3DKMDT_CB_MAXVALID = 5


DXGK_RECOMMENDFUNCTIONALVIDPN_REASON = v_enum()
DXGK_RECOMMENDFUNCTIONALVIDPN_REASON.DXGK_RFVR_UNINITIALIZED = 0
DXGK_RECOMMENDFUNCTIONALVIDPN_REASON.DXGK_RFVR_HOTKEY = 1
DXGK_RECOMMENDFUNCTIONALVIDPN_REASON.DXGK_RFVR_USERMODE = 2


D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT = v_enum()
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttempt = 0
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptSuccess = 1
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissNoCommand = 2
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissNotEnabled = 3
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissNextFence = 4
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissPagingCommand = 5
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissSplittedCommand = 6
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissFenceCommand = 7
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissRenderPendingFlip = 8
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissNotMakingProgress = 9
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissLessPriority = 10
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissRemainingQuantum = 11
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissRemainingPreemptionQuantum = 12
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissAlreadyPreempting = 13
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissGlobalBlock = 14
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptMissAlreadyRunning = 15
D3DKMT_QUERYRESULT_PREEMPTION_ATTEMPT_RESULT.D3DKMT_PreemptionAttemptStatisticsMax = 16


INTERFACE_TYPE = v_enum()
INTERFACE_TYPE.InterfaceTypeUndefined = -1
INTERFACE_TYPE.Internal = 0
INTERFACE_TYPE.Isa = 1
INTERFACE_TYPE.Eisa = 2
INTERFACE_TYPE.MicroChannel = 3
INTERFACE_TYPE.TurboChannel = 4
INTERFACE_TYPE.PCIBus = 5
INTERFACE_TYPE.VMEBus = 6
INTERFACE_TYPE.NuBus = 7
INTERFACE_TYPE.PCMCIABus = 8
INTERFACE_TYPE.CBus = 9
INTERFACE_TYPE.MPIBus = 10
INTERFACE_TYPE.MPSABus = 11
INTERFACE_TYPE.ProcessorInternal = 12
INTERFACE_TYPE.InternalPowerBus = 13
INTERFACE_TYPE.PNPISABus = 14
INTERFACE_TYPE.PNPBus = 15
INTERFACE_TYPE.Vmcs = 16
INTERFACE_TYPE.MaximumInterfaceType = 17


ALTERNATIVE_ARCHITECTURE_TYPE = v_enum()
ALTERNATIVE_ARCHITECTURE_TYPE.StandardDesign = 0
ALTERNATIVE_ARCHITECTURE_TYPE.NEC98x86 = 1
ALTERNATIVE_ARCHITECTURE_TYPE.EndAlternatives = 2


D3DKMDT_VIDPN_PRESENT_PATH_ROTATION = v_enum()
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_UNINITIALIZED = 0
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_IDENTITY = 1
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_ROTATE90 = 2
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_ROTATE180 = 3
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_ROTATE270 = 4
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_UNPINNED = 254
D3DKMDT_VIDPN_PRESENT_PATH_ROTATION.D3DKMDT_VPPR_NOTSPECIFIED = 255


WHEA_ERROR_TYPE = v_enum()
WHEA_ERROR_TYPE.WheaErrTypeProcessor = 0
WHEA_ERROR_TYPE.WheaErrTypeMemory = 1
WHEA_ERROR_TYPE.WheaErrTypePCIExpress = 2
WHEA_ERROR_TYPE.WheaErrTypeNMI = 3
WHEA_ERROR_TYPE.WheaErrTypePCIXBus = 4
WHEA_ERROR_TYPE.WheaErrTypePCIXDevice = 5
WHEA_ERROR_TYPE.WheaErrTypeGeneric = 6


DXGK_DIAG_TYPE = v_enum()
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_NONE = 0
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_SDC = 1
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_HPD = 2
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_DC_ORIGIN = 3
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_USER_CDS = 4
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_DRV_CDS = 5
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_CODE_POINT = 6
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_QDC = 7
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_MONITOR_MGR = 8
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_CONNECTEDSET_NOT_FOUND = 9
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_DISPDIAG_COLLECTED = 10
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_BML_PACKET = 11
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_BML_PACKET_EX = 12
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_COMMIT_VIDPN_FAILED = 13
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_DRIVER_RECOMMEND_VIDPN = 14
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_MAX = 14
DXGK_DIAG_TYPE.DXGK_DIAG_TYPE_FORCE_UINT32 = -1


ReplacesCorHdrNumericDefines = v_enum()
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_ILONLY = 1
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_32BITREQUIRED = 2
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_IL_LIBRARY = 4
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_STRONGNAMESIGNED = 8
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_NATIVE_ENTRYPOINT = 16
ReplacesCorHdrNumericDefines.COMIMAGE_FLAGS_TRACKDEBUGDATA = 65536
ReplacesCorHdrNumericDefines.COR_VERSION_MAJOR_V2 = 2
ReplacesCorHdrNumericDefines.COR_VERSION_MAJOR = 2
ReplacesCorHdrNumericDefines.COR_VERSION_MINOR = 0
ReplacesCorHdrNumericDefines.COR_DELETED_NAME_LENGTH = 8
ReplacesCorHdrNumericDefines.COR_VTABLEGAP_NAME_LENGTH = 8
ReplacesCorHdrNumericDefines.NATIVE_TYPE_MAX_CB = 1
ReplacesCorHdrNumericDefines.COR_ILMETHOD_SECT_SMALL_MAX_DATASIZE = 255
ReplacesCorHdrNumericDefines.IMAGE_COR_MIH_METHODRVA = 1
ReplacesCorHdrNumericDefines.IMAGE_COR_MIH_EHRVA = 2
ReplacesCorHdrNumericDefines.IMAGE_COR_MIH_BASICBLOCK = 8
ReplacesCorHdrNumericDefines.COR_VTABLE_32BIT = 1
ReplacesCorHdrNumericDefines.COR_VTABLE_64BIT = 2
ReplacesCorHdrNumericDefines.COR_VTABLE_FROM_UNMANAGED = 4
ReplacesCorHdrNumericDefines.COR_VTABLE_FROM_UNMANAGED_RETAIN_APPDOMAIN = 8
ReplacesCorHdrNumericDefines.COR_VTABLE_CALL_MOST_DERIVED = 16
ReplacesCorHdrNumericDefines.IMAGE_COR_EATJ_THUNK_SIZE = 32
ReplacesCorHdrNumericDefines.MAX_CLASS_NAME = 1024
ReplacesCorHdrNumericDefines.MAX_PACKAGE_NAME = 1024


D3DKMDT_MODE_PREFERENCE = v_enum()
D3DKMDT_MODE_PREFERENCE.D3DKMDT_MP_UNINITIALIZED = 0
D3DKMDT_MODE_PREFERENCE.D3DKMDT_MP_PREFERRED = 1
D3DKMDT_MODE_PREFERENCE.D3DKMDT_MP_NOTPREFERRED = 2
D3DKMDT_MODE_PREFERENCE.D3DKMDT_MP_MAXVALID = 2


eTHRESHOLD_MARGIN_DIRECTION = v_enum()
eTHRESHOLD_MARGIN_DIRECTION.ThresholdMarginTop = 0
eTHRESHOLD_MARGIN_DIRECTION.ThresholdMarginLeft = 1
eTHRESHOLD_MARGIN_DIRECTION.ThresholdMarginRight = 2
eTHRESHOLD_MARGIN_DIRECTION.ThresholdMarginBottom = 3
eTHRESHOLD_MARGIN_DIRECTION.ThresholdMarginMax = 4


MOVERECT_STYLE = v_enum()
MOVERECT_STYLE.MoveRectKeepPositionAtCursor = 0
MOVERECT_STYLE.MoveRectMidTopAtCursor = 1
MOVERECT_STYLE.MoveRectKeepAspectRatioAtCursor = 2
MOVERECT_STYLE.MoveRectSidewiseKeepPositionAtCursor = 3


D3DKMDT_MONITOR_TIMING_TYPE = v_enum()
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_UNINITIALIZED = 0
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_ESTABLISHED = 1
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_STANDARD = 2
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_EXTRASTANDARD = 3
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_DETAILED = 4
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_DEFAULTMONITORPROFILE = 5
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_DRIVER = 6
D3DKMDT_MONITOR_TIMING_TYPE.D3DKMDT_MTT_MAXVALID = 6


MEMORY_CACHING_TYPE_ORIG = v_enum()
MEMORY_CACHING_TYPE_ORIG.MmFrameBufferCached = 2


D3DDDIFORMAT = v_enum()
D3DDDIFORMAT.D3DDDIFMT_UNKNOWN = 0
D3DDDIFORMAT.D3DDDIFMT_R8G8B8 = 20
D3DDDIFORMAT.D3DDDIFMT_A8R8G8B8 = 21
D3DDDIFORMAT.D3DDDIFMT_X8R8G8B8 = 22
D3DDDIFORMAT.D3DDDIFMT_R5G6B5 = 23
D3DDDIFORMAT.D3DDDIFMT_X1R5G5B5 = 24
D3DDDIFORMAT.D3DDDIFMT_A1R5G5B5 = 25
D3DDDIFORMAT.D3DDDIFMT_A4R4G4B4 = 26
D3DDDIFORMAT.D3DDDIFMT_R3G3B2 = 27
D3DDDIFORMAT.D3DDDIFMT_A8 = 28
D3DDDIFORMAT.D3DDDIFMT_A8R3G3B2 = 29
D3DDDIFORMAT.D3DDDIFMT_X4R4G4B4 = 30
D3DDDIFORMAT.D3DDDIFMT_A2B10G10R10 = 31
D3DDDIFORMAT.D3DDDIFMT_A8B8G8R8 = 32
D3DDDIFORMAT.D3DDDIFMT_X8B8G8R8 = 33
D3DDDIFORMAT.D3DDDIFMT_G16R16 = 34
D3DDDIFORMAT.D3DDDIFMT_A2R10G10B10 = 35
D3DDDIFORMAT.D3DDDIFMT_A16B16G16R16 = 36
D3DDDIFORMAT.D3DDDIFMT_A8P8 = 40
D3DDDIFORMAT.D3DDDIFMT_P8 = 41
D3DDDIFORMAT.D3DDDIFMT_L8 = 50
D3DDDIFORMAT.D3DDDIFMT_A8L8 = 51
D3DDDIFORMAT.D3DDDIFMT_A4L4 = 52
D3DDDIFORMAT.D3DDDIFMT_V8U8 = 60
D3DDDIFORMAT.D3DDDIFMT_L6V5U5 = 61
D3DDDIFORMAT.D3DDDIFMT_X8L8V8U8 = 62
D3DDDIFORMAT.D3DDDIFMT_Q8W8V8U8 = 63
D3DDDIFORMAT.D3DDDIFMT_V16U16 = 64
D3DDDIFORMAT.D3DDDIFMT_W11V11U10 = 65
D3DDDIFORMAT.D3DDDIFMT_A2W10V10U10 = 67
D3DDDIFORMAT.D3DDDIFMT_UYVY = 1498831189
D3DDDIFORMAT.D3DDDIFMT_R8G8_B8G8 = 1195525970
D3DDDIFORMAT.D3DDDIFMT_YUY2 = 844715353
D3DDDIFORMAT.D3DDDIFMT_G8R8_G8B8 = 1111970375
D3DDDIFORMAT.D3DDDIFMT_DXT1 = 827611204
D3DDDIFORMAT.D3DDDIFMT_DXT2 = 844388420
D3DDDIFORMAT.D3DDDIFMT_DXT3 = 861165636
D3DDDIFORMAT.D3DDDIFMT_DXT4 = 877942852
D3DDDIFORMAT.D3DDDIFMT_DXT5 = 894720068
D3DDDIFORMAT.D3DDDIFMT_D16_LOCKABLE = 70
D3DDDIFORMAT.D3DDDIFMT_D32 = 71
D3DDDIFORMAT.D3DDDIFMT_D15S1 = 73
D3DDDIFORMAT.D3DDDIFMT_D24S8 = 75
D3DDDIFORMAT.D3DDDIFMT_D24X8 = 77
D3DDDIFORMAT.D3DDDIFMT_D24X4S4 = 79
D3DDDIFORMAT.D3DDDIFMT_D16 = 80
D3DDDIFORMAT.D3DDDIFMT_D32F_LOCKABLE = 82
D3DDDIFORMAT.D3DDDIFMT_D24FS8 = 83
D3DDDIFORMAT.D3DDDIFMT_D32_LOCKABLE = 84
D3DDDIFORMAT.D3DDDIFMT_S8_LOCKABLE = 85
D3DDDIFORMAT.D3DDDIFMT_S1D15 = 72
D3DDDIFORMAT.D3DDDIFMT_S8D24 = 74
D3DDDIFORMAT.D3DDDIFMT_X8D24 = 76
D3DDDIFORMAT.D3DDDIFMT_X4S4D24 = 78
D3DDDIFORMAT.D3DDDIFMT_L16 = 81
D3DDDIFORMAT.D3DDDIFMT_VERTEXDATA = 100
D3DDDIFORMAT.D3DDDIFMT_INDEX16 = 101
D3DDDIFORMAT.D3DDDIFMT_INDEX32 = 102
D3DDDIFORMAT.D3DDDIFMT_Q16W16V16U16 = 110
D3DDDIFORMAT.D3DDDIFMT_MULTI2_ARGB8 = 827606349
D3DDDIFORMAT.D3DDDIFMT_R16F = 111
D3DDDIFORMAT.D3DDDIFMT_G16R16F = 112
D3DDDIFORMAT.D3DDDIFMT_A16B16G16R16F = 113
D3DDDIFORMAT.D3DDDIFMT_R32F = 114
D3DDDIFORMAT.D3DDDIFMT_G32R32F = 115
D3DDDIFORMAT.D3DDDIFMT_A32B32G32R32F = 116
D3DDDIFORMAT.D3DDDIFMT_CxV8U8 = 117
D3DDDIFORMAT.D3DDDIFMT_A1 = 118
D3DDDIFORMAT.D3DDDIFMT_A2B10G10R10_XR_BIAS = 119
D3DDDIFORMAT.D3DDDIFMT_DXVACOMPBUFFER_BASE = 150
D3DDDIFORMAT.D3DDDIFMT_PICTUREPARAMSDATA = 150
D3DDDIFORMAT.D3DDDIFMT_MACROBLOCKDATA = 151
D3DDDIFORMAT.D3DDDIFMT_RESIDUALDIFFERENCEDATA = 152
D3DDDIFORMAT.D3DDDIFMT_DEBLOCKINGDATA = 153
D3DDDIFORMAT.D3DDDIFMT_INVERSEQUANTIZATIONDATA = 154
D3DDDIFORMAT.D3DDDIFMT_SLICECONTROLDATA = 155
D3DDDIFORMAT.D3DDDIFMT_BITSTREAMDATA = 156
D3DDDIFORMAT.D3DDDIFMT_MOTIONVECTORBUFFER = 157
D3DDDIFORMAT.D3DDDIFMT_FILMGRAINBUFFER = 158
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED9 = 159
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED10 = 160
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED11 = 161
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED12 = 162
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED13 = 163
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED14 = 164
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED15 = 165
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED16 = 166
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED17 = 167
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED18 = 168
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED19 = 169
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED20 = 170
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED21 = 171
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED22 = 172
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED23 = 173
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED24 = 174
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED25 = 175
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED26 = 176
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED27 = 177
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED28 = 178
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED29 = 179
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED30 = 180
D3DDDIFORMAT.D3DDDIFMT_DXVA_RESERVED31 = 181
D3DDDIFORMAT.D3DDDIFMT_DXVACOMPBUFFER_MAX = 181
D3DDDIFORMAT.D3DDDIFMT_BINARYBUFFER = 199
D3DDDIFORMAT.D3DDDIFMT_FORCE_UINT = 2147483647


POWER_ACTION = v_enum()
POWER_ACTION.PowerActionNone = 0
POWER_ACTION.PowerActionReserved = 1
POWER_ACTION.PowerActionSleep = 2
POWER_ACTION.PowerActionHibernate = 3
POWER_ACTION.PowerActionShutdown = 4
POWER_ACTION.PowerActionShutdownReset = 5
POWER_ACTION.PowerActionShutdownOff = 6
POWER_ACTION.PowerActionWarmEject = 7


D3DKMDT_MONITOR_DESCRIPTOR_TYPE = v_enum()
D3DKMDT_MONITOR_DESCRIPTOR_TYPE.D3DKMDT_MDT_UNINITIALIZED = 0
D3DKMDT_MONITOR_DESCRIPTOR_TYPE.D3DKMDT_MDT_VESA_EDID_V1_BASEBLOCK = 1
D3DKMDT_MONITOR_DESCRIPTOR_TYPE.D3DKMDT_MDT_VESA_EDID_V1_BLOCKMAP = 2
D3DKMDT_MONITOR_DESCRIPTOR_TYPE.D3DKMDT_MDT_OTHER = 255


SM_RANGE_TYPES = v_enum()
SM_RANGE_TYPES.SmRangeSharedInfo = 0
SM_RANGE_TYPES.SmRangeNonSharedInfo = 1
SM_RANGE_TYPES.SmRangeBool = 2


WINDOWCOMPOSITIONATTRIB = v_enum()
WINDOWCOMPOSITIONATTRIB.WCA_UNDEFINED = 0
WINDOWCOMPOSITIONATTRIB.WCA_NCRENDERING_ENABLED = 1
WINDOWCOMPOSITIONATTRIB.WCA_NCRENDERING_POLICY = 2
WINDOWCOMPOSITIONATTRIB.WCA_TRANSITIONS_FORCEDISABLED = 3
WINDOWCOMPOSITIONATTRIB.WCA_ALLOW_NCPAINT = 4
WINDOWCOMPOSITIONATTRIB.WCA_CAPTION_BUTTON_BOUNDS = 5
WINDOWCOMPOSITIONATTRIB.WCA_NONCLIENT_RTL_LAYOUT = 6
WINDOWCOMPOSITIONATTRIB.WCA_FORCE_ICONIC_REPRESENTATION = 7
WINDOWCOMPOSITIONATTRIB.WCA_FLIP3D_POLICY = 8
WINDOWCOMPOSITIONATTRIB.WCA_EXTENDED_FRAME_BOUNDS = 9
WINDOWCOMPOSITIONATTRIB.WCA_HAS_ICONIC_BITMAP = 10
WINDOWCOMPOSITIONATTRIB.WCA_THEME_ATTRIBUTES = 11
WINDOWCOMPOSITIONATTRIB.WCA_NCRENDERING_EXILED = 12
WINDOWCOMPOSITIONATTRIB.WCA_NCADORNMENTINFO = 13
WINDOWCOMPOSITIONATTRIB.WCA_EXCLUDED_FROM_LIVEPREVIEW = 14
WINDOWCOMPOSITIONATTRIB.WCA_VIDEO_OVERLAY_ACTIVE = 15
WINDOWCOMPOSITIONATTRIB.WCA_FORCE_ACTIVEWINDOW_APPEARANCE = 16
WINDOWCOMPOSITIONATTRIB.WCA_DISALLOW_PEEK = 17
WINDOWCOMPOSITIONATTRIB.WCA_LAST = 18


class _unnamed_10519(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceTextType = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.LocaleId = v_uint32()
        self._pad0010 = v_bytes(size=4)


class _unnamed_10514(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IdType = v_uint32()


class _unnamed_14487(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Priority = v_uint32()
        self.Reserved1 = v_uint32()
        self.Reserved2 = v_uint32()


class _unnamed_14482(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.MinBusNumber = v_uint32()
        self.MaxBusNumber = v_uint32()
        self.Reserved = v_uint32()


class tagTOUCHINPUTINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = THROBJHEAD()
        self.dwcInputs = v_uint32()
        self.uFlags = v_uint32()
        self.TouchInput = vstruct.VArray([ tagTOUCHINPUT() for i in range(1) ])


class tagHOOK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = THRDESKHEAD()
        self.phkNext = v_ptr64()
        self.iHook = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.offPfn = v_uint64()
        self.flags = v_uint32()
        self.ihmod = v_uint32()
        self.ptiHooked = v_ptr64()
        self.rpdesk = v_ptr64()
        self.nTimeout = v_uint32()
        self._pad0060 = v_bytes(size=4)


class VK_TO_WCHAR_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pVkToWchars = v_ptr64()
        self.nModifications = v_uint8()
        self.cbSize = v_uint8()
        self._pad0010 = v_bytes(size=6)


class D3DKMDT_2DREGION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cx = v_uint32()
        self.cy = v_uint32()


class DEADKEY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwBoth = v_uint32()
        self.wchComposed = v_uint16()
        self.uFlags = v_uint16()


class CURDIR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DosPath = UNICODE_STRING()
        self.Handle = v_ptr64()


class _unnamed_13900(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Port = _unnamed_14462()


class tagPROPLIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cEntries = v_uint32()
        self.iFirstFree = v_uint32()
        self.aprop = vstruct.VArray([ tagPROP() for i in range(1) ])


class _unnamed_9808(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BaseMiddle = v_uint32()


class _unnamed_9807(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BaseMiddle = v_uint8()
        self.Flags1 = v_uint8()
        self.Flags2 = v_uint8()
        self.BaseHigh = v_uint8()


class tagDESKTOPINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pvDesktopBase = v_ptr64()
        self.pvDesktopLimit = v_ptr64()
        self.spwnd = v_ptr64()
        self.fsHooks = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.aphkStart = vstruct.VArray([ v_ptr64() for i in range(16) ])
        self.spwndShell = v_ptr64()
        self.ppiShellProcess = v_ptr64()
        self.spwndBkGnd = v_ptr64()
        self.spwndTaskman = v_ptr64()
        self.spwndProgman = v_ptr64()
        self.pvwplShellHook = v_ptr64()
        self.cntMBox = v_uint32()
        self._pad00d8 = v_bytes(size=4)
        self.spwndGestureEngine = v_ptr64()
        self.pvwplMessagePPHandler = v_ptr64()
        self.fComposited = v_uint32()
        self._pad00f0 = v_bytes(size=4)


class _unnamed_10207(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceQueueEntry = KDEVICE_QUEUE_ENTRY()
        self._pad0020 = v_bytes(size=8)
        self.Thread = v_ptr64()
        self.AuxiliaryBuffer = v_ptr64()
        self.ListEntry = LIST_ENTRY()
        self.CurrentStackLocation = v_ptr64()
        self.OriginalFileObject = v_ptr64()


class WHEA_ERROR_RECORD_SECTION_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SectionOffset = v_uint32()
        self.SectionLength = v_uint32()
        self.Revision = WHEA_REVISION()
        self.ValidBits = WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS()
        self.Reserved = v_uint8()
        self.Flags = WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS()
        self.SectionType = GUID()
        self.FRUId = GUID()
        self.SectionSeverity = v_uint32()
        self.FRUText = vstruct.VArray([ v_uint8() for i in range(20) ])


class VK_TO_FUNCTION_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Vk = v_uint8()
        self.NLSFEProcType = v_uint8()
        self.NLSFEProcCurrent = v_uint8()
        self.NLSFEProcSwitch = v_uint8()
        self.NLSFEProc = vstruct.VArray([ VK_FUNCTION_PARAM() for i in range(8) ])
        self.NLSFEProcAlt = vstruct.VArray([ VK_FUNCTION_PARAM() for i in range(8) ])


class tagTHREADINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pEThread = v_ptr64()
        self.RefCount = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.ptlW32 = v_ptr64()
        self.pgdiDcattr = v_ptr64()
        self.pgdiBrushAttr = v_ptr64()
        self.pUMPDObjs = v_ptr64()
        self.pUMPDHeap = v_ptr64()
        self.pUMPDObj = v_ptr64()
        self.pProxyPort = v_ptr64()
        self.pClientID = v_ptr64()
        self.GdiTmpTgoList = LIST_ENTRY()
        self.pRBRecursionCount = v_uint32()
        self.pNonRBRecursionCount = v_uint32()
        self.tlSpriteState = TLSPRITESTATE()
        self.pSpriteState = v_ptr64()
        self.pDevHTInfo = v_ptr64()
        self.ulDevHTInfoUniqueness = v_uint32()
        self._pad0128 = v_bytes(size=4)
        self.pdcoAA = v_ptr64()
        self.pdcoRender = v_ptr64()
        self.pdcoSrc = v_ptr64()
        self.bEnableEngUpdateDeviceSurface = v_uint8()
        self.bIncludeSprites = v_uint8()
        self._pad0144 = v_bytes(size=2)
        self.ulWindowSystemRendering = v_uint32()
        self.iVisRgnUniqueness = v_uint32()
        self._pad0150 = v_bytes(size=4)
        self.ptl = v_ptr64()
        self.ppi = v_ptr64()
        self.pq = v_ptr64()
        self.spklActive = v_ptr64()
        self.pcti = v_ptr64()
        self.rpdesk = v_ptr64()
        self.pDeskInfo = v_ptr64()
        self.ulClientDelta = v_uint64()
        self.pClientInfo = v_ptr64()
        self.TIF_flags = v_uint32()
        self._pad01a0 = v_bytes(size=4)
        self.pstrAppName = v_ptr64()
        self.psmsSent = v_ptr64()
        self.psmsCurrent = v_ptr64()
        self.psmsReceiveList = v_ptr64()
        self.timeLast = v_uint32()
        self._pad01c8 = v_bytes(size=4)
        self.idLast = v_uint64()
        self.exitCode = v_uint32()
        self._pad01d8 = v_bytes(size=4)
        self.hdesk = v_ptr64()
        self.cPaintsReady = v_uint32()
        self.cTimersReady = v_uint32()
        self.pMenuState = v_ptr64()
        self.ptdb = v_ptr64()
        self.psiiList = v_ptr64()
        self.dwExpWinVer = v_uint32()
        self.dwCompatFlags = v_uint32()
        self.dwCompatFlags2 = v_uint32()
        self._pad0210 = v_bytes(size=4)
        self.pqAttach = v_ptr64()
        self.ptiSibling = v_ptr64()
        self.pmsd = v_ptr64()
        self.fsHooks = v_uint32()
        self._pad0230 = v_bytes(size=4)
        self.sphkCurrent = v_ptr64()
        self.lParamHkCurrent = v_uint64()
        self.wParamHkCurrent = v_uint64()
        self.pSBTrack = v_ptr64()
        self.hEventQueueClient = v_ptr64()
        self.pEventQueueServer = v_ptr64()
        self.PtiLink = LIST_ENTRY()
        self.iCursorLevel = v_uint32()
        self.ptLast = tagPOINT()
        self.ptLastReal = tagPOINT()
        self._pad0288 = v_bytes(size=4)
        self.spwndDefaultIme = v_ptr64()
        self.spDefaultImc = v_ptr64()
        self.hklPrev = v_ptr64()
        self.cEnterCount = v_uint32()
        self._pad02a8 = v_bytes(size=4)
        self.mlPost = tagMLIST()
        self.fsChangeBitsRemoved = v_uint16()
        self.wchInjected = v_uint16()
        self.fsReserveKeys = v_uint32()
        self.apEvent = v_ptr64()
        self.amdesk = v_uint32()
        self.cWindows = v_uint32()
        self.cVisWindows = v_uint32()
        self._pad02e0 = v_bytes(size=4)
        self.aphkStart = vstruct.VArray([ v_ptr64() for i in range(16) ])
        self.cti = tagCLIENTTHREADINFO()
        self.hPrevHidData = v_ptr64()
        self.hTouchInputCurrent = v_ptr64()
        self.hGestureInfoCurrent = v_ptr64()
        self.MsgPPInfo = tagMSGPPINFO()
        self.cNestedStableVisRgn = v_uint32()
        self.readyHead = LIST_ENTRY()
        self.fSpecialInitialization = v_uint32()
        self._pad03a8 = v_bytes(size=4)


class D3DKMDT_VIDEO_SIGNAL_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VideoStandard = v_uint32()
        self.TotalSize = D3DKMDT_2DREGION()
        self.ActiveSize = D3DKMDT_2DREGION()
        self.VSyncFreq = D3DDDI_RATIONAL()
        self.HSyncFreq = D3DDDI_RATIONAL()
        self._pad0028 = v_bytes(size=4)
        self.PixelRate = v_uint64()
        self.ScanLineOrdering = v_uint32()
        self._pad0038 = v_bytes(size=4)


class CM_PARTIAL_RESOURCE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint16()
        self.Revision = v_uint16()
        self.Count = v_uint32()
        self.PartialDescriptors = vstruct.VArray([ CM_PARTIAL_RESOURCE_DESCRIPTOR() for i in range(1) ])


class HGESTUREINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class DEVICE_CAPABILITIES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self.DeviceD1 = v_uint32()
        self.Address = v_uint32()
        self.UINumber = v_uint32()
        self.DeviceState = vstruct.VArray([ DEVICE_POWER_STATE() for i in range(7) ])
        self.SystemWake = v_uint32()
        self.DeviceWake = v_uint32()
        self.D1Latency = v_uint32()
        self.D2Latency = v_uint32()
        self.D3Latency = v_uint32()


class tagMONITOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = HEAD()
        self.pMonitorNext = v_ptr64()
        self.dwMONFlags = v_uint32()
        self.rcMonitorReal = tagRECT()
        self.rcWorkReal = tagRECT()
        self._pad0040 = v_bytes(size=4)
        self.hrgnMonitorReal = v_ptr64()
        self.Spare0 = v_uint16()
        self.cWndStack = v_uint16()
        self._pad0050 = v_bytes(size=4)
        self.hDev = v_ptr64()
        self.hDevReal = v_ptr64()
        self.DockTargets = vstruct.VArray([ v_uint32() for i in range(7) ])
        self._pad0080 = v_bytes(size=4)
        self.Flink = v_ptr64()
        self.Blink = v_ptr64()


class _unnamed_10363(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.FileInformationClass = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.FileObject = v_ptr64()
        self.ReplaceIfExists = v_uint8()
        self.AdvanceOnly = v_uint8()
        self._pad0020 = v_bytes(size=6)


class KPROCESS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class DEVICE_OBJECT_POWER_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class tagTEXTMETRICW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.tmHeight = v_uint32()
        self.tmAscent = v_uint32()
        self.tmDescent = v_uint32()
        self.tmInternalLeading = v_uint32()
        self.tmExternalLeading = v_uint32()
        self.tmAveCharWidth = v_uint32()
        self.tmMaxCharWidth = v_uint32()
        self.tmWeight = v_uint32()
        self.tmOverhang = v_uint32()
        self.tmDigitizedAspectX = v_uint32()
        self.tmDigitizedAspectY = v_uint32()
        self.tmFirstChar = v_uint16()
        self.tmLastChar = v_uint16()
        self.tmDefaultChar = v_uint16()
        self.tmBreakChar = v_uint16()
        self.tmItalic = v_uint8()
        self.tmUnderlined = v_uint8()
        self.tmStruckOut = v_uint8()
        self.tmPitchAndFamily = v_uint8()
        self.tmCharSet = v_uint8()
        self._pad003c = v_bytes(size=3)


class WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Primary = v_uint32()


class TP_CALLBACK_ENVIRON_V3(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Pool = v_ptr64()
        self.CleanupGroup = v_ptr64()
        self.CleanupGroupCancelCallback = v_ptr64()
        self.RaceDll = v_ptr64()
        self.ActivationContext = v_ptr64()
        self.FinalizationCallback = v_ptr64()
        self.u = _unnamed_9312()
        self.CallbackPriority = v_uint32()
        self.Size = v_uint32()
        self._pad0048 = v_bytes(size=4)


class HDESK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class RTL_ACTIVATION_CONTEXT_STACK_FRAME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Previous = v_ptr64()
        self.ActivationContext = v_ptr64()
        self.Flags = v_uint32()
        self._pad0018 = v_bytes(size=4)


class OBJECT_HANDLE_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HandleAttributes = v_uint32()
        self.GrantedAccess = v_uint32()


class DMA_OPERATIONS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.PutDmaAdapter = v_ptr64()
        self.AllocateCommonBuffer = v_ptr64()
        self.FreeCommonBuffer = v_ptr64()
        self.AllocateAdapterChannel = v_ptr64()
        self.FlushAdapterBuffers = v_ptr64()
        self.FreeAdapterChannel = v_ptr64()
        self.FreeMapRegisters = v_ptr64()
        self.MapTransfer = v_ptr64()
        self.GetDmaAlignment = v_ptr64()
        self.ReadDmaCounter = v_ptr64()
        self.GetScatterGatherList = v_ptr64()
        self.PutScatterGatherList = v_ptr64()
        self.CalculateScatterGatherList = v_ptr64()
        self.BuildScatterGatherList = v_ptr64()
        self.BuildMdlFromScatterGatherList = v_ptr64()


class XSTATE_CONFIGURATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.EnabledFeatures = v_uint64()
        self.Size = v_uint32()
        self.OptimizedSave = v_uint32()
        self.Features = vstruct.VArray([ XSTATE_FEATURE() for i in range(64) ])


class _unnamed_10357(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.CompletionFilter = v_uint32()
        self._pad0010 = v_bytes(size=4)


class RTL_AVL_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.BalancedRoot = RTL_BALANCED_LINKS()
        self.OrderedPointer = v_ptr64()
        self.WhichOrderedElement = v_uint32()
        self.NumberGenericTableElements = v_uint32()
        self.DepthOfTree = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.RestartKey = v_ptr64()
        self.DeleteCount = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.CompareRoutine = v_ptr64()
        self.AllocateRoutine = v_ptr64()
        self.FreeRoutine = v_ptr64()
        self.TableContext = v_ptr64()


class tagHID_TLC_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.link = LIST_ENTRY()
        self.usUsagePage = v_uint16()
        self.usUsage = v_uint16()
        self.cDevices = v_uint32()
        self.cDirectRequest = v_uint32()
        self.cUsagePageRequest = v_uint32()
        self.cExcludeRequest = v_uint32()
        self.cExcludeOrphaned = v_uint32()


class WHEA_ERROR_PACKET_V2(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Version = v_uint32()
        self.Length = v_uint32()
        self.Flags = WHEA_ERROR_PACKET_FLAGS()
        self.ErrorType = v_uint32()
        self.ErrorSeverity = v_uint32()
        self.ErrorSourceId = v_uint32()
        self.ErrorSourceType = v_uint32()
        self.NotifyType = GUID()
        self.Context = v_uint64()
        self.DataFormat = v_uint32()
        self.Reserved1 = v_uint32()
        self.DataOffset = v_uint32()
        self.DataLength = v_uint32()
        self.PshedDataOffset = v_uint32()
        self.PshedDataLength = v_uint32()


class DXGK_DIAG_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()
        self.Size = v_uint32()
        self.LogTimestamp = v_uint64()
        self.ProcessName = vstruct.VArray([ v_uint8() for i in range(16) ])
        self.ThreadId = v_uint64()
        self.Index = v_uint32()
        self.WdLogIdx = v_uint32()


class DMM_VIDPNPATHANDTARGETMODESET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PathInfo = D3DKMDT_VIDPN_PRESENT_PATH()
        self.TargetModeSet = DMM_VIDPNTARGETMODESET_SERIALIZATION()


class VK_TO_WCHARS1(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VirtualKey = v_uint8()
        self.Attributes = v_uint8()
        self.wch = vstruct.VArray([ v_uint16() for i in range(1) ])


class OWNER_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OwnerThread = v_uint64()
        self.IoPriorityBoosted = v_uint32()
        self._pad0010 = v_bytes(size=4)


class DEVOBJ_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.DeviceObject = v_ptr64()
        self.PowerFlags = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.Dope = v_ptr64()
        self.ExtensionFlags = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.DeviceNode = v_ptr64()
        self.AttachedTo = v_ptr64()
        self.StartIoCount = v_uint32()
        self.StartIoKey = v_uint32()
        self.StartIoFlags = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.Vpb = v_ptr64()
        self.DependentList = LIST_ENTRY()
        self.ProviderList = LIST_ENTRY()


class D3DKMDT_MONITOR_FREQUENCY_RANGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Origin = v_uint32()
        self.RangeLimits = D3DKMDT_FREQUENCY_RANGE()
        self.ConstraintType = v_uint32()
        self.Constraint = _unnamed_11215()


class tagQ(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.mlInput = tagMLIST()
        self.ptiSysLock = v_ptr64()
        self.idSysLock = v_uint64()
        self.idSysPeek = v_uint64()
        self.ptiMouse = v_ptr64()
        self.ptiKeyboard = v_ptr64()
        self.spwndCapture = v_ptr64()
        self.spwndFocus = v_ptr64()
        self.spwndActive = v_ptr64()
        self.spwndActivePrev = v_ptr64()
        self.codeCapture = v_uint32()
        self.msgDblClk = v_uint32()
        self.xbtnDblClk = v_uint16()
        self._pad006c = v_bytes(size=2)
        self.timeDblClk = v_uint32()
        self.hwndDblClk = v_ptr64()
        self.ptDblClk = tagPOINT()
        self.ptMouseMove = tagPOINT()
        self.afKeyRecentDown = vstruct.VArray([ v_uint8() for i in range(32) ])
        self.afKeyState = vstruct.VArray([ v_uint8() for i in range(64) ])
        self.caret = tagCARET()
        self.spcurCurrent = v_ptr64()
        self.iCursorLevel = v_uint32()
        self.QF_flags = v_uint32()
        self.cThreads = v_uint16()
        self.cLockCount = v_uint16()
        self.msgJournal = v_uint32()
        self.ExtraInfo = v_uint64()
        self.ulEtwReserved1 = v_uint32()
        self._pad0158 = v_bytes(size=4)


class _unnamed_10148(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListEntry = LIST_ENTRY()
        self._pad0048 = v_bytes(size=56)


class CALLPROCDATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = PROCDESKHEAD()
        self.spcpdNext = v_ptr64()
        self.pfnClientPrevious = v_uint64()
        self.wType = v_uint16()
        self._pad0040 = v_bytes(size=6)


class WM_VALUES_STRINGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pszName = v_ptr64()
        self.fInternal = v_uint8()
        self.fDefined = v_uint8()
        self._pad0010 = v_bytes(size=6)


class MAILSLOT_CREATE_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MailslotQuota = v_uint32()
        self.MaximumMessageSize = v_uint32()
        self.ReadTimeout = LARGE_INTEGER()
        self.TimeoutSpecified = v_uint8()
        self._pad0018 = v_bytes(size=7)


class HIMC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class _unnamed_10417(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Vpb = v_ptr64()
        self.DeviceObject = v_ptr64()


class ACCESS_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OperationID = LUID()
        self.SecurityEvaluated = v_uint8()
        self.GenerateAudit = v_uint8()
        self.GenerateOnClose = v_uint8()
        self.PrivilegesAllocated = v_uint8()
        self.Flags = v_uint32()
        self.RemainingDesiredAccess = v_uint32()
        self.PreviouslyGrantedAccess = v_uint32()
        self.OriginalDesiredAccess = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.SubjectSecurityContext = SECURITY_SUBJECT_CONTEXT()
        self.SecurityDescriptor = v_ptr64()
        self.AuxData = v_ptr64()
        self.Privileges = _unnamed_10796()
        self.AuditPrivileges = v_uint8()
        self._pad0080 = v_bytes(size=3)
        self.ObjectName = UNICODE_STRING()
        self.ObjectTypeName = UNICODE_STRING()


class FILE_STANDARD_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocationSize = LARGE_INTEGER()
        self.EndOfFile = LARGE_INTEGER()
        self.NumberOfLinks = v_uint32()
        self.DeletePending = v_uint8()
        self.Directory = v_uint8()
        self._pad0018 = v_bytes(size=2)


class _unnamed_9985(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Depth = v_uint64()
        self.HeaderType = v_uint64()


class _unnamed_9984(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Depth = v_uint64()
        self.HeaderType = v_uint64()


class _unnamed_9983(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Depth = v_uint64()
        self.HeaderType = v_uint64()


class tagRECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.left = v_uint32()
        self.top = v_uint32()
        self.right = v_uint32()
        self.bottom = v_uint32()


class GDI_TEB_BATCH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.HDC = v_uint64()
        self.Buffer = vstruct.VArray([ v_uint32() for i in range(310) ])


class ECP_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_13949(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length48 = v_uint32()


class tagMENUSTATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pGlobalPopupMenu = v_ptr64()
        self.fMenuStarted = v_uint32()
        self.ptMouseLast = tagPOINT()
        self.mnFocus = v_uint32()
        self.cmdLast = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.ptiMenuStateOwner = v_ptr64()
        self.dwLockCount = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.pmnsPrev = v_ptr64()
        self.ptButtonDown = tagPOINT()
        self.uButtonDownHitArea = v_uint64()
        self.uButtonDownIndex = v_uint32()
        self.vkButtonDown = v_uint32()
        self.uDraggingHitArea = v_uint64()
        self.uDraggingIndex = v_uint32()
        self.uDraggingFlags = v_uint32()
        self.hdcWndAni = v_ptr64()
        self.dwAniStartTime = v_uint32()
        self.ixAni = v_uint32()
        self.iyAni = v_uint32()
        self.cxAni = v_uint32()
        self.cyAni = v_uint32()
        self._pad0080 = v_bytes(size=4)
        self.hbmAni = v_ptr64()
        self.hdcAni = v_ptr64()


class SECTION_OBJECT_POINTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSectionObject = v_ptr64()
        self.SharedCacheMap = v_ptr64()
        self.ImageSectionObject = v_ptr64()


class MDL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr64()
        self.Size = v_uint16()
        self.MdlFlags = v_uint16()
        self._pad0010 = v_bytes(size=4)
        self.Process = v_ptr64()
        self.MappedSystemVa = v_ptr64()
        self.StartVa = v_ptr64()
        self.ByteCount = v_uint32()
        self.ByteOffset = v_uint32()


class tagMSGPPINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwIndexMsgPP = v_uint32()


class _unnamed_13942(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataSize = v_uint32()
        self.Reserved1 = v_uint32()
        self.Reserved2 = v_uint32()


class VWPLELEMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DataOrTag = v_uint64()
        self.pwnd = v_ptr64()


class _unnamed_13946(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length40 = v_uint32()


class IO_TIMER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class VSC_VK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Vsc = v_uint8()
        self._pad0002 = v_bytes(size=1)
        self.Vk = v_uint16()


class WHEA_REVISION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinorRevision = v_uint8()
        self.MajorRevision = v_uint8()


class MAGNIFICATION_INPUT_TRANSFORM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.rcSource = tagRECT()
        self.rcScreen = tagRECT()
        self.ptiMagThreadInfo = v_ptr64()
        self.magFactorX = v_uint32()
        self.magFactorY = v_uint32()


class TP_CLEANUP_GROUP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class DMM_VIDPNPATHANDTARGETMODE_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PathInfo = D3DKMDT_VIDPN_PRESENT_PATH()
        self.TargetMode = D3DKMDT_VIDPN_TARGET_MODE()


class _unnamed_10483(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Capabilities = v_ptr64()


class D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_SUPPORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NoProtection = v_uint32()


class D3DDDI_DXGI_RGB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Red = v_uint32()
        self.Green = v_uint32()
        self.Blue = v_uint32()


class OBJECT_TYPE_INITIALIZER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.ObjectTypeFlags = v_uint8()
        self._pad0004 = v_bytes(size=1)
        self.ObjectTypeCode = v_uint32()
        self.InvalidAttributes = v_uint32()
        self.GenericMapping = GENERIC_MAPPING()
        self.ValidAccessMask = v_uint32()
        self.RetainAccess = v_uint32()
        self.PoolType = v_uint32()
        self.DefaultPagedPoolCharge = v_uint32()
        self.DefaultNonPagedPoolCharge = v_uint32()
        self.DumpProcedure = v_ptr64()
        self.OpenProcedure = v_ptr64()
        self.CloseProcedure = v_ptr64()
        self.DeleteProcedure = v_ptr64()
        self.ParseProcedure = v_ptr64()
        self.SecurityProcedure = v_ptr64()
        self.QueryNameProcedure = v_ptr64()
        self.OkayToCloseProcedure = v_ptr64()


class MOVESIZEDATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.spwnd = v_ptr64()
        self.rcDrag = tagRECT()
        self.rcDragCursor = tagRECT()
        self.rcPreview = tagRECT()
        self.rcPreviewCursor = tagRECT()
        self.rcParent = tagRECT()
        self.ptMinTrack = tagPOINT()
        self.ptMaxTrack = tagPOINT()
        self.rcWindow = tagRECT()
        self.rcNormalStartCheckPt = tagRECT()
        self.dxMouse = v_uint32()
        self.dyMouse = v_uint32()
        self.cmd = v_uint32()
        self.impx = v_uint32()
        self.impy = v_uint32()
        self.ptRestore = tagPOINT()
        self.Flags = v_uint32()
        self.pStartMonitorCurrentHitTarget = v_ptr64()
        self.StartCurrentHitTarget = v_uint32()
        self._pad00b8 = v_bytes(size=4)
        self.pMonitorCurrentHitTarget = v_ptr64()
        self.CurrentHitTarget = v_uint32()
        self.MoveRectStyle = v_uint32()
        self.ptHitWindowRelative = tagPOINT()
        self.ptStartHitWindowRelative = tagPOINT()
        self.ptLastTrack = tagPOINT()
        self.ulCountDragOutOfTopTarget = v_uint32()
        self.ulCountDragOutOfLeftRightTarget = v_uint32()
        self.ulCountSizeOutOfTopBottomTarget = v_uint32()
        self._pad00f0 = v_bytes(size=4)


class TP_DIRECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Callback = v_ptr64()
        self.NumaNode = v_uint32()
        self.IdealProcessor = v_uint8()
        self._pad0010 = v_bytes(size=3)


class LARGE_INTEGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class _unnamed_13938(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = v_uint32()
        self.Length = v_uint32()
        self.Reserved = v_uint32()


class _unnamed_13936(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data = vstruct.VArray([ v_uint32() for i in range(3) ])


class _unnamed_13932(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Channel = v_uint32()
        self.Port = v_uint32()
        self.Reserved1 = v_uint32()


class tagQMSG(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pqmsgNext = v_ptr64()
        self.pqmsgPrev = v_ptr64()
        self.msg = tagMSG()
        self.ExtraInfo = v_uint64()
        self.ptMouseReal = tagPOINT()
        self.dwQEvent = v_uint32()
        self.Wow64Message = v_uint32()
        self.pti = v_ptr64()
        self.MsgPPInfo = tagMSGPPINFO()
        self._pad0068 = v_bytes(size=4)


class PAGED_LOOKASIDE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.L = GENERAL_LOOKASIDE()


class RTL_BITMAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfBitMap = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Buffer = v_ptr64()


class TLSPRITESTATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.bInsideDriverCall = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.flOriginalSurfFlags = v_uint32()
        self.iOriginalType = v_uint32()
        self.flSpriteSurfFlags = v_uint32()
        self.iSpriteType = v_uint32()
        self.flags = v_uint32()
        self.iType = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.pState = v_ptr64()
        self.pfnStrokeAndFillPath = v_ptr64()
        self.pfnStrokePath = v_ptr64()
        self.pfnFillPath = v_ptr64()
        self.pfnPaint = v_ptr64()
        self.pfnBitBlt = v_ptr64()
        self.pfnCopyBits = v_ptr64()
        self.pfnStretchBlt = v_ptr64()
        self.pfnTextOut = v_ptr64()
        self.pfnLineTo = v_ptr64()
        self.pfnTransparentBlt = v_ptr64()
        self.pfnAlphaBlend = v_ptr64()
        self.pfnPlgBlt = v_ptr64()
        self.pfnGradientFill = v_ptr64()
        self.pfnSaveScreenBits = v_ptr64()
        self.pfnStretchBltROP = v_ptr64()
        self.pfnDrawStream = v_ptr64()


class HICON(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class NPAGED_LOOKASIDE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.L = GENERAL_LOOKASIDE()


class tagWin32PoolHead(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.size = v_uint64()
        self.pPrev = v_ptr64()
        self.pNext = v_ptr64()
        self.pTrace = v_ptr64()


class VPB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.Flags = v_uint16()
        self.VolumeLabelLength = v_uint16()
        self.DeviceObject = v_ptr64()
        self.RealDevice = v_ptr64()
        self.SerialNumber = v_uint32()
        self.ReferenceCount = v_uint32()
        self.VolumeLabel = vstruct.VArray([ v_uint16() for i in range(32) ])


class tagTOUCHINPUT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.x = v_uint32()
        self.y = v_uint32()
        self.hSource = v_ptr64()
        self.dwID = v_uint32()
        self.dwFlags = v_uint32()
        self.dwMask = v_uint32()
        self.dwTime = v_uint32()
        self.dwExtraInfo = v_uint64()
        self.cxContact = v_uint32()
        self.cyContact = v_uint32()


class HEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.h = v_ptr64()
        self.cLockObj = v_uint32()
        self._pad0010 = v_bytes(size=4)


class OBJECT_NAME_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Name = UNICODE_STRING()


class IO_RESOURCE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint16()
        self.Revision = v_uint16()
        self.Count = v_uint32()
        self.Descriptors = vstruct.VArray([ IO_RESOURCE_DESCRIPTOR() for i in range(1) ])


class KUSER_SHARED_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TickCountLowDeprecated = v_uint32()
        self.TickCountMultiplier = v_uint32()
        self.InterruptTime = KSYSTEM_TIME()
        self.SystemTime = KSYSTEM_TIME()
        self.TimeZoneBias = KSYSTEM_TIME()
        self.ImageNumberLow = v_uint16()
        self.ImageNumberHigh = v_uint16()
        self.NtSystemRoot = vstruct.VArray([ v_uint16() for i in range(260) ])
        self.MaxStackTraceDepth = v_uint32()
        self.CryptoExponent = v_uint32()
        self.TimeZoneId = v_uint32()
        self.LargePageMinimum = v_uint32()
        self.Reserved2 = vstruct.VArray([ v_uint32() for i in range(7) ])
        self.NtProductType = v_uint32()
        self.ProductTypeIsValid = v_uint8()
        self._pad026c = v_bytes(size=3)
        self.NtMajorVersion = v_uint32()
        self.NtMinorVersion = v_uint32()
        self.ProcessorFeatures = vstruct.VArray([ v_uint8() for i in range(64) ])
        self.Reserved1 = v_uint32()
        self.Reserved3 = v_uint32()
        self.TimeSlip = v_uint32()
        self.AlternativeArchitecture = v_uint32()
        self.AltArchitecturePad = vstruct.VArray([ v_uint32() for i in range(1) ])
        self.SystemExpirationDate = LARGE_INTEGER()
        self.SuiteMask = v_uint32()
        self.KdDebuggerEnabled = v_uint8()
        self.NXSupportPolicy = v_uint8()
        self._pad02d8 = v_bytes(size=2)
        self.ActiveConsoleId = v_uint32()
        self.DismountCount = v_uint32()
        self.ComPlusPackage = v_uint32()
        self.LastSystemRITEventTickCount = v_uint32()
        self.NumberOfPhysicalPages = v_uint32()
        self.SafeBootMode = v_uint8()
        self.TscQpcData = v_uint8()
        self.TscQpcPad = vstruct.VArray([ v_uint8() for i in range(2) ])
        self.SharedDataFlags = v_uint32()
        self.DataFlagsPad = vstruct.VArray([ v_uint32() for i in range(1) ])
        self.TestRetInstruction = v_uint64()
        self.SystemCall = v_uint32()
        self.SystemCallReturn = v_uint32()
        self.SystemCallPad = vstruct.VArray([ v_uint64() for i in range(3) ])
        self.TickCount = KSYSTEM_TIME()
        self.TickCountPad = vstruct.VArray([ v_uint32() for i in range(1) ])
        self.Cookie = v_uint32()
        self.CookiePad = vstruct.VArray([ v_uint32() for i in range(1) ])
        self.ConsoleSessionForegroundProcessId = v_uint64()
        self.Wow64SharedInformation = vstruct.VArray([ v_uint32() for i in range(16) ])
        self.UserModeGlobalLogger = vstruct.VArray([ v_uint16() for i in range(16) ])
        self.ImageFileExecutionOptions = v_uint32()
        self.LangGenerationCount = v_uint32()
        self.Reserved5 = v_uint64()
        self.InterruptTimeBias = v_uint64()
        self.TscQpcBias = v_uint64()
        self.ActiveProcessorCount = v_uint32()
        self.ActiveGroupCount = v_uint16()
        self.Reserved4 = v_uint16()
        self.AitSamplingValue = v_uint32()
        self.AppCompatFlag = v_uint32()
        self.SystemDllNativeRelocation = v_uint64()
        self.SystemDllWowRelocation = v_uint32()
        self.XStatePad = vstruct.VArray([ v_uint32() for i in range(1) ])
        self.XState = XSTATE_CONFIGURATION()


class SYSTEM_POWER_STATE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reserved1 = v_uint32()


class IO_STATUS_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Status = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Information = v_uint64()


class PRIVILEGE_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrivilegeCount = v_uint32()
        self.Control = v_uint32()
        self.Privilege = vstruct.VArray([ LUID_AND_ATTRIBUTES() for i in range(1) ])


class CM_RESOURCE_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self.List = vstruct.VArray([ CM_FULL_RESOURCE_DESCRIPTOR() for i in range(1) ])


class DMM_MONITOR_SOURCE_MODE_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Info = D3DKMDT_MONITOR_SOURCE_MODE()
        self.TimingType = v_uint32()
        self._pad0068 = v_bytes(size=4)


class EPROCESS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class tagPROFILEVALUEINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwValue = v_uint32()
        self.uSection = v_uint32()
        self.pwszKeyName = v_ptr64()


class tagDISPLAYINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.hDev = v_ptr64()
        self.pmdev = v_ptr64()
        self.hDevInfo = v_ptr64()
        self.hdcScreen = v_ptr64()
        self.hdcBits = v_ptr64()
        self.hdcGray = v_ptr64()
        self.hbmGray = v_ptr64()
        self.cxGray = v_uint32()
        self.cyGray = v_uint32()
        self.pdceFirst = v_ptr64()
        self.pspbFirst = v_ptr64()
        self.cMonitors = v_uint32()
        self._pad0058 = v_bytes(size=4)
        self.pMonitorPrimary = v_ptr64()
        self.pMonitorFirst = v_ptr64()
        self.rcScreenReal = tagRECT()
        self.hrgnScreenReal = v_ptr64()
        self.dmLogPixels = v_uint16()
        self.BitCountMax = v_uint16()
        self.fDesktopIsRect = v_uint32()
        self.DockThresholdMax = v_uint32()
        self._pad0090 = v_bytes(size=4)
        self.SpatialListHead = KLIST_ENTRY()
        self.cFullScreen = v_uint16()
        self.Spare0 = v_uint16()
        self._pad00a8 = v_bytes(size=4)


class TP_TASK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Callbacks = v_ptr64()
        self.NumaNode = v_uint32()
        self.IdealProcessor = v_uint8()
        self._pad0010 = v_bytes(size=3)
        self.PostGuard = TP_NBQ_GUARD()
        self.NBQNode = v_ptr64()


class PROCDESKHEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.h = v_ptr64()
        self.cLockObj = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.hTaskWow = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.rpdesk = v_ptr64()
        self.pSelf = v_ptr64()


class PFNCLIENTWORKER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pfnButtonWndProc = v_ptr64()
        self.pfnComboBoxWndProc = v_ptr64()
        self.pfnComboListBoxProc = v_ptr64()
        self.pfnDialogWndProc = v_ptr64()
        self.pfnEditWndProc = v_ptr64()
        self.pfnListBoxWndProc = v_ptr64()
        self.pfnMDIClientWndProc = v_ptr64()
        self.pfnStaticWndProc = v_ptr64()
        self.pfnImeWndProc = v_ptr64()
        self.pfnGhostWndProc = v_ptr64()
        self.pfnCtfHookProc = v_ptr64()


class DMM_COMMITVIDPNREQUESTSET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumCommitVidPnRequests = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.CommitVidPnRequestOffset = vstruct.VArray([ v_uint32() for i in range(1) ])


class D3DKMDT_MONITOR_SOURCE_MODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.VideoSignalInfo = D3DKMDT_VIDEO_SIGNAL_INFO()
        self.ColorBasis = v_uint32()
        self.ColorCoeffDynamicRanges = D3DKMDT_COLOR_COEFF_DYNAMIC_RANGES()
        self.Origin = v_uint32()
        self.Preference = v_uint32()
        self._pad0060 = v_bytes(size=4)


class _unnamed_11215(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ActiveSize = D3DKMDT_2DREGION()


class CM_PARTIAL_RESOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.ShareDisposition = v_uint8()
        self.Flags = v_uint16()
        self.u = _unnamed_13586()


class TP_CALLBACK_INSTANCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class tagSBCALC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.posMin = v_uint32()
        self.posMax = v_uint32()
        self.page = v_uint32()
        self.pos = v_uint32()
        self.pxTop = v_uint32()
        self.pxBottom = v_uint32()
        self.pxLeft = v_uint32()
        self.pxRight = v_uint32()
        self.cpxThumb = v_uint32()
        self.pxUpArrow = v_uint32()
        self.pxDownArrow = v_uint32()
        self.pxStart = v_uint32()
        self.pxThumbBottom = v_uint32()
        self.pxThumbTop = v_uint32()
        self.cpx = v_uint32()
        self.pxMin = v_uint32()


class OBJECT_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.RootDirectory = v_ptr64()
        self.ObjectName = v_ptr64()
        self.Attributes = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.SecurityDescriptor = v_ptr64()
        self.SecurityQualityOfService = v_ptr64()


class CM_FULL_RESOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.PartialResourceList = CM_PARTIAL_RESOURCE_LIST()


class FAST_IO_DISPATCH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SizeOfFastIoDispatch = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.FastIoCheckIfPossible = v_ptr64()
        self.FastIoRead = v_ptr64()
        self.FastIoWrite = v_ptr64()
        self.FastIoQueryBasicInfo = v_ptr64()
        self.FastIoQueryStandardInfo = v_ptr64()
        self.FastIoLock = v_ptr64()
        self.FastIoUnlockSingle = v_ptr64()
        self.FastIoUnlockAll = v_ptr64()
        self.FastIoUnlockAllByKey = v_ptr64()
        self.FastIoDeviceControl = v_ptr64()
        self.AcquireFileForNtCreateSection = v_ptr64()
        self.ReleaseFileForNtCreateSection = v_ptr64()
        self.FastIoDetachDevice = v_ptr64()
        self.FastIoQueryNetworkOpenInfo = v_ptr64()
        self.AcquireForModWrite = v_ptr64()
        self.MdlRead = v_ptr64()
        self.MdlReadComplete = v_ptr64()
        self.PrepareMdlWrite = v_ptr64()
        self.MdlWriteComplete = v_ptr64()
        self.FastIoReadCompressed = v_ptr64()
        self.FastIoWriteCompressed = v_ptr64()
        self.MdlReadCompleteCompressed = v_ptr64()
        self.MdlWriteCompleteCompressed = v_ptr64()
        self.FastIoQueryOpen = v_ptr64()
        self.ReleaseForModWrite = v_ptr64()
        self.AcquireForCcFlush = v_ptr64()
        self.ReleaseForCcFlush = v_ptr64()


class tagPROCESS_HID_REQUEST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.link = LIST_ENTRY()
        self.usUsagePage = v_uint16()
        self.usUsage = v_uint16()
        self.fSinkable = v_uint32()
        self.pTLCInfo = v_ptr64()
        self.spwndTarget = v_ptr64()


class KFLOATING_SAVE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Dummy = v_uint32()


class RTL_DYNAMIC_HASH_TABLE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ChainHead = v_ptr64()
        self.PrevLinkage = v_ptr64()
        self.Signature = v_uint64()


class tagSBDATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.posMin = v_uint32()
        self.posMax = v_uint32()
        self.page = v_uint32()
        self.pos = v_uint32()


class D3DDDI_GAMMA_RAMP_RGB256x3x16(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Red = vstruct.VArray([ v_uint16() for i in range(256) ])
        self.Green = vstruct.VArray([ v_uint16() for i in range(256) ])
        self.Blue = vstruct.VArray([ v_uint16() for i in range(256) ])


class tagUAHMENUPOPUPMETRICS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.rgcx = vstruct.VArray([ v_uint32() for i in range(4) ])
        self.fUpdateMaxWidths = v_uint32()


class _unnamed_10527(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InPath = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in range(3) ])
        self._pad0008 = v_bytes(size=4)
        self.Type = v_uint32()
        self._pad0010 = v_bytes(size=4)


class THROBJHEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.h = v_ptr64()
        self.cLockObj = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.pti = v_ptr64()


class DMM_VIDPNTARGETMODESET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumModes = v_uint8()
        self._pad0008 = v_bytes(size=7)
        self.ModeSerialization = vstruct.VArray([ D3DKMDT_VIDPN_TARGET_MODE() for i in range(1) ])


class KGDTENTRY64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LimitLow = v_uint16()
        self.BaseLow = v_uint16()
        self.Bytes = _unnamed_9807()
        self.BaseUpper = v_uint32()
        self.MustBeZero = v_uint32()


class KSPECIAL_REGISTERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Cr0 = v_uint64()
        self.Cr2 = v_uint64()
        self.Cr3 = v_uint64()
        self.Cr4 = v_uint64()
        self.KernelDr0 = v_uint64()
        self.KernelDr1 = v_uint64()
        self.KernelDr2 = v_uint64()
        self.KernelDr3 = v_uint64()
        self.KernelDr6 = v_uint64()
        self.KernelDr7 = v_uint64()
        self.Gdtr = KDESCRIPTOR()
        self.Idtr = KDESCRIPTOR()
        self.Tr = v_uint16()
        self.Ldtr = v_uint16()
        self.MxCsr = v_uint32()
        self.DebugControl = v_uint64()
        self.LastBranchToRip = v_uint64()
        self.LastBranchFromRip = v_uint64()
        self.LastExceptionToRip = v_uint64()
        self.LastExceptionFromRip = v_uint64()
        self.Cr8 = v_uint64()
        self.MsrGsBase = v_uint64()
        self.MsrGsSwap = v_uint64()
        self.MsrStar = v_uint64()
        self.MsrLStar = v_uint64()
        self.MsrCStar = v_uint64()
        self.MsrSyscallMask = v_uint64()


class _unnamed_10441(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InterfaceType = v_ptr64()
        self.Size = v_uint16()
        self.Version = v_uint16()
        self._pad0010 = v_bytes(size=4)
        self.Interface = v_ptr64()
        self.InterfaceSpecificData = v_ptr64()


class TP_NBQ_GUARD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.GuardLinks = LIST_ENTRY()
        self.Guards = vstruct.VArray([ v_ptr64() for i in range(2) ])


class RTL_CRITICAL_SECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DebugInfo = v_ptr64()
        self.LockCount = v_uint32()
        self.RecursionCount = v_uint32()
        self.OwningThread = v_ptr64()
        self.LockSemaphore = v_ptr64()
        self.SpinCount = v_uint64()


class KSYSTEM_TIME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.High1Time = v_uint32()
        self.High2Time = v_uint32()


class DMA_ADAPTER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Version = v_uint16()
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.DmaOperations = v_ptr64()


class WNDMSG(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.maxMsgs = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.abMsgs = v_ptr64()


class D3DDDI_RATIONAL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Numerator = v_uint32()
        self.Denominator = v_uint32()


class LUID_AND_ATTRIBUTES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Luid = LUID()
        self.Attributes = v_uint32()


class IMAGE_NT_HEADERS64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.FileHeader = IMAGE_FILE_HEADER()
        self.OptionalHeader = IMAGE_OPTIONAL_HEADER64()


class tagSBTRACK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.fHitOld = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.spwndTrack = v_ptr64()
        self.spwndSB = v_ptr64()
        self.spwndSBNotify = v_ptr64()
        self.rcTrack = tagRECT()
        self.xxxpfnSB = v_ptr64()
        self.cmdSB = v_uint32()
        self._pad0040 = v_bytes(size=4)
        self.hTimerSB = v_uint64()
        self.dpxThumb = v_uint32()
        self.pxOld = v_uint32()
        self.posOld = v_uint32()
        self.posNew = v_uint32()
        self.nBar = v_uint32()
        self._pad0060 = v_bytes(size=4)
        self.pSBCalc = v_ptr64()


class KTHREAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class HFONT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class tagDPISERVERINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.gclBorder = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.hCaptionFont = v_ptr64()
        self.hMsgFont = v_ptr64()
        self.cxMsgFontChar = v_uint32()
        self.cyMsgFontChar = v_uint32()
        self.wMaxBtnSize = v_uint32()
        self._pad0028 = v_bytes(size=4)


class HDC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.P1Home = v_uint64()
        self.P2Home = v_uint64()
        self.P3Home = v_uint64()
        self.P4Home = v_uint64()
        self.P5Home = v_uint64()
        self.P6Home = v_uint64()
        self.ContextFlags = v_uint32()
        self.MxCsr = v_uint32()
        self.SegCs = v_uint16()
        self.SegDs = v_uint16()
        self.SegEs = v_uint16()
        self.SegFs = v_uint16()
        self.SegGs = v_uint16()
        self.SegSs = v_uint16()
        self.EFlags = v_uint32()
        self.Dr0 = v_uint64()
        self.Dr1 = v_uint64()
        self.Dr2 = v_uint64()
        self.Dr3 = v_uint64()
        self.Dr6 = v_uint64()
        self.Dr7 = v_uint64()
        self.Rax = v_uint64()
        self.Rcx = v_uint64()
        self.Rdx = v_uint64()
        self.Rbx = v_uint64()
        self.Rsp = v_uint64()
        self.Rbp = v_uint64()
        self.Rsi = v_uint64()
        self.Rdi = v_uint64()
        self.R8 = v_uint64()
        self.R9 = v_uint64()
        self.R10 = v_uint64()
        self.R11 = v_uint64()
        self.R12 = v_uint64()
        self.R13 = v_uint64()
        self.R14 = v_uint64()
        self.R15 = v_uint64()
        self.Rip = v_uint64()
        self.FltSave = XSAVE_FORMAT()
        self.VectorRegister = vstruct.VArray([ M128A() for i in range(26) ])
        self.VectorControl = v_uint64()
        self.DebugControl = v_uint64()
        self.LastBranchToRip = v_uint64()
        self.LastBranchFromRip = v_uint64()
        self.LastExceptionToRip = v_uint64()
        self.LastExceptionFromRip = v_uint64()


class WAIT_CONTEXT_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WaitQueueEntry = KDEVICE_QUEUE_ENTRY()
        self.DeviceRoutine = v_ptr64()
        self.DeviceContext = v_ptr64()
        self.NumberOfMapRegisters = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.DeviceObject = v_ptr64()
        self.CurrentIrp = v_ptr64()
        self.BufferChainingDpc = v_ptr64()


class AUX_ACCESS_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrivilegesUsed = v_ptr64()
        self.GenericMapping = GENERIC_MAPPING()
        self.AccessesToAudit = v_uint32()
        self.MaximumAuditMask = v_uint32()
        self.TransactionId = GUID()
        self.NewSecurityDescriptor = v_ptr64()
        self.ExistingSecurityDescriptor = v_ptr64()
        self.ParentSecurityDescriptor = v_ptr64()
        self.DeRefSecurityDescriptor = v_ptr64()
        self.SDLock = v_ptr64()
        self.AccessReasons = ACCESS_REASONS()


class LIGATURE1(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VirtualKey = v_uint8()
        self._pad0002 = v_bytes(size=1)
        self.ModificationNumber = v_uint16()
        self.wch = vstruct.VArray([ v_uint16() for i in range(1) ])


class D3DKMDT_VIDPN_PRESENT_PATH_SCALING_SUPPORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Identity = v_uint32()


class EVENT_DATA_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Ptr = v_uint64()
        self.Size = v_uint32()
        self.Reserved = v_uint32()


class TEB_ACTIVE_FRAME_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.FrameName = v_ptr64()


class DRIVER_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.DeviceObject = v_ptr64()
        self.Flags = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.DriverStart = v_ptr64()
        self.DriverSize = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.DriverSection = v_ptr64()
        self.DriverExtension = v_ptr64()
        self.DriverName = UNICODE_STRING()
        self.HardwareDatabase = v_ptr64()
        self.FastIoDispatch = v_ptr64()
        self.DriverInit = v_ptr64()
        self.DriverStartIo = v_ptr64()
        self.DriverUnload = v_ptr64()
        self.MajorFunction = vstruct.VArray([ v_ptr64() for i in range(28) ])


class HMONITOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class EJOB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class D3DKMDT_GAMMA_RAMP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.DataSize = v_uint64()
        self.Data = _unnamed_13776()


class VK_TO_BIT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Vk = v_uint8()
        self.ModBits = v_uint8()


class KPROCESSOR_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SpecialRegisters = KSPECIAL_REGISTERS()
        self._pad00e0 = v_bytes(size=8)
        self.ContextFrame = CONTEXT()


class KAPC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.SpareByte0 = v_uint8()
        self.Size = v_uint8()
        self.SpareByte1 = v_uint8()
        self.SpareLong0 = v_uint32()
        self.Thread = v_ptr64()
        self.ApcListEntry = LIST_ENTRY()
        self.KernelRoutine = v_ptr64()
        self.RundownRoutine = v_ptr64()
        self.NormalRoutine = v_ptr64()
        self.NormalContext = v_ptr64()
        self.SystemArgument1 = v_ptr64()
        self.SystemArgument2 = v_ptr64()
        self.ApcStateIndex = v_uint8()
        self.ApcMode = v_uint8()
        self.Inserted = v_uint8()
        self._pad0058 = v_bytes(size=5)


class tagIMEINFOEX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.hkl = v_ptr64()
        self.ImeInfo = tagIMEINFO()
        self.wszUIClass = vstruct.VArray([ v_uint16() for i in range(16) ])
        self.fdwInitConvMode = v_uint32()
        self.fInitOpen = v_uint32()
        self.fLoadFlag = v_uint32()
        self.dwProdVersion = v_uint32()
        self.dwImeWinVersion = v_uint32()
        self.wszImeDescription = vstruct.VArray([ v_uint16() for i in range(50) ])
        self.wszImeFile = vstruct.VArray([ v_uint16() for i in range(80) ])
        self.fSysWow64Only = v_uint32()


class D3DKMDT_FREQUENCY_RANGE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinVSyncFreq = D3DDDI_RATIONAL()
        self.MaxVSyncFreq = D3DDDI_RATIONAL()
        self.MinHSyncFreq = D3DDDI_RATIONAL()
        self.MaxHSyncFreq = D3DDDI_RATIONAL()


class _unnamed_10432(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint32()


class tagWND(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = THRDESKHEAD()
        self.state = v_uint32()
        self.state2 = v_uint32()
        self.ExStyle = v_uint32()
        self.style = v_uint32()
        self.hModule = v_ptr64()
        self.hMod16 = v_uint16()
        self.fnid = v_uint16()
        self._pad0048 = v_bytes(size=4)
        self.spwndNext = v_ptr64()
        self.spwndPrev = v_ptr64()
        self.spwndParent = v_ptr64()
        self.spwndChild = v_ptr64()
        self.spwndOwner = v_ptr64()
        self.rcWindow = tagRECT()
        self.rcClient = tagRECT()
        self.lpfnWndProc = v_ptr64()
        self.pcls = v_ptr64()
        self.hrgnUpdate = v_ptr64()
        self.ppropList = v_ptr64()
        self.pSBInfo = v_ptr64()
        self.spmenuSys = v_ptr64()
        self.spmenu = v_ptr64()
        self.hrgnClip = v_ptr64()
        self.hrgnNewFrame = v_ptr64()
        self.strName = LARGE_UNICODE_STRING()
        self.cbwndExtra = v_uint32()
        self._pad00f0 = v_bytes(size=4)
        self.spwndLastActive = v_ptr64()
        self.hImc = v_ptr64()
        self.dwUserData = v_uint64()
        self.pActCtx = v_ptr64()
        self.pTransform = v_ptr64()
        self.spwndClipboardListenerNext = v_ptr64()
        self.ExStyle2 = v_uint32()
        self._pad0128 = v_bytes(size=4)


class _unnamed_14496(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length48 = v_uint32()
        self.Alignment48 = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class XSTATE_FEATURE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Offset = v_uint32()
        self.Size = v_uint32()


class D3DDDI_GAMMA_RAMP_DXGI_1(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Scale = D3DDDI_DXGI_RGB()
        self.Offset = D3DDDI_DXGI_RGB()
        self.GammaCurve = vstruct.VArray([ D3DDDI_DXGI_RGB() for i in range(1025) ])


class WHEA_TIMESTAMP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Seconds = v_uint64()


class ACTIVATION_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class tagUAHMENUITEMMETRICS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.rgsizeBar = vstruct.VArray([ tagSIZE() for i in range(2) ])
        self._pad0020 = v_bytes(size=16)


class KLIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_ptr64()
        self.Blink = v_ptr64()


class _unnamed_10401(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityInformation = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Length = v_uint32()
        self._pad0010 = v_bytes(size=4)


class _unnamed_10404(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityInformation = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.SecurityDescriptor = v_ptr64()


class RTL_CRITICAL_SECTION_DEBUG(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.CreatorBackTraceIndex = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.CriticalSection = v_ptr64()
        self.ProcessLocksList = LIST_ENTRY()
        self.EntryCount = v_uint32()
        self.ContentionCount = v_uint32()
        self.Flags = v_uint32()
        self.CreatorBackTraceIndexHigh = v_uint16()
        self.SpareUSHORT = v_uint16()


class DISPATCHER_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.TimerControlFlags = v_uint8()
        self.ThreadControlFlags = v_uint8()
        self.TimerMiscFlags = v_uint8()
        self.SignalState = v_uint32()
        self.WaitListHead = LIST_ENTRY()


class HBITMAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class tagW32JOB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pNext = v_ptr64()
        self.Job = v_ptr64()
        self.pAtomTable = v_ptr64()
        self.restrictions = v_uint32()
        self.uProcessCount = v_uint32()
        self.uMaxProcesses = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.ppiTable = v_ptr64()
        self.ughCrt = v_uint32()
        self.ughMax = v_uint32()
        self.pgh = v_ptr64()


class ASSEMBLY_STORAGE_MAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class tagMBSTRING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.szName = vstruct.VArray([ v_uint16() for i in range(15) ])
        self._pad0020 = v_bytes(size=2)
        self.uID = v_uint32()
        self.uStr = v_uint32()


class POWER_SEQUENCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SequenceD1 = v_uint32()
        self.SequenceD2 = v_uint32()
        self.SequenceD3 = v_uint32()


class DMM_MONITORDESCRIPTOR_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint32()
        self.Type = v_uint32()
        self.Origin = v_uint32()
        self.Data = vstruct.VArray([ v_uint8() for i in range(128) ])


class tagCLS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pclsNext = v_ptr64()
        self.atomClassName = v_uint16()
        self.atomNVClassName = v_uint16()
        self.fnid = v_uint16()
        self._pad0010 = v_bytes(size=2)
        self.rpdeskParent = v_ptr64()
        self.pdce = v_ptr64()
        self.hTaskWow = v_uint16()
        self.CSF_flags = v_uint16()
        self._pad0028 = v_bytes(size=4)
        self.lpszClientAnsiMenuName = v_ptr64()
        self.lpszClientUnicodeMenuName = v_ptr64()
        self.spcpdFirst = v_ptr64()
        self.pclsBase = v_ptr64()
        self.pclsClone = v_ptr64()
        self.cWndReferenceCount = v_uint32()
        self.style = v_uint32()
        self.lpfnWndProc = v_ptr64()
        self.cbclsExtra = v_uint32()
        self.cbwndExtra = v_uint32()
        self.hModule = v_ptr64()
        self.spicn = v_ptr64()
        self.spcur = v_ptr64()
        self.hbrBackground = v_ptr64()
        self.lpszMenuName = v_ptr64()
        self.lpszAnsiClassName = v_ptr64()
        self.spicnSm = v_ptr64()


class SM_VALUES_STRINGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pszName = v_ptr64()
        self.ulValue = v_uint32()
        self.RangeType = v_uint32()
        self.StorageType = v_uint32()
        self._pad0018 = v_bytes(size=4)


class HBRUSH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class SECURITY_QUALITY_OF_SERVICE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.ImpersonationLevel = v_uint32()
        self.ContextTrackingMode = v_uint8()
        self.EffectiveOnly = v_uint8()
        self._pad000c = v_bytes(size=2)


class COMPRESSED_DATA_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CompressionFormatAndEngine = v_uint16()
        self.CompressionUnitShift = v_uint8()
        self.ChunkShift = v_uint8()
        self.ClusterShift = v_uint8()
        self.Reserved = v_uint8()
        self.NumberOfChunks = v_uint16()
        self.CompressedChunkSizes = vstruct.VArray([ v_uint32() for i in range(1) ])


class WHEA_ERROR_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = WHEA_ERROR_RECORD_HEADER()
        self.SectionDescriptor = vstruct.VArray([ WHEA_ERROR_RECORD_SECTION_DESCRIPTOR() for i in range(1) ])


class _unnamed_10572(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemContext = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Type = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.State = POWER_STATE()
        self._pad0018 = v_bytes(size=4)
        self.ShutdownType = v_uint32()
        self._pad0020 = v_bytes(size=4)


class LUID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class tagDESKTOP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwSessionId = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.pDeskInfo = v_ptr64()
        self.pDispInfo = v_ptr64()
        self.rpdeskNext = v_ptr64()
        self.rpwinstaParent = v_ptr64()
        self.dwDTFlags = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.dwDesktopId = v_uint64()
        self.spmenuSys = v_ptr64()
        self.spmenuDialogSys = v_ptr64()
        self.spmenuHScroll = v_ptr64()
        self.spmenuVScroll = v_ptr64()
        self.spwndForeground = v_ptr64()
        self.spwndTray = v_ptr64()
        self.spwndMessage = v_ptr64()
        self.spwndTooltip = v_ptr64()
        self.hsectionDesktop = v_ptr64()
        self.pheapDesktop = v_ptr64()
        self.ulHeapSize = v_uint32()
        self._pad0090 = v_bytes(size=4)
        self.cciConsole = CONSOLE_CARET_INFO()
        self.PtiList = LIST_ENTRY()
        self.spwndTrack = v_ptr64()
        self.htEx = v_uint32()
        self.rcMouseHover = tagRECT()
        self.dwMouseHoverTime = v_uint32()
        self.pMagInputTransform = v_ptr64()


class tagPOOLRECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExtraData = v_ptr64()
        self.size = v_uint64()
        self.trace = vstruct.VArray([ v_ptr64() for i in range(6) ])


class CLIENT_ID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UniqueProcess = v_ptr64()
        self.UniqueThread = v_ptr64()


class IMAGE_OPTIONAL_HEADER64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Magic = v_uint16()
        self.MajorLinkerVersion = v_uint8()
        self.MinorLinkerVersion = v_uint8()
        self.SizeOfCode = v_uint32()
        self.SizeOfInitializedData = v_uint32()
        self.SizeOfUninitializedData = v_uint32()
        self.AddressOfEntryPoint = v_uint32()
        self.BaseOfCode = v_uint32()
        self.ImageBase = v_uint64()
        self.SectionAlignment = v_uint32()
        self.FileAlignment = v_uint32()
        self.MajorOperatingSystemVersion = v_uint16()
        self.MinorOperatingSystemVersion = v_uint16()
        self.MajorImageVersion = v_uint16()
        self.MinorImageVersion = v_uint16()
        self.MajorSubsystemVersion = v_uint16()
        self.MinorSubsystemVersion = v_uint16()
        self.Win32VersionValue = v_uint32()
        self.SizeOfImage = v_uint32()
        self.SizeOfHeaders = v_uint32()
        self.CheckSum = v_uint32()
        self.Subsystem = v_uint16()
        self.DllCharacteristics = v_uint16()
        self.SizeOfStackReserve = v_uint64()
        self.SizeOfStackCommit = v_uint64()
        self.SizeOfHeapReserve = v_uint64()
        self.SizeOfHeapCommit = v_uint64()
        self.LoaderFlags = v_uint32()
        self.NumberOfRvaAndSizes = v_uint32()
        self.DataDirectory = vstruct.VArray([ IMAGE_DATA_DIRECTORY() for i in range(16) ])


class OBJECT_DUMP_CONTROL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Stream = v_ptr64()
        self.Detail = v_uint32()
        self._pad0010 = v_bytes(size=4)


class _unnamed_10089(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AsynchronousParameters = _unnamed_10107()


class GENERAL_LOOKASIDE_POOL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = SLIST_HEADER()
        self.Depth = v_uint16()
        self.MaximumDepth = v_uint16()
        self.TotalAllocates = v_uint32()
        self.AllocateMisses = v_uint32()
        self.TotalFrees = v_uint32()
        self.FreeMisses = v_uint32()
        self.Type = v_uint32()
        self.Tag = v_uint32()
        self.Size = v_uint32()
        self.AllocateEx = v_ptr64()
        self.FreeEx = v_ptr64()
        self.ListEntry = LIST_ENTRY()
        self.LastTotalAllocates = v_uint32()
        self.LastAllocateMisses = v_uint32()
        self.Future = vstruct.VArray([ v_uint32() for i in range(2) ])


class tagSPB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pspbNext = v_ptr64()
        self.spwnd = v_ptr64()
        self.hbm = v_ptr64()
        self.rc = tagRECT()
        self.hrgn = v_ptr64()
        self.flags = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.ulSaveId = v_uint64()


class _unnamed_13929(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Raw = _unnamed_13924()


class _unnamed_13924(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Group = v_uint16()
        self.MessageCount = v_uint16()
        self.Vector = v_uint32()
        self.Affinity = v_uint64()


class DMM_VIDPNSET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumVidPns = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.VidPnOffset = vstruct.VArray([ v_uint32() for i in range(1) ])


class STRING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.MaximumLength = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.Buffer = v_ptr64()


class TP_POOL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_9282(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class tagPROP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.hData = v_ptr64()
        self.atomKey = v_uint16()
        self.fs = v_uint16()
        self._pad0010 = v_bytes(size=4)


class LIST_ENTRY32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_uint32()
        self.Blink = v_uint32()


class KDESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Pad = vstruct.VArray([ v_uint16() for i in range(3) ])
        self.Limit = v_uint16()
        self.Base = v_ptr64()


class _unnamed_10583(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AllocatedResources = v_ptr64()
        self.AllocatedResourcesTranslated = v_ptr64()


class SINGLE_LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr64()


class _unnamed_10587(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ProviderId = v_uint64()
        self.DataPath = v_ptr64()
        self.BufferSize = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.Buffer = v_ptr64()


class CONTEXT32_UPDATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumberEntries = v_uint32()


class KDEVICE_QUEUE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DeviceListEntry = LIST_ENTRY()
        self.SortKey = v_uint32()
        self.Inserted = v_uint8()
        self._pad0018 = v_bytes(size=3)


class D3DKMDT_VIDPN_SOURCE_MODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint32()
        self.Type = v_uint32()
        self.Format = _unnamed_11143()


class tagCLIENTTHREADINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CTIF_flags = v_uint32()
        self.fsChangeBits = v_uint16()
        self.fsWakeBits = v_uint16()
        self.fsWakeBitsJournal = v_uint16()
        self.fsWakeMask = v_uint16()
        self.tickLastMsgChecked = v_uint32()


class tagKbdNlsLayer(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OEMIdentifier = v_uint16()
        self.LayoutInformation = v_uint16()
        self.NumOfVkToF = v_uint32()
        self.pVkToF = v_ptr64()
        self.NumOfMouseVKey = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.pusMouseVKey = v_ptr64()


class KSPIN_LOCK_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr64()
        self.Lock = v_ptr64()


class tagPROCESS_HID_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.link = LIST_ENTRY()
        self.InclusionList = LIST_ENTRY()
        self.UsagePageList = LIST_ENTRY()
        self.ExclusionList = LIST_ENTRY()
        self.spwndTargetMouse = v_ptr64()
        self.spwndTargetKbd = v_ptr64()
        self.nSinks = v_uint32()
        self._pad0058 = v_bytes(size=4)
        self.pLastRequest = v_ptr64()
        self.UsagePageLast = v_uint16()
        self.UsageLast = v_uint16()
        self.fRawMouse = v_uint32()


class WHEA_ERROR_PACKET_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PreviousError = v_uint32()


class _unnamed_10351(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.FileName = v_ptr64()
        self.FileInformationClass = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.FileIndex = v_uint32()
        self._pad0020 = v_bytes(size=4)


class WHEA_PERSISTENCE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint64()


class EX_PUSH_LOCK_CACHE_AWARE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Locks = vstruct.VArray([ v_ptr64() for i in range(1) ])


class tagMLIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pqmsgRead = v_ptr64()
        self.pqmsgWriteLast = v_ptr64()
        self.cMsgs = v_uint32()
        self._pad0018 = v_bytes(size=4)


class _unnamed_10290(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Key = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.ByteOffset = LARGE_INTEGER()


class DMM_MONITORDESCRIPTORSET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumDescriptors = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.DescriptorSerialization = vstruct.VArray([ DMM_MONITORDESCRIPTOR_SERIALIZATION() for i in range(1) ])


class tagCLIP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.fmt = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.hData = v_ptr64()
        self.fGlobalHandle = v_uint32()
        self._pad0018 = v_bytes(size=4)


class tagSMS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.psmsNext = v_ptr64()
        self.psmsReceiveNext = v_ptr64()
        self.ptiSender = v_ptr64()
        self.ptiReceiver = v_ptr64()
        self.lpResultCallBack = v_ptr64()
        self.dwData = v_uint64()
        self.ptiCallBackSender = v_ptr64()
        self.lRet = v_uint64()
        self.tSent = v_uint32()
        self.flags = v_uint32()
        self.wParam = v_uint64()
        self.lParam = v_uint64()
        self.message = v_uint32()
        self._pad0060 = v_bytes(size=4)
        self.spwnd = v_ptr64()
        self.pvCapture = v_ptr64()


class SCSI_REQUEST_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class ETHREAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class FAST_MUTEX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Count = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Owner = v_ptr64()
        self.Contention = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.Event = KEVENT()
        self.OldIrql = v_uint32()
        self._pad0038 = v_bytes(size=4)


class WHEA_ERROR_RECORD_HEADER_VALIDBITS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PlatformId = v_uint32()


class D3DKMDT_VIDPN_PRESENT_PATH_TRANSFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Scaling = v_uint32()
        self.ScalingSupport = D3DKMDT_VIDPN_PRESENT_PATH_SCALING_SUPPORT()
        self.Rotation = v_uint32()
        self.RotationSupport = D3DKMDT_VIDPN_PRESENT_PATH_ROTATION_SUPPORT()


class KDEVICE_QUEUE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.DeviceListHead = LIST_ENTRY()
        self.Lock = v_uint64()
        self.Busy = v_uint8()
        self._pad0028 = v_bytes(size=7)


class CALLBACKWND(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.hwnd = v_ptr64()
        self.pwnd = v_ptr64()
        self.pActCtx = v_ptr64()


class IO_SECURITY_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityQos = v_ptr64()
        self.AccessState = v_ptr64()
        self.DesiredAccess = v_uint32()
        self.FullCreateOptions = v_uint32()


class tagSIZE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cx = v_uint32()
        self.cy = v_uint32()


class tagDESKTOPVIEW(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pdvNext = v_ptr64()
        self.pdesk = v_ptr64()
        self.ulClientDelta = v_uint64()


class PROCMARKHEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.h = v_ptr64()
        self.cLockObj = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.hTaskWow = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.ppi = v_ptr64()


class INITIAL_PRIVILEGE_SET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrivilegeCount = v_uint32()
        self.Control = v_uint32()
        self.Privilege = vstruct.VArray([ LUID_AND_ATTRIBUTES() for i in range(3) ])


class D3DKMDT_COLOR_COEFF_DYNAMIC_RANGES(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FirstChannel = v_uint32()
        self.SecondChannel = v_uint32()
        self.ThirdChannel = v_uint32()
        self.FourthChannel = v_uint32()


class WHEA_ERROR_RECORD_HEADER_FLAGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Recovered = v_uint32()


class MODIFIERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pVkToBit = v_ptr64()
        self.wMaxModBits = v_uint16()
        self.ModNumber = vstruct.VArray([ v_uint8() for i in range(0) ])
        self._pad0010 = v_bytes(size=6)


class _unnamed_14501(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length64 = v_uint32()
        self.Alignment64 = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class PFNCLIENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pfnScrollBarWndProc = v_ptr64()
        self.pfnTitleWndProc = v_ptr64()
        self.pfnMenuWndProc = v_ptr64()
        self.pfnDesktopWndProc = v_ptr64()
        self.pfnDefWindowProc = v_ptr64()
        self.pfnMessageWindowProc = v_ptr64()
        self.pfnSwitchWindowProc = v_ptr64()
        self.pfnButtonWndProc = v_ptr64()
        self.pfnComboBoxWndProc = v_ptr64()
        self.pfnComboListBoxProc = v_ptr64()
        self.pfnDialogWndProc = v_ptr64()
        self.pfnEditWndProc = v_ptr64()
        self.pfnListBoxWndProc = v_ptr64()
        self.pfnMDIClientWndProc = v_ptr64()
        self.pfnStaticWndProc = v_ptr64()
        self.pfnImeWndProc = v_ptr64()
        self.pfnGhostWndProc = v_ptr64()
        self.pfnHkINLPCWPSTRUCT = v_ptr64()
        self.pfnHkINLPCWPRETSTRUCT = v_ptr64()
        self.pfnDispatchHook = v_ptr64()
        self.pfnDispatchDefWindowProc = v_ptr64()
        self.pfnDispatchMessage = v_ptr64()
        self.pfnMDIActivateDlgProc = v_ptr64()


class _unnamed_10539(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PowerState = v_uint32()


class ACTIVATION_CONTEXT_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class FILE_NETWORK_OPEN_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CreationTime = LARGE_INTEGER()
        self.LastAccessTime = LARGE_INTEGER()
        self.LastWriteTime = LARGE_INTEGER()
        self.ChangeTime = LARGE_INTEGER()
        self.AllocationSize = LARGE_INTEGER()
        self.EndOfFile = LARGE_INTEGER()
        self.FileAttributes = v_uint32()
        self._pad0038 = v_bytes(size=4)


class tagSVR_INSTANCE_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = THROBJHEAD()
        self.next = v_ptr64()
        self.nextInThisThread = v_ptr64()
        self.afCmd = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.spwndEvent = v_ptr64()
        self.pcii = v_ptr64()


class _unnamed_14479(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinimumChannel = v_uint32()
        self.MaximumChannel = v_uint32()


class RTL_DRIVE_LETTER_CURDIR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint16()
        self.Length = v_uint16()
        self.TimeStamp = v_uint32()
        self.DosPath = STRING()


class _unnamed_14472(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MinimumVector = v_uint32()
        self.MaximumVector = v_uint32()
        self.AffinityPolicy = v_uint16()
        self.Group = v_uint16()
        self.PriorityPolicy = v_uint32()
        self.TargetedProcessors = v_uint64()


class KIDTENTRY64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OffsetLow = v_uint16()
        self.Selector = v_uint16()
        self.IstIndex = v_uint16()
        self.OffsetMiddle = v_uint16()
        self.OffsetHigh = v_uint32()
        self.Reserved1 = v_uint32()


class _unnamed_10386(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OutputBufferLength = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.InputBufferLength = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.FsControlCode = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.Type3InputBuffer = v_ptr64()


class ULARGE_INTEGER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class VWPL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cPwnd = v_uint32()
        self.cElem = v_uint32()
        self.cThreshhold = v_uint32()
        self.fTagged = v_uint32()
        self.aElement = vstruct.VArray([ VWPLELEMENT() for i in range(0) ])


class _unnamed_10383(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.FsInformationClass = v_uint32()
        self._pad0010 = v_bytes(size=4)


class TEB_ACTIVE_FRAME(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Previous = v_ptr64()
        self.Context = v_ptr64()


class GENERAL_LOOKASIDE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListHead = SLIST_HEADER()
        self.Depth = v_uint16()
        self.MaximumDepth = v_uint16()
        self.TotalAllocates = v_uint32()
        self.AllocateMisses = v_uint32()
        self.TotalFrees = v_uint32()
        self.FreeMisses = v_uint32()
        self.Type = v_uint32()
        self.Tag = v_uint32()
        self.Size = v_uint32()
        self.AllocateEx = v_ptr64()
        self.FreeEx = v_ptr64()
        self.ListEntry = LIST_ENTRY()
        self.LastTotalAllocates = v_uint32()
        self.LastAllocateMisses = v_uint32()
        self.Future = vstruct.VArray([ v_uint32() for i in range(2) ])
        self._pad0080 = v_bytes(size=32)


class tagCURSOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = PROCMARKHEAD()
        self.pcurNext = v_ptr64()
        self.strName = UNICODE_STRING()
        self.atomModName = v_uint16()
        self.rt = v_uint16()
        self._pad0040 = v_bytes(size=4)
        self.CURSORF_flags = v_uint32()
        self.xHotspot = v_uint16()
        self.yHotspot = v_uint16()
        self.hbmMask = v_ptr64()
        self.hbmColor = v_ptr64()
        self.hbmAlpha = v_ptr64()
        self.rcBounds = tagRECT()
        self.hbmUserAlpha = v_ptr64()
        self.bpp = v_uint32()
        self.cx = v_uint32()
        self.cy = v_uint32()
        self._pad0088 = v_bytes(size=4)


class _unnamed_10545(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PowerSequence = v_ptr64()


class tagDCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pdceNext = v_ptr64()
        self.hdc = v_ptr64()
        self.pwndOrg = v_ptr64()
        self.pwndClip = v_ptr64()
        self.pwndRedirect = v_ptr64()
        self.hrgnClip = v_ptr64()
        self.hrgnClipPublic = v_ptr64()
        self.hrgnSavedVis = v_ptr64()
        self.DCX_flags = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.ptiOwner = v_ptr64()
        self.ppiOwner = v_ptr64()
        self.pMonitor = v_ptr64()


class VSC_LPWSTR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.vsc = v_uint8()
        self._pad0008 = v_bytes(size=7)
        self.pwsz = v_ptr64()


class NAMED_PIPE_CREATE_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NamedPipeType = v_uint32()
        self.ReadMode = v_uint32()
        self.CompletionMode = v_uint32()
        self.MaximumInstances = v_uint32()
        self.InboundQuota = v_uint32()
        self.OutboundQuota = v_uint32()
        self.DefaultTimeout = LARGE_INTEGER()
        self.TimeoutSpecified = v_uint8()
        self._pad0028 = v_bytes(size=7)


class NT_TIB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionList = v_ptr64()
        self.StackBase = v_ptr64()
        self.StackLimit = v_ptr64()
        self.SubSystemTib = v_ptr64()
        self.FiberData = v_ptr64()
        self.ArbitraryUserPointer = v_ptr64()
        self.Self = v_ptr64()


class SCATTER_GATHER_ELEMENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Address = LARGE_INTEGER()
        self.Length = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.Reserved = v_uint64()


class POWER_STATE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemState = v_uint32()


class UNICODE_STRING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.MaximumLength = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.Buffer = v_ptr64()


class DMM_MONITORSOURCEMODESET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumModes = v_uint8()
        self._pad0008 = v_bytes(size=7)
        self.ModeSerialization = vstruct.VArray([ DMM_MONITOR_SOURCE_MODE_SERIALIZATION() for i in range(1) ])


class D3DKMDT_VIDPN_TARGET_MODE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.VideoSignalInfo = D3DKMDT_VIDEO_SIGNAL_INFO()
        self.Preference = v_uint32()
        self._pad0048 = v_bytes(size=4)


class tagWOWTHREADINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pwtiNext = v_ptr64()
        self.idTask = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.idWaitObject = v_uint64()
        self.idParentProcess = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.pIdleEvent = v_ptr64()
        self.fAssigned = v_uint32()
        self._pad0030 = v_bytes(size=4)


class _unnamed_10092(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Overlay = _unnamed_10207()
        self._pad0058 = v_bytes(size=8)


class ACCESS_REASONS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data = vstruct.VArray([ v_uint32() for i in range(32) ])


class _unnamed_10271(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = v_ptr64()
        self.Options = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.Reserved = v_uint16()
        self.ShareAccess = v_uint16()
        self._pad0018 = v_bytes(size=4)
        self.Parameters = v_ptr64()


class HANDLEENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.phead = v_ptr64()
        self.pOwner = v_ptr64()
        self.bType = v_uint8()
        self.bFlags = v_uint8()
        self.wUniq = v_uint16()
        self._pad0018 = v_bytes(size=4)


class W32THREAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pEThread = v_ptr64()
        self.RefCount = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.ptlW32 = v_ptr64()
        self.pgdiDcattr = v_ptr64()
        self.pgdiBrushAttr = v_ptr64()
        self.pUMPDObjs = v_ptr64()
        self.pUMPDHeap = v_ptr64()
        self.pUMPDObj = v_ptr64()
        self.pProxyPort = v_ptr64()
        self.pClientID = v_ptr64()
        self.GdiTmpTgoList = LIST_ENTRY()
        self.pRBRecursionCount = v_uint32()
        self.pNonRBRecursionCount = v_uint32()
        self.tlSpriteState = TLSPRITESTATE()
        self.pSpriteState = v_ptr64()
        self.pDevHTInfo = v_ptr64()
        self.ulDevHTInfoUniqueness = v_uint32()
        self._pad0128 = v_bytes(size=4)
        self.pdcoAA = v_ptr64()
        self.pdcoRender = v_ptr64()
        self.pdcoSrc = v_ptr64()
        self.bEnableEngUpdateDeviceSurface = v_uint8()
        self.bIncludeSprites = v_uint8()
        self._pad0144 = v_bytes(size=2)
        self.ulWindowSystemRendering = v_uint32()
        self.iVisRgnUniqueness = v_uint32()
        self._pad0150 = v_bytes(size=4)


class KDPC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint8()
        self.Importance = v_uint8()
        self.Number = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.DpcListEntry = LIST_ENTRY()
        self.DeferredRoutine = v_ptr64()
        self.DeferredContext = v_ptr64()
        self.SystemArgument1 = v_ptr64()
        self.SystemArgument2 = v_ptr64()
        self.DpcData = v_ptr64()


class KEVENT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()


class KSEMAPHORE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DISPATCHER_HEADER()
        self.Limit = v_uint32()
        self._pad0020 = v_bytes(size=4)


class OBJECT_TYPE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.TypeList = LIST_ENTRY()
        self.Name = UNICODE_STRING()
        self.DefaultObject = v_ptr64()
        self.Index = v_uint8()
        self._pad002c = v_bytes(size=3)
        self.TotalNumberOfObjects = v_uint32()
        self.TotalNumberOfHandles = v_uint32()
        self.HighWaterNumberOfObjects = v_uint32()
        self.HighWaterNumberOfHandles = v_uint32()
        self._pad0040 = v_bytes(size=4)
        self.TypeInfo = OBJECT_TYPE_INITIALIZER()
        self.TypeLock = EX_PUSH_LOCK()
        self.Key = v_uint32()
        self._pad00c0 = v_bytes(size=4)
        self.CallbackList = LIST_ENTRY()


class tagIMEINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwPrivateDataSize = v_uint32()
        self.fdwProperty = v_uint32()
        self.fdwConversionCaps = v_uint32()
        self.fdwSentenceCaps = v_uint32()
        self.fdwUICaps = v_uint32()
        self.fdwSCSCaps = v_uint32()
        self.fdwSelectCaps = v_uint32()


class DXGK_DIAG_CODE_POINT_PACKET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Header = DXGK_DIAG_HEADER()
        self.CodePointType = v_uint32()
        self.Param1 = v_uint32()
        self.Param2 = v_uint32()
        self.Param3 = v_uint32()


class _unnamed_10168(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Create = _unnamed_10255()


class W32PROCESS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Process = v_ptr64()
        self.RefCount = v_uint32()
        self.W32PF_Flags = v_uint32()
        self.InputIdleEvent = v_ptr64()
        self.StartCursorHideTime = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.NextStart = v_ptr64()
        self.pDCAttrList = v_ptr64()
        self.pBrushAttrList = v_ptr64()
        self.W32Pid = v_uint32()
        self.GDIHandleCount = v_uint32()
        self.GDIHandleCountPeak = v_uint32()
        self.UserHandleCount = v_uint32()
        self.UserHandleCountPeak = v_uint32()
        self._pad0050 = v_bytes(size=4)
        self.GDIPushLock = EX_PUSH_LOCK()
        self.GDIEngUserMemAllocTable = RTL_AVL_TABLE()
        self.GDIDcAttrFreeList = LIST_ENTRY()
        self.GDIBrushAttrFreeList = LIST_ENTRY()
        self.GDIW32PIDLockedBitmaps = LIST_ENTRY()
        self.hSecureGdiSharedHandleTable = v_ptr64()
        self.DxProcess = v_ptr64()


class tagKBDFILE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = HEAD()
        self.pkfNext = v_ptr64()
        self.hBase = v_ptr64()
        self.pKbdTbl = v_ptr64()
        self.Size = v_uint32()
        self._pad0030 = v_bytes(size=4)
        self.pKbdNlsTbl = v_ptr64()
        self.awchDllName = vstruct.VArray([ v_uint16() for i in range(32) ])


class DMM_COMMITVIDPNREQUEST_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.AffectedVidPnSourceId = v_uint32()
        self.RequestDiagInfo = DMM_COMMITVIDPNREQUEST_DIAGINFO()
        self.VidPnSerialization = DMM_VIDPN_SERIALIZATION()


class _unnamed_10360(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.FileInformationClass = v_uint32()
        self._pad0010 = v_bytes(size=4)


class _unnamed_13586(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Generic = _unnamed_13916()
        self._pad0010 = v_bytes(size=4)


class EXCEPTION_REGISTRATION_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr64()
        self.Handler = v_ptr64()


class FILE_BASIC_INFORMATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CreationTime = LARGE_INTEGER()
        self.LastAccessTime = LARGE_INTEGER()
        self.LastWriteTime = LARGE_INTEGER()
        self.ChangeTime = LARGE_INTEGER()
        self.FileAttributes = v_uint32()
        self._pad0028 = v_bytes(size=4)


class LIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_ptr64()
        self.Blink = v_ptr64()


class M128A(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Low = v_uint64()
        self.High = v_uint64()


class tagUSERSTARTUPINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.cb = v_uint32()
        self.dwX = v_uint32()
        self.dwY = v_uint32()
        self.dwXSize = v_uint32()
        self.dwYSize = v_uint32()
        self.dwFlags = v_uint32()
        self.wShowWindow = v_uint16()
        self.cbReserved2 = v_uint16()


class _unnamed_13369(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Attrib = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.cbData = v_uint64()


class tagHID_PAGEONLY_REQUEST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.link = LIST_ENTRY()
        self.usUsagePage = v_uint16()
        self._pad0014 = v_bytes(size=2)
        self.cRefCount = v_uint32()


class _unnamed_11143(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Graphics = D3DKMDT_GRAPHICS_RENDERING_FORMAT()


class _unnamed_13366(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Attrib = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.cbData = v_uint64()


class RTL_DYNAMIC_HASH_TABLE_ENUMERATOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.HashEntry = RTL_DYNAMIC_HASH_TABLE_ENTRY()
        self.ChainHead = v_ptr64()
        self.BucketIndex = v_uint32()
        self._pad0028 = v_bytes(size=4)


class tagWINDOWSTATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwSessionId = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.rpwinstaNext = v_ptr64()
        self.rpdeskList = v_ptr64()
        self.pTerm = v_ptr64()
        self.dwWSF_Flags = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.spklList = v_ptr64()
        self.ptiClipLock = v_ptr64()
        self.ptiDrawingClipboard = v_ptr64()
        self.spwndClipOpen = v_ptr64()
        self.spwndClipViewer = v_ptr64()
        self.spwndClipOwner = v_ptr64()
        self.pClipBase = v_ptr64()
        self.cNumClipFormats = v_uint32()
        self.iClipSerialNumber = v_uint32()
        self.iClipSequenceNumber = v_uint32()
        self._pad0070 = v_bytes(size=4)
        self.spwndClipboardListener = v_ptr64()
        self.pGlobalAtomTable = v_ptr64()
        self.luidEndSession = LUID()
        self.luidUser = LUID()
        self.psidUser = v_ptr64()


class DMM_VIDPNPATHSFROMSOURCE_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SourceMode = D3DKMDT_VIDPN_SOURCE_MODE()
        self.NumPathsFromSource = v_uint8()
        self._pad0030 = v_bytes(size=7)
        self.PathAndTargetModeSerialization = vstruct.VArray([ DMM_VIDPNPATHANDTARGETMODE_SERIALIZATION() for i in range(1) ])


class GUID(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Data1 = v_uint32()
        self.Data2 = v_uint16()
        self.Data3 = v_uint16()
        self.Data4 = vstruct.VArray([ v_uint8() for i in range(8) ])


class D3DKMDT_GRAPHICS_RENDERING_FORMAT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.PrimSurfSize = D3DKMDT_2DREGION()
        self.VisibleRegionSize = D3DKMDT_2DREGION()
        self.Stride = v_uint32()
        self.PixelFormat = v_uint32()
        self.ColorBasis = v_uint32()
        self.PixelValueAccessMode = v_uint32()


class SLIST_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Next = v_ptr64()
        self._pad0010 = v_bytes(size=8)


class IO_RESOURCE_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Option = v_uint8()
        self.Type = v_uint8()
        self.ShareDisposition = v_uint8()
        self.Spare1 = v_uint8()
        self.Flags = v_uint16()
        self.Spare2 = v_uint16()
        self.u = _unnamed_13900()


class IO_STATUS_BLOCK32(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Status = v_uint32()
        self.Information = v_uint32()


class GENERIC_MAPPING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.GenericRead = v_uint32()
        self.GenericWrite = v_uint32()
        self.GenericExecute = v_uint32()
        self.GenericAll = v_uint32()


class IRP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.MdlAddress = v_ptr64()
        self.Flags = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.AssociatedIrp = _unnamed_10086()
        self.ThreadListEntry = LIST_ENTRY()
        self.IoStatus = IO_STATUS_BLOCK()
        self.RequestorMode = v_uint8()
        self.PendingReturned = v_uint8()
        self.StackCount = v_uint8()
        self.CurrentLocation = v_uint8()
        self.Cancel = v_uint8()
        self.CancelIrql = v_uint8()
        self.ApcEnvironment = v_uint8()
        self.AllocationFlags = v_uint8()
        self.UserIosb = v_ptr64()
        self.UserEvent = v_ptr64()
        self.Overlay = _unnamed_10089()
        self.CancelRoutine = v_ptr64()
        self.UserBuffer = v_ptr64()
        self.Tail = _unnamed_10092()


class _unnamed_10500(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WhichSpace = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Buffer = v_ptr64()
        self.Offset = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.Length = v_uint32()
        self._pad0020 = v_bytes(size=4)


class _unnamed_10505(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Lock = v_uint8()


class D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CopyProtectionType = v_uint32()
        self.APSTriggerBits = v_uint32()
        self.OEMCopyProtection = vstruct.VArray([ v_uint8() for i in range(256) ])
        self.CopyProtectionSupport = D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_SUPPORT()


class _unnamed_14491(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length40 = v_uint32()
        self.Alignment40 = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class DMM_VIDPN_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self.NumActiveSources = v_uint8()
        self._pad0008 = v_bytes(size=3)
        self.PathsFromSourceSerializationOffsets = vstruct.VArray([ v_uint32() for i in range(1) ])


class IO_COMPLETION_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Port = v_ptr64()
        self.Key = v_ptr64()


class DRIVER_EXTENSION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.DriverObject = v_ptr64()
        self.AddDevice = v_ptr64()
        self.Count = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.ServiceKeyName = UNICODE_STRING()


class _unnamed_13919(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Level = v_uint16()
        self.Group = v_uint16()
        self.Vector = v_uint32()
        self.Affinity = v_uint64()


class DMM_COFUNCPATHSMODALITY_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumPathsFromSource = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.PathAndTargetModeSetOffset = vstruct.VArray([ v_uint32() for i in range(1) ])


class tagTDB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ptdbNext = v_ptr64()
        self.nEvents = v_uint32()
        self.nPriority = v_uint32()
        self.pti = v_ptr64()
        self.pwti = v_ptr64()
        self.hTaskWow = v_uint16()
        self.TDB_Flags = v_uint16()
        self._pad0028 = v_bytes(size=4)


class _unnamed_13916(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length = v_uint32()


class KPRCB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MxCsr = v_uint32()
        self.LegacyNumber = v_uint8()
        self.ReservedMustBeZero = v_uint8()
        self.InterruptRequest = v_uint8()
        self.IdleHalt = v_uint8()
        self.CurrentThread = v_ptr64()
        self.NextThread = v_ptr64()
        self.IdleThread = v_ptr64()
        self.NestingLevel = v_uint8()
        self.PrcbPad00 = vstruct.VArray([ v_uint8() for i in range(3) ])
        self.Number = v_uint32()
        self.RspBase = v_uint64()
        self.PrcbLock = v_uint64()
        self.PrcbPad01 = v_uint64()
        self.ProcessorState = KPROCESSOR_STATE()
        self.CpuType = v_uint8()
        self.CpuID = v_uint8()
        self.CpuStep = v_uint16()
        self.MHz = v_uint32()
        self.HalReserved = vstruct.VArray([ v_uint64() for i in range(8) ])
        self.MinorVersion = v_uint16()
        self.MajorVersion = v_uint16()
        self.BuildType = v_uint8()
        self.CpuVendor = v_uint8()
        self.CoresPerPhysicalProcessor = v_uint8()
        self.LogicalProcessorsPerCore = v_uint8()
        self.ApicMask = v_uint32()
        self.CFlushSize = v_uint32()
        self.AcpiReserved = v_ptr64()
        self.InitialApicId = v_uint32()
        self.Stride = v_uint32()
        self.Group = v_uint16()
        self._pad0660 = v_bytes(size=6)
        self.GroupSetMember = v_uint64()
        self.GroupIndex = v_uint8()
        self._pad0670 = v_bytes(size=7)


class WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_VALIDBITS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.FRUId = v_uint8()


class tagWin32AllocStats(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwMaxMem = v_uint64()
        self.dwCrtMem = v_uint64()
        self.dwMaxAlloc = v_uint32()
        self.dwCrtAlloc = v_uint32()
        self.pHead = v_ptr64()


class LARGE_UNICODE_STRING(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.MaximumLength = v_uint32()
        self.Buffer = v_ptr64()


class EXCEPTION_RECORD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExceptionCode = v_uint32()
        self.ExceptionFlags = v_uint32()
        self.ExceptionRecord = v_ptr64()
        self.ExceptionAddress = v_ptr64()
        self.NumberParameters = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.ExceptionInformation = vstruct.VArray([ v_uint64() for i in range(15) ])


class HTOUCHINPUT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class PROCESSOR_NUMBER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Group = v_uint16()
        self.Number = v_uint8()
        self.Reserved = v_uint8()


class _unnamed_10592(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Argument1 = v_ptr64()
        self.Argument2 = v_ptr64()
        self.Argument3 = v_ptr64()
        self.Argument4 = v_ptr64()


class KPCR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NtTib = NT_TIB()
        self.IdtBase = v_ptr64()
        self.Unused = vstruct.VArray([ v_uint64() for i in range(2) ])
        self.Irql = v_uint8()
        self.SecondLevelCacheAssociativity = v_uint8()
        self.ObsoleteNumber = v_uint8()
        self.Fill0 = v_uint8()
        self.Unused0 = vstruct.VArray([ v_uint32() for i in range(3) ])
        self.MajorVersion = v_uint16()
        self.MinorVersion = v_uint16()
        self.StallScaleFactor = v_uint32()
        self.Unused1 = vstruct.VArray([ v_ptr64() for i in range(3) ])
        self.KernelReserved = vstruct.VArray([ v_uint32() for i in range(15) ])
        self.SecondLevelCacheSize = v_uint32()
        self.HalReserved = vstruct.VArray([ v_uint32() for i in range(16) ])
        self.Unused2 = v_uint32()
        self._pad0108 = v_bytes(size=4)
        self.KdVersionBlock = v_ptr64()
        self.Unused3 = v_ptr64()
        self.PcrAlign1 = vstruct.VArray([ v_uint32() for i in range(24) ])
        self._pad0180 = v_bytes(size=8)
        self.Prcb = KPRCB()


class IMAGE_FILE_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Machine = v_uint16()
        self.NumberOfSections = v_uint16()
        self.TimeDateStamp = v_uint32()
        self.PointerToSymbolTable = v_uint32()
        self.NumberOfSymbols = v_uint32()
        self.SizeOfOptionalHeader = v_uint16()
        self.Characteristics = v_uint16()


class SCATTER_GATHER_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumberOfElements = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.Reserved = v_uint64()
        self.Elements = vstruct.VArray([ SCATTER_GATHER_ELEMENT() for i in range(0) ])


class tagPROCESSINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Process = v_ptr64()
        self.RefCount = v_uint32()
        self.W32PF_Flags = v_uint32()
        self.InputIdleEvent = v_ptr64()
        self.StartCursorHideTime = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.NextStart = v_ptr64()
        self.pDCAttrList = v_ptr64()
        self.pBrushAttrList = v_ptr64()
        self.W32Pid = v_uint32()
        self.GDIHandleCount = v_uint32()
        self.GDIHandleCountPeak = v_uint32()
        self.UserHandleCount = v_uint32()
        self.UserHandleCountPeak = v_uint32()
        self._pad0050 = v_bytes(size=4)
        self.GDIPushLock = EX_PUSH_LOCK()
        self.GDIEngUserMemAllocTable = RTL_AVL_TABLE()
        self.GDIDcAttrFreeList = LIST_ENTRY()
        self.GDIBrushAttrFreeList = LIST_ENTRY()
        self.GDIW32PIDLockedBitmaps = LIST_ENTRY()
        self.hSecureGdiSharedHandleTable = v_ptr64()
        self.DxProcess = v_ptr64()
        self.ptiList = v_ptr64()
        self.ptiMainThread = v_ptr64()
        self.rpdeskStartup = v_ptr64()
        self.pclsPrivateList = v_ptr64()
        self.pclsPublicList = v_ptr64()
        self.pwpi = v_ptr64()
        self.ppiNext = v_ptr64()
        self.ppiNextRunning = v_ptr64()
        self.cThreads = v_uint32()
        self._pad0148 = v_bytes(size=4)
        self.hdeskStartup = v_ptr64()
        self.cSysExpunge = v_uint32()
        self.dwhmodLibLoadedMask = v_uint32()
        self.ahmodLibLoaded = vstruct.VArray([ v_ptr64() for i in range(32) ])
        self.rpwinsta = v_ptr64()
        self.hwinsta = v_ptr64()
        self.amwinsta = v_uint32()
        self.dwHotkey = v_uint32()
        self.hMonitor = v_ptr64()
        self.pdvList = v_ptr64()
        self.iClipSerialNumber = v_uint32()
        self._pad0288 = v_bytes(size=4)
        self.bmHandleFlags = RTL_BITMAP()
        self.pCursorCache = v_ptr64()
        self.pClientBase = v_ptr64()
        self.dwLpkEntryPoints = v_uint32()
        self._pad02b0 = v_bytes(size=4)
        self.pW32Job = v_ptr64()
        self.dwImeCompatFlags = v_uint32()
        self.luidSession = LUID()
        self.usi = tagUSERSTARTUPINFO()
        self.Flags = v_uint32()
        self.dwLayout = v_uint32()
        self.pHidTable = v_ptr64()
        self.dwRegisteredClasses = v_uint32()
        self._pad02f8 = v_bytes(size=4)
        self.pvwplWndGCList = v_ptr64()


class HKL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class PEB_LDR_DATA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Initialized = v_uint8()
        self._pad0008 = v_bytes(size=3)
        self.SsHandle = v_ptr64()
        self.InLoadOrderModuleList = LIST_ENTRY()
        self.InMemoryOrderModuleList = LIST_ENTRY()
        self.InInitializationOrderModuleList = LIST_ENTRY()
        self.EntryInProgress = v_ptr64()
        self.ShutdownInProgress = v_uint8()
        self._pad0050 = v_bytes(size=7)
        self.ShutdownThreadId = v_ptr64()


class DMM_MONITORFREQUENCYRANGESET_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NumFrequencyRanges = v_uint8()
        self._pad0008 = v_bytes(size=7)
        self.FrequencyRangeSerialization = vstruct.VArray([ D3DKMDT_MONITOR_FREQUENCY_RANGE() for i in range(1) ])


class SECURITY_SUBJECT_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClientToken = v_ptr64()
        self.ImpersonationLevel = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.PrimaryToken = v_ptr64()
        self.ProcessAuditId = v_ptr64()


class DMM_MONITOR_SERIALIZATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint32()
        self.VideoPresentTargetId = v_uint32()
        self.Orientation = v_uint32()
        self.IsSimulatedMonitor = v_uint8()
        self.IsUsingDefaultProfile = v_uint8()
        self._pad0010 = v_bytes(size=2)
        self.ModePruningAlgorithm = v_uint32()
        self.MonitorPowerState = v_uint32()
        self.SourceModeSetOffset = v_uint32()
        self.FrequencyRangeSetOffset = v_uint32()
        self.DescriptorSetOffset = v_uint32()
        self.MonitorType = v_uint32()


class tagKbdLayer(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pCharModifiers = v_ptr64()
        self.pVkToWcharTable = v_ptr64()
        self.pDeadKey = v_ptr64()
        self.pKeyNames = v_ptr64()
        self.pKeyNamesExt = v_ptr64()
        self.pKeyNamesDead = v_ptr64()
        self.pusVSCtoVK = v_ptr64()
        self.bMaxVSCtoVK = v_uint8()
        self._pad0040 = v_bytes(size=7)
        self.pVSCtoVK_E0 = v_ptr64()
        self.pVSCtoVK_E1 = v_ptr64()
        self.fLocaleFlags = v_uint32()
        self.nLgMax = v_uint8()
        self.cbLgEntry = v_uint8()
        self._pad0058 = v_bytes(size=2)
        self.pLigature = v_ptr64()
        self.dwType = v_uint32()
        self.dwSubType = v_uint32()


class HWND(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class _unnamed_9269(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LowPart = v_uint32()
        self.HighPart = v_uint32()


class tagMSG(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.hwnd = v_ptr64()
        self.message = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.wParam = v_uint64()
        self.lParam = v_uint64()
        self.time = v_uint32()
        self.pt = tagPOINT()
        self._pad0030 = v_bytes(size=4)


class _unnamed_10283(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = v_ptr64()
        self.Options = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.Reserved = v_uint16()
        self.ShareAccess = v_uint16()
        self._pad0018 = v_bytes(size=4)
        self.Parameters = v_ptr64()


class INTERFACE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self.Version = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.Context = v_ptr64()
        self.InterfaceReference = v_ptr64()
        self.InterfaceDereference = v_ptr64()


class SLIST_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Alignment = v_uint64()
        self.Region = v_uint64()


class IMAGE_DATA_DIRECTORY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VirtualAddress = v_uint32()
        self.Size = v_uint32()


class FILE_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.DeviceObject = v_ptr64()
        self.Vpb = v_ptr64()
        self.FsContext = v_ptr64()
        self.FsContext2 = v_ptr64()
        self.SectionObjectPointer = v_ptr64()
        self.PrivateCacheMap = v_ptr64()
        self.FinalStatus = v_uint32()
        self._pad0040 = v_bytes(size=4)
        self.RelatedFileObject = v_ptr64()
        self.LockOperation = v_uint8()
        self.DeletePending = v_uint8()
        self.ReadAccess = v_uint8()
        self.WriteAccess = v_uint8()
        self.DeleteAccess = v_uint8()
        self.SharedRead = v_uint8()
        self.SharedWrite = v_uint8()
        self.SharedDelete = v_uint8()
        self.Flags = v_uint32()
        self._pad0058 = v_bytes(size=4)
        self.FileName = UNICODE_STRING()
        self.CurrentByteOffset = LARGE_INTEGER()
        self.Waiters = v_uint32()
        self.Busy = v_uint32()
        self.LastLock = v_ptr64()
        self.Lock = KEVENT()
        self.Event = KEVENT()
        self.CompletionContext = v_ptr64()
        self.IrpListLock = v_uint64()
        self.IrpList = LIST_ENTRY()
        self.FileObjectExtension = v_ptr64()


class tagWOWPROCESSINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pwpiNext = v_ptr64()
        self.ptiScheduled = v_ptr64()
        self.ptdbHead = v_ptr64()
        self.lpfnWowExitTask = v_ptr64()
        self.pEventWowExec = v_ptr64()
        self.hEventWowExecClient = v_ptr64()
        self.nSendLock = v_uint32()
        self.nRecvLock = v_uint32()
        self.CSOwningThread = v_ptr64()
        self.CSLockCount = v_uint32()
        self._pad0048 = v_bytes(size=4)


class tagMENU(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = PROCDESKHEAD()
        self.fFlags = v_uint32()
        self.iItem = v_uint32()
        self.cAlloced = v_uint32()
        self.cItems = v_uint32()
        self.cxMenu = v_uint32()
        self.cyMenu = v_uint32()
        self.cxTextAlign = v_uint32()
        self._pad0048 = v_bytes(size=4)
        self.spwndNotify = v_ptr64()
        self.rgItems = v_ptr64()
        self.pParentMenus = v_ptr64()
        self.dwContextHelpId = v_uint32()
        self.cyMax = v_uint32()
        self.dwMenuData = v_uint64()
        self.hbrBack = v_ptr64()
        self.iTop = v_uint32()
        self.iMaxTop = v_uint32()
        self.dwArrowsOn = v_uint32()
        self.umpm = tagUAHMENUPOPUPMETRICS()


class ERESOURCE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SystemResourcesList = LIST_ENTRY()
        self.OwnerTable = v_ptr64()
        self.ActiveCount = v_uint16()
        self.Flag = v_uint16()
        self._pad0020 = v_bytes(size=4)
        self.SharedWaiters = v_ptr64()
        self.ExclusiveWaiters = v_ptr64()
        self.OwnerEntry = OWNER_ENTRY()
        self.ActiveEntries = v_uint32()
        self.ContentionCount = v_uint32()
        self.NumberOfSharedWaiters = v_uint32()
        self.NumberOfExclusiveWaiters = v_uint32()
        self.Reserved2 = v_ptr64()
        self.Address = v_ptr64()
        self.SpinLock = v_uint64()


class _unnamed_9315(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.LongFunction = v_uint32()


class _unnamed_9312(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()


class PEB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InheritedAddressSpace = v_uint8()
        self.ReadImageFileExecOptions = v_uint8()
        self.BeingDebugged = v_uint8()
        self.BitField = v_uint8()
        self._pad0008 = v_bytes(size=4)
        self.Mutant = v_ptr64()
        self.ImageBaseAddress = v_ptr64()
        self.Ldr = v_ptr64()
        self.ProcessParameters = v_ptr64()
        self.SubSystemData = v_ptr64()
        self.ProcessHeap = v_ptr64()
        self.FastPebLock = v_ptr64()
        self.AtlThunkSListPtr = v_ptr64()
        self.IFEOKey = v_ptr64()
        self.CrossProcessFlags = v_uint32()
        self._pad0058 = v_bytes(size=4)
        self.KernelCallbackTable = v_ptr64()
        self.SystemReserved = vstruct.VArray([ v_uint32() for i in range(1) ])
        self.AtlThunkSListPtr32 = v_uint32()
        self.ApiSetMap = v_ptr64()
        self.TlsExpansionCounter = v_uint32()
        self._pad0078 = v_bytes(size=4)
        self.TlsBitmap = v_ptr64()
        self.TlsBitmapBits = vstruct.VArray([ v_uint32() for i in range(2) ])
        self.ReadOnlySharedMemoryBase = v_ptr64()
        self.HotpatchInformation = v_ptr64()
        self.ReadOnlyStaticServerData = v_ptr64()
        self.AnsiCodePageData = v_ptr64()
        self.OemCodePageData = v_ptr64()
        self.UnicodeCaseTableData = v_ptr64()
        self.NumberOfProcessors = v_uint32()
        self.NtGlobalFlag = v_uint32()
        self.CriticalSectionTimeout = LARGE_INTEGER()
        self.HeapSegmentReserve = v_uint64()
        self.HeapSegmentCommit = v_uint64()
        self.HeapDeCommitTotalFreeThreshold = v_uint64()
        self.HeapDeCommitFreeBlockThreshold = v_uint64()
        self.NumberOfHeaps = v_uint32()
        self.MaximumNumberOfHeaps = v_uint32()
        self.ProcessHeaps = v_ptr64()
        self.GdiSharedHandleTable = v_ptr64()
        self.ProcessStarterHelper = v_ptr64()
        self.GdiDCAttributeList = v_uint32()
        self._pad0110 = v_bytes(size=4)
        self.LoaderLock = v_ptr64()
        self.OSMajorVersion = v_uint32()
        self.OSMinorVersion = v_uint32()
        self.OSBuildNumber = v_uint16()
        self.OSCSDVersion = v_uint16()
        self.OSPlatformId = v_uint32()
        self.ImageSubsystem = v_uint32()
        self.ImageSubsystemMajorVersion = v_uint32()
        self.ImageSubsystemMinorVersion = v_uint32()
        self._pad0138 = v_bytes(size=4)
        self.ActiveProcessAffinityMask = v_uint64()
        self.GdiHandleBuffer = vstruct.VArray([ v_uint32() for i in range(60) ])
        self.PostProcessInitRoutine = v_ptr64()
        self.TlsExpansionBitmap = v_ptr64()
        self.TlsExpansionBitmapBits = vstruct.VArray([ v_uint32() for i in range(32) ])
        self.SessionId = v_uint32()
        self._pad02c8 = v_bytes(size=4)
        self.AppCompatFlags = ULARGE_INTEGER()
        self.AppCompatFlagsUser = ULARGE_INTEGER()
        self.pShimData = v_ptr64()
        self.AppCompatInfo = v_ptr64()
        self.CSDVersion = UNICODE_STRING()
        self.ActivationContextData = v_ptr64()
        self.ProcessAssemblyStorageMap = v_ptr64()
        self.SystemDefaultActivationContextData = v_ptr64()
        self.SystemAssemblyStorageMap = v_ptr64()
        self.MinimumStackCommit = v_uint64()
        self.FlsCallback = v_ptr64()
        self.FlsListHead = LIST_ENTRY()
        self.FlsBitmap = v_ptr64()
        self.FlsBitmapBits = vstruct.VArray([ v_uint32() for i in range(4) ])
        self.FlsHighIndex = v_uint32()
        self._pad0358 = v_bytes(size=4)
        self.WerRegistrationData = v_ptr64()
        self.WerShipAssertPtr = v_ptr64()
        self.pContextData = v_ptr64()
        self.pImageHeaderHash = v_ptr64()
        self.TracingFlags = v_uint32()
        self._pad0380 = v_bytes(size=4)


class THRDESKHEAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.h = v_ptr64()
        self.cLockObj = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.pti = v_ptr64()
        self.rpdesk = v_ptr64()
        self.pSelf = v_ptr64()


class tagPOPUPMENU(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.fIsMenuBar = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.spwndNotify = v_ptr64()
        self.spwndPopupMenu = v_ptr64()
        self.spwndNextPopup = v_ptr64()
        self.spwndPrevPopup = v_ptr64()
        self.spmenu = v_ptr64()
        self.spmenuAlternate = v_ptr64()
        self.spwndActivePopup = v_ptr64()
        self.ppopupmenuRoot = v_ptr64()
        self.ppmDelayedFree = v_ptr64()
        self.posSelectedItem = v_uint32()
        self.posDropped = v_uint32()


class TP_TASK_CALLBACKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ExecuteCallback = v_ptr64()
        self.Unposted = v_ptr64()


class RTL_BALANCED_LINKS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Parent = v_ptr64()
        self.LeftChild = v_ptr64()
        self.RightChild = v_ptr64()
        self.Balance = v_uint8()
        self.Reserved = vstruct.VArray([ v_uint8() for i in range(3) ])
        self._pad0020 = v_bytes(size=4)


class _unnamed_10421(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Srb = v_ptr64()


class VK_FUNCTION_PARAM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NLSFEProcIndex = v_uint8()
        self._pad0004 = v_bytes(size=3)
        self.NLSFEProcParam = v_uint32()


class EX_PUSH_LOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Locked = v_uint64()


class D3DMATRIX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self._11 = v_uint32()
        self._12 = v_uint32()
        self._13 = v_uint32()
        self._14 = v_uint32()
        self._21 = v_uint32()
        self._22 = v_uint32()
        self._23 = v_uint32()
        self._24 = v_uint32()
        self._31 = v_uint32()
        self._32 = v_uint32()
        self._33 = v_uint32()
        self._34 = v_uint32()
        self._41 = v_uint32()
        self._42 = v_uint32()
        self._43 = v_uint32()
        self._44 = v_uint32()


class _unnamed_13952(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Start = LARGE_INTEGER()
        self.Length64 = v_uint32()


class CONSOLE_CARET_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.hwnd = v_ptr64()
        self.rc = tagRECT()


class D3DKMDT_VIDPN_PRESENT_PATH_ROTATION_SUPPORT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Identity = v_uint32()


class _unnamed_14462(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint32()
        self.Alignment = v_uint32()
        self.MinimumAddress = LARGE_INTEGER()
        self.MaximumAddress = LARGE_INTEGER()


class WHEA_ERROR_RECORD_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Signature = v_uint32()
        self.Revision = WHEA_REVISION()
        self.SignatureEnd = v_uint32()
        self.SectionCount = v_uint16()
        self.Severity = v_uint32()
        self.ValidBits = WHEA_ERROR_RECORD_HEADER_VALIDBITS()
        self.Length = v_uint32()
        self.Timestamp = WHEA_TIMESTAMP()
        self.PlatformId = GUID()
        self.PartitionId = GUID()
        self.CreatorId = GUID()
        self.NotifyType = GUID()
        self.RecordId = v_uint64()
        self.Flags = WHEA_ERROR_RECORD_HEADER_FLAGS()
        self.PersistenceInfo = WHEA_PERSISTENCE_INFO()
        self.Reserved = vstruct.VArray([ v_uint8() for i in range(12) ])


class EVENT_DESCRIPTOR(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Id = v_uint16()
        self.Version = v_uint8()
        self.Channel = v_uint8()
        self.Level = v_uint8()
        self.Opcode = v_uint8()
        self.Task = v_uint16()
        self.Keyword = v_uint64()


class HRGN(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class _unnamed_10391(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_ptr64()
        self.Key = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.ByteOffset = LARGE_INTEGER()


class _unnamed_10396(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.OutputBufferLength = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.InputBufferLength = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.IoControlCode = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.Type3InputBuffer = v_ptr64()


class tagSBINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.WSBflags = v_uint32()
        self.Horz = tagSBDATA()
        self.Vert = tagSBDATA()


class FLS_CALLBACK_INFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class _unnamed_10255(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.SecurityContext = v_ptr64()
        self.Options = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.FileAttributes = v_uint16()
        self.ShareAccess = v_uint16()
        self._pad0018 = v_bytes(size=4)
        self.EaLength = v_uint32()
        self._pad0020 = v_bytes(size=4)


class LIST_ENTRY64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flink = v_uint64()
        self.Blink = v_uint64()


class tagOEMBITMAPINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.x = v_uint32()
        self.y = v_uint32()
        self.cx = v_uint32()
        self.cy = v_uint32()


class _unnamed_10497(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.IoResourceRequirementList = v_ptr64()


class ACTIVATION_CONTEXT_STACK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ActiveFrame = v_ptr64()
        self.FrameListCache = LIST_ENTRY()
        self.Flags = v_uint32()
        self.NextCookieSequenceNumber = v_uint32()
        self.StackId = v_uint32()
        self._pad0028 = v_bytes(size=4)


class tagITEM(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.fType = v_uint32()
        self.fState = v_uint32()
        self.wID = v_uint32()
        self._pad0010 = v_bytes(size=4)
        self.spSubMenu = v_ptr64()
        self.hbmpChecked = v_ptr64()
        self.hbmpUnchecked = v_ptr64()
        self.lpstr = v_ptr64()
        self.cch = v_uint32()
        self._pad0038 = v_bytes(size=4)
        self.dwItemData = v_uint64()
        self.xItem = v_uint32()
        self.yItem = v_uint32()
        self.cxItem = v_uint32()
        self.cyItem = v_uint32()
        self.dxTab = v_uint32()
        self.ulX = v_uint32()
        self.ulWidth = v_uint32()
        self._pad0060 = v_bytes(size=4)
        self.hbmp = v_ptr64()
        self.cxBmp = v_uint32()
        self.cyBmp = v_uint32()
        self.umim = tagUAHMENUITEMMETRICS()


class IO_DRIVER_CREATE_CONTEXT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Size = v_uint16()
        self._pad0008 = v_bytes(size=6)
        self.ExtraCreateParameter = v_ptr64()
        self.DeviceObjectHint = v_ptr64()
        self.TxnParameters = v_ptr64()


class LOOKASIDE_LIST_EX(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.L = GENERAL_LOOKASIDE_POOL()


class TEB(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.NtTib = NT_TIB()
        self.EnvironmentPointer = v_ptr64()
        self.ClientId = CLIENT_ID()
        self.ActiveRpcHandle = v_ptr64()
        self.ThreadLocalStoragePointer = v_ptr64()
        self.ProcessEnvironmentBlock = v_ptr64()
        self.LastErrorValue = v_uint32()
        self.CountOfOwnedCriticalSections = v_uint32()
        self.CsrClientThread = v_ptr64()
        self.Win32ThreadInfo = v_ptr64()
        self.User32Reserved = vstruct.VArray([ v_uint32() for i in range(26) ])
        self.UserReserved = vstruct.VArray([ v_uint32() for i in range(5) ])
        self._pad0100 = v_bytes(size=4)
        self.WOW32Reserved = v_ptr64()
        self.CurrentLocale = v_uint32()
        self.FpSoftwareStatusRegister = v_uint32()
        self.SystemReserved1 = vstruct.VArray([ v_ptr64() for i in range(54) ])
        self.ExceptionCode = v_uint32()
        self._pad02c8 = v_bytes(size=4)
        self.ActivationContextStackPointer = v_ptr64()
        self.SpareBytes = vstruct.VArray([ v_uint8() for i in range(24) ])
        self.TxFsContext = v_uint32()
        self._pad02f0 = v_bytes(size=4)
        self.GdiTebBatch = GDI_TEB_BATCH()
        self.RealClientId = CLIENT_ID()
        self.GdiCachedProcessHandle = v_ptr64()
        self.GdiClientPID = v_uint32()
        self.GdiClientTID = v_uint32()
        self.GdiThreadLocalInfo = v_ptr64()
        self.Win32ClientInfo = vstruct.VArray([ v_uint64() for i in range(62) ])
        self.glDispatchTable = vstruct.VArray([ v_ptr64() for i in range(233) ])
        self.glReserved1 = vstruct.VArray([ v_uint64() for i in range(29) ])
        self.glReserved2 = v_ptr64()
        self.glSectionInfo = v_ptr64()
        self.glSection = v_ptr64()
        self.glTable = v_ptr64()
        self.glCurrentRC = v_ptr64()
        self.glContext = v_ptr64()
        self.LastStatusValue = v_uint32()
        self._pad1258 = v_bytes(size=4)
        self.StaticUnicodeString = UNICODE_STRING()
        self.StaticUnicodeBuffer = vstruct.VArray([ v_uint16() for i in range(261) ])
        self._pad1478 = v_bytes(size=6)
        self.DeallocationStack = v_ptr64()
        self.TlsSlots = vstruct.VArray([ v_ptr64() for i in range(64) ])
        self.TlsLinks = LIST_ENTRY()
        self.Vdm = v_ptr64()
        self.ReservedForNtRpc = v_ptr64()
        self.DbgSsReserved = vstruct.VArray([ v_ptr64() for i in range(2) ])
        self.HardErrorMode = v_uint32()
        self._pad16b8 = v_bytes(size=4)
        self.Instrumentation = vstruct.VArray([ v_ptr64() for i in range(11) ])
        self.ActivityId = GUID()
        self.SubProcessTag = v_ptr64()
        self.EtwLocalData = v_ptr64()
        self.EtwTraceData = v_ptr64()
        self.WinSockData = v_ptr64()
        self.GdiBatchCount = v_uint32()
        self.CurrentIdealProcessor = PROCESSOR_NUMBER()
        self.GuaranteedStackBytes = v_uint32()
        self._pad1750 = v_bytes(size=4)
        self.ReservedForPerf = v_ptr64()
        self.ReservedForOle = v_ptr64()
        self.WaitingOnLoaderLock = v_uint32()
        self._pad1768 = v_bytes(size=4)
        self.SavedPriorityState = v_ptr64()
        self.SoftPatchPtr1 = v_uint64()
        self.ThreadPoolData = v_ptr64()
        self.TlsExpansionSlots = v_ptr64()
        self.DeallocationBStore = v_ptr64()
        self.BStoreLimit = v_ptr64()
        self.MuiGeneration = v_uint32()
        self.IsImpersonating = v_uint32()
        self.NlsCache = v_ptr64()
        self.pShimData = v_ptr64()
        self.HeapVirtualAffinity = v_uint32()
        self._pad17b8 = v_bytes(size=4)
        self.CurrentTransactionHandle = v_ptr64()
        self.ActiveFrame = v_ptr64()
        self.FlsData = v_ptr64()
        self.PreferredLanguages = v_ptr64()
        self.UserPrefLanguages = v_ptr64()
        self.MergedPrefLanguages = v_ptr64()
        self.MuiImpersonation = v_uint32()
        self.CrossTebFlags = v_uint16()
        self.SameTebFlags = v_uint16()
        self.TxnScopeEnterCallback = v_ptr64()
        self.TxnScopeExitCallback = v_ptr64()
        self.TxnScopeContext = v_ptr64()
        self.LockCount = v_uint32()
        self.SpareUlong0 = v_uint32()
        self.ResourceRetValue = v_ptr64()


class tagWIN32HEAP(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)


class XSAVE_FORMAT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ControlWord = v_uint16()
        self.StatusWord = v_uint16()
        self.TagWord = v_uint8()
        self.Reserved1 = v_uint8()
        self.ErrorOpcode = v_uint16()
        self.ErrorOffset = v_uint32()
        self.ErrorSelector = v_uint16()
        self.Reserved2 = v_uint16()
        self.DataOffset = v_uint32()
        self.DataSelector = v_uint16()
        self.Reserved3 = v_uint16()
        self.MxCsr = v_uint32()
        self.MxCsr_Mask = v_uint32()
        self.FloatRegisters = vstruct.VArray([ M128A() for i in range(8) ])
        self.XmmRegisters = vstruct.VArray([ M128A() for i in range(16) ])
        self.Reserved4 = vstruct.VArray([ v_uint8() for i in range(96) ])


class DMM_COMMITVIDPNREQUEST_DIAGINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ClientType = v_uint32()
        self.ReclaimClonedTarget = v_uint8()
        self._pad0008 = v_bytes(size=3)
        self.ModeChangeRequestId = v_uint32()


class IMAGE_DOS_HEADER(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.e_magic = v_uint16()
        self.e_cblp = v_uint16()
        self.e_cp = v_uint16()
        self.e_crlc = v_uint16()
        self.e_cparhdr = v_uint16()
        self.e_minalloc = v_uint16()
        self.e_maxalloc = v_uint16()
        self.e_ss = v_uint16()
        self.e_sp = v_uint16()
        self.e_csum = v_uint16()
        self.e_ip = v_uint16()
        self.e_cs = v_uint16()
        self.e_lfarlc = v_uint16()
        self.e_ovno = v_uint16()
        self.e_res = vstruct.VArray([ v_uint16() for i in range(4) ])
        self.e_oemid = v_uint16()
        self.e_oeminfo = v_uint16()
        self.e_res2 = vstruct.VArray([ v_uint16() for i in range(10) ])
        self.e_lfanew = v_uint32()


class RTL_DYNAMIC_HASH_TABLE_ENTRY(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Linkage = LIST_ENTRY()
        self.Signature = v_uint64()


class _unnamed_13776(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pRgb256x3x16 = v_ptr64()


class _unnamed_10086(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MasterIrp = v_ptr64()


class TXN_PARAMETER_BLOCK(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Length = v_uint16()
        self.TxFsContext = v_uint16()
        self._pad0008 = v_bytes(size=4)
        self.TransactionObject = v_ptr64()


class _unnamed_10796(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.InitialPrivilegeSet = INITIAL_PRIVILEGE_SET()


class QUAD(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UseThisFieldToCopy = v_uint64()


class RTL_DYNAMIC_HASH_TABLE(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Flags = v_uint32()
        self.Shift = v_uint32()
        self.TableSize = v_uint32()
        self.Pivot = v_uint32()
        self.DivisorMask = v_uint32()
        self.NumEntries = v_uint32()
        self.NonEmptyBuckets = v_uint32()
        self.NumEnumerators = v_uint32()
        self.Directory = v_ptr64()


class tagSERVERINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwSRVIFlags = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.cHandleEntries = v_uint64()
        self.mpFnidPfn = vstruct.VArray([ v_ptr64() for i in range(32) ])
        self.aStoCidPfn = vstruct.VArray([ v_ptr64() for i in range(7) ])
        self.mpFnid_serverCBWndProc = vstruct.VArray([ v_uint16() for i in range(31) ])
        self._pad0188 = v_bytes(size=2)
        self.apfnClientA = PFNCLIENT()
        self.apfnClientW = PFNCLIENT()
        self.apfnClientWorker = PFNCLIENTWORKER()
        self.cbHandleTable = v_uint32()
        self.atomSysClass = vstruct.VArray([ v_uint16() for i in range(25) ])
        self._pad0388 = v_bytes(size=2)
        self.dwDefaultHeapBase = v_uint32()
        self.dwDefaultHeapSize = v_uint32()
        self.uiShellMsg = v_uint32()
        self.MBStrings = vstruct.VArray([ tagMBSTRING() for i in range(11) ])
        self.atomIconSmProp = v_uint16()
        self.atomIconProp = v_uint16()
        self.atomContextHelpIdProp = v_uint16()
        self.atomFrostedWindowProp = v_uint16()
        self.acOemToAnsi = vstruct.VArray([ v_uint8() for i in range(256) ])
        self.acAnsiToOem = vstruct.VArray([ v_uint8() for i in range(256) ])
        self.dwInstalledEventHooks = v_uint32()
        self.aiSysMet = vstruct.VArray([ v_uint32() for i in range(97) ])
        self.argbSystemUnmatched = vstruct.VArray([ v_uint32() for i in range(31) ])
        self.argbSystem = vstruct.VArray([ v_uint32() for i in range(31) ])
        self._pad09d8 = v_bytes(size=4)
        self.ahbrSystem = vstruct.VArray([ v_ptr64() for i in range(31) ])
        self.hbrGray = v_ptr64()
        self.ptCursor = tagPOINT()
        self.ptCursorReal = tagPOINT()
        self.dwLastRITEventTickCount = v_uint32()
        self.nEvents = v_uint32()
        self.dtScroll = v_uint32()
        self.dtLBSearch = v_uint32()
        self.dtCaretBlink = v_uint32()
        self.ucWheelScrollLines = v_uint32()
        self.ucWheelScrollChars = v_uint32()
        self.wMaxLeftOverlapChars = v_uint32()
        self.wMaxRightOverlapChars = v_uint32()
        self.cxSysFontChar = v_uint32()
        self.cySysFontChar = v_uint32()
        self.tmSysFont = tagTEXTMETRICW()
        self.dpiSystem = tagDPISERVERINFO()
        self.hIconSmWindows = v_ptr64()
        self.hIcoWindows = v_ptr64()
        self.dwKeyCache = v_uint32()
        self.dwAsyncKeyCache = v_uint32()
        self.cCaptures = v_uint32()
        self.oembmi = vstruct.VArray([ tagOEMBITMAPINFO() for i in range(93) ])
        self.rcScreenReal = tagRECT()
        self.BitCount = v_uint16()
        self.dmLogPixels = v_uint16()
        self.Planes = v_uint8()
        self.BitsPixel = v_uint8()
        self._pad117c = v_bytes(size=2)
        self.PUSIFlags = v_uint32()
        self.uCaretWidth = v_uint32()
        self.UILangID = v_uint16()
        self._pad1188 = v_bytes(size=2)
        self.dwLastSystemRITEventTickCountUpdate = v_uint32()
        self.adwDBGTAGFlags = vstruct.VArray([ v_uint32() for i in range(35) ])
        self.dwTagCount = v_uint32()
        self.dwRIPFlags = v_uint32()


class DEVICE_OBJECT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Type = v_uint16()
        self.Size = v_uint16()
        self.ReferenceCount = v_uint32()
        self.DriverObject = v_ptr64()
        self.NextDevice = v_ptr64()
        self.AttachedDevice = v_ptr64()
        self.CurrentIrp = v_ptr64()
        self.Timer = v_ptr64()
        self.Flags = v_uint32()
        self.Characteristics = v_uint32()
        self.Vpb = v_ptr64()
        self.DeviceExtension = v_ptr64()
        self.DeviceType = v_uint32()
        self.StackSize = v_uint8()
        self._pad0050 = v_bytes(size=3)
        self.Queue = _unnamed_10148()
        self.AlignmentRequirement = v_uint32()
        self._pad00a0 = v_bytes(size=4)
        self.DeviceQueue = KDEVICE_QUEUE()
        self.Dpc = KDPC()
        self.ActiveThreadCount = v_uint32()
        self._pad0110 = v_bytes(size=4)
        self.SecurityDescriptor = v_ptr64()
        self.DeviceLock = KEVENT()
        self.SectorSize = v_uint16()
        self.Spare1 = v_uint16()
        self._pad0138 = v_bytes(size=4)
        self.DeviceObjectExtension = v_ptr64()
        self.Reserved = v_ptr64()
        self._pad0150 = v_bytes(size=8)


class KTSS64(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.Reserved0 = v_uint32()
        self.Rsp0 = v_uint64()
        self.Rsp1 = v_uint64()
        self.Rsp2 = v_uint64()
        self.Ist = vstruct.VArray([ v_uint64() for i in range(8) ])
        self.Reserved1 = v_uint64()
        self.Reserved2 = v_uint16()
        self.IoMapBase = v_uint16()


class tagCLIENTINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.CI_flags = v_uint64()
        self.cSpins = v_uint64()
        self.dwExpWinVer = v_uint32()
        self.dwCompatFlags = v_uint32()
        self.dwCompatFlags2 = v_uint32()
        self.dwTIFlags = v_uint32()
        self.pDeskInfo = v_ptr64()
        self.ulClientDelta = v_uint64()
        self.phkCurrent = v_ptr64()
        self.fsHooks = v_uint32()
        self._pad0040 = v_bytes(size=4)
        self.CallbackWnd = CALLBACKWND()
        self.dwHookCurrent = v_uint32()
        self.cInDDEMLCallback = v_uint32()
        self.pClientThreadInfo = v_ptr64()
        self.dwHookData = v_uint64()
        self.dwKeyCache = v_uint32()
        self.afKeyState = vstruct.VArray([ v_uint8() for i in range(8) ])
        self.dwAsyncKeyCache = v_uint32()
        self.afAsyncKeyState = vstruct.VArray([ v_uint8() for i in range(8) ])
        self.afAsyncKeyStateRecentDown = vstruct.VArray([ v_uint8() for i in range(8) ])
        self.hKL = v_ptr64()
        self.CodePage = v_uint16()
        self.achDbcsCF = vstruct.VArray([ v_uint8() for i in range(2) ])
        self._pad00a0 = v_bytes(size=4)
        self.msgDbcsCB = tagMSG()
        self.lpdwRegisteredClasses = v_ptr64()


class HWINSTA(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.unused = v_uint32()


class TL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.next = v_ptr64()
        self.pobj = v_ptr64()
        self.pfnFree = v_ptr64()


class IO_STACK_LOCATION(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MajorFunction = v_uint8()
        self.MinorFunction = v_uint8()
        self.Flags = v_uint8()
        self.Control = v_uint8()
        self._pad0008 = v_bytes(size=4)
        self.Parameters = _unnamed_10168()
        self.DeviceObject = v_ptr64()
        self.FileObject = v_ptr64()
        self.CompletionRoutine = v_ptr64()
        self.Context = v_ptr64()


class tagTERMINAL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.dwTERMF_Flags = v_uint32()
        self._pad0008 = v_bytes(size=4)
        self.spwndDesktopOwner = v_ptr64()
        self.ptiDesktop = v_ptr64()
        self.pqDesktop = v_ptr64()
        self.dwNestedLevel = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.pEventTermInit = v_ptr64()
        self.rpdeskDestroy = v_ptr64()
        self.pEventInputReady = v_ptr64()


class D3DKMDT_VIDPN_PRESENT_PATH(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.VidPnSourceId = v_uint32()
        self.VidPnTargetId = v_uint32()
        self.ImportanceOrdinal = v_uint32()
        self.ContentTransformation = D3DKMDT_VIDPN_PRESENT_PATH_TRANSFORMATION()
        self.VisibleFromActiveTLOffset = D3DKMDT_2DREGION()
        self.VisibleFromActiveBROffset = D3DKMDT_2DREGION()
        self.VidPnTargetColorBasis = v_uint32()
        self.VidPnTargetColorCoeffDynamicRanges = D3DKMDT_COLOR_COEFF_DYNAMIC_RANGES()
        self.Content = v_uint32()
        self.CopyProtection = D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION()
        self.GammaRamp = D3DKMDT_GAMMA_RAMP()


class tagMENULIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pNext = v_ptr64()
        self.pMenu = v_ptr64()


class VK_VALUES_STRINGS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.pszMultiNames = v_ptr64()
        self.fReserved = v_uint8()
        self._pad0010 = v_bytes(size=7)


class tagKL(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = HEAD()
        self.pklNext = v_ptr64()
        self.pklPrev = v_ptr64()
        self.dwKL_Flags = v_uint32()
        self._pad0028 = v_bytes(size=4)
        self.hkl = v_ptr64()
        self.spkf = v_ptr64()
        self.spkfPrimary = v_ptr64()
        self.dwFontSigs = v_uint32()
        self.iBaseCharset = v_uint32()
        self.CodePage = v_uint16()
        self.wchDiacritic = v_uint16()
        self._pad0050 = v_bytes(size=4)
        self.piiex = v_ptr64()
        self.uNumTbl = v_uint32()
        self._pad0060 = v_bytes(size=4)
        self.pspkfExtra = v_ptr64()
        self.dwLastKbdType = v_uint32()
        self.dwLastKbdSubType = v_uint32()
        self.dwKLID = v_uint32()
        self._pad0078 = v_bytes(size=4)


class tagPOINT(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.x = v_uint32()
        self.y = v_uint32()


class RTL_USER_PROCESS_PARAMETERS(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.MaximumLength = v_uint32()
        self.Length = v_uint32()
        self.Flags = v_uint32()
        self.DebugFlags = v_uint32()
        self.ConsoleHandle = v_ptr64()
        self.ConsoleFlags = v_uint32()
        self._pad0020 = v_bytes(size=4)
        self.StandardInput = v_ptr64()
        self.StandardOutput = v_ptr64()
        self.StandardError = v_ptr64()
        self.CurrentDirectory = CURDIR()
        self.DllPath = UNICODE_STRING()
        self.ImagePathName = UNICODE_STRING()
        self.CommandLine = UNICODE_STRING()
        self.Environment = v_ptr64()
        self.StartingX = v_uint32()
        self.StartingY = v_uint32()
        self.CountX = v_uint32()
        self.CountY = v_uint32()
        self.CountCharsX = v_uint32()
        self.CountCharsY = v_uint32()
        self.FillAttribute = v_uint32()
        self.WindowFlags = v_uint32()
        self.ShowWindowFlags = v_uint32()
        self._pad00b0 = v_bytes(size=4)
        self.WindowTitle = UNICODE_STRING()
        self.DesktopInfo = UNICODE_STRING()
        self.ShellInfo = UNICODE_STRING()
        self.RuntimeData = UNICODE_STRING()
        self.CurrentDirectores = vstruct.VArray([ RTL_DRIVE_LETTER_CURDIR() for i in range(32) ])
        self.EnvironmentSize = v_uint64()
        self.EnvironmentVersion = v_uint64()


class tagSHAREDINFO(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.psi = v_ptr64()
        self.aheList = v_ptr64()
        self.HeEntrySize = v_uint32()
        self._pad0018 = v_bytes(size=4)
        self.pDispInfo = v_ptr64()
        self.ulSharedDelta = v_uint64()
        self.awmControl = vstruct.VArray([ WNDMSG() for i in range(31) ])
        self.DefWindowMsgs = WNDMSG()
        self.DefWindowSpecMsgs = WNDMSG()


class _unnamed_10107(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.UserApcRoutine = v_ptr64()
        self.UserApcContext = v_ptr64()


class tagIMC(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.head = THRDESKHEAD()
        self.pImcNext = v_ptr64()
        self.dwClientImcData = v_uint64()
        self.hImeWnd = v_ptr64()


class IO_RESOURCE_REQUIREMENTS_LIST(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.ListSize = v_uint32()
        self.InterfaceType = v_uint32()
        self.BusNumber = v_uint32()
        self.SlotNumber = v_uint32()
        self.Reserved = vstruct.VArray([ v_uint32() for i in range(3) ])
        self.AlternativeLists = v_uint32()
        self.List = vstruct.VArray([ IO_RESOURCE_LIST() for i in range(1) ])


class tagCARET(vstruct.VStruct):
    def __init__(self):
        vstruct.VStruct.__init__(self)
        self.spwnd = v_ptr64()
        self.fVisible = v_uint32()
        self.iHideLevel = v_uint32()
        self.x = v_uint32()
        self.y = v_uint32()
        self.cy = v_uint32()
        self.cx = v_uint32()
        self.hBitmap = v_ptr64()
        self.hTimer = v_uint64()
        self.tid = v_uint32()
        self.xOwnDc = v_uint32()
        self.yOwnDc = v_uint32()
        self.cxOwnDc = v_uint32()
        self.cyOwnDc = v_uint32()
        self._pad0048 = v_bytes(size=4)



