<a id="mypy-boto3-omics"></a>

# mypy-boto3-omics

[![PyPI - mypy-boto3-omics](https://img.shields.io/pypi/v/mypy-boto3-omics.svg?color=blue)](https://pypi.org/project/mypy-boto3-omics)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-omics.svg?color=blue)](https://pypi.org/project/mypy-boto3-omics)
[![Docs](https://img.shields.io/readthedocs/boto3-stubs.svg?color=blue)](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_omics/)
[![PyPI - Downloads](https://static.pepy.tech/badge/mypy-boto3-omics)](https://pepy.tech/project/mypy-boto3-omics)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.Omics 1.28.16](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/omics.html#Omics)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.16.2](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-omics docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_omics/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-omics](#mypy-boto3-omics)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `Omics`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `Omics` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[omics]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[omics]'


# standalone installation
python -m pip install mypy-boto3-omics
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-omics
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[omics]` in your environment:

```bash
python -m pip install 'boto3-stubs[omics]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[omics]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[omics]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[omics]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[omics]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[omics]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[omics]` in your environment:

```bash
python -m pip install 'boto3-stubs[omics]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[omics]` in your environment:

```bash
python -m pip install 'boto3-stubs[omics]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`OmicsClient` provides annotations for `boto3.client("omics")`.

```python
from boto3.session import Session

from mypy_boto3_omics import OmicsClient

client: OmicsClient = Session().client("omics")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_omics.paginator` module contains type annotations for all
paginators.

```python
from boto3.session import Session

from mypy_boto3_omics import OmicsClient
from mypy_boto3_omics.paginator import (
    ListAnnotationImportJobsPaginator,
    ListAnnotationStoresPaginator,
    ListMultipartReadSetUploadsPaginator,
    ListReadSetActivationJobsPaginator,
    ListReadSetExportJobsPaginator,
    ListReadSetImportJobsPaginator,
    ListReadSetUploadPartsPaginator,
    ListReadSetsPaginator,
    ListReferenceImportJobsPaginator,
    ListReferenceStoresPaginator,
    ListReferencesPaginator,
    ListRunGroupsPaginator,
    ListRunTasksPaginator,
    ListRunsPaginator,
    ListSequenceStoresPaginator,
    ListVariantImportJobsPaginator,
    ListVariantStoresPaginator,
    ListWorkflowsPaginator,
)

client: OmicsClient = Session().client("omics")

# Explicit type annotations are optional here
# Types should be correctly discovered by mypy and IDEs
list_annotation_import_jobs_paginator: ListAnnotationImportJobsPaginator = client.get_paginator(
    "list_annotation_import_jobs"
)
list_annotation_stores_paginator: ListAnnotationStoresPaginator = client.get_paginator(
    "list_annotation_stores"
)
list_multipart_read_set_uploads_paginator: ListMultipartReadSetUploadsPaginator = (
    client.get_paginator("list_multipart_read_set_uploads")
)
list_read_set_activation_jobs_paginator: ListReadSetActivationJobsPaginator = client.get_paginator(
    "list_read_set_activation_jobs"
)
list_read_set_export_jobs_paginator: ListReadSetExportJobsPaginator = client.get_paginator(
    "list_read_set_export_jobs"
)
list_read_set_import_jobs_paginator: ListReadSetImportJobsPaginator = client.get_paginator(
    "list_read_set_import_jobs"
)
list_read_set_upload_parts_paginator: ListReadSetUploadPartsPaginator = client.get_paginator(
    "list_read_set_upload_parts"
)
list_read_sets_paginator: ListReadSetsPaginator = client.get_paginator("list_read_sets")
list_reference_import_jobs_paginator: ListReferenceImportJobsPaginator = client.get_paginator(
    "list_reference_import_jobs"
)
list_reference_stores_paginator: ListReferenceStoresPaginator = client.get_paginator(
    "list_reference_stores"
)
list_references_paginator: ListReferencesPaginator = client.get_paginator("list_references")
list_run_groups_paginator: ListRunGroupsPaginator = client.get_paginator("list_run_groups")
list_run_tasks_paginator: ListRunTasksPaginator = client.get_paginator("list_run_tasks")
list_runs_paginator: ListRunsPaginator = client.get_paginator("list_runs")
list_sequence_stores_paginator: ListSequenceStoresPaginator = client.get_paginator(
    "list_sequence_stores"
)
list_variant_import_jobs_paginator: ListVariantImportJobsPaginator = client.get_paginator(
    "list_variant_import_jobs"
)
list_variant_stores_paginator: ListVariantStoresPaginator = client.get_paginator(
    "list_variant_stores"
)
list_workflows_paginator: ListWorkflowsPaginator = client.get_paginator("list_workflows")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_omics.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_omics import OmicsClient
from mypy_boto3_omics.waiter import (
    AnnotationImportJobCreatedWaiter,
    AnnotationStoreCreatedWaiter,
    AnnotationStoreDeletedWaiter,
    ReadSetActivationJobCompletedWaiter,
    ReadSetExportJobCompletedWaiter,
    ReadSetImportJobCompletedWaiter,
    ReferenceImportJobCompletedWaiter,
    RunCompletedWaiter,
    RunRunningWaiter,
    TaskCompletedWaiter,
    TaskRunningWaiter,
    VariantImportJobCreatedWaiter,
    VariantStoreCreatedWaiter,
    VariantStoreDeletedWaiter,
    WorkflowActiveWaiter,
)

client: OmicsClient = Session().client("omics")

# Explicit type annotations are optional here
# Types should be correctly discovered by mypy and IDEs
annotation_import_job_created_waiter: AnnotationImportJobCreatedWaiter = client.get_waiter(
    "annotation_import_job_created"
)
annotation_store_created_waiter: AnnotationStoreCreatedWaiter = client.get_waiter(
    "annotation_store_created"
)
annotation_store_deleted_waiter: AnnotationStoreDeletedWaiter = client.get_waiter(
    "annotation_store_deleted"
)
read_set_activation_job_completed_waiter: ReadSetActivationJobCompletedWaiter = client.get_waiter(
    "read_set_activation_job_completed"
)
read_set_export_job_completed_waiter: ReadSetExportJobCompletedWaiter = client.get_waiter(
    "read_set_export_job_completed"
)
read_set_import_job_completed_waiter: ReadSetImportJobCompletedWaiter = client.get_waiter(
    "read_set_import_job_completed"
)
reference_import_job_completed_waiter: ReferenceImportJobCompletedWaiter = client.get_waiter(
    "reference_import_job_completed"
)
run_completed_waiter: RunCompletedWaiter = client.get_waiter("run_completed")
run_running_waiter: RunRunningWaiter = client.get_waiter("run_running")
task_completed_waiter: TaskCompletedWaiter = client.get_waiter("task_completed")
task_running_waiter: TaskRunningWaiter = client.get_waiter("task_running")
variant_import_job_created_waiter: VariantImportJobCreatedWaiter = client.get_waiter(
    "variant_import_job_created"
)
variant_store_created_waiter: VariantStoreCreatedWaiter = client.get_waiter("variant_store_created")
variant_store_deleted_waiter: VariantStoreDeletedWaiter = client.get_waiter("variant_store_deleted")
workflow_active_waiter: WorkflowActiveWaiter = client.get_waiter("workflow_active")
```

<a id="literals"></a>

### Literals

`mypy_boto3_omics.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_omics.literals import (
    AcceleratorsType,
    AnnotationImportJobCreatedWaiterName,
    AnnotationStoreCreatedWaiterName,
    AnnotationStoreDeletedWaiterName,
    AnnotationTypeType,
    CreationTypeType,
    EncryptionTypeType,
    FileTypeType,
    FormatToHeaderKeyType,
    JobStatusType,
    ListAnnotationImportJobsPaginatorName,
    ListAnnotationStoresPaginatorName,
    ListMultipartReadSetUploadsPaginatorName,
    ListReadSetActivationJobsPaginatorName,
    ListReadSetExportJobsPaginatorName,
    ListReadSetImportJobsPaginatorName,
    ListReadSetUploadPartsPaginatorName,
    ListReadSetsPaginatorName,
    ListReferenceImportJobsPaginatorName,
    ListReferenceStoresPaginatorName,
    ListReferencesPaginatorName,
    ListRunGroupsPaginatorName,
    ListRunTasksPaginatorName,
    ListRunsPaginatorName,
    ListSequenceStoresPaginatorName,
    ListVariantImportJobsPaginatorName,
    ListVariantStoresPaginatorName,
    ListWorkflowsPaginatorName,
    ReadSetActivationJobCompletedWaiterName,
    ReadSetActivationJobItemStatusType,
    ReadSetActivationJobStatusType,
    ReadSetExportJobCompletedWaiterName,
    ReadSetExportJobItemStatusType,
    ReadSetExportJobStatusType,
    ReadSetFileType,
    ReadSetImportJobCompletedWaiterName,
    ReadSetImportJobItemStatusType,
    ReadSetImportJobStatusType,
    ReadSetPartSourceType,
    ReadSetStatusType,
    ReferenceFileType,
    ReferenceImportJobCompletedWaiterName,
    ReferenceImportJobItemStatusType,
    ReferenceImportJobStatusType,
    ReferenceStatusType,
    RunCompletedWaiterName,
    RunExportType,
    RunLogLevelType,
    RunRunningWaiterName,
    RunStatusType,
    SchemaValueTypeType,
    StoreFormatType,
    StoreStatusType,
    TaskCompletedWaiterName,
    TaskRunningWaiterName,
    TaskStatusType,
    VariantImportJobCreatedWaiterName,
    VariantStoreCreatedWaiterName,
    VariantStoreDeletedWaiterName,
    WorkflowActiveWaiterName,
    WorkflowEngineType,
    WorkflowExportType,
    WorkflowStatusType,
    WorkflowTypeType,
    OmicsServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    WaiterName,
    RegionName,
)


def check_value(value: AcceleratorsType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_omics.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_omics.type_defs import (
    AbortMultipartReadSetUploadRequestRequestTypeDef,
    ActivateReadSetFilterTypeDef,
    ActivateReadSetJobItemTypeDef,
    ActivateReadSetSourceItemTypeDef,
    AnnotationImportItemDetailTypeDef,
    AnnotationImportItemSourceTypeDef,
    AnnotationImportJobItemTypeDef,
    ReferenceItemTypeDef,
    SseConfigTypeDef,
    BatchDeleteReadSetRequestRequestTypeDef,
    ReadSetBatchErrorTypeDef,
    ResponseMetadataTypeDef,
    CancelAnnotationImportRequestRequestTypeDef,
    CancelRunRequestRequestTypeDef,
    CancelVariantImportRequestRequestTypeDef,
    CompleteReadSetUploadPartListItemTypeDef,
    CreateMultipartReadSetUploadRequestRequestTypeDef,
    CreateRunGroupRequestRequestTypeDef,
    WorkflowParameterTypeDef,
    DeleteAnnotationStoreRequestRequestTypeDef,
    DeleteReferenceRequestRequestTypeDef,
    DeleteReferenceStoreRequestRequestTypeDef,
    DeleteRunGroupRequestRequestTypeDef,
    DeleteRunRequestRequestTypeDef,
    DeleteSequenceStoreRequestRequestTypeDef,
    DeleteVariantStoreRequestRequestTypeDef,
    DeleteWorkflowRequestRequestTypeDef,
    ExportReadSetDetailTypeDef,
    ExportReadSetFilterTypeDef,
    ExportReadSetJobDetailTypeDef,
    ExportReadSetTypeDef,
    FileInformationTypeDef,
    VcfOptionsTypeDef,
    WaiterConfigTypeDef,
    GetAnnotationImportRequestRequestTypeDef,
    GetAnnotationStoreRequestRequestTypeDef,
    GetReadSetActivationJobRequestRequestTypeDef,
    GetReadSetExportJobRequestRequestTypeDef,
    GetReadSetImportJobRequestRequestTypeDef,
    GetReadSetMetadataRequestRequestTypeDef,
    SequenceInformationTypeDef,
    GetReadSetRequestRequestTypeDef,
    GetReferenceImportJobRequestRequestTypeDef,
    ImportReferenceSourceItemTypeDef,
    GetReferenceMetadataRequestRequestTypeDef,
    GetReferenceRequestRequestTypeDef,
    GetReferenceStoreRequestRequestTypeDef,
    GetRunGroupRequestRequestTypeDef,
    GetRunRequestRequestTypeDef,
    GetRunTaskRequestRequestTypeDef,
    GetSequenceStoreRequestRequestTypeDef,
    GetVariantImportRequestRequestTypeDef,
    VariantImportItemDetailTypeDef,
    GetVariantStoreRequestRequestTypeDef,
    GetWorkflowRequestRequestTypeDef,
    ImportReadSetFilterTypeDef,
    ImportReadSetJobItemTypeDef,
    SourceFilesTypeDef,
    ImportReferenceFilterTypeDef,
    ImportReferenceJobItemTypeDef,
    ListAnnotationImportJobsFilterTypeDef,
    PaginatorConfigTypeDef,
    ListAnnotationStoresFilterTypeDef,
    ListMultipartReadSetUploadsRequestRequestTypeDef,
    MultipartReadSetUploadListItemTypeDef,
    ReadSetUploadPartListFilterTypeDef,
    ReadSetUploadPartListItemTypeDef,
    ReadSetFilterTypeDef,
    ReferenceStoreFilterTypeDef,
    ReferenceFilterTypeDef,
    ReferenceListItemTypeDef,
    ListRunGroupsRequestRequestTypeDef,
    RunGroupListItemTypeDef,
    ListRunTasksRequestRequestTypeDef,
    TaskListItemTypeDef,
    ListRunsRequestRequestTypeDef,
    RunListItemTypeDef,
    SequenceStoreFilterTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListVariantImportJobsFilterTypeDef,
    VariantImportJobItemTypeDef,
    ListVariantStoresFilterTypeDef,
    ListWorkflowsRequestRequestTypeDef,
    WorkflowListItemTypeDef,
    ReadOptionsTypeDef,
    StartReadSetActivationJobSourceItemTypeDef,
    StartReferenceImportJobSourceItemTypeDef,
    StartRunRequestRequestTypeDef,
    VariantImportItemSourceTypeDef,
    TsvStoreOptionsOutputTypeDef,
    TsvStoreOptionsTypeDef,
    TagResourceRequestRequestTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAnnotationStoreRequestRequestTypeDef,
    UpdateRunGroupRequestRequestTypeDef,
    UpdateVariantStoreRequestRequestTypeDef,
    UpdateWorkflowRequestRequestTypeDef,
    UploadReadSetPartRequestRequestTypeDef,
    ListReadSetActivationJobsRequestRequestTypeDef,
    AnnotationStoreItemTypeDef,
    CreateReferenceStoreRequestRequestTypeDef,
    CreateSequenceStoreRequestRequestTypeDef,
    CreateVariantStoreRequestRequestTypeDef,
    ReferenceStoreDetailTypeDef,
    SequenceStoreDetailTypeDef,
    VariantStoreItemTypeDef,
    BatchDeleteReadSetResponseTypeDef,
    CompleteMultipartReadSetUploadResponseTypeDef,
    CreateMultipartReadSetUploadResponseTypeDef,
    CreateReferenceStoreResponseTypeDef,
    CreateRunGroupResponseTypeDef,
    CreateSequenceStoreResponseTypeDef,
    CreateVariantStoreResponseTypeDef,
    CreateWorkflowResponseTypeDef,
    DeleteAnnotationStoreResponseTypeDef,
    DeleteVariantStoreResponseTypeDef,
    EmptyResponseMetadataTypeDef,
    GetReadSetActivationJobResponseTypeDef,
    GetReadSetResponseTypeDef,
    GetReferenceResponseTypeDef,
    GetReferenceStoreResponseTypeDef,
    GetRunGroupResponseTypeDef,
    GetRunResponseTypeDef,
    GetRunTaskResponseTypeDef,
    GetSequenceStoreResponseTypeDef,
    GetVariantStoreResponseTypeDef,
    ListAnnotationImportJobsResponseTypeDef,
    ListReadSetActivationJobsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    StartAnnotationImportResponseTypeDef,
    StartReadSetActivationJobResponseTypeDef,
    StartReadSetExportJobResponseTypeDef,
    StartReadSetImportJobResponseTypeDef,
    StartReferenceImportJobResponseTypeDef,
    StartRunResponseTypeDef,
    StartVariantImportResponseTypeDef,
    UpdateVariantStoreResponseTypeDef,
    UploadReadSetPartResponseTypeDef,
    CompleteMultipartReadSetUploadRequestRequestTypeDef,
    CreateWorkflowRequestRequestTypeDef,
    GetWorkflowResponseTypeDef,
    GetReadSetExportJobResponseTypeDef,
    ListReadSetExportJobsRequestRequestTypeDef,
    ListReadSetExportJobsResponseTypeDef,
    StartReadSetExportJobRequestRequestTypeDef,
    ReadSetFilesTypeDef,
    ReferenceFilesTypeDef,
    GetAnnotationImportRequestAnnotationImportJobCreatedWaitTypeDef,
    GetAnnotationStoreRequestAnnotationStoreCreatedWaitTypeDef,
    GetAnnotationStoreRequestAnnotationStoreDeletedWaitTypeDef,
    GetReadSetActivationJobRequestReadSetActivationJobCompletedWaitTypeDef,
    GetReadSetExportJobRequestReadSetExportJobCompletedWaitTypeDef,
    GetReadSetImportJobRequestReadSetImportJobCompletedWaitTypeDef,
    GetReferenceImportJobRequestReferenceImportJobCompletedWaitTypeDef,
    GetRunRequestRunCompletedWaitTypeDef,
    GetRunRequestRunRunningWaitTypeDef,
    GetRunTaskRequestTaskCompletedWaitTypeDef,
    GetRunTaskRequestTaskRunningWaitTypeDef,
    GetVariantImportRequestVariantImportJobCreatedWaitTypeDef,
    GetVariantStoreRequestVariantStoreCreatedWaitTypeDef,
    GetVariantStoreRequestVariantStoreDeletedWaitTypeDef,
    GetWorkflowRequestWorkflowActiveWaitTypeDef,
    ReadSetListItemTypeDef,
    GetReferenceImportJobResponseTypeDef,
    GetVariantImportResponseTypeDef,
    ListReadSetImportJobsRequestRequestTypeDef,
    ListReadSetImportJobsResponseTypeDef,
    ImportReadSetSourceItemTypeDef,
    StartReadSetImportJobSourceItemTypeDef,
    ListReferenceImportJobsRequestRequestTypeDef,
    ListReferenceImportJobsResponseTypeDef,
    ListAnnotationImportJobsRequestRequestTypeDef,
    ListAnnotationImportJobsRequestListAnnotationImportJobsPaginateTypeDef,
    ListMultipartReadSetUploadsRequestListMultipartReadSetUploadsPaginateTypeDef,
    ListReadSetActivationJobsRequestListReadSetActivationJobsPaginateTypeDef,
    ListReadSetExportJobsRequestListReadSetExportJobsPaginateTypeDef,
    ListReadSetImportJobsRequestListReadSetImportJobsPaginateTypeDef,
    ListReferenceImportJobsRequestListReferenceImportJobsPaginateTypeDef,
    ListRunGroupsRequestListRunGroupsPaginateTypeDef,
    ListRunTasksRequestListRunTasksPaginateTypeDef,
    ListRunsRequestListRunsPaginateTypeDef,
    ListWorkflowsRequestListWorkflowsPaginateTypeDef,
    ListAnnotationStoresRequestListAnnotationStoresPaginateTypeDef,
    ListAnnotationStoresRequestRequestTypeDef,
    ListMultipartReadSetUploadsResponseTypeDef,
    ListReadSetUploadPartsRequestListReadSetUploadPartsPaginateTypeDef,
    ListReadSetUploadPartsRequestRequestTypeDef,
    ListReadSetUploadPartsResponseTypeDef,
    ListReadSetsRequestListReadSetsPaginateTypeDef,
    ListReadSetsRequestRequestTypeDef,
    ListReferenceStoresRequestListReferenceStoresPaginateTypeDef,
    ListReferenceStoresRequestRequestTypeDef,
    ListReferencesRequestListReferencesPaginateTypeDef,
    ListReferencesRequestRequestTypeDef,
    ListReferencesResponseTypeDef,
    ListRunGroupsResponseTypeDef,
    ListRunTasksResponseTypeDef,
    ListRunsResponseTypeDef,
    ListSequenceStoresRequestListSequenceStoresPaginateTypeDef,
    ListSequenceStoresRequestRequestTypeDef,
    ListVariantImportJobsRequestListVariantImportJobsPaginateTypeDef,
    ListVariantImportJobsRequestRequestTypeDef,
    ListVariantImportJobsResponseTypeDef,
    ListVariantStoresRequestListVariantStoresPaginateTypeDef,
    ListVariantStoresRequestRequestTypeDef,
    ListWorkflowsResponseTypeDef,
    TsvOptionsTypeDef,
    StartReadSetActivationJobRequestRequestTypeDef,
    StartReferenceImportJobRequestRequestTypeDef,
    StartVariantImportRequestRequestTypeDef,
    StoreOptionsOutputTypeDef,
    StoreOptionsTypeDef,
    ListAnnotationStoresResponseTypeDef,
    ListReferenceStoresResponseTypeDef,
    ListSequenceStoresResponseTypeDef,
    ListVariantStoresResponseTypeDef,
    GetReadSetMetadataResponseTypeDef,
    GetReferenceMetadataResponseTypeDef,
    ListReadSetsResponseTypeDef,
    GetReadSetImportJobResponseTypeDef,
    StartReadSetImportJobRequestRequestTypeDef,
    FormatOptionsTypeDef,
    CreateAnnotationStoreResponseTypeDef,
    GetAnnotationStoreResponseTypeDef,
    UpdateAnnotationStoreResponseTypeDef,
    CreateAnnotationStoreRequestRequestTypeDef,
    GetAnnotationImportResponseTypeDef,
    StartAnnotationImportRequestRequestTypeDef,
)


def get_structure() -> AbortMultipartReadSetUploadRequestRequestTypeDef:
    return {...}
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from `botocore` schemas.
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore`, `aiobotocore` and `aioboto3`
  libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.resource` calls
- Auto discovery of types for `session.client` and `session.resource` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-omics` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_omics/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
