# thousandeyes-sdk-endpoint-labels
Manage labels applied to endpoint agents using this API.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 7.0.36
- Generator version: 7.6.0
- Build package: com.thousandeyes.api.codegen.ThousandeyesPythonGenerator

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

Install directly via PyPi:

```sh
pip install thousandeyes-sdk-endpoint-labels
```
(you may need to run `pip` with root permission: `sudo pip install thousandeyes-sdk-endpoint-labels`)

Then import the package:
```python
import thousandeyes_sdk.endpoint_labels
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import thousandeyes_sdk.endpoint_labels
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the installation procedure and then run the following:

```python

import thousandeyes_sdk.core
import thousandeyes_sdk.endpoint_labels
from thousandeyes_sdk.core.exceptions import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.thousandeyes.com/v7
# See configuration.py for a list of all supported configuration parameters.
configuration = thousandeyes_sdk.core.Configuration(
    host = "https://api.thousandeyes.com/v7"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: BearerAuth
configuration = thousandeyes_sdk.core.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with thousandeyes_sdk.core.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = thousandeyes_sdk.endpoint_labels.EndpointAgentLabelsApi(api_client)
    aid = '1234' # str | A unique identifier associated with your account group. You can retrieve your `AccountGroupId` from the `/account-groups` endpoint. Note that you must be assigned to the target account group. Specifying this parameter without being assigned to the target account group will result in an error response. (optional)
    label_request = thousandeyes_sdk.endpoint_labels.LabelRequest() # LabelRequest | Label settings (optional)

    try:
        # Create label
        api_response = api_instance.create_endpoint_label(aid=aid, label_request=label_request)
        print("The response of EndpointAgentLabelsApi->create_endpoint_label:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling EndpointAgentLabelsApi->create_endpoint_label: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.thousandeyes.com/v7*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EndpointAgentLabelsApi* | [**create_endpoint_label**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/EndpointAgentLabelsApi.md#create_endpoint_label) | **POST** /endpoint/labels | Create label
*EndpointAgentLabelsApi* | [**delete_endpoint_label**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/EndpointAgentLabelsApi.md#delete_endpoint_label) | **DELETE** /endpoint/labels/{id} | Delete label
*EndpointAgentLabelsApi* | [**get_endpoint_label**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/EndpointAgentLabelsApi.md#get_endpoint_label) | **GET** /endpoint/labels/{id} | Retrieve label
*EndpointAgentLabelsApi* | [**get_endpoint_labels**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/EndpointAgentLabelsApi.md#get_endpoint_labels) | **GET** /endpoint/labels | List labels
*EndpointAgentLabelsApi* | [**update_endpoint_label**](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/EndpointAgentLabelsApi.md#update_endpoint_label) | **PATCH** /endpoint/labels/{id} | Update label


## Documentation For Models

 - [Error](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/Error.md)
 - [ExpandLabelOptions](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/ExpandLabelOptions.md)
 - [Filter](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/Filter.md)
 - [FilterType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/FilterType.md)
 - [Label](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/Label.md)
 - [LabelFilterMode](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/LabelFilterMode.md)
 - [LabelRequest](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/LabelRequest.md)
 - [LabelResponse](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/LabelResponse.md)
 - [Labels](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/Labels.md)
 - [Link](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/Link.md)
 - [MatchType](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/MatchType.md)
 - [PaginationNextAndSelfLink](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/PaginationNextAndSelfLink.md)
 - [SelfLinks](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/SelfLinks.md)
 - [UnauthorizedError](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/UnauthorizedError.md)
 - [ValidationError](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/ValidationError.md)
 - [ValidationErrorItem](https://github.com/thousandeyes/thousandeyes-sdk-python//tree/main/thousandeyes-sdk-endpoint-labels/docs/ValidationErrorItem.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication


## Author

<a href="mailto:api-team@thousandeyes.com">ThousandEyes API Team </a>


