import cv2
import os

# 视频文件路径
video_path = 'aaaa.mp4'

# 创建VideoCapture对象
cap = cv2.VideoCapture(video_path)

# 用于保存图片的文件夹
images_folder = './images/'

# 创建文件夹用于保存图片
if not os.path.exists(images_folder):
    os.makedirs(images_folder)

# 读取视频的每一帧
frame_id = 0
while True:
    # 读取下一帧
    ret, frame = cap.read()

    # 如果读取失败，退出循环
    if not ret:
        break

    # 保存图片
    image_path = images_folder + f'frame_{frame_id:04d}.png'
    cv2.imwrite(image_path, frame)
    print(f'Saved image: {image_path}')

    frame_id += 20

# 释放VideoCapture对象
cap.release()
