# 切换清华源
# 1、临时使用
# pip install -i https://pypi.tuna.tsinghua.edu.cn/simple some-package
# 2、永久更改pip源
# 升级 pip 到最新的版本 (>=10.0.0) 后进行配置：
# pip install pip -U
# python -m pip install --upgrade pip
# pip config set global.index-url https://pypi.tuna.tsinghua.edu.cn/simple
# 如果您到 pip 默认源的网络连接较差，临时使用镜像站来升级 pip：
# pip install -i https://pypi.tuna.tsinghua.edu.cn/simple pip -U
# 3、查看当前源列表
# pip config list
#
#
# 4 安装ultralytics
# pip3 freeze > requirements.txt
#
# 方式一：
#  pip install ultralytics -i  https://pypi.tuna.tsinghua.edu.cn/simple/
# 方式二：
# pip install -i https://pypi.tuna.tsinghua.edu.cn/simple --trusted-host pypi.tuna.tsinghua.edu.cn ultralytics
#
# pandas

import matplotlib
from ultralytics import YOLO
# Load a model
model = YOLO('yolov8.yaml')  # load a pretrained model (recommended for training)
# model = YOLO('yolov8s.pt')  # load a pretrained model (recommended for training)
if __name__ == '__main__':
    # model.train(data="NEU_train.yaml", epochs=10, imgsz=104, device=0, verbose=True, batch=2,optimizer='SGD')
    # result = model.train(data="train2017.yaml", epochs=5,  imgsz=224, device=0, workers=0, optimizer='SGD')
    # result = model.train(data="train2017.yaml", epochs=5, batch=10, imgsz=640, workers=0, optimizer='SGD')
    # result = model.train(data="../src/train2017.yaml", epochs=10, imgsz=224, device=0, verbose=True, workers=1)
    result = model.train(data="train2017.yaml", epochs=10, imgsz=224,  verbose=True, workers=1, optimizer='SGD')
    model.val()

    # 测试模型
    matplotlib.use( "TkAgg")
    #加载训练好的模型
    model = YOLO('models/best.pt')
    # 对验证集进行评估
    metrics = model.val(data = 'datasets/SteelData/data.yaml',show_boxes=False)

    # 检测任务 测试模型结果
    print(metrics.box.map)    # map50-95
    # 检测任务 0.4295214306631942
    print(metrics.box.map50)  # map50
    # 检测任务 0.7603770368473041
    print(metrics.box.map75)  # map75
    # 检测任务 .42599055499198585
    print(metrics.box.maps)
    # 分割任务
    print(metrics.seg.mr)

# Attributes:
# save_dir (Path): Path to the directory where the output plots should be saved. 应保存输出绘图的目录的路径。
# plot (bool): Whether to save the detection and segmentation plots.是否保存检测和分割图。
# on_plot (func): An optional callback to pass plots path and data when they are rendered.一个可选的回调，用于在渲染时传递绘图路径和数据。
# names(list):List of class names.类名列表。
# box (Metric): An instance of the Metric class to calculate box detection metrics.用于计算 box 检测指标的 Metric 类的实例。
# seg (Metric): An instance of the Metric class to calculate mask seqmentation metrics.Metric 类的实例，用于计算掩码 seqmentation 指标。
# speed (dict): Dictionary to store the time taken in different phases of inference.用于存储推理不同阶段所花费时间的字典

# Methods :
# ap50(): AP at IoU threshold of 0.5 for all classes. Returns: List of AP scores. shape: (nc,) or [].所有类的IoU阈值为0.5时的AP。返回：AP分数列表。形状：（NC，）或[]。
# ap(): AP at IoU thresholds from 0.5 to 0.95 for all classes. Returns: List of Ap scores. Shape: (nc,) or [lmp(): Mean precision of all classes. Returns: Float.所有类的IoU阈值从0.5到0.95的AP。返回：Ap分数列表。形状：（nc，） 或[lmp（）：所有类的平均精度。返回：浮动。
# mr(): Mean recall of all classes. Returns: Float.：所有类的平均召回率。返回：浮动。
# map50(): Mean AP at Iou threshold of 0.5 for all classes. Returns: Float.所有类的Iou阈值为0.5时的平均AP。返回：浮动。
# map75(): Mean AP at Iou threshold of 0.75 for all classes. Returns: Float.所有类的Iou阈值为0.75时的平均AP。返回：浮动。
# map(): Mean AP at Iou thresholds from 0.5 to 0.95 for all classes. Returns: Float.所有类的Iou阈值从0.5到0.95的平均AP。返回：浮动。
# mean_results(): Mean of results, returns mp, mr, map50, map.结果的平均值，返回mp、mr、map50、map。
# class_result(i): class-aware result, returns p[i], r[i], ap50[i], ap[i].类感知结果，返回p[i]、r[i]、ap50[i]、ap[i]
# maps(): mAP of each class. Returns: Array of mAP scores, shape: (nc,).每个类的mAP。 返回：mAP分数数组，shape：（nc，）。
# fitness(): Model fitness as a weighted combination of metrics. Returns: Float.将适应度建模为指标的加权组合。返回：浮动。
# update(results): Update metric attributes with new evaluation results.使用新的评估结果更新指标属性。

import pandas as pd
# with open("aa.csv",encoding="UTF-8") as f:
#     df = pd.read_csv(f, on_bad_lines="skip",sep=";")
#     print(df.head())
#     print(df.info())
#     print(df)

df = pd.read_csv("aa222.csv");
print(f"head: {df.head()}")
print(f"info: {df.info()}")

# 选择两列数据
columns = ['required_experience', 'employment_type']  # 假设你想要处理的列名分别是column1和column2
df[columns[0]] = df[columns[0]].fillna('Experience not available')  # 用'value'替换空值
df[columns[1]] = df[columns[1]].fillna('Employment not available')  # 用'value'替换空值

# 保存结果到新的CSV文件
# df.to_csv("result.csv", index=False)

# 获取所有信息
a = df.iloc()
#打印第一行，title数据的值
print(f"参数为：{a[0].title}")
print(f"参数为：{a}")


# 接下来，我们需要将文本数据转换成特征向量。
# 我们可以使用词袋模型（Bag of Words）或
# TF-IDF（Term Frequency-Inverse Document Frequency）来提取特征。
# 导入CountVectorizer
from sklearn.feature_extraction.text import CountVectorizer

# 实例化CountVectorizer
vectorizer = CountVectorizer()

# 将文本数据转换成特征向量
X = vectorizer.fit_transform(df['required_experience']).values.astype('U'))

# 查看特征向量的形状
X.shape

# 现在，我们可以选择一个机器学习模型来训练，比如逻辑回归模型。
# 导入逻辑回归模型
from sklearn.linear_model import LogisticRegression

# 实例化逻辑回归模型
model = LogisticRegression()

# 拟合模型
model.fit(X, df['title'])

# 最后，我们使用训练好的模型来对新闻进行真假预测。
# 准备测试数据
test_data = ['这是一条真实新闻', '这是一条假新闻']

# 将测试数据转换成特征向量
X_test = vectorizer.transform(test_data)

# 预测新闻的真假
predictions = model.predict(X_test)

# 打印预测结果
for news, pred in zip(test_data, predictions):
    print(f'新闻：{news}，预测结果：{"真实" if pred == 1 else "假新闻"}')