# Contributing

Please submit contributions by raising an issue and/or making a pull
request to the repository.

Please include updates to the documentation and tests to provide
full test coverage.

Here are some suggestions:

* CJK wide characters.
* A stand-alone helper function to add an index row to a cell grid.  It
  can go in a new file perhaps named addons.py.  It should accept
  cellgrid of type Iterable of Iterable and handle short rows.
* Additional format exception handlers.
* Additional format functions.  These can be added to plugin.py.
* New format directives should be general purpose
  and applicable to more than one application domain.  (Whatever that
  means).
* monotable should still run with no required PYPI dependencies.
* Handle ANSI escape terminal color sequences.  Please keep in mind colors
  should be preserved when a cell is:

  * max_cell_height limited.
  * text wrapped, truncated, or padded by the **width**, **fixed**,
    and **wrap** format options.
    
# Developing

Documentation is generated by Sphinx using doctest, autodoc,
napoleon, and sphinx_rtd_theme.  The docstrings in table.py consumed
by api_*.rst are Google Style docstrings as described by the
sphinx.ext.napoleon documentation.

Tests are executed by pytest.

Versioning complies with Semantic versioning described by
the Python Packaging User Guide.  Please see section
[Choosing a versioning scheme](
https://packaging.python.org/distributing/#choosing-a-versioning-scheme).

The test suite checks that all uses of the
version number are the same.  The developer can update the version number
in __init__.py and then let the test suite failures show the other usages.

The script readme_preview.py generates html from
the output of ``setup.py --long-description``.

Experimental static type checking and code conformance checks are performed
during Continuous Integration.  Errors raised by these tools will not
fail the build.  Please check the log files manually.
