# task

[![Build Status](http://drone.matteyeux.com/api/badges/matteyeux/task/status.svg)](http://drone.matteyeux.com/matteyeux/task)

Taskwarrior-like CLI tool

```
Usage: task [OPTIONS] COMMAND [ARGS]...

Options:
  -v, --version  print version
  --help         Show this message and exit.

Commands:
  add       Add task
  describe  Describe task.
  done      Finished task.
  ls        List tasks.
  rm        Remove a task.
```

### Installation

Make sure to have [poetry](https://pypi.org/project/poetry)

#### Github repository
```bash
$ git clone https://github.com/matteyeux/task
$ cd task
$ poetry install
```

#### PyPI
- Installation : `pip3 install task`
- Update : `pip3 install --upgrade task`

### Setup

Make sure to have `~/.local/bin` in your `$PATH` (`export PATH=$PATH:~/.local/bin`)

The first time you run `task add` command it will setup the SQLite3 database.


### Examples

#### Add
- Add task: `task add "Start TIC-BLK4" -p BLK4`
- Add task in project: `task add "Start TIC-BLK4" -p BLK4`

#### List
List tasks :
```
λ ~ » task ls
  ID  Project    Task                          Urgency  Due    Age
   1  etna_cli   fix my bug                          0         4 minutes
   2  etna_cli   add tabulate to list stuff          0         4 minutes
   3  Master2    Get that diploma                    0         3 minutes
   4             Buy a new iPhone                    0         2 minutes
   5             Patch the covid-19 bug              0         41 seconds
   6  BLK4       Start TIC-BLK4                      0         9 seconds
```

#### Done

Set task to done :
```
λ ~ » task done 6
Done 6
```

#### Remove

Delete row from database :
```
λ ~ » task rm 5
Done
```

### Credits
- Task Warrior :  because it's a pretty cool project
- me : cuz I wrote it
