"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PgStacApiLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_python_alpha_1 = require("@aws-cdk/aws-lambda-python-alpha");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_apigatewayv2_integrations_alpha_1 = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const constructs_1 = require("constructs");
class PgStacApiLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const apiCode = props.apiCode || {
            entry: `${__dirname}/runtime`,
            index: "src/handler.py",
            handler: "handler",
        };
        const handler = new aws_lambda_python_alpha_1.PythonFunction(this, "stac-api", {
            ...apiCode,
            /**
             * NOTE: Unable to use Py3.9, due to issues with hashes:
             *
             *    ERROR: Hashes are required in --require-hashes mode, but they are missing
             *    from some requirements. Here is a list of those requirements along with the
             *    hashes their downloaded archives actually had. Add lines like these to your
             *    requirements files to prevent tampering. (If you did not enable
             *    --require-hashes manually, note that it turns on automatically when any
             *    package has a hash.)
             *        anyio==3.6.1 --hash=sha256:cb29b9c70620506a9a8f87a309591713446953302d7d995344d0d7c6c0c9a7be
             * */
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            architecture: aws_cdk_lib_1.aws_lambda.Architecture.X86_64,
            environment: {
                PGSTAC_SECRET_ARN: props.dbSecret.secretArn,
                DB_MIN_CONN_SIZE: "0",
                DB_MAX_CONN_SIZE: "1",
                ...props.apiEnv,
            },
            vpc: props.vpc,
            vpcSubnets: props.subnetSelection,
            allowPublicSubnet: true,
            memorySize: 8192,
        });
        props.dbSecret.grantRead(handler);
        handler.connections.allowTo(props.db, aws_cdk_lib_1.aws_ec2.Port.tcp(5432));
        const stacApi = new aws_apigatewayv2_alpha_1.HttpApi(this, "api", {
            defaultIntegration: new aws_apigatewayv2_integrations_alpha_1.HttpLambdaIntegration("integration", handler),
        });
        new aws_cdk_lib_1.CfnOutput(this, "stac-api-output", {
            exportName: `${aws_cdk_lib_1.Stack.of(this).stackName}-url`,
            value: stacApi.url,
        });
    }
}
exports.PgStacApiLambda = PgStacApiLambda;
_a = JSII_RTTI_SYMBOL_1;
PgStacApiLambda[_a] = { fqn: "cdk-pgstac.PgStacApiLambda", version: "1.2.0" };
//# sourceMappingURL=data:application/json;base64,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