import { aws_ec2 as ec2, aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { PythonFunctionProps } from "@aws-cdk/aws-lambda-python-alpha";
import { Construct } from "constructs";
export declare class PgStacApiLambda extends Construct {
    constructor(scope: Construct, id: string, props: PgStacApiLambdaProps);
}
export interface PgStacApiLambdaProps {
    /**
     * VPC into which the lambda should be deployed.
     */
    readonly vpc: ec2.IVpc;
    /**
     * RDS Instance with installed pgSTAC.
     */
    readonly db: rds.IDatabaseInstance;
    /**
     * Subnet into which the lambda should be deployed.
     */
    readonly subnetSelection: ec2.SubnetSelection;
    /**
     * Secret containing connection information for pgSTAC database.
     */
    readonly dbSecret: secretsmanager.ISecret;
    /**
     * Custom code to run for fastapi-pgstac.
     *
     * @default - simplified version of fastapi-pgstac
     */
    readonly apiCode?: ApiEntrypoint;
    /**
     * Customized environment variables to send to fastapi-pgstac runtime.
     */
    readonly apiEnv?: Record<string, string>;
}
export interface ApiEntrypoint {
    /**
     * Path to the source of the function or the location for dependencies.
     */
    readonly entry: PythonFunctionProps["entry"];
    /**
     * The path (relative to entry) to the index file containing the exported handler.
     */
    readonly index: PythonFunctionProps["index"];
    /**
     * The name of the exported handler in the index file.
     */
    readonly handler: PythonFunctionProps["handler"];
}
