"""initial

Revision ID: 828190f8b707
Revises: 
Create Date: 2022-06-22 16:22:17.027700

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "828190f8b707"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "roles",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "users",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("email", sa.Text(), nullable=False),
        sa.Column("password", sa.Text(), nullable=False),
        sa.Column("active", sa.Boolean(), nullable=True),
        sa.Column("admin", sa.Boolean(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("email"),
    )
    op.create_table(
        "users_roles",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("role", sa.Integer(), nullable=True),
        sa.Column("user", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["role"],
            ["roles.id"],
            name="fk_users_roles_roles_role_id",
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["user"],
            ["users.id"],
            name="fk_users_roles_users_user_id",
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("users_roles")
    op.drop_table("users")
    op.drop_table("roles")
    # ### end Alembic commands ###
