/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;

public class StackMaker
implements PlugIn {
    private int rows;
    private int columns;
    private int border;

    @Override
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getStackSize() > 1) {
            IJ.error("This command requires a montage");
            return;
        }
        String options = Macro.getOptions();
        if (options != null) {
            options = options.replace("images_per_row=", "columns=");
            options = options.replace("images_per_column=", "rows=");
        }
        this.columns = this.info("xMontage", imp, 2);
        this.rows = this.info("yMontage", imp, 2);
        String montageHeight = (String)imp.getProperty("yMontage");
        if (montageHeight != null) {
            this.rows = Integer.parseInt(montageHeight);
        }
        GenericDialog gd = new GenericDialog("Stack Maker");
        gd.addNumericField("Columns: ", this.columns, 0);
        gd.addNumericField("Rows: ", this.rows, 0);
        gd.addNumericField("Border width: ", this.border, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.columns = (int)gd.getNextNumber();
        this.rows = (int)gd.getNextNumber();
        this.border = (int)gd.getNextNumber();
        if (this.rows == 0 || this.columns == 0) {
            return;
        }
        ImageStack stack = this.makeStack(imp.getProcessor(), this.rows, this.columns, this.border);
        new ImagePlus("Stack", stack).show();
    }

    private int info(String key, ImagePlus imp, int value) {
        String svalue = imp.getStringProperty(key);
        if (svalue != null) {
            value = Integer.parseInt(svalue);
        }
        return value;
    }

    public ImageStack makeStack(ImageProcessor ip, int rows, int columns, int border) {
        int stackSize = rows * columns;
        int width = ip.getWidth() / columns;
        int height = ip.getHeight() / rows;
        ImageStack stack = new ImageStack(width, height);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                ip.setRoi(x * width, y * height, width, height);
                stack.addSlice(null, ip.crop());
            }
        }
        if (border > 0) {
            int cropwidth = width - border - border / 2;
            int cropheight = height - border - border / 2;
            StackProcessor sp = new StackProcessor(stack, ip);
            stack = sp.crop(border, border, cropwidth, cropheight);
        }
        return stack;
    }
}

