"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const validation_1 = require("../validation");
// ARN format:
//  arn:aws:secretsmanager:<Region>:<AccountId>:secret:OptionalPath/SecretName-6RandomCharacters
test.each([
    // Start with a full valid arn, and then remove/change each part from left to right
    ['arn:aws:secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', true],
    ['arn:aws-cn:secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', true],
    ['arn:aws-us-gov:secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', true],
    [':aws:secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', false],
    ['a:aws:secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', false],
    ['arn::secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', false],
    ['arn:a:secretsmanager:us-west-1:1234567890:secret:SecretPath/SecretName', false],
    ['arn:aws::us-west-1:1234567890:secret:SecretPath/SecretName', false],
    ['arn:aws:aa:us-west-1:1234567890:secret:SecretPath/SecretName', false],
    ['arn:aws:secretsmanager::1234567890:secret:SecretPath/SecretName', true],
    ['arn:aws:secretsmanager:us-west-1::secret:SecretPath/SecretName', true],
    ['arn:aws:secretsmanager:us-west-1:1234567890::SecretPath/SecretName', false],
    ['arn:aws:secretsmanager:us-west-1:1234567890:sec:SecretPath/SecretName', false],
    ['arn:aws:secretsmanager:us-west-1:1234567890:secret:SecretName', true],
    ['arn:aws:secretsmanager:us-west-1:1234567890:secret:SecretPath/', true],
])('isArn(%s) -> %p', (value, expected) => {
    expect(validation_1.isArn(value)).toBe(expected);
});
//# sourceMappingURL=data:application/json;base64,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