/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { DynamoDB } from 'aws-sdk';
import { CompositeStringIndexTable } from '../dynamodb';
import { SimpleCustomResource } from './simple-resource';
export declare abstract class DynamoBackedCustomResource extends SimpleCustomResource {
    /**
     * The DynamoDB database should be initialized with CDK and passed in by name in the Lambda Function's environment.
     * Implementing classes can then utilize it as a CompositeStringIndexTable to get functionality intended to help
     * track the resources that get created, so they can be destroyed properly later.
     */
    private readonly tableName;
    private readonly dynamoDbClient;
    /**
     * The resource table uses the databaseName and the dynamoDbClient to fetch the DynamoDB table that backs it.
     * Ideally it would be readonly and initialized in the constructor, but it can't because the call is asynchronous.
     * Keeping it private and trying to limit its access through getResourceTable() is meant to help avoid mutation.
     */
    private resourceTable?;
    constructor(dynamoDbClient: DynamoDB);
    /**
     * This method is provided to do a quick permisions check on the database to make sure that all operations that are
     * performed by the CompositeStringIndexTable are available.
     */
    protected databasePermissionsCheck(database: CompositeStringIndexTable): Promise<void>;
    protected getResourceTable(): Promise<CompositeStringIndexTable>;
}
