"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = exports.ThinkboxEcrProviderResource = void 0;
const custom_resource_1 = require("../lib/custom-resource");
const ecr_provider_1 = require("../lib/ecr-provider");
/**
 * This custom resource will parse and return the base ECR ARN or URI containing Thinkbox published Docker Images.
 * A global ECR base URI is returned.
 */
class ThinkboxEcrProviderResource extends custom_resource_1.SimpleCustomResource {
    constructor() {
        super();
        this.ecrProvider = new ecr_provider_1.ThinkboxEcrProvider();
    }
    /**
     * @inheritdoc
     */
    validateInput(data) {
        return this.isEcrProviderResourceProperties(data);
    }
    /**
     * @inheritdoc
     */
    async doCreate(_physicalId, _resourceProperties) {
        const result = {
            EcrURIPrefix: await this.ecrProvider.getGlobalEcrBaseURI(),
        };
        console.log('result = ');
        console.log(JSON.stringify(result, null, 4));
        return result;
    }
    /**
     * @inheritdoc
     */
    /* istanbul ignore next */
    async doDelete(_physicalId, _resourceProperties) {
        // Nothing to do -- we don't modify anything.
        return;
    }
    isEcrProviderResourceProperties(value) {
        if (!value || typeof (value) !== 'object' || Array.isArray(value)) {
            return false;
        }
        function isOptionalString(val) {
            return val === undefined || typeof (val) == 'string';
        }
        return isOptionalString(value.ForceRun);
    }
}
exports.ThinkboxEcrProviderResource = ThinkboxEcrProviderResource;
/**
 * The handler used to provide the installer links for the requested version
 */
/* istanbul ignore next */
async function handler(event, context) {
    const ecrProvider = new ThinkboxEcrProviderResource();
    return await ecrProvider.handler(event, context);
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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