"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagementRegistrationStatus = exports.SecretsManagementRole = void 0;
/**
 * Deadline Secrets Management roles.
 *
 * See https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#assigned-roles
 */
var SecretsManagementRole;
(function (SecretsManagementRole) {
    /**
     * The administrator role is given to users that are created either by the Repository Installer when enabling the
     * Deadline Secrets Management feature for the first time, or by running the CreateNewAdmin command. Note: there can
     * be more than one Administrator user. All Administrators are equal and have full read and write access to all
     * secrets.
     */
    SecretsManagementRole["ADMINISTRATOR"] = "Administrator";
    /**
     * The Server role is intended to be granted to your machine(s) running the
     * [Remote Connection Server](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/remote-connection-server.html#remote-connection-server-ref-label)
     * application. The Server role is granted to a registered machine by an administrator in the
     * [Monitor UI](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#identity-management-assigning-ref-label).
     * In order to encrypt and decrypt secrets, the master key must be assigned to the Server by an Administrator user
     * running the [GrantKeyAccessToServer command](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#deadline-secrets-management-command-grantkeyaccesstoserver).
     * Servers can encrypt and decrypt all secrets, and are responsible for providing secrets to approved clients.
     */
    SecretsManagementRole["SERVER"] = "Server";
    /**
     * The Client role is typically intended to be granted to any of your machines running the
     * [Worker](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/worker.html#worker-ref-label)
     * application. The Client role is granted to a registered machine by an administrator in the
     * [Monitor UI](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#identity-management-assigning-ref-label).
     * Clients can request storage of secrets not in the
     * [Administrator Secret Access Level](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#deadline-secrets-management-secret-namespace-ref-label),
     * and can retrieve secrets from all namespaces when authenticating through the server.
     */
    SecretsManagementRole["CLIENT"] = "Client";
})(SecretsManagementRole = exports.SecretsManagementRole || (exports.SecretsManagementRole = {}));
;
/**
 * The different possible Deadline Secrets Management registration statuses that a Deadline Client's identity can be set
 * to.
 *
 * See https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#registration-status
 */
var SecretsManagementRegistrationStatus;
(function (SecretsManagementRegistrationStatus) {
    /**
     * This is the default status for an Identity that has just registered itself. It cannot access any secrets with this status.
     */
    SecretsManagementRegistrationStatus["PENDING"] = "Pending";
    /**
     * This status allows Identities to make use of the Secrets API, so long as they have the appropriate
     * [Identity Role](https://docs.thinkboxsoftware.com/products/deadline/10.1/1_User%20Manual/manual/secrets-management/deadline-secrets-management.html#identity-management-roles-ref-label).
     */
    SecretsManagementRegistrationStatus["REGISTERED"] = "Registered";
    /**
     * Identities with this status will not be allowed to make use of the Secrets API.
     */
    SecretsManagementRegistrationStatus["REVOKED"] = "Revoked";
})(SecretsManagementRegistrationStatus = exports.SecretsManagementRegistrationStatus || (exports.SecretsManagementRegistrationStatus = {}));
//# sourceMappingURL=data:application/json;base64,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