"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.tagConstruct = exports.RFDK_VERSION = exports.tagFields = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The name of the tag used to associate the RFDK version and construct that deploys a given resources.
 */
const TAG_NAME = 'aws-rfdk';
/**
 * Returns the fields to be used for tagging AWS resources for a given construct
 *
 * @param scope The construct instance whose underlying resources should be tagged
 */
function tagFields(scope) {
    const className = scope.constructor.name;
    return {
        name: TAG_NAME,
        value: `${exports.RFDK_VERSION}:${className}`,
    };
}
exports.tagFields = tagFields;
/**
 * Function that reads in the version of RFDK from the `package.json` file.
 */
function getVersion() {
    return require(path.join(__dirname, '..', '..', '..', 'package.json')).version; // eslint-disable-line @typescript-eslint/no-require-imports
}
/**
 * The RFDK version string as listed in `package.json`
 */
exports.RFDK_VERSION = getVersion();
/**
 * Tags all resources deployed by a construct with the RFDK version and the construct name separated by a colon (":")
 * delimiter.
 *
 * @param scope A construct instance to tag
 */
function tagConstruct(scope) {
    const fields = tagFields(scope);
    aws_cdk_lib_1.Tags.of(scope).add(fields.name, fields.value);
}
exports.tagConstruct = tagConstruct;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVudGltZS1pbmZvLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicnVudGltZS1pbmZvLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0dBR0c7OztBQUVILDZCQUE2QjtBQUU3Qiw2Q0FFcUI7QUFHckI7O0dBRUc7QUFDSCxNQUFNLFFBQVEsR0FBRyxVQUFVLENBQUM7QUFjNUI7Ozs7R0FJRztBQUNILFNBQWdCLFNBQVMsQ0FBc0IsS0FBUTtJQUNyRCxNQUFNLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQztJQUN6QyxPQUFPO1FBQ0wsSUFBSSxFQUFFLFFBQVE7UUFDZCxLQUFLLEVBQUUsR0FBRyxvQkFBWSxJQUFJLFNBQVMsRUFBRTtLQUN0QyxDQUFDO0FBQ0osQ0FBQztBQU5ELDhCQU1DO0FBRUQ7O0dBRUc7QUFDSCxTQUFTLFVBQVU7SUFDakIsT0FBTyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsY0FBYyxDQUFDLENBQUMsQ0FBQyxPQUFpQixDQUFDLENBQUMsNERBQTREO0FBQ3hKLENBQUM7QUFFRDs7R0FFRztBQUNVLFFBQUEsWUFBWSxHQUFHLFVBQVUsRUFBRSxDQUFDO0FBRXpDOzs7OztHQUtHO0FBQ0gsU0FBZ0IsWUFBWSxDQUFzQixLQUFRO0lBQ3hELE1BQU0sTUFBTSxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNoQyxrQkFBSSxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7QUFDaEQsQ0FBQztBQUhELG9DQUdDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcblxuaW1wb3J0IHtcbiAgVGFncyxcbn0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogVGhlIG5hbWUgb2YgdGhlIHRhZyB1c2VkIHRvIGFzc29jaWF0ZSB0aGUgUkZESyB2ZXJzaW9uIGFuZCBjb25zdHJ1Y3QgdGhhdCBkZXBsb3lzIGEgZ2l2ZW4gcmVzb3VyY2VzLlxuICovXG5jb25zdCBUQUdfTkFNRSA9ICdhd3MtcmZkayc7XG5cbmludGVyZmFjZSBUYWdGaWVsZHMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHRhZ1xuICAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgdmFsdWUgb2YgdGhlIHRhZ1xuICAgKi9cbiAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXR1cm5zIHRoZSBmaWVsZHMgdG8gYmUgdXNlZCBmb3IgdGFnZ2luZyBBV1MgcmVzb3VyY2VzIGZvciBhIGdpdmVuIGNvbnN0cnVjdFxuICpcbiAqIEBwYXJhbSBzY29wZSBUaGUgY29uc3RydWN0IGluc3RhbmNlIHdob3NlIHVuZGVybHlpbmcgcmVzb3VyY2VzIHNob3VsZCBiZSB0YWdnZWRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRhZ0ZpZWxkczxUIGV4dGVuZHMgQ29uc3RydWN0PihzY29wZTogVCk6IFRhZ0ZpZWxkcyB7XG4gIGNvbnN0IGNsYXNzTmFtZSA9IHNjb3BlLmNvbnN0cnVjdG9yLm5hbWU7XG4gIHJldHVybiB7XG4gICAgbmFtZTogVEFHX05BTUUsXG4gICAgdmFsdWU6IGAke1JGREtfVkVSU0lPTn06JHtjbGFzc05hbWV9YCxcbiAgfTtcbn1cblxuLyoqXG4gKiBGdW5jdGlvbiB0aGF0IHJlYWRzIGluIHRoZSB2ZXJzaW9uIG9mIFJGREsgZnJvbSB0aGUgYHBhY2thZ2UuanNvbmAgZmlsZS5cbiAqL1xuZnVuY3Rpb24gZ2V0VmVyc2lvbigpOiBzdHJpbmcge1xuICByZXR1cm4gcmVxdWlyZShwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4nLCAnLi4nLCAnLi4nLCAncGFja2FnZS5qc29uJykpLnZlcnNpb24gYXMgc3RyaW5nOyAvLyBlc2xpbnQtZGlzYWJsZS1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1yZXF1aXJlLWltcG9ydHNcbn1cblxuLyoqXG4gKiBUaGUgUkZESyB2ZXJzaW9uIHN0cmluZyBhcyBsaXN0ZWQgaW4gYHBhY2thZ2UuanNvbmBcbiAqL1xuZXhwb3J0IGNvbnN0IFJGREtfVkVSU0lPTiA9IGdldFZlcnNpb24oKTtcblxuLyoqXG4gKiBUYWdzIGFsbCByZXNvdXJjZXMgZGVwbG95ZWQgYnkgYSBjb25zdHJ1Y3Qgd2l0aCB0aGUgUkZESyB2ZXJzaW9uIGFuZCB0aGUgY29uc3RydWN0IG5hbWUgc2VwYXJhdGVkIGJ5IGEgY29sb24gKFwiOlwiKVxuICogZGVsaW1pdGVyLlxuICpcbiAqIEBwYXJhbSBzY29wZSBBIGNvbnN0cnVjdCBpbnN0YW5jZSB0byB0YWdcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRhZ0NvbnN0cnVjdDxUIGV4dGVuZHMgQ29uc3RydWN0PihzY29wZTogVCkge1xuICBjb25zdCBmaWVsZHMgPSB0YWdGaWVsZHMoc2NvcGUpO1xuICBUYWdzLm9mKHNjb3BlKS5hZGQoZmllbGRzLm5hbWUsIGZpZWxkcy52YWx1ZSk7XG59XG4iXX0=