import os
import subprocess
from .exceptions import LoggedError

TF_DIR = "tf"


class MissingTFDirectoryError(LoggedError):
    def __init__(self) -> None:
        message = (
            f"Can't find directory '{TF_DIR}'. Are you at the root of the project?"
        )
        super().__init__(message)


def ensure_tf_dir():
    if not os.path.exists(TF_DIR):
        raise MissingTFDirectoryError()


def init(workspace: str):
    cmd = ["terraform", "init"]
    subprocess.run(cmd, cwd=TF_DIR)
    cmd = ["terraform", "workspace", "select", workspace]
    subprocess.run(cmd, cwd="tf", check=True)


def plan(out: str):
    cmd = ["terraform", "plan", f"-out={out}"]
    subprocess.run(cmd, cwd=TF_DIR)


def apply(planfile: str):
    cmd = ["terraform", "apply", planfile]
    subprocess.run(cmd, cwd=TF_DIR)
