from .exceptions import LoggedError


class StorageObjectNotFoundError(LoggedError):
    def __init__(self, obj: str) -> None:
        super().__init__(f"Could not find storage object {obj}")


def upload(obj: str) -> None:
    pass


def download(obj: str) -> None:
    raise StorageObjectNotFoundError(obj)
