from . import storage, git


def upload(workspace: str, sha: str) -> None:
    obj = _get_obj_name(workspace, sha)
    storage.download(obj)


def download(workspace: str, sha: str) -> None:
    obj = _get_obj_name(workspace, sha)
    storage.download(obj)


def _get_obj_name(workspace: str, sha: str) -> str:
    repo = git.get_repo_name()
    return f"{repo}/plans/{workspace}/{sha}"
