**This is an autogenerated file**  
Please see [**the official README**](docs/README.md) for information on contributing, testing, installing, uploading to PyPi, as well as correctly formatted examples. 

# deep_lynx
The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import deep_lynx 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import deep_lynx
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import deep_lynx
from deep_lynx.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = deep_lynx.AuthenticationApi(deep_lynx.ApiClient(configuration))
body = deep_lynx.TokenExchangeRequest() # TokenExchangeRequest |  (optional)

try:
    # Exchange OAuth Token
    api_response = api_instance.exchange_o_auth_token(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->exchange_o_auth_token: %s\n" % e)


# create an instance of the API class
api_instance = deep_lynx.AuthenticationApi(deep_lynx.ApiClient(configuration))
x_api_key = 'x_api_key_example' # str | The API key
x_api_secret = 'x_api_secret_example' # str | The API secret
x_api_expiry = 'x_api_expiry_example' # str | The API expiry date (optional)

try:
    # Retrieve OAuth Token
    api_response = api_instance.retrieve_o_auth_token(x_api_key, x_api_secret, x_api_expiry=x_api_expiry)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->retrieve_o_auth_token: %s\n" % e)


# create an instance of the API class
api_instance = deep_lynx.AuthenticationApi(deep_lynx.ApiClient(configuration))
body = deep_lynx.RSACancelRequest() # RSACancelRequest |  (optional)

try:
    # RSA Cancel
    api_response = api_instance.rsa_cancel(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->rsa_cancel: %s\n" % e)


# create an instance of the API class
api_instance = deep_lynx.AuthenticationApi(deep_lynx.ApiClient(configuration))
body = deep_lynx.RSAInitRequest() # RSAInitRequest |  (optional)

try:
    # RSA Initialize
    api_response = api_instance.rsa_initialize(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->rsa_initialize: %s\n" % e)


# create an instance of the API class
api_instance = deep_lynx.AuthenticationApi(deep_lynx.ApiClient(configuration))
body = deep_lynx.RSAStatusRequest() # RSAStatusRequest |  (optional)

try:
    # RSA Status
    api_response = api_instance.rsa_status(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->rsa_status: %s\n" % e)


# create an instance of the API class
api_instance = deep_lynx.AuthenticationApi(deep_lynx.ApiClient(configuration))
body = deep_lynx.RSAVerifyRequest() # RSAVerifyRequest |  (optional)

try:
    # RSA Verify
    api_response = api_instance.rsa_verify(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationApi->rsa_verify: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8090*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**exchange_o_auth_token**](docs/AuthenticationApi.md#exchange_o_auth_token) | **POST** /oauth/exchange | Exchange OAuth Token
*AuthenticationApi* | [**retrieve_o_auth_token**](docs/AuthenticationApi.md#retrieve_o_auth_token) | **GET** /oauth/token | Retrieve OAuth Token
*AuthenticationApi* | [**rsa_cancel**](docs/AuthenticationApi.md#rsa_cancel) | **POST** /rsa/cancel | RSA Cancel
*AuthenticationApi* | [**rsa_initialize**](docs/AuthenticationApi.md#rsa_initialize) | **POST** /rsa/initialize | RSA Initialize
*AuthenticationApi* | [**rsa_status**](docs/AuthenticationApi.md#rsa_status) | **POST** /rsa/status | RSA Status
*AuthenticationApi* | [**rsa_verify**](docs/AuthenticationApi.md#rsa_verify) | **POST** /rsa/verify | RSA Verify
*ContainersApi* | [**archive_container**](docs/ContainersApi.md#archive_container) | **DELETE** /containers/{container_id} | Archive Container
*ContainersApi* | [**container_batch_update**](docs/ContainersApi.md#container_batch_update) | **PUT** /containers | Container Batch Update
*ContainersApi* | [**create_container**](docs/ContainersApi.md#create_container) | **POST** /containers | Create Container
*ContainersApi* | [**import_container**](docs/ContainersApi.md#import_container) | **POST** /containers/import | Import Container
*ContainersApi* | [**list_containers**](docs/ContainersApi.md#list_containers) | **GET** /containers | List Containers
*ContainersApi* | [**repair_container_permissions**](docs/ContainersApi.md#repair_container_permissions) | **POST** /containers/{container_id}/permissions | Repair Container Permissions
*ContainersApi* | [**retrieve_container**](docs/ContainersApi.md#retrieve_container) | **GET** /containers/{container_id} | Retrieve Container
*ContainersApi* | [**set_container_active**](docs/ContainersApi.md#set_container_active) | **POST** /containers/{container_id}/active | Set Container Active
*ContainersApi* | [**update_container**](docs/ContainersApi.md#update_container) | **PUT** /containers/{container_id} | Update Container
*ContainersApi* | [**update_container_import**](docs/ContainersApi.md#update_container_import) | **PUT** /containers/import/{container_id} | Update Container Import
*DataExportApi* | [**create_data_export**](docs/DataExportApi.md#create_data_export) | **POST** /containers/{container_id}/data/export | Create Data Export
*DataExportApi* | [**delete_data_export**](docs/DataExportApi.md#delete_data_export) | **DELETE** /containers/{container_id}/data/export/{export_id} | Delete Data Export
*DataExportApi* | [**list_data_exports**](docs/DataExportApi.md#list_data_exports) | **GET** /containers/{container_id}/data/export | List Data Exports
*DataExportApi* | [**retrieve_data_export**](docs/DataExportApi.md#retrieve_data_export) | **GET** /containers/{container_id}/data/export/{export_id} | Retrieve Data Export
*DataExportApi* | [**start_data_export**](docs/DataExportApi.md#start_data_export) | **POST** /containers/{container_id}/data/export/{export_id} | Start Data Export
*DataExportApi* | [**stop_data_export**](docs/DataExportApi.md#stop_data_export) | **PUT** /containers/{container_id}/data/export/{export_id} | Stop Data Export
*DataQueryApi* | [**query_graph**](docs/DataQueryApi.md#query_graph) | **POST** /containers/{container_id}/query | Query Graph
*DataSourcesApi* | [**archive_data_source**](docs/DataSourcesApi.md#archive_data_source) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id} | Archive Data Source
*DataSourcesApi* | [**create_data_source**](docs/DataSourcesApi.md#create_data_source) | **POST** /containers/{container_id}/import/datasources | Create Data Source
*DataSourcesApi* | [**create_manual_import**](docs/DataSourcesApi.md#create_manual_import) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/imports | Create Manual Import
*DataSourcesApi* | [**download_file**](docs/DataSourcesApi.md#download_file) | **GET** /containers/{container_id}/files/{file_id}/download | Download File
*DataSourcesApi* | [**list_data_sources**](docs/DataSourcesApi.md#list_data_sources) | **GET** /containers/{container_id}/import/datasources | List Data Sources
*DataSourcesApi* | [**list_imports_for_data_source**](docs/DataSourcesApi.md#list_imports_for_data_source) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/imports | List Imports for Data Source
*DataSourcesApi* | [**retrieve_data_source**](docs/DataSourcesApi.md#retrieve_data_source) | **GET** /containers/{container_id}/import/datasources/{data_source_id} | Retrieve Data Source
*DataSourcesApi* | [**retrieve_file**](docs/DataSourcesApi.md#retrieve_file) | **GET** /containers/{container_id}/files/{file_id} | Retrieve File
*DataSourcesApi* | [**set_data_source_active**](docs/DataSourcesApi.md#set_data_source_active) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/active | Set Data Source Active
*DataSourcesApi* | [**set_data_source_configuration**](docs/DataSourcesApi.md#set_data_source_configuration) | **PUT** /containers/{container_id}/import/datasources/{data_source_id} | Set Data Source Configuration
*DataSourcesApi* | [**set_data_source_inactive**](docs/DataSourcesApi.md#set_data_source_inactive) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id}/active | Set Data Source Inactive
*DataSourcesApi* | [**upload_file**](docs/DataSourcesApi.md#upload_file) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/files | Upload File
*DataTypeMappingsApi* | [**create_transformation**](docs/DataTypeMappingsApi.md#create_transformation) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations | Create Data Type Mapping&#x27;s Transformations
*DataTypeMappingsApi* | [**delete_data_type_mapping**](docs/DataTypeMappingsApi.md#delete_data_type_mapping) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id} | Delete Data Type Mapping
*DataTypeMappingsApi* | [**delete_transformation**](docs/DataTypeMappingsApi.md#delete_transformation) | **DELETE** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations/{transformation_id} | Delete Data Type Mapping&#x27;s Transformations
*DataTypeMappingsApi* | [**export_type_mappings**](docs/DataTypeMappingsApi.md#export_type_mappings) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/mappings/export | Export Type Mappings
*DataTypeMappingsApi* | [**import_data_type_mappings**](docs/DataTypeMappingsApi.md#import_data_type_mappings) | **POST** /containers/{container_id}/import/datasources/{data_source_id}/mappings/import | Import Data Type Mappings
*DataTypeMappingsApi* | [**list_data_type_mappings**](docs/DataTypeMappingsApi.md#list_data_type_mappings) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/mappings | List Data Type Mappings
*DataTypeMappingsApi* | [**list_transformations**](docs/DataTypeMappingsApi.md#list_transformations) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations | List Data Type Mapping&#x27;s Transformations
*DataTypeMappingsApi* | [**retrieve_data_type_mapping**](docs/DataTypeMappingsApi.md#retrieve_data_type_mapping) | **GET** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id} | Retrieve Data Type Mapping
*DataTypeMappingsApi* | [**update_data_type_mapping**](docs/DataTypeMappingsApi.md#update_data_type_mapping) | **PUT** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id} | Update Data Type Mapping
*DataTypeMappingsApi* | [**update_transformation**](docs/DataTypeMappingsApi.md#update_transformation) | **PUT** /containers/{container_id}/import/datasources/{data_source_id}/mappings/{mapping_id}/transformations/{transformation_id} | Update Data Type Mapping&#x27;s Transformations
*EventsApi* | [**create_event**](docs/EventsApi.md#create_event) | **POST** /events | Create Event
*EventsApi* | [**create_event_action**](docs/EventsApi.md#create_event_action) | **POST** /event_actions | Create Event Action
*EventsApi* | [**delete_event_action**](docs/EventsApi.md#delete_event_action) | **DELETE** /event_actions/{action_id} | Delete Event Action
*EventsApi* | [**list_event_action_statuses**](docs/EventsApi.md#list_event_action_statuses) | **GET** /event_action_status | List Event Action Statuses
*EventsApi* | [**list_event_actions**](docs/EventsApi.md#list_event_actions) | **GET** /event_actions | List Event Actions
*EventsApi* | [**list_events**](docs/EventsApi.md#list_events) | **GET** /events | List Events
*EventsApi* | [**retrieve_event**](docs/EventsApi.md#retrieve_event) | **GET** /events/{event_id} | Retrieve Event
*EventsApi* | [**retrieve_event_action**](docs/EventsApi.md#retrieve_event_action) | **GET** /event_actions/{action_id} | Retrieve Event Action
*EventsApi* | [**retrieve_event_action_status**](docs/EventsApi.md#retrieve_event_action_status) | **GET** /event_action_status/{status_id} | Retrieve Event Action Status
*EventsApi* | [**update_event_action**](docs/EventsApi.md#update_event_action) | **PUT** /event_actions/{action_id} | Update Event Action
*EventsApi* | [**update_event_action_status**](docs/EventsApi.md#update_event_action_status) | **PUT** /event_action_status/{status_id} | Update Event Action Status
*GraphApi* | [**archive_edge**](docs/GraphApi.md#archive_edge) | **DELETE** /containers/{container_id}/graphs/edges/{edge_id} | Archive Edge
*GraphApi* | [**archive_node**](docs/GraphApi.md#archive_node) | **DELETE** /containers/{container_id}/graphs/nodes/{node_id} | Archive Node
*GraphApi* | [**attach_edge_file**](docs/GraphApi.md#attach_edge_file) | **PUT** /containers/{container_id}/graphs/edges/{edge_id}/files/{file_id} | Attach Edge File
*GraphApi* | [**attach_node_file**](docs/GraphApi.md#attach_node_file) | **PUT** /containers/{container_id}/graphs/nodes/{node_id}/files/{file_id} | Attach Node File
*GraphApi* | [**create_or_update_edges**](docs/GraphApi.md#create_or_update_edges) | **POST** /containers/{container_id}/graphs/edges | Create or Update Edges
*GraphApi* | [**create_or_update_nodes**](docs/GraphApi.md#create_or_update_nodes) | **POST** /containers/{container_id}/graphs/nodes | Create Or Update Nodes
*GraphApi* | [**delete_node_file**](docs/GraphApi.md#delete_node_file) | **DELETE** /containers/{container_id}/graphs/nodes/{node_id}/files/{file_id} | Detach Node File
*GraphApi* | [**detach_node_file**](docs/GraphApi.md#detach_node_file) | **DELETE** /containers/{container_id}/graphs/edges/{edge_id}/files/{file_id} | Detach Node File
*GraphApi* | [**list_edge_files**](docs/GraphApi.md#list_edge_files) | **GET** /containers/{container_id}/graphs/edges/{edge_id}/files | List Edge Files
*GraphApi* | [**list_edges**](docs/GraphApi.md#list_edges) | **GET** /containers/{container_id}/graphs/edges | List Edges
*GraphApi* | [**list_node_files**](docs/GraphApi.md#list_node_files) | **GET** /containers/{container_id}/graphs/nodes/{node_id}/files | List Node Files
*GraphApi* | [**list_nodes**](docs/GraphApi.md#list_nodes) | **GET** /containers/{container_id}/graphs/nodes | List Nodes
*GraphApi* | [**list_nodes_by_metatype_id**](docs/GraphApi.md#list_nodes_by_metatype_id) | **GET** /containers/{container_id}/graphs/nodes/metatype/{metatype_id} | List Nodes By Metatype ID
*GraphApi* | [**retrieve_edge**](docs/GraphApi.md#retrieve_edge) | **GET** /containers/{container_id}/graphs/edges/{edge_id} | Retrieve Edge
*GraphApi* | [**retrieve_node**](docs/GraphApi.md#retrieve_node) | **GET** /containers/{container_id}/graphs/nodes/{node_id} | Retrieve Node
*ImportsApi* | [**add_data_to_import**](docs/ImportsApi.md#add_data_to_import) | **POST** /containers/{container_id}/datasources/{data_source_id}/imports/{import_id}/data | Add Data to Import
*ImportsApi* | [**create_import**](docs/ImportsApi.md#create_import) | **POST** /containers/{container_id}/datasources/{data_source_id}/imports | Create Import
*ImportsApi* | [**delete_import**](docs/ImportsApi.md#delete_import) | **DELETE** /containers/{container_id}/import/imports/{import_id} | Delete Import
*ImportsApi* | [**delete_import_data**](docs/ImportsApi.md#delete_import_data) | **DELETE** /containers/{container_id}/import/imports/{import_id}/data/{data_id} | Delete Import Data
*ImportsApi* | [**list_imports_data**](docs/ImportsApi.md#list_imports_data) | **GET** /containers/{container_id}/import/imports/{import_id}/data | List Import&#x27;s Data
*ImportsApi* | [**retrieve_import_data**](docs/ImportsApi.md#retrieve_import_data) | **GET** /containers/{container_id}/import/imports/{import_id}/data/{data_id} | Retrieve Import Data
*ImportsApi* | [**update_import_data**](docs/ImportsApi.md#update_import_data) | **PUT** /containers/{container_id}/import/imports/{import_id}/data/{data_id} | Update Import Data
*MetatypeKeysApi* | [**archive_metatype_key**](docs/MetatypeKeysApi.md#archive_metatype_key) | **DELETE** /containers/{container_id}/metatypes/{metatype_id}/keys/{key_id} | Archive Metatype Key
*MetatypeKeysApi* | [**create_metatype_key**](docs/MetatypeKeysApi.md#create_metatype_key) | **POST** /containers/{container_id}/metatypes/{metatype_id}/keys | Create Metatype Key
*MetatypeKeysApi* | [**list_metatypes_keys**](docs/MetatypeKeysApi.md#list_metatypes_keys) | **GET** /containers/{container_id}/metatypes/{metatype_id}/keys | List Metatype&#x27;s Keys
*MetatypeKeysApi* | [**retrieve_metatype_key**](docs/MetatypeKeysApi.md#retrieve_metatype_key) | **GET** /containers/{container_id}/metatypes/{metatype_id}/keys/{key_id} | Retrieve Metatype Key
*MetatypeKeysApi* | [**update_metatype_key**](docs/MetatypeKeysApi.md#update_metatype_key) | **PUT** /containers/{container_id}/metatypes/{metatype_id}/keys/{key_id} | Update Metatype Key
*MetatypeRelationshipKeysApi* | [**archive_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#archive_metatype_relationship_key) | **DELETE** /containers/{container_id}/metatype_relationships/{relationship_id}/keys/{key_id} | Archive Metatype Relationship Key
*MetatypeRelationshipKeysApi* | [**create_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#create_metatype_relationship_key) | **POST** /containers/{container_id}/metatype_relationships/{relationship_id}/keys | Create Metatype Relationship Key
*MetatypeRelationshipKeysApi* | [**list_metatype_relationship_keys**](docs/MetatypeRelationshipKeysApi.md#list_metatype_relationship_keys) | **GET** /containers/{container_id}/metatype_relationships/{relationship_id}/keys | List Metatype Relationship Keys
*MetatypeRelationshipKeysApi* | [**retrieve_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#retrieve_metatype_relationship_key) | **GET** /containers/{container_id}/metatype_relationships/{relationship_id}/keys/{key_id} | Retrieve Metatype Relationship Key
*MetatypeRelationshipKeysApi* | [**update_metatype_relationship_key**](docs/MetatypeRelationshipKeysApi.md#update_metatype_relationship_key) | **PUT** /containers/{container_id}/metatype_relationships/{relationship_id}/keys/{key_id} | Update Metaype Relationship Key
*MetatypeRelationshipPairsApi* | [**archive_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#archive_metatype_relationship_pair) | **DELETE** /containers/{container_id}/metatype_relationship_pairs/{pair_id} | Archive Metatype Relationship Pair
*MetatypeRelationshipPairsApi* | [**create_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#create_metatype_relationship_pair) | **POST** /containers/{container_id}/metatype_relationship_pairs | Create Metatype Relationship Pair
*MetatypeRelationshipPairsApi* | [**list_metatype_relationship_pairs**](docs/MetatypeRelationshipPairsApi.md#list_metatype_relationship_pairs) | **GET** /containers/{container_id}/metatype_relationship_pairs | List Metatype Relationship Pairs
*MetatypeRelationshipPairsApi* | [**retrieve_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#retrieve_metatype_relationship_pair) | **GET** /containers/{container_id}/metatype_relationship_pairs/{pair_id} | Retrieve Metatype Relationship Pair
*MetatypeRelationshipPairsApi* | [**update_metatype_relationship_pair**](docs/MetatypeRelationshipPairsApi.md#update_metatype_relationship_pair) | **PUT** /containers/{container_id}/metatype_relationship_pairs/{pair_id} | Update Metaype Relationship Pair
*MetatypeRelationshipsApi* | [**archive_metatype_relationship**](docs/MetatypeRelationshipsApi.md#archive_metatype_relationship) | **DELETE** /containers/{container_id}/metatype_relationships/{relationship_id} | Archive Metatype Relationship
*MetatypeRelationshipsApi* | [**create_metatype_relationship**](docs/MetatypeRelationshipsApi.md#create_metatype_relationship) | **POST** /containers/{container_id}/metatype_relationships | Create Metatype Relationship
*MetatypeRelationshipsApi* | [**list_metatype_relationships**](docs/MetatypeRelationshipsApi.md#list_metatype_relationships) | **GET** /containers/{container_id}/metatype_relationships | List Metatype Relationships
*MetatypeRelationshipsApi* | [**retrieve_metatype_relationship**](docs/MetatypeRelationshipsApi.md#retrieve_metatype_relationship) | **GET** /containers/{container_id}/metatype_relationships/{relationship_id} | Retrieve Metatype Relationship
*MetatypeRelationshipsApi* | [**update_metatype_relationship**](docs/MetatypeRelationshipsApi.md#update_metatype_relationship) | **PUT** /containers/{container_id}/metatype_relationships/{relationship_id} | Update Metatype Relationship
*MetatypesApi* | [**archive_metatype**](docs/MetatypesApi.md#archive_metatype) | **DELETE** /containers/{container_id}/metatypes/{metatype_id} | Archive Metatype
*MetatypesApi* | [**create_metatype**](docs/MetatypesApi.md#create_metatype) | **POST** /containers/{container_id}/metatypes | Create Metatype
*MetatypesApi* | [**list_metatypes**](docs/MetatypesApi.md#list_metatypes) | **GET** /containers/{container_id}/metatypes | List Metatypes
*MetatypesApi* | [**retrieve_metaype**](docs/MetatypesApi.md#retrieve_metaype) | **GET** /containers/{container_id}/metatypes/{metatype_id} | Retrieve Metatype
*MetatypesApi* | [**update_metatype**](docs/MetatypesApi.md#update_metatype) | **PUT** /containers/{container_id}/metatypes/{metatype_id} | Update Metatype
*MetatypesApi* | [**validate_metatype_properties**](docs/MetatypesApi.md#validate_metatype_properties) | **POST** /containers/{container_id}/metatypes/{metatype_id} | Validate Metatype Properties
*MiscApi* | [**health**](docs/MiscApi.md#health) | **GET** /health | Health
*TasksApi* | [**create_task**](docs/TasksApi.md#create_task) | **POST** /containers/{container_id}/task | Create Task
*TasksApi* | [**get_task**](docs/TasksApi.md#get_task) | **GET** /containers/{container_id}/task/{task_id} | Get Task
*TasksApi* | [**list_tasks**](docs/TasksApi.md#list_tasks) | **GET** /containers/{container_id}/task | List Tasks
*TasksApi* | [**update_task**](docs/TasksApi.md#update_task) | **PUT** /containers/{container_id}/task/{task_id} | Update Task
*UsersApi* | [**accept_container_invite**](docs/UsersApi.md#accept_container_invite) | **GET** /users/invite | Accept Container Invite
*UsersApi* | [**assign_user_role**](docs/UsersApi.md#assign_user_role) | **POST** /containers/{container_id}/users/roles | Assign User Role
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /users/{user_id} | Delete User
*UsersApi* | [**invite_user_to_container**](docs/UsersApi.md#invite_user_to_container) | **POST** /containers/{container_id}/users/invite | Invite User to Container
*UsersApi* | [**list_invited_users_for_container**](docs/UsersApi.md#list_invited_users_for_container) | **GET** /containers/{container_id}/users/invite | List Invited Users for Container
*UsersApi* | [**list_outstanding_invites**](docs/UsersApi.md#list_outstanding_invites) | **GET** /users/invites | List Outstanding Invites
*UsersApi* | [**list_user_permissions**](docs/UsersApi.md#list_user_permissions) | **GET** /users/permissions | List User Permissions
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /users | List Users
*UsersApi* | [**list_users_for_container**](docs/UsersApi.md#list_users_for_container) | **GET** /containers/{container_id}/users | List Users for Container
*UsersApi* | [**list_users_roles**](docs/UsersApi.md#list_users_roles) | **GET** /containers/{container_id}/users/{user_id}/roles | List User&#x27;s Roles
*UsersApi* | [**retrieve_user**](docs/UsersApi.md#retrieve_user) | **GET** /containers/{container_id}/users/{user_id} | Retrieve User
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /users/{user_id} | Update User

## Documentation For Models

 - [AddDataToImportResponse](docs/AddDataToImportResponse.md)
 - [AssignRoleRequest](docs/AssignRoleRequest.md)
 - [BatchContainerUpdateRequest](docs/BatchContainerUpdateRequest.md)
 - [BatchContainerUpdateRequestInner](docs/BatchContainerUpdateRequestInner.md)
 - [BatchUpdateContainerResponse](docs/BatchUpdateContainerResponse.md)
 - [Container](docs/Container.md)
 - [ContainerConfig](docs/ContainerConfig.md)
 - [ContainerImportRequest](docs/ContainerImportRequest.md)
 - [ContainerImportResponse](docs/ContainerImportResponse.md)
 - [ContainerImportUpdateResponse](docs/ContainerImportUpdateResponse.md)
 - [ContainerInvite](docs/ContainerInvite.md)
 - [CreateContainerRequest](docs/CreateContainerRequest.md)
 - [CreateContainerResponse](docs/CreateContainerResponse.md)
 - [CreateDataExportRequest](docs/CreateDataExportRequest.md)
 - [CreateDataSourceConfig](docs/CreateDataSourceConfig.md)
 - [CreateDataSourceRequest](docs/CreateDataSourceRequest.md)
 - [CreateDataSourcesResponse](docs/CreateDataSourcesResponse.md)
 - [CreateEventActionRequest](docs/CreateEventActionRequest.md)
 - [CreateEventActionResponse](docs/CreateEventActionResponse.md)
 - [CreateEventRequest](docs/CreateEventRequest.md)
 - [CreateEventResponse](docs/CreateEventResponse.md)
 - [CreateImportResponse](docs/CreateImportResponse.md)
 - [CreateManualImport](docs/CreateManualImport.md)
 - [CreateManualImportResponse](docs/CreateManualImportResponse.md)
 - [CreateMetatypeKeyRequest](docs/CreateMetatypeKeyRequest.md)
 - [CreateMetatypeKeysResponse](docs/CreateMetatypeKeysResponse.md)
 - [CreateMetatypeRelationshipKeyRequest](docs/CreateMetatypeRelationshipKeyRequest.md)
 - [CreateMetatypeRelationshipKeysResponse](docs/CreateMetatypeRelationshipKeysResponse.md)
 - [CreateMetatypeRelationshipPairRequest](docs/CreateMetatypeRelationshipPairRequest.md)
 - [CreateMetatypeRelationshipPairsResponse](docs/CreateMetatypeRelationshipPairsResponse.md)
 - [CreateMetatypeRelationshipRequest](docs/CreateMetatypeRelationshipRequest.md)
 - [CreateMetatypeRelationshipsResponse](docs/CreateMetatypeRelationshipsResponse.md)
 - [CreateMetatypeRequest](docs/CreateMetatypeRequest.md)
 - [CreateMetatypesResponse](docs/CreateMetatypesResponse.md)
 - [CreateOrUpdateEdgesRequest](docs/CreateOrUpdateEdgesRequest.md)
 - [CreateOrUpdateNodesRequest](docs/CreateOrUpdateNodesRequest.md)
 - [CreateTaskResponse](docs/CreateTaskResponse.md)
 - [CreateTransformationResponse](docs/CreateTransformationResponse.md)
 - [CreateTypeMappingTransformationsRequest](docs/CreateTypeMappingTransformationsRequest.md)
 - [DataExportConfig](docs/DataExportConfig.md)
 - [DataSource](docs/DataSource.md)
 - [DataSourceConfig](docs/DataSourceConfig.md)
 - [DataSourceIdFilesBody](docs/DataSourceIdFilesBody.md)
 - [DataSourceIdImportsBody](docs/DataSourceIdImportsBody.md)
 - [DataSourceImport](docs/DataSourceImport.md)
 - [DataStaging](docs/DataStaging.md)
 - [Edge](docs/Edge.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Event](docs/Event.md)
 - [EventAction](docs/EventAction.md)
 - [EventActionStatus](docs/EventActionStatus.md)
 - [Exporter](docs/Exporter.md)
 - [ExporterConfig](docs/ExporterConfig.md)
 - [FileInfo](docs/FileInfo.md)
 - [FileModel](docs/FileModel.md)
 - [Generic200Response](docs/Generic200Response.md)
 - [GetContainerResponse](docs/GetContainerResponse.md)
 - [GetDataExportResponse](docs/GetDataExportResponse.md)
 - [GetDataSourceResponse](docs/GetDataSourceResponse.md)
 - [GetDataTypeMappingResponse](docs/GetDataTypeMappingResponse.md)
 - [GetEdgeResponse](docs/GetEdgeResponse.md)
 - [GetEventActionResponse](docs/GetEventActionResponse.md)
 - [GetEventActionStatusResponse](docs/GetEventActionStatusResponse.md)
 - [GetEventResponse](docs/GetEventResponse.md)
 - [GetFileInfoResponse](docs/GetFileInfoResponse.md)
 - [GetImportDataResponse](docs/GetImportDataResponse.md)
 - [GetMetatypeKeyResponse](docs/GetMetatypeKeyResponse.md)
 - [GetMetatypeRelationshipKeyResponse](docs/GetMetatypeRelationshipKeyResponse.md)
 - [GetMetatypeRelationshipPairResponse](docs/GetMetatypeRelationshipPairResponse.md)
 - [GetMetatypeRelationshipResponse](docs/GetMetatypeRelationshipResponse.md)
 - [GetMetatypeResponse](docs/GetMetatypeResponse.md)
 - [GetNodeResponse](docs/GetNodeResponse.md)
 - [GetTaskResponse](docs/GetTaskResponse.md)
 - [GetUserResponse](docs/GetUserResponse.md)
 - [ImportDataTypeMappingResponse](docs/ImportDataTypeMappingResponse.md)
 - [ImportDataTypeMappingResponseInner](docs/ImportDataTypeMappingResponseInner.md)
 - [ImportIdDataBody](docs/ImportIdDataBody.md)
 - [ImportModel](docs/ImportModel.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [KeyValidation](docs/KeyValidation.md)
 - [ListContainerInvitesResponse](docs/ListContainerInvitesResponse.md)
 - [ListContainerResponse](docs/ListContainerResponse.md)
 - [ListDataExportsResponse](docs/ListDataExportsResponse.md)
 - [ListDataSourceImportsResponse](docs/ListDataSourceImportsResponse.md)
 - [ListDataSourcesResponse](docs/ListDataSourcesResponse.md)
 - [ListDataTypeMappingResponse](docs/ListDataTypeMappingResponse.md)
 - [ListEdgeFiles](docs/ListEdgeFiles.md)
 - [ListEdgesResponse](docs/ListEdgesResponse.md)
 - [ListEventActionResponse](docs/ListEventActionResponse.md)
 - [ListEventActionStatusResponse](docs/ListEventActionStatusResponse.md)
 - [ListEventsResponse](docs/ListEventsResponse.md)
 - [ListImportDataResponse](docs/ListImportDataResponse.md)
 - [ListMetatypeKeysResponse](docs/ListMetatypeKeysResponse.md)
 - [ListMetatypeRelationshipKeysResponse](docs/ListMetatypeRelationshipKeysResponse.md)
 - [ListMetatypeRelationshipPairsResponse](docs/ListMetatypeRelationshipPairsResponse.md)
 - [ListMetatypeRelationshipsResponse](docs/ListMetatypeRelationshipsResponse.md)
 - [ListMetatypesResponse](docs/ListMetatypesResponse.md)
 - [ListNodeFiles](docs/ListNodeFiles.md)
 - [ListNodesByMetatypeResponse](docs/ListNodesByMetatypeResponse.md)
 - [ListNodesResponse](docs/ListNodesResponse.md)
 - [ListTasksResponse](docs/ListTasksResponse.md)
 - [ListTransformationResponse](docs/ListTransformationResponse.md)
 - [ListUserInvitesResponse](docs/ListUserInvitesResponse.md)
 - [ListUserPermissionsResponse](docs/ListUserPermissionsResponse.md)
 - [ListUserRoles](docs/ListUserRoles.md)
 - [ListUsersForContainerResponse](docs/ListUsersForContainerResponse.md)
 - [ListUsersResponse](docs/ListUsersResponse.md)
 - [MappingsImportBody](docs/MappingsImportBody.md)
 - [Metatype](docs/Metatype.md)
 - [MetatypeKey](docs/MetatypeKey.md)
 - [MetatypeRelationship](docs/MetatypeRelationship.md)
 - [Node](docs/Node.md)
 - [NodeMetatypeBody](docs/NodeMetatypeBody.md)
 - [NotFound404](docs/NotFound404.md)
 - [OneOfUploadFileResponse](docs/OneOfUploadFileResponse.md)
 - [RSACancelRequest](docs/RSACancelRequest.md)
 - [RSAInitRequest](docs/RSAInitRequest.md)
 - [RSAResponse](docs/RSAResponse.md)
 - [RSAResponseValue](docs/RSAResponseValue.md)
 - [RSAResponseValueChallengeMethods](docs/RSAResponseValueChallengeMethods.md)
 - [RSAResponseValueChallengeMethodsChallenges](docs/RSAResponseValueChallengeMethodsChallenges.md)
 - [RSAResponseValueChallengeMethodsPrompt](docs/RSAResponseValueChallengeMethodsPrompt.md)
 - [RSAResponseValueChallengeMethodsRequiredMethods](docs/RSAResponseValueChallengeMethodsRequiredMethods.md)
 - [RSAResponseValueChallengeMethodsVersions](docs/RSAResponseValueChallengeMethodsVersions.md)
 - [RSAResponseValueContext](docs/RSAResponseValueContext.md)
 - [RSAResponseValueCredentialValidationResults](docs/RSAResponseValueCredentialValidationResults.md)
 - [RSAStatusRequest](docs/RSAStatusRequest.md)
 - [RSAStatusResponse](docs/RSAStatusResponse.md)
 - [RSAVerifyRequest](docs/RSAVerifyRequest.md)
 - [RelationshipKey](docs/RelationshipKey.md)
 - [RelationshipPair](docs/RelationshipPair.md)
 - [RelationshipPairDestinationMetatype](docs/RelationshipPairDestinationMetatype.md)
 - [Task](docs/Task.md)
 - [TaskConfig](docs/TaskConfig.md)
 - [TokenExchangeRequest](docs/TokenExchangeRequest.md)
 - [Transformation](docs/Transformation.md)
 - [TransformationCondition](docs/TransformationCondition.md)
 - [TransformationKey](docs/TransformationKey.md)
 - [TypeMapping](docs/TypeMapping.md)
 - [TypeMappingExportPayload](docs/TypeMappingExportPayload.md)
 - [UpdateContainerRequest](docs/UpdateContainerRequest.md)
 - [UpdateContainerRequestConfig](docs/UpdateContainerRequestConfig.md)
 - [UpdateContainerResponse](docs/UpdateContainerResponse.md)
 - [UpdateDataSourceResponse](docs/UpdateDataSourceResponse.md)
 - [UpdateDataTypeMappingResponse](docs/UpdateDataTypeMappingResponse.md)
 - [UpdateEventActionResponse](docs/UpdateEventActionResponse.md)
 - [UpdateEventActionStatusRequest](docs/UpdateEventActionStatusRequest.md)
 - [UpdateEventActionStatusResponse](docs/UpdateEventActionStatusResponse.md)
 - [UpdateImportDataResponse](docs/UpdateImportDataResponse.md)
 - [UpdateMetatypeKeyResponse](docs/UpdateMetatypeKeyResponse.md)
 - [UpdateMetatypeRelationshipKeyResponse](docs/UpdateMetatypeRelationshipKeyResponse.md)
 - [UpdateMetatypeRelationshipPairResponse](docs/UpdateMetatypeRelationshipPairResponse.md)
 - [UpdateMetatypeRelationshipRequest](docs/UpdateMetatypeRelationshipRequest.md)
 - [UpdateMetatypeRelationshipResponse](docs/UpdateMetatypeRelationshipResponse.md)
 - [UpdateMetatypeRequest](docs/UpdateMetatypeRequest.md)
 - [UpdateMetatypeResponse](docs/UpdateMetatypeResponse.md)
 - [UpdateTaskResponse](docs/UpdateTaskResponse.md)
 - [UpdateTransformationResponse](docs/UpdateTransformationResponse.md)
 - [UploadFileResponse](docs/UploadFileResponse.md)
 - [User](docs/User.md)
 - [UserKey](docs/UserKey.md)
 - [ValidateMetatypePropertiesResponse](docs/ValidateMetatypePropertiesResponse.md)

## Documentation For Authorization


## BearerAuth



## Author


