"""
    Copyright (C) <2010>  Autin L. TSRI
    
    This file git_upy/bitoperators.py is part of upy.

    upy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    upy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with upy.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
"""
# -*- coding: utf-8 -*-
"""
Created on Thur April 19 2012

@author: Johan Hake
"""

# testBit() returns a nonzero result, 2**offset, if the bit at 'offset' is one.


def testBit(int_type, offset):
    mask = 1 << offset
    return int_type & mask


# setBit() returns an integer with the bit at 'offset' set to 1.


def setBit(int_type, offset):
    mask = 1 << offset
    return int_type | mask


# clearBit() returns an integer with the bit at 'offset' cleared.


def clearBit(int_type, offset):
    mask = ~(1 << offset)
    return int_type & mask


# toggleBit() returns an integer with the bit at 'offset' inverted, 0 -> 1 and 1 -> 0.


def toggleBit(int_type, offset):
    mask = 1 << offset
    return int_type ^ mask
