# Generated by Django 2.0.9 on 2020-03-06 14:53

import ckeditor_uploader.fields
from django.db import migrations, models
import django.db.models.deletion

from articles import config


def get_operations():
    operations = [
        migrations.CreateModel(
            name='Article',
            fields=get_article_fields(),
            options={
                'verbose_name': 'Article',
                'verbose_name_plural': 'Articles',
                'ordering': ['-created'],
            },
        )
    ]

    if config.IS_ARTICLE_TYPE_ENABLED:
        operations += [
            migrations.CreateModel(
                name='ArticleType',
                fields=[
                    (
                    'id', models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID')
                    ),
                    ('name', models.CharField(
                        max_length=255,
                        unique=True,
                        verbose_name='Name')
                     ),
                    ('slug',
                     models.CharField(
                         db_index=True,
                         max_length=255,
                         unique=True,
                         verbose_name='Slug')
                     ),
                ],
                options={
                    'verbose_name': 'Article type',
                    'verbose_name_plural': 'Article types',
                },
            ),
            migrations.AddField(
                model_name='article',
                name='type',
                field=models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    related_name='articles',
                    to='articles.ArticleType',
                    verbose_name='Type'),
            ),
        ]

    if config.IS_ARTICLE_TAGS_ENABLED:
        operations += [
            migrations.CreateModel(
                name='ArticleTag',
                fields=[
                    (
                        'id', models.AutoField(
                            auto_created=True,
                            primary_key=True,
                            serialize=False,
                            verbose_name='ID')
                    ),
                    ('text', models.CharField(
                        max_length=255,
                        unique=True,
                        verbose_name='Text')
                    ),
                ],
                options={
                    'verbose_name': 'Article tag',
                    'verbose_name_plural': 'Article tags',
                },
            ),
            migrations.AddField(
                model_name='article',
                name='tags',
                field=models.ManyToManyField(
                blank=True,
                related_name='tags',
                to='articles.ArticleTag',
                verbose_name='Tags'),
            )
        ]

    return operations


def get_article_fields():

    fields = [
        (
            'id',
            models.AutoField(
                auto_created=True,
                primary_key=True,
                serialize=False,
                verbose_name='ID')
        ),
        (
            'title',
            models.CharField(
                max_length=255,
                verbose_name='Title')
        ),
        ('logo',
         models.ImageField(
             blank=True,
             null=True,
             upload_to='article_logos')
         ),
        ('description',
         models.CharField(
             max_length=255,
             verbose_name='Description')
         ),
        ('text',
         ckeditor_uploader.fields.RichTextUploadingField(
             max_length=50000,
             verbose_name='Text')
         ),
        ('created',
         models.DateTimeField(
             db_index=True,
             verbose_name='Created')
         ),
        ('author',
         models.CharField(
             blank=True,
             max_length=255,
             verbose_name='Author')
         ),
    ]

    if config.IS_ARTICLE_COMMENTS_ENABLED:
        fields += [
            (
                'is_comments_enabled',
                models.BooleanField(
                    default=True,
                    verbose_name='Is comments enabled')
            )
        ]

    return fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = get_operations()
