"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rds = void 0;
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
class Rds {
    static metrics(name) {
        let header = new aws_cloudwatch_1.TextWidget({
            width: 24,
            height: 1,
            markdown: `# ${name} - RDS`,
        });
        let metrics = [
            'CPUUtilization',
            'FreeableMemory',
            'FreeLocalStorage',
            'DatabaseConnections',
            'DiskQueueDepth',
            'NetworkReceiveThroughput',
            'NetworkTransmitThroughput',
        ];
        let graph = Array();
        graph.push(header);
        metrics.forEach(metric => {
            graph.push(Rds.metricGraph(metric, name));
        });
        return graph;
    }
    static metricGraph(metric, name) {
        let cloudwatchMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/RDS',
            metricName: metric,
            dimensions: {
                DBInstanceIdentifier: name,
            },
        });
        let graphWidget = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        graphWidget.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: `${metric} (expected)`,
            color: '#666666',
            usingMetrics: {
                m1: cloudwatchMetric,
            },
        }));
        graphWidget.addRightMetric(cloudwatchMetric);
        return graphWidget;
    }
}
exports.Rds = Rds;
//# sourceMappingURL=data:application/json;base64,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