"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_autoscaling_1 = require("@aws-cdk/aws-autoscaling");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const aws_elasticloadbalancingv2_1 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
const auto_scaling_1 = require("./auto-scaling");
const load_balancer_1 = require("./load-balancer");
const rds_1 = require("./rds");
const redis_1 = require("./redis");
/**
 * An AWS CloudWatch Dashboard.
 *
 * @stability stable
 * @example
 *
 * // create a dashboard for AutoScaling
 * new Dashboard(this, 'dashboard', {
 *    autoScalingName: 'my-auto-scaling',
 *    autoScalingMaxCapacity: 10
 * });
 */
class Dashboard extends core_1.Construct {
    /**
     * Creates a Dashboard based on the Halloumi best practices.
     *
     * @param scope the scope into which to import this dashboard.
     * @param id the logical ID of the returned dashboard construct.
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        let start = (props === null || props === void 0 ? void 0 : props.start) ? props.start : '-PT24H';
        let periodOverride = (props === null || props === void 0 ? void 0 : props.periodOverride) ? props.periodOverride : aws_cloudwatch_1.PeriodOverride.INHERIT;
        const dashboard = new aws_cloudwatch_1.Dashboard(this, id, {
            dashboardName: props === null || props === void 0 ? void 0 : props.dashboardName,
            start: start,
            end: props === null || props === void 0 ? void 0 : props.end,
            periodOverride: periodOverride,
            widgets: props === null || props === void 0 ? void 0 : props.widgets,
        });
        if (props === null || props === void 0 ? void 0 : props.loadBalancer) {
            for (let i = 0; i < props.loadBalancer.length; i++) {
                let loadBalancer = props.loadBalancer[i];
                let name;
                let full_name;
                if (loadBalancer instanceof aws_elasticloadbalancingv2_1.BaseLoadBalancer) {
                    name = loadBalancer.loadBalancerName;
                    full_name = loadBalancer.loadBalancerFullName;
                }
                if (loadBalancer instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
                    name = loadBalancer.attrLoadBalancerName;
                    full_name = loadBalancer.attrLoadBalancerFullName;
                }
                const lbWidgets = load_balancer_1.LoadBalancer.metrics(name, full_name);
                lbWidgets.forEach(widget => {
                    dashboard.addWidgets(widget);
                });
            }
        }
        if (props === null || props === void 0 ? void 0 : props.autoScaling) {
            for (let i = 0; i < props.autoScaling.length; i++) {
                let auto_scaling_group = props.autoScaling[i];
                let maxCapacity;
                let name = auto_scaling_group.autoScalingGroupName;
                if (auto_scaling_group instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
                    name = auto_scaling_group.ref;
                    maxCapacity = parseInt(auto_scaling_group.maxSize);
                    dashboard.node.addDependency(auto_scaling_group);
                }
                let autoScalingWidgets = auto_scaling_1.AutoScaling.metrics(name, maxCapacity);
                autoScalingWidgets.forEach(widget => {
                    dashboard.addWidgets(widget);
                });
            }
        }
        if (props === null || props === void 0 ? void 0 : props.elasticache) {
            for (let i = 0; i < props.elasticache.length; i++) {
                let elasticache = props.elasticache[i];
                let name = elasticache.ref;
                let numNodes = elasticache.numNodeGroups || 1;
                for (let node = 1; node <= numNodes; node++) {
                    let nodeId = name + '-' + node.toString().padStart(3, '0');
                    let elasticacheWidgets = redis_1.Redis.metrics(nodeId);
                    elasticacheWidgets.forEach(widget => {
                        dashboard.addWidgets(widget);
                    });
                }
            }
        }
        if (props === null || props === void 0 ? void 0 : props.rds) {
            for (let i = 0; i < props.rds.length; i++) {
                let rds_cluster = props.rds[i];
                let name = rds_cluster.ref;
                let rdsWidgets = rds_1.Rds.metrics(name);
                rdsWidgets.forEach(widget => {
                    dashboard.addWidgets(widget);
                });
            }
        }
    }
}
exports.Dashboard = Dashboard;
_a = JSII_RTTI_SYMBOL_1;
Dashboard[_a] = { fqn: "halloumi-cloudwatch-dashboard.Dashboard", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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