# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by `Samarkand Global <https://samarkand.global>`_ in partnership with `SF Express <https://www.sf- express.com/cn/sc/>`_, `eSinotrans <http://www.esinotrans.com/haitao.html>`_. Read the documentation online at `Nomad API Suite <https://api.samarkand.io/>`_ and Check out the detailed `changelog <https://gitlab.com/samarkand-nomad/nomad_readme/-/raw/master/history/nomad_pilot.md>`_. - Install for node with ``npm install nomad_pilot_cli`` - Install for python with ``pip install nomad-pilot-cli``  # noqa: E501

    The version of the OpenAPI document: 1.30.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_pilot_cli.api_client import ApiClient
from nomad_pilot_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class FreightForwardApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def query_freight_forward(self, carrier, status, page_no, page_size, **kwargs):  # noqa: E501
        """queryFreightForward  # noqa: E501

        Query a specfic waybill in Freight Forwarding.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_freight_forward(carrier, status, page_no, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: Carrier to ship with (required)
        :param str status: package status, 5 available options: UNPROCESSED, PACKED, PROCESSED, SHIPPED, CANCEL (required)
        :param int page_no: Page number, between 1 and 1000 (required)
        :param int page_size: Page size, options: [1, 10, 50, 100, 1000] (required)
        :param list[str] tracking_refs: String name of tracking reference by Express Company. One or more tracking references: [SF1026045099931, SF1025950147480]
        :param str created_range: the time range of package update, use ISO_8601 format here, e.g. 2020-07-10T13:00:00Z/2020-07-11T15:30:00Z
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponseGeneral
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_freight_forward_with_http_info(carrier, status, page_no, page_size, **kwargs)  # noqa: E501

    def query_freight_forward_with_http_info(self, carrier, status, page_no, page_size, **kwargs):  # noqa: E501
        """queryFreightForward  # noqa: E501

        Query a specfic waybill in Freight Forwarding.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_freight_forward_with_http_info(carrier, status, page_no, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: Carrier to ship with (required)
        :param str status: package status, 5 available options: UNPROCESSED, PACKED, PROCESSED, SHIPPED, CANCEL (required)
        :param int page_no: Page number, between 1 and 1000 (required)
        :param int page_size: Page size, options: [1, 10, 50, 100, 1000] (required)
        :param list[str] tracking_refs: String name of tracking reference by Express Company. One or more tracking references: [SF1026045099931, SF1025950147480]
        :param str created_range: the time range of package update, use ISO_8601 format here, e.g. 2020-07-10T13:00:00Z/2020-07-11T15:30:00Z
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponseGeneral, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'status', 'page_no', 'page_size', 'tracking_refs', 'created_range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_freight_forward" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `query_freight_forward`")  # noqa: E501
        # verify the required parameter 'status' is set
        if self.api_client.client_side_validation and ('status' not in local_var_params or  # noqa: E501
                                                        local_var_params['status'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `status` when calling `query_freight_forward`")  # noqa: E501
        # verify the required parameter 'page_no' is set
        if self.api_client.client_side_validation and ('page_no' not in local_var_params or  # noqa: E501
                                                        local_var_params['page_no'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `page_no` when calling `query_freight_forward`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if self.api_client.client_side_validation and ('page_size' not in local_var_params or  # noqa: E501
                                                        local_var_params['page_size'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `page_size` when calling `query_freight_forward`")  # noqa: E501

        if self.api_client.client_side_validation and 'page_no' in local_var_params and local_var_params['page_no'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_no` when calling `query_freight_forward`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_no' in local_var_params and local_var_params['page_no'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_no` when calling `query_freight_forward`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('tracking_refs' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tracking_refs']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tracking_refs` when calling `query_freight_forward`, number of items must be less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'page_no' in local_var_params and local_var_params['page_no'] is not None:  # noqa: E501
            query_params.append(('page_no', local_var_params['page_no']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501
        if 'tracking_refs' in local_var_params and local_var_params['tracking_refs'] is not None:  # noqa: E501
            query_params.append(('tracking_refs', local_var_params['tracking_refs']))  # noqa: E501
            collection_formats['tracking_refs'] = 'csv'  # noqa: E501
        if 'created_range' in local_var_params and local_var_params['created_range'] is not None:  # noqa: E501
            query_params.append(('created_range', local_var_params['created_range']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/freight-forward/{carrier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseGeneral',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
