# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['visualfailureanalysis', 'visualfailureanalysis.utils']

package_data = \
{'': ['*']}

install_requires = \
['Flask>=2.2.2,<3.0.0',
 'Pillow>=9.3.0,<10.0.0',
 'PyPDF2>=2.11.2,<3.0.0',
 'albumentations>=1.3.0,<2.0.0',
 'dash-bootstrap-components>=1.2.1,<2.0.0',
 'dash>=2.7.0,<3.0.0',
 'ipywidgets>=8.0.2,<9.0.0',
 'kaleido==0.2.1',
 'matplotlib>=3.6.2,<4.0.0',
 'numpy>=1.23.5,<2.0.0',
 'pandas>=1.5.2,<2.0.0',
 'plotly>=5.11.0,<6.0.0',
 'scikit-learn>=1.1.3,<2.0.0',
 'scipy>=1.9.3,<2.0.0',
 'torchvision>=0.14.0,<0.15.0']

setup_kwargs = {
    'name': 'visualfailureanalysis',
    'version': '0.1.1',
    'description': 'Toolkit to visualize the reasoning of image classification networks.',
    'long_description': '# Purpose\nThis toolkit is designed to analyse the underlying representation of a image classification network.  \n\n# Instructions\n\n1) Create a new fodler  \n2) Create a new virtual environment  \n3) Update your pip  \n4) Install the package (pip install  pip install visualfailureanalysis)  \n5) Setup your folder in the form "../experiemnt_group_name/experiment_name/test_results"  \n6) In this folder place your data as raw_outputs.npz  \n7)  Format: Outputs of the softmax in the first columns followed by the label as an integer and dataset integer index in the last column. Each row is one data point. If you only have one data set the index is always 0.  \n8) In this folder place your latent space as encoded_output.npz  \n9) Format: Outputs of the penultimate layer (e.g. inputs to the final layer) in the first columns and dataset index in the last. Each row is one data point.   \n10) In this folder place your data as attribution.csv\n11) attributions.csv needs to at least contain a column called "filepath" containing the absolute filepaths of your images. If you have multiple data sets attributions are renamed to "attributions0.csv","attributions1.csv",..  \n12) All three data files need the rows to be in the same order!  \n13) In python: from visualfailureanalysis import analyser  \n14) Initalize the main class: my_data_visulizer = analyser.Analyser(path=path,class2name=class2name,class2plot=class2plot,ls_testsets=ls_testsets,test_datasets=test_datasets)  \n15) path ="../experiemnt_group_name/experiment_name"  \n16) class2plot = dict({0:"myclassname0",...}) conatianing a mapping of integer classes to real names   \n17) ls_testsets = ["nameoftestset",...] a list with names of all testsets  \n18) class2plot and test_datasets are two lists with a subset of classes/ testset names for which to generate outputs. (output can be quite large)  \n19) run my_data_visulizer.setup() to link the create the lower dimensional representation needed  \n20) generate outputs and statistics with the respective class methods.  \n\n# Outputs\n\nGenerates outputs for representative images based on a k-means clustering of the latent space. Latennt space dimenstions are reduced to 50 by pca and 3 by T-SNE.   \nGenerates the most overconfident as well as underconfident images based on the softmax response (could be adjusted to other confidence score).\nThe app.py file can be run by "python3 app.py" and starts an interactive dash app that allows the user to explore the latent space of his neural network and the images linked to each data point. The data necessary to run the app can be generated by the package. After initalizing the main analyser simply run analyzer.prepaire_dash() and the correct data frame is written.\n',
    'author': 'Levin Kobelke',
    'author_email': 'levin-kobelke@t-online.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
