from abc import ABC, abstractmethod
from datetime import datetime


def email_date_converter(email_date):
    if email_date[-3:-2].isalpha():
        email_date = " ".join(email_date.split()[:-1])
    if email_date[:3].isalpha() and email_date[-3] != ":":
        return datetime.strptime(email_date, "%a, %d %b %Y %H:%M:%S %z")
    elif email_date[-3] == ":":
        return datetime.strptime(email_date, "%a, %d %b %Y %H:%M:%S")
    else:
        return datetime.strptime(email_date, "%d %b %Y %H:%M:%S %z")


class Message(ABC):
    def __init__(self, message_dict):
        self._message_dict = message_dict

    @abstractmethod
    def get_from(self):
        pass

    @abstractmethod
    def get_to(self):
        pass

    @abstractmethod
    def get_label_ids(self):
        pass

    @abstractmethod
    def get_subject(self):
        pass

    @abstractmethod
    def get_date(self):
        pass

    @abstractmethod
    def get_content(self):
        pass

    @abstractmethod
    def get_thread_id(self):
        pass

    @abstractmethod
    def get_email_id(self):
        pass

    def to_dict(self):
        return {
            "id": self.get_email_id(),
            "thread_id": self.get_thread_id(),
            "label_ids": self.get_label_ids(),
            "to": self.get_to(),
            "from": self.get_from(),
            "subject": self.get_subject(),
            "content": self.get_content(),
            "date": self.get_date(),
        }
