# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.mgmt.core import ARMPipelineClient
from msrest import Serializer, Deserializer

from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin
from ._configuration import NetworkManagementClientConfiguration
from ._operations_mixin import NetworkManagementClientOperationsMixin
class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class NetworkManagementClient(NetworkManagementClientOperationsMixin, MultiApiClientMixin, _SDKClient):
    """Network Client.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str api_version: API version to use if no profile is provided, or if
     missing in profile.
    :param str base_url: Service URL
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2020-11-01'
    _PROFILE_TAG = "azure.mgmt.network.NetworkManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'firewall_policy_rule_groups': '2020-04-01',
            'interface_endpoints': '2019-02-01',
            'p2_svpn_server_configurations': '2019-07-01',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        api_version=None,
        base_url=None,
        profile=KnownProfiles.default,
        **kwargs  # type: Any
    ):
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = NetworkManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(NetworkManagementClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2015-06-15: :mod:`v2015_06_15.models<azure.mgmt.network.v2015_06_15.models>`
           * 2016-09-01: :mod:`v2016_09_01.models<azure.mgmt.network.v2016_09_01.models>`
           * 2016-12-01: :mod:`v2016_12_01.models<azure.mgmt.network.v2016_12_01.models>`
           * 2017-03-01: :mod:`v2017_03_01.models<azure.mgmt.network.v2017_03_01.models>`
           * 2017-06-01: :mod:`v2017_06_01.models<azure.mgmt.network.v2017_06_01.models>`
           * 2017-08-01: :mod:`v2017_08_01.models<azure.mgmt.network.v2017_08_01.models>`
           * 2017-09-01: :mod:`v2017_09_01.models<azure.mgmt.network.v2017_09_01.models>`
           * 2017-10-01: :mod:`v2017_10_01.models<azure.mgmt.network.v2017_10_01.models>`
           * 2017-11-01: :mod:`v2017_11_01.models<azure.mgmt.network.v2017_11_01.models>`
           * 2018-01-01: :mod:`v2018_01_01.models<azure.mgmt.network.v2018_01_01.models>`
           * 2018-02-01: :mod:`v2018_02_01.models<azure.mgmt.network.v2018_02_01.models>`
           * 2018-04-01: :mod:`v2018_04_01.models<azure.mgmt.network.v2018_04_01.models>`
           * 2018-06-01: :mod:`v2018_06_01.models<azure.mgmt.network.v2018_06_01.models>`
           * 2018-07-01: :mod:`v2018_07_01.models<azure.mgmt.network.v2018_07_01.models>`
           * 2018-08-01: :mod:`v2018_08_01.models<azure.mgmt.network.v2018_08_01.models>`
           * 2018-10-01: :mod:`v2018_10_01.models<azure.mgmt.network.v2018_10_01.models>`
           * 2018-11-01: :mod:`v2018_11_01.models<azure.mgmt.network.v2018_11_01.models>`
           * 2018-12-01: :mod:`v2018_12_01.models<azure.mgmt.network.v2018_12_01.models>`
           * 2019-02-01: :mod:`v2019_02_01.models<azure.mgmt.network.v2019_02_01.models>`
           * 2019-04-01: :mod:`v2019_04_01.models<azure.mgmt.network.v2019_04_01.models>`
           * 2019-06-01: :mod:`v2019_06_01.models<azure.mgmt.network.v2019_06_01.models>`
           * 2019-07-01: :mod:`v2019_07_01.models<azure.mgmt.network.v2019_07_01.models>`
           * 2019-08-01: :mod:`v2019_08_01.models<azure.mgmt.network.v2019_08_01.models>`
           * 2019-09-01: :mod:`v2019_09_01.models<azure.mgmt.network.v2019_09_01.models>`
           * 2019-11-01: :mod:`v2019_11_01.models<azure.mgmt.network.v2019_11_01.models>`
           * 2019-12-01: :mod:`v2019_12_01.models<azure.mgmt.network.v2019_12_01.models>`
           * 2020-03-01: :mod:`v2020_03_01.models<azure.mgmt.network.v2020_03_01.models>`
           * 2020-04-01: :mod:`v2020_04_01.models<azure.mgmt.network.v2020_04_01.models>`
           * 2020-05-01: :mod:`v2020_05_01.models<azure.mgmt.network.v2020_05_01.models>`
           * 2020-06-01: :mod:`v2020_06_01.models<azure.mgmt.network.v2020_06_01.models>`
           * 2020-07-01: :mod:`v2020_07_01.models<azure.mgmt.network.v2020_07_01.models>`
           * 2020-08-01: :mod:`v2020_08_01.models<azure.mgmt.network.v2020_08_01.models>`
           * 2020-11-01: :mod:`v2020_11_01.models<azure.mgmt.network.v2020_11_01.models>`
        """
        if api_version == '2015-06-15':
            from .v2015_06_15 import models
            return models
        elif api_version == '2016-09-01':
            from .v2016_09_01 import models
            return models
        elif api_version == '2016-12-01':
            from .v2016_12_01 import models
            return models
        elif api_version == '2017-03-01':
            from .v2017_03_01 import models
            return models
        elif api_version == '2017-06-01':
            from .v2017_06_01 import models
            return models
        elif api_version == '2017-08-01':
            from .v2017_08_01 import models
            return models
        elif api_version == '2017-09-01':
            from .v2017_09_01 import models
            return models
        elif api_version == '2017-10-01':
            from .v2017_10_01 import models
            return models
        elif api_version == '2017-11-01':
            from .v2017_11_01 import models
            return models
        elif api_version == '2018-01-01':
            from .v2018_01_01 import models
            return models
        elif api_version == '2018-02-01':
            from .v2018_02_01 import models
            return models
        elif api_version == '2018-04-01':
            from .v2018_04_01 import models
            return models
        elif api_version == '2018-06-01':
            from .v2018_06_01 import models
            return models
        elif api_version == '2018-07-01':
            from .v2018_07_01 import models
            return models
        elif api_version == '2018-08-01':
            from .v2018_08_01 import models
            return models
        elif api_version == '2018-10-01':
            from .v2018_10_01 import models
            return models
        elif api_version == '2018-11-01':
            from .v2018_11_01 import models
            return models
        elif api_version == '2018-12-01':
            from .v2018_12_01 import models
            return models
        elif api_version == '2019-02-01':
            from .v2019_02_01 import models
            return models
        elif api_version == '2019-04-01':
            from .v2019_04_01 import models
            return models
        elif api_version == '2019-06-01':
            from .v2019_06_01 import models
            return models
        elif api_version == '2019-07-01':
            from .v2019_07_01 import models
            return models
        elif api_version == '2019-08-01':
            from .v2019_08_01 import models
            return models
        elif api_version == '2019-09-01':
            from .v2019_09_01 import models
            return models
        elif api_version == '2019-11-01':
            from .v2019_11_01 import models
            return models
        elif api_version == '2019-12-01':
            from .v2019_12_01 import models
            return models
        elif api_version == '2020-03-01':
            from .v2020_03_01 import models
            return models
        elif api_version == '2020-04-01':
            from .v2020_04_01 import models
            return models
        elif api_version == '2020-05-01':
            from .v2020_05_01 import models
            return models
        elif api_version == '2020-06-01':
            from .v2020_06_01 import models
            return models
        elif api_version == '2020-07-01':
            from .v2020_07_01 import models
            return models
        elif api_version == '2020-08-01':
            from .v2020_08_01 import models
            return models
        elif api_version == '2020-11-01':
            from .v2020_11_01 import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def application_gateway_private_endpoint_connections(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`ApplicationGatewayPrivateEndpointConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.ApplicationGatewayPrivateEndpointConnectionsOperations>`
           * 2020-06-01: :class:`ApplicationGatewayPrivateEndpointConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.ApplicationGatewayPrivateEndpointConnectionsOperations>`
           * 2020-07-01: :class:`ApplicationGatewayPrivateEndpointConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.ApplicationGatewayPrivateEndpointConnectionsOperations>`
           * 2020-08-01: :class:`ApplicationGatewayPrivateEndpointConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.ApplicationGatewayPrivateEndpointConnectionsOperations>`
           * 2020-11-01: :class:`ApplicationGatewayPrivateEndpointConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.ApplicationGatewayPrivateEndpointConnectionsOperations>`
        """
        api_version = self._get_api_version('application_gateway_private_endpoint_connections')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import ApplicationGatewayPrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ApplicationGatewayPrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ApplicationGatewayPrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ApplicationGatewayPrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ApplicationGatewayPrivateEndpointConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'application_gateway_private_endpoint_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def application_gateway_private_link_resources(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`ApplicationGatewayPrivateLinkResourcesOperations<azure.mgmt.network.v2020_05_01.operations.ApplicationGatewayPrivateLinkResourcesOperations>`
           * 2020-06-01: :class:`ApplicationGatewayPrivateLinkResourcesOperations<azure.mgmt.network.v2020_06_01.operations.ApplicationGatewayPrivateLinkResourcesOperations>`
           * 2020-07-01: :class:`ApplicationGatewayPrivateLinkResourcesOperations<azure.mgmt.network.v2020_07_01.operations.ApplicationGatewayPrivateLinkResourcesOperations>`
           * 2020-08-01: :class:`ApplicationGatewayPrivateLinkResourcesOperations<azure.mgmt.network.v2020_08_01.operations.ApplicationGatewayPrivateLinkResourcesOperations>`
           * 2020-11-01: :class:`ApplicationGatewayPrivateLinkResourcesOperations<azure.mgmt.network.v2020_11_01.operations.ApplicationGatewayPrivateLinkResourcesOperations>`
        """
        api_version = self._get_api_version('application_gateway_private_link_resources')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import ApplicationGatewayPrivateLinkResourcesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ApplicationGatewayPrivateLinkResourcesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ApplicationGatewayPrivateLinkResourcesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ApplicationGatewayPrivateLinkResourcesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ApplicationGatewayPrivateLinkResourcesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'application_gateway_private_link_resources'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def application_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.ApplicationGatewaysOperations>`
           * 2016-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.ApplicationGatewaysOperations>`
           * 2016-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.ApplicationGatewaysOperations>`
           * 2017-03-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.ApplicationGatewaysOperations>`
           * 2017-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.ApplicationGatewaysOperations>`
           * 2017-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.ApplicationGatewaysOperations>`
           * 2017-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_09_01.operations.ApplicationGatewaysOperations>`
           * 2017-10-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_10_01.operations.ApplicationGatewaysOperations>`
           * 2017-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_11_01.operations.ApplicationGatewaysOperations>`
           * 2018-01-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_01_01.operations.ApplicationGatewaysOperations>`
           * 2018-02-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_02_01.operations.ApplicationGatewaysOperations>`
           * 2018-04-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_04_01.operations.ApplicationGatewaysOperations>`
           * 2018-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_06_01.operations.ApplicationGatewaysOperations>`
           * 2018-07-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_07_01.operations.ApplicationGatewaysOperations>`
           * 2018-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_08_01.operations.ApplicationGatewaysOperations>`
           * 2018-10-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_10_01.operations.ApplicationGatewaysOperations>`
           * 2018-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_11_01.operations.ApplicationGatewaysOperations>`
           * 2018-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_12_01.operations.ApplicationGatewaysOperations>`
           * 2019-02-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.ApplicationGatewaysOperations>`
           * 2019-04-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.ApplicationGatewaysOperations>`
           * 2019-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.ApplicationGatewaysOperations>`
           * 2019-07-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.ApplicationGatewaysOperations>`
           * 2019-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.ApplicationGatewaysOperations>`
           * 2019-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.ApplicationGatewaysOperations>`
           * 2019-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.ApplicationGatewaysOperations>`
           * 2019-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.ApplicationGatewaysOperations>`
           * 2020-03-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.ApplicationGatewaysOperations>`
           * 2020-04-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.ApplicationGatewaysOperations>`
           * 2020-05-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.ApplicationGatewaysOperations>`
           * 2020-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.ApplicationGatewaysOperations>`
           * 2020-07-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.ApplicationGatewaysOperations>`
           * 2020-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.ApplicationGatewaysOperations>`
           * 2020-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.ApplicationGatewaysOperations>`
        """
        api_version = self._get_api_version('application_gateways')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ApplicationGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'application_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def application_security_groups(self):
        """Instance depends on the API version:

           * 2017-09-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_09_01.operations.ApplicationSecurityGroupsOperations>`
           * 2017-10-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_10_01.operations.ApplicationSecurityGroupsOperations>`
           * 2017-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_11_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-01-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_01_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-02-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_02_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-04-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_04_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-06-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_06_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-07-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_07_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-08-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_08_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-10-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_10_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_11_01.operations.ApplicationSecurityGroupsOperations>`
           * 2018-12-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_12_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-02-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_02_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-04-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_04_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-06-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_06_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-07-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_07_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-08-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_08_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-09-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_09_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_11_01.operations.ApplicationSecurityGroupsOperations>`
           * 2019-12-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_12_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-03-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_03_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-04-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_04_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-05-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_05_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-06-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_06_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-07-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_07_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-08-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_08_01.operations.ApplicationSecurityGroupsOperations>`
           * 2020-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_11_01.operations.ApplicationSecurityGroupsOperations>`
        """
        api_version = self._get_api_version('application_security_groups')
        if api_version == '2017-09-01':
            from .v2017_09_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'application_security_groups'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_delegations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_08_01.operations.AvailableDelegationsOperations>`
           * 2018-10-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_10_01.operations.AvailableDelegationsOperations>`
           * 2018-11-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_11_01.operations.AvailableDelegationsOperations>`
           * 2018-12-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_12_01.operations.AvailableDelegationsOperations>`
           * 2019-02-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_02_01.operations.AvailableDelegationsOperations>`
           * 2019-04-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_04_01.operations.AvailableDelegationsOperations>`
           * 2019-06-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_06_01.operations.AvailableDelegationsOperations>`
           * 2019-07-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_07_01.operations.AvailableDelegationsOperations>`
           * 2019-08-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_08_01.operations.AvailableDelegationsOperations>`
           * 2019-09-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_09_01.operations.AvailableDelegationsOperations>`
           * 2019-11-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_11_01.operations.AvailableDelegationsOperations>`
           * 2019-12-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_12_01.operations.AvailableDelegationsOperations>`
           * 2020-03-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_03_01.operations.AvailableDelegationsOperations>`
           * 2020-04-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_04_01.operations.AvailableDelegationsOperations>`
           * 2020-05-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_05_01.operations.AvailableDelegationsOperations>`
           * 2020-06-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_06_01.operations.AvailableDelegationsOperations>`
           * 2020-07-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_07_01.operations.AvailableDelegationsOperations>`
           * 2020-08-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_08_01.operations.AvailableDelegationsOperations>`
           * 2020-11-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_11_01.operations.AvailableDelegationsOperations>`
        """
        api_version = self._get_api_version('available_delegations')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AvailableDelegationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'available_delegations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_endpoint_services(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_06_01.operations.AvailableEndpointServicesOperations>`
           * 2017-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_08_01.operations.AvailableEndpointServicesOperations>`
           * 2017-09-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_09_01.operations.AvailableEndpointServicesOperations>`
           * 2017-10-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_10_01.operations.AvailableEndpointServicesOperations>`
           * 2017-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_11_01.operations.AvailableEndpointServicesOperations>`
           * 2018-01-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_01_01.operations.AvailableEndpointServicesOperations>`
           * 2018-02-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_02_01.operations.AvailableEndpointServicesOperations>`
           * 2018-04-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_04_01.operations.AvailableEndpointServicesOperations>`
           * 2018-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_06_01.operations.AvailableEndpointServicesOperations>`
           * 2018-07-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_07_01.operations.AvailableEndpointServicesOperations>`
           * 2018-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_08_01.operations.AvailableEndpointServicesOperations>`
           * 2018-10-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_10_01.operations.AvailableEndpointServicesOperations>`
           * 2018-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_11_01.operations.AvailableEndpointServicesOperations>`
           * 2018-12-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_12_01.operations.AvailableEndpointServicesOperations>`
           * 2019-02-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_02_01.operations.AvailableEndpointServicesOperations>`
           * 2019-04-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_04_01.operations.AvailableEndpointServicesOperations>`
           * 2019-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_06_01.operations.AvailableEndpointServicesOperations>`
           * 2019-07-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_07_01.operations.AvailableEndpointServicesOperations>`
           * 2019-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_08_01.operations.AvailableEndpointServicesOperations>`
           * 2019-09-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_09_01.operations.AvailableEndpointServicesOperations>`
           * 2019-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_11_01.operations.AvailableEndpointServicesOperations>`
           * 2019-12-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_12_01.operations.AvailableEndpointServicesOperations>`
           * 2020-03-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_03_01.operations.AvailableEndpointServicesOperations>`
           * 2020-04-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_04_01.operations.AvailableEndpointServicesOperations>`
           * 2020-05-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_05_01.operations.AvailableEndpointServicesOperations>`
           * 2020-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_06_01.operations.AvailableEndpointServicesOperations>`
           * 2020-07-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_07_01.operations.AvailableEndpointServicesOperations>`
           * 2020-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_08_01.operations.AvailableEndpointServicesOperations>`
           * 2020-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_11_01.operations.AvailableEndpointServicesOperations>`
        """
        api_version = self._get_api_version('available_endpoint_services')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AvailableEndpointServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'available_endpoint_services'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_private_endpoint_types(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_04_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2019-06-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_06_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2019-07-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_07_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2019-08-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_08_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2019-09-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_09_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2019-11-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_11_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2019-12-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_12_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-03-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_03_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-04-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_04_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-05-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_05_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-06-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_06_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-07-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_07_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-08-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_08_01.operations.AvailablePrivateEndpointTypesOperations>`
           * 2020-11-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_11_01.operations.AvailablePrivateEndpointTypesOperations>`
        """
        api_version = self._get_api_version('available_private_endpoint_types')
        if api_version == '2019-04-01':
            from .v2019_04_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AvailablePrivateEndpointTypesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'available_private_endpoint_types'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_resource_group_delegations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_08_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2018-10-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_10_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2018-11-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_11_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2018-12-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_12_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-02-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_02_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-04-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_04_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-06-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_06_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-07-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_07_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-08-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_08_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-09-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_09_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-11-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_11_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2019-12-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_12_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-03-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_03_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-04-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_04_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-05-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_05_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-06-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_06_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-07-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_07_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-08-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_08_01.operations.AvailableResourceGroupDelegationsOperations>`
           * 2020-11-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_11_01.operations.AvailableResourceGroupDelegationsOperations>`
        """
        api_version = self._get_api_version('available_resource_group_delegations')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AvailableResourceGroupDelegationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'available_resource_group_delegations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_service_aliases(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_08_01.operations.AvailableServiceAliasesOperations>`
           * 2019-09-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_09_01.operations.AvailableServiceAliasesOperations>`
           * 2019-11-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_11_01.operations.AvailableServiceAliasesOperations>`
           * 2019-12-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_12_01.operations.AvailableServiceAliasesOperations>`
           * 2020-03-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_03_01.operations.AvailableServiceAliasesOperations>`
           * 2020-04-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_04_01.operations.AvailableServiceAliasesOperations>`
           * 2020-05-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_05_01.operations.AvailableServiceAliasesOperations>`
           * 2020-06-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_06_01.operations.AvailableServiceAliasesOperations>`
           * 2020-07-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_07_01.operations.AvailableServiceAliasesOperations>`
           * 2020-08-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_08_01.operations.AvailableServiceAliasesOperations>`
           * 2020-11-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_11_01.operations.AvailableServiceAliasesOperations>`
        """
        api_version = self._get_api_version('available_service_aliases')
        if api_version == '2019-08-01':
            from .v2019_08_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AvailableServiceAliasesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'available_service_aliases'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def azure_firewall_fqdn_tags(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_08_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2018-10-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_10_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2018-11-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_11_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2018-12-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_12_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-02-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_02_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-04-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_04_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-06-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_06_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-07-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_07_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-08-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_08_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-09-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_09_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-11-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_11_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2019-12-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_12_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-03-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_03_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-04-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_04_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-05-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_05_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-06-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_06_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-07-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_07_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-08-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_08_01.operations.AzureFirewallFqdnTagsOperations>`
           * 2020-11-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_11_01.operations.AzureFirewallFqdnTagsOperations>`
        """
        api_version = self._get_api_version('azure_firewall_fqdn_tags')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AzureFirewallFqdnTagsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'azure_firewall_fqdn_tags'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def azure_firewalls(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_04_01.operations.AzureFirewallsOperations>`
           * 2018-06-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_06_01.operations.AzureFirewallsOperations>`
           * 2018-07-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_07_01.operations.AzureFirewallsOperations>`
           * 2018-08-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_08_01.operations.AzureFirewallsOperations>`
           * 2018-10-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_10_01.operations.AzureFirewallsOperations>`
           * 2018-11-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_11_01.operations.AzureFirewallsOperations>`
           * 2018-12-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_12_01.operations.AzureFirewallsOperations>`
           * 2019-02-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_02_01.operations.AzureFirewallsOperations>`
           * 2019-04-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_04_01.operations.AzureFirewallsOperations>`
           * 2019-06-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_06_01.operations.AzureFirewallsOperations>`
           * 2019-07-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_07_01.operations.AzureFirewallsOperations>`
           * 2019-08-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_08_01.operations.AzureFirewallsOperations>`
           * 2019-09-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_09_01.operations.AzureFirewallsOperations>`
           * 2019-11-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_11_01.operations.AzureFirewallsOperations>`
           * 2019-12-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_12_01.operations.AzureFirewallsOperations>`
           * 2020-03-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_03_01.operations.AzureFirewallsOperations>`
           * 2020-04-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_04_01.operations.AzureFirewallsOperations>`
           * 2020-05-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_05_01.operations.AzureFirewallsOperations>`
           * 2020-06-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_06_01.operations.AzureFirewallsOperations>`
           * 2020-07-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_07_01.operations.AzureFirewallsOperations>`
           * 2020-08-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_08_01.operations.AzureFirewallsOperations>`
           * 2020-11-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_11_01.operations.AzureFirewallsOperations>`
        """
        api_version = self._get_api_version('azure_firewalls')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import AzureFirewallsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'azure_firewalls'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def bastion_hosts(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_04_01.operations.BastionHostsOperations>`
           * 2019-06-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_06_01.operations.BastionHostsOperations>`
           * 2019-07-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_07_01.operations.BastionHostsOperations>`
           * 2019-08-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_08_01.operations.BastionHostsOperations>`
           * 2019-09-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_09_01.operations.BastionHostsOperations>`
           * 2019-11-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_11_01.operations.BastionHostsOperations>`
           * 2019-12-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_12_01.operations.BastionHostsOperations>`
           * 2020-03-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_03_01.operations.BastionHostsOperations>`
           * 2020-04-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_04_01.operations.BastionHostsOperations>`
           * 2020-05-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_05_01.operations.BastionHostsOperations>`
           * 2020-06-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_06_01.operations.BastionHostsOperations>`
           * 2020-07-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_07_01.operations.BastionHostsOperations>`
           * 2020-08-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_08_01.operations.BastionHostsOperations>`
           * 2020-11-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_11_01.operations.BastionHostsOperations>`
        """
        api_version = self._get_api_version('bastion_hosts')
        if api_version == '2019-04-01':
            from .v2019_04_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import BastionHostsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import BastionHostsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'bastion_hosts'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def bgp_service_communities(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2016_12_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-03-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_03_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_06_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_08_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-09-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_09_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-10-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_10_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_11_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-01-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_01_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-02-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_02_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-04-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_04_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_06_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-07-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_07_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_08_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-10-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_10_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_11_01.operations.BgpServiceCommunitiesOperations>`
           * 2018-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_12_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-02-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_02_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-04-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_04_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_06_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-07-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_07_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_08_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-09-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_09_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_11_01.operations.BgpServiceCommunitiesOperations>`
           * 2019-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_12_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-03-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_03_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-04-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_04_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-05-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_05_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_06_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-07-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_07_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_08_01.operations.BgpServiceCommunitiesOperations>`
           * 2020-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_11_01.operations.BgpServiceCommunitiesOperations>`
        """
        api_version = self._get_api_version('bgp_service_communities')
        if api_version == '2016-12-01':
            from .v2016_12_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import BgpServiceCommunitiesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'bgp_service_communities'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def connection_monitors(self):
        """Instance depends on the API version:

           * 2017-10-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2017_10_01.operations.ConnectionMonitorsOperations>`
           * 2017-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2017_11_01.operations.ConnectionMonitorsOperations>`
           * 2018-01-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_01_01.operations.ConnectionMonitorsOperations>`
           * 2018-02-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_02_01.operations.ConnectionMonitorsOperations>`
           * 2018-04-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_04_01.operations.ConnectionMonitorsOperations>`
           * 2018-06-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_06_01.operations.ConnectionMonitorsOperations>`
           * 2018-07-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_07_01.operations.ConnectionMonitorsOperations>`
           * 2018-08-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_08_01.operations.ConnectionMonitorsOperations>`
           * 2018-10-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_10_01.operations.ConnectionMonitorsOperations>`
           * 2018-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_11_01.operations.ConnectionMonitorsOperations>`
           * 2018-12-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_12_01.operations.ConnectionMonitorsOperations>`
           * 2019-02-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_02_01.operations.ConnectionMonitorsOperations>`
           * 2019-04-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_04_01.operations.ConnectionMonitorsOperations>`
           * 2019-06-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_06_01.operations.ConnectionMonitorsOperations>`
           * 2019-07-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_07_01.operations.ConnectionMonitorsOperations>`
           * 2019-08-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_08_01.operations.ConnectionMonitorsOperations>`
           * 2019-09-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_09_01.operations.ConnectionMonitorsOperations>`
           * 2019-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_11_01.operations.ConnectionMonitorsOperations>`
           * 2019-12-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_12_01.operations.ConnectionMonitorsOperations>`
           * 2020-03-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_03_01.operations.ConnectionMonitorsOperations>`
           * 2020-04-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_04_01.operations.ConnectionMonitorsOperations>`
           * 2020-05-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_05_01.operations.ConnectionMonitorsOperations>`
           * 2020-06-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_06_01.operations.ConnectionMonitorsOperations>`
           * 2020-07-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_07_01.operations.ConnectionMonitorsOperations>`
           * 2020-08-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_08_01.operations.ConnectionMonitorsOperations>`
           * 2020-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_11_01.operations.ConnectionMonitorsOperations>`
        """
        api_version = self._get_api_version('connection_monitors')
        if api_version == '2017-10-01':
            from .v2017_10_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ConnectionMonitorsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'connection_monitors'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def custom_ip_prefixes(self):
        """Instance depends on the API version:

           * 2020-06-01: :class:`CustomIPPrefixesOperations<azure.mgmt.network.v2020_06_01.operations.CustomIPPrefixesOperations>`
           * 2020-07-01: :class:`CustomIPPrefixesOperations<azure.mgmt.network.v2020_07_01.operations.CustomIPPrefixesOperations>`
           * 2020-08-01: :class:`CustomIPPrefixesOperations<azure.mgmt.network.v2020_08_01.operations.CustomIPPrefixesOperations>`
           * 2020-11-01: :class:`CustomIPPrefixesOperations<azure.mgmt.network.v2020_11_01.operations.CustomIPPrefixesOperations>`
        """
        api_version = self._get_api_version('custom_ip_prefixes')
        if api_version == '2020-06-01':
            from .v2020_06_01.operations import CustomIPPrefixesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import CustomIPPrefixesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import CustomIPPrefixesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import CustomIPPrefixesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'custom_ip_prefixes'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ddos_custom_policies(self):
        """Instance depends on the API version:

           * 2018-11-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2018_11_01.operations.DdosCustomPoliciesOperations>`
           * 2018-12-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2018_12_01.operations.DdosCustomPoliciesOperations>`
           * 2019-02-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_02_01.operations.DdosCustomPoliciesOperations>`
           * 2019-04-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_04_01.operations.DdosCustomPoliciesOperations>`
           * 2019-06-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_06_01.operations.DdosCustomPoliciesOperations>`
           * 2019-07-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_07_01.operations.DdosCustomPoliciesOperations>`
           * 2019-08-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_08_01.operations.DdosCustomPoliciesOperations>`
           * 2019-09-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_09_01.operations.DdosCustomPoliciesOperations>`
           * 2019-11-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_11_01.operations.DdosCustomPoliciesOperations>`
           * 2019-12-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_12_01.operations.DdosCustomPoliciesOperations>`
           * 2020-03-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_03_01.operations.DdosCustomPoliciesOperations>`
           * 2020-04-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_04_01.operations.DdosCustomPoliciesOperations>`
           * 2020-05-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_05_01.operations.DdosCustomPoliciesOperations>`
           * 2020-06-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_06_01.operations.DdosCustomPoliciesOperations>`
           * 2020-07-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_07_01.operations.DdosCustomPoliciesOperations>`
           * 2020-08-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_08_01.operations.DdosCustomPoliciesOperations>`
           * 2020-11-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_11_01.operations.DdosCustomPoliciesOperations>`
        """
        api_version = self._get_api_version('ddos_custom_policies')
        if api_version == '2018-11-01':
            from .v2018_11_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import DdosCustomPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'ddos_custom_policies'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ddos_protection_plans(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_02_01.operations.DdosProtectionPlansOperations>`
           * 2018-04-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_04_01.operations.DdosProtectionPlansOperations>`
           * 2018-06-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_06_01.operations.DdosProtectionPlansOperations>`
           * 2018-07-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_07_01.operations.DdosProtectionPlansOperations>`
           * 2018-08-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_08_01.operations.DdosProtectionPlansOperations>`
           * 2018-10-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_10_01.operations.DdosProtectionPlansOperations>`
           * 2018-11-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_11_01.operations.DdosProtectionPlansOperations>`
           * 2018-12-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_12_01.operations.DdosProtectionPlansOperations>`
           * 2019-02-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_02_01.operations.DdosProtectionPlansOperations>`
           * 2019-04-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_04_01.operations.DdosProtectionPlansOperations>`
           * 2019-06-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_06_01.operations.DdosProtectionPlansOperations>`
           * 2019-07-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_07_01.operations.DdosProtectionPlansOperations>`
           * 2019-08-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_08_01.operations.DdosProtectionPlansOperations>`
           * 2019-09-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_09_01.operations.DdosProtectionPlansOperations>`
           * 2019-11-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_11_01.operations.DdosProtectionPlansOperations>`
           * 2019-12-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_12_01.operations.DdosProtectionPlansOperations>`
           * 2020-03-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_03_01.operations.DdosProtectionPlansOperations>`
           * 2020-04-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_04_01.operations.DdosProtectionPlansOperations>`
           * 2020-05-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_05_01.operations.DdosProtectionPlansOperations>`
           * 2020-06-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_06_01.operations.DdosProtectionPlansOperations>`
           * 2020-07-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_07_01.operations.DdosProtectionPlansOperations>`
           * 2020-08-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_08_01.operations.DdosProtectionPlansOperations>`
           * 2020-11-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_11_01.operations.DdosProtectionPlansOperations>`
        """
        api_version = self._get_api_version('ddos_protection_plans')
        if api_version == '2018-02-01':
            from .v2018_02_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import DdosProtectionPlansOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'ddos_protection_plans'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def default_security_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_06_01.operations.DefaultSecurityRulesOperations>`
           * 2017-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_08_01.operations.DefaultSecurityRulesOperations>`
           * 2017-09-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_09_01.operations.DefaultSecurityRulesOperations>`
           * 2017-10-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_10_01.operations.DefaultSecurityRulesOperations>`
           * 2017-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_11_01.operations.DefaultSecurityRulesOperations>`
           * 2018-01-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_01_01.operations.DefaultSecurityRulesOperations>`
           * 2018-02-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_02_01.operations.DefaultSecurityRulesOperations>`
           * 2018-04-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_04_01.operations.DefaultSecurityRulesOperations>`
           * 2018-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_06_01.operations.DefaultSecurityRulesOperations>`
           * 2018-07-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_07_01.operations.DefaultSecurityRulesOperations>`
           * 2018-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_08_01.operations.DefaultSecurityRulesOperations>`
           * 2018-10-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_10_01.operations.DefaultSecurityRulesOperations>`
           * 2018-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_11_01.operations.DefaultSecurityRulesOperations>`
           * 2018-12-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_12_01.operations.DefaultSecurityRulesOperations>`
           * 2019-02-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_02_01.operations.DefaultSecurityRulesOperations>`
           * 2019-04-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_04_01.operations.DefaultSecurityRulesOperations>`
           * 2019-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_06_01.operations.DefaultSecurityRulesOperations>`
           * 2019-07-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_07_01.operations.DefaultSecurityRulesOperations>`
           * 2019-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_08_01.operations.DefaultSecurityRulesOperations>`
           * 2019-09-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_09_01.operations.DefaultSecurityRulesOperations>`
           * 2019-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_11_01.operations.DefaultSecurityRulesOperations>`
           * 2019-12-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_12_01.operations.DefaultSecurityRulesOperations>`
           * 2020-03-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_03_01.operations.DefaultSecurityRulesOperations>`
           * 2020-04-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_04_01.operations.DefaultSecurityRulesOperations>`
           * 2020-05-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_05_01.operations.DefaultSecurityRulesOperations>`
           * 2020-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_06_01.operations.DefaultSecurityRulesOperations>`
           * 2020-07-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_07_01.operations.DefaultSecurityRulesOperations>`
           * 2020-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_08_01.operations.DefaultSecurityRulesOperations>`
           * 2020-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_11_01.operations.DefaultSecurityRulesOperations>`
        """
        api_version = self._get_api_version('default_security_rules')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import DefaultSecurityRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'default_security_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def dscp_configuration(self):
        """Instance depends on the API version:

           * 2020-06-01: :class:`DscpConfigurationOperations<azure.mgmt.network.v2020_06_01.operations.DscpConfigurationOperations>`
           * 2020-07-01: :class:`DscpConfigurationOperations<azure.mgmt.network.v2020_07_01.operations.DscpConfigurationOperations>`
           * 2020-08-01: :class:`DscpConfigurationOperations<azure.mgmt.network.v2020_08_01.operations.DscpConfigurationOperations>`
           * 2020-11-01: :class:`DscpConfigurationOperations<azure.mgmt.network.v2020_11_01.operations.DscpConfigurationOperations>`
        """
        api_version = self._get_api_version('dscp_configuration')
        if api_version == '2020-06-01':
            from .v2020_06_01.operations import DscpConfigurationOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import DscpConfigurationOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import DscpConfigurationOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import DscpConfigurationOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'dscp_configuration'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_authorizations(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_11_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-01-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_01_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-02-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-05-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-07-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
        """
        api_version = self._get_api_version('express_route_circuit_authorizations')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_circuit_authorizations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_connections(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-05-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-06-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-07-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-08-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteCircuitConnectionsOperations>`
           * 2020-11-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteCircuitConnectionsOperations>`
        """
        api_version = self._get_api_version('express_route_circuit_connections')
        if api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteCircuitConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_circuit_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_peerings(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_11_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-01-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_01_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-02-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-05-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-07-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2020-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteCircuitPeeringsOperations>`
        """
        api_version = self._get_api_version('express_route_circuit_peerings')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_circuit_peerings'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuits(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_11_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-01-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_01_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-02-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteCircuitsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteCircuitsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-05-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-07-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteCircuitsOperations>`
           * 2020-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteCircuitsOperations>`
        """
        api_version = self._get_api_version('express_route_circuits')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteCircuitsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_circuits'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_connections(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteConnectionsOperations>`
           * 2018-10-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteConnectionsOperations>`
           * 2018-11-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteConnectionsOperations>`
           * 2018-12-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-02-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-04-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-06-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-07-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-08-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-09-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-11-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteConnectionsOperations>`
           * 2019-12-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-03-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-04-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-05-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-06-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-07-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-08-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteConnectionsOperations>`
           * 2020-11-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteConnectionsOperations>`
        """
        api_version = self._get_api_version('express_route_connections')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_cross_connection_peerings(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-04-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-06-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-07-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-08-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-10-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-11-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-12-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-02-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-04-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-06-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-07-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-08-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-09-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-11-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-12-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-03-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-04-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-05-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-06-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-07-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-08-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-11-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteCrossConnectionPeeringsOperations>`
        """
        api_version = self._get_api_version('express_route_cross_connection_peerings')
        if api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_cross_connection_peerings'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_cross_connections(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-04-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-06-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-07-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-08-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-10-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-11-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2018-12-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-02-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-04-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-06-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-07-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-08-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-09-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-11-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2019-12-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-03-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-04-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-05-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-06-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-07-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-08-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteCrossConnectionsOperations>`
           * 2020-11-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteCrossConnectionsOperations>`
        """
        api_version = self._get_api_version('express_route_cross_connections')
        if api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteCrossConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_cross_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_gateways(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteGatewaysOperations>`
           * 2018-10-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteGatewaysOperations>`
           * 2018-11-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteGatewaysOperations>`
           * 2018-12-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-02-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-04-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-06-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-07-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-08-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-09-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-11-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteGatewaysOperations>`
           * 2019-12-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-03-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-04-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-05-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-06-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-07-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-08-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteGatewaysOperations>`
           * 2020-11-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteGatewaysOperations>`
        """
        api_version = self._get_api_version('express_route_gateways')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_links(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteLinksOperations>`
           * 2018-10-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteLinksOperations>`
           * 2018-11-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteLinksOperations>`
           * 2018-12-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteLinksOperations>`
           * 2019-02-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteLinksOperations>`
           * 2019-04-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteLinksOperations>`
           * 2019-06-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteLinksOperations>`
           * 2019-07-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteLinksOperations>`
           * 2019-08-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteLinksOperations>`
           * 2019-09-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteLinksOperations>`
           * 2019-11-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteLinksOperations>`
           * 2019-12-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteLinksOperations>`
           * 2020-03-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteLinksOperations>`
           * 2020-04-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteLinksOperations>`
           * 2020-05-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteLinksOperations>`
           * 2020-06-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteLinksOperations>`
           * 2020-07-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteLinksOperations>`
           * 2020-08-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteLinksOperations>`
           * 2020-11-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteLinksOperations>`
        """
        api_version = self._get_api_version('express_route_links')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteLinksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_links'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_ports(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRoutePortsOperations>`
           * 2018-10-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRoutePortsOperations>`
           * 2018-11-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRoutePortsOperations>`
           * 2018-12-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRoutePortsOperations>`
           * 2019-02-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRoutePortsOperations>`
           * 2019-04-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRoutePortsOperations>`
           * 2019-06-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRoutePortsOperations>`
           * 2019-07-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRoutePortsOperations>`
           * 2019-08-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRoutePortsOperations>`
           * 2019-09-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRoutePortsOperations>`
           * 2019-11-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRoutePortsOperations>`
           * 2019-12-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRoutePortsOperations>`
           * 2020-03-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRoutePortsOperations>`
           * 2020-04-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRoutePortsOperations>`
           * 2020-05-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRoutePortsOperations>`
           * 2020-06-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRoutePortsOperations>`
           * 2020-07-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRoutePortsOperations>`
           * 2020-08-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRoutePortsOperations>`
           * 2020-11-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRoutePortsOperations>`
        """
        api_version = self._get_api_version('express_route_ports')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRoutePortsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_ports'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_ports_locations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2018-10-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2018-11-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2018-12-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-02-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-04-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-06-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-07-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-08-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-09-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-11-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2019-12-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-03-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-04-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-05-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-06-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-07-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-08-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRoutePortsLocationsOperations>`
           * 2020-11-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRoutePortsLocationsOperations>`
        """
        api_version = self._get_api_version('express_route_ports_locations')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRoutePortsLocationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_ports_locations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_service_providers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteServiceProvidersOperations>`
           * 2016-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2016-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-03-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-10-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_11_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-01-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_01_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-02-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_02_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-04-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_04_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_06_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-07-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_07_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_08_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-10-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_10_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_11_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2018-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_12_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-02-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_02_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-04-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_04_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_06_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-07-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_07_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_08_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_09_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_11_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2019-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_12_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-03-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_03_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-04-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_04_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-05-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_05_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_06_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-07-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_07_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_08_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2020-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_11_01.operations.ExpressRouteServiceProvidersOperations>`
        """
        api_version = self._get_api_version('express_route_service_providers')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'express_route_service_providers'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def firewall_policies(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_06_01.operations.FirewallPoliciesOperations>`
           * 2019-07-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_07_01.operations.FirewallPoliciesOperations>`
           * 2019-08-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_08_01.operations.FirewallPoliciesOperations>`
           * 2019-09-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_09_01.operations.FirewallPoliciesOperations>`
           * 2019-11-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_11_01.operations.FirewallPoliciesOperations>`
           * 2019-12-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_12_01.operations.FirewallPoliciesOperations>`
           * 2020-03-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_03_01.operations.FirewallPoliciesOperations>`
           * 2020-04-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_04_01.operations.FirewallPoliciesOperations>`
           * 2020-05-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_05_01.operations.FirewallPoliciesOperations>`
           * 2020-06-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_06_01.operations.FirewallPoliciesOperations>`
           * 2020-07-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_07_01.operations.FirewallPoliciesOperations>`
           * 2020-08-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_08_01.operations.FirewallPoliciesOperations>`
           * 2020-11-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_11_01.operations.FirewallPoliciesOperations>`
        """
        api_version = self._get_api_version('firewall_policies')
        if api_version == '2019-06-01':
            from .v2019_06_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import FirewallPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'firewall_policies'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def firewall_policy_rule_collection_groups(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`FirewallPolicyRuleCollectionGroupsOperations<azure.mgmt.network.v2020_05_01.operations.FirewallPolicyRuleCollectionGroupsOperations>`
           * 2020-06-01: :class:`FirewallPolicyRuleCollectionGroupsOperations<azure.mgmt.network.v2020_06_01.operations.FirewallPolicyRuleCollectionGroupsOperations>`
           * 2020-07-01: :class:`FirewallPolicyRuleCollectionGroupsOperations<azure.mgmt.network.v2020_07_01.operations.FirewallPolicyRuleCollectionGroupsOperations>`
           * 2020-08-01: :class:`FirewallPolicyRuleCollectionGroupsOperations<azure.mgmt.network.v2020_08_01.operations.FirewallPolicyRuleCollectionGroupsOperations>`
           * 2020-11-01: :class:`FirewallPolicyRuleCollectionGroupsOperations<azure.mgmt.network.v2020_11_01.operations.FirewallPolicyRuleCollectionGroupsOperations>`
        """
        api_version = self._get_api_version('firewall_policy_rule_collection_groups')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import FirewallPolicyRuleCollectionGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import FirewallPolicyRuleCollectionGroupsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import FirewallPolicyRuleCollectionGroupsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import FirewallPolicyRuleCollectionGroupsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import FirewallPolicyRuleCollectionGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'firewall_policy_rule_collection_groups'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def firewall_policy_rule_groups(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_06_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2019-07-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_07_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2019-08-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_08_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2019-09-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_09_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2019-11-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_11_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2019-12-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_12_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2020-03-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2020_03_01.operations.FirewallPolicyRuleGroupsOperations>`
           * 2020-04-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2020_04_01.operations.FirewallPolicyRuleGroupsOperations>`
        """
        api_version = self._get_api_version('firewall_policy_rule_groups')
        if api_version == '2019-06-01':
            from .v2019_06_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import FirewallPolicyRuleGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'firewall_policy_rule_groups'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def flow_logs(self):
        """Instance depends on the API version:

           * 2019-11-01: :class:`FlowLogsOperations<azure.mgmt.network.v2019_11_01.operations.FlowLogsOperations>`
           * 2019-12-01: :class:`FlowLogsOperations<azure.mgmt.network.v2019_12_01.operations.FlowLogsOperations>`
           * 2020-03-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_03_01.operations.FlowLogsOperations>`
           * 2020-04-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_04_01.operations.FlowLogsOperations>`
           * 2020-05-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_05_01.operations.FlowLogsOperations>`
           * 2020-06-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_06_01.operations.FlowLogsOperations>`
           * 2020-07-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_07_01.operations.FlowLogsOperations>`
           * 2020-08-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_08_01.operations.FlowLogsOperations>`
           * 2020-11-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_11_01.operations.FlowLogsOperations>`
        """
        api_version = self._get_api_version('flow_logs')
        if api_version == '2019-11-01':
            from .v2019_11_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import FlowLogsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import FlowLogsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'flow_logs'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def hub_route_tables(self):
        """Instance depends on the API version:

           * 2020-04-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_04_01.operations.HubRouteTablesOperations>`
           * 2020-05-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_05_01.operations.HubRouteTablesOperations>`
           * 2020-06-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_06_01.operations.HubRouteTablesOperations>`
           * 2020-07-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_07_01.operations.HubRouteTablesOperations>`
           * 2020-08-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_08_01.operations.HubRouteTablesOperations>`
           * 2020-11-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_11_01.operations.HubRouteTablesOperations>`
        """
        api_version = self._get_api_version('hub_route_tables')
        if api_version == '2020-04-01':
            from .v2020_04_01.operations import HubRouteTablesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import HubRouteTablesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import HubRouteTablesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import HubRouteTablesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import HubRouteTablesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import HubRouteTablesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'hub_route_tables'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def hub_virtual_network_connections(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_04_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2018-06-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_06_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2018-07-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_07_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2018-08-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_08_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2018-10-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_10_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2018-11-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_11_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2018-12-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-02-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-04-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-06-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-07-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-08-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-09-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-11-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2019-12-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-03-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-04-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-05-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-06-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-07-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-08-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.HubVirtualNetworkConnectionsOperations>`
           * 2020-11-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.HubVirtualNetworkConnectionsOperations>`
        """
        api_version = self._get_api_version('hub_virtual_network_connections')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import HubVirtualNetworkConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'hub_virtual_network_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def inbound_nat_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_06_01.operations.InboundNatRulesOperations>`
           * 2017-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_08_01.operations.InboundNatRulesOperations>`
           * 2017-09-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_09_01.operations.InboundNatRulesOperations>`
           * 2017-10-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_10_01.operations.InboundNatRulesOperations>`
           * 2017-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_11_01.operations.InboundNatRulesOperations>`
           * 2018-01-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_01_01.operations.InboundNatRulesOperations>`
           * 2018-02-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_02_01.operations.InboundNatRulesOperations>`
           * 2018-04-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_04_01.operations.InboundNatRulesOperations>`
           * 2018-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_06_01.operations.InboundNatRulesOperations>`
           * 2018-07-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_07_01.operations.InboundNatRulesOperations>`
           * 2018-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_08_01.operations.InboundNatRulesOperations>`
           * 2018-10-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_10_01.operations.InboundNatRulesOperations>`
           * 2018-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_11_01.operations.InboundNatRulesOperations>`
           * 2018-12-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_12_01.operations.InboundNatRulesOperations>`
           * 2019-02-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_02_01.operations.InboundNatRulesOperations>`
           * 2019-04-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_04_01.operations.InboundNatRulesOperations>`
           * 2019-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_06_01.operations.InboundNatRulesOperations>`
           * 2019-07-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_07_01.operations.InboundNatRulesOperations>`
           * 2019-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_08_01.operations.InboundNatRulesOperations>`
           * 2019-09-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_09_01.operations.InboundNatRulesOperations>`
           * 2019-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_11_01.operations.InboundNatRulesOperations>`
           * 2019-12-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_12_01.operations.InboundNatRulesOperations>`
           * 2020-03-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_03_01.operations.InboundNatRulesOperations>`
           * 2020-04-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_04_01.operations.InboundNatRulesOperations>`
           * 2020-05-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_05_01.operations.InboundNatRulesOperations>`
           * 2020-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_06_01.operations.InboundNatRulesOperations>`
           * 2020-07-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_07_01.operations.InboundNatRulesOperations>`
           * 2020-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_08_01.operations.InboundNatRulesOperations>`
           * 2020-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_11_01.operations.InboundNatRulesOperations>`
        """
        api_version = self._get_api_version('inbound_nat_rules')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import InboundNatRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'inbound_nat_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def inbound_security_rule(self):
        """Instance depends on the API version:

           * 2020-06-01: :class:`InboundSecurityRuleOperations<azure.mgmt.network.v2020_06_01.operations.InboundSecurityRuleOperations>`
           * 2020-07-01: :class:`InboundSecurityRuleOperations<azure.mgmt.network.v2020_07_01.operations.InboundSecurityRuleOperations>`
           * 2020-08-01: :class:`InboundSecurityRuleOperations<azure.mgmt.network.v2020_08_01.operations.InboundSecurityRuleOperations>`
           * 2020-11-01: :class:`InboundSecurityRuleOperations<azure.mgmt.network.v2020_11_01.operations.InboundSecurityRuleOperations>`
        """
        api_version = self._get_api_version('inbound_security_rule')
        if api_version == '2020-06-01':
            from .v2020_06_01.operations import InboundSecurityRuleOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import InboundSecurityRuleOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import InboundSecurityRuleOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import InboundSecurityRuleOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'inbound_security_rule'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def interface_endpoints(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_08_01.operations.InterfaceEndpointsOperations>`
           * 2018-10-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_10_01.operations.InterfaceEndpointsOperations>`
           * 2018-11-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_11_01.operations.InterfaceEndpointsOperations>`
           * 2018-12-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_12_01.operations.InterfaceEndpointsOperations>`
           * 2019-02-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2019_02_01.operations.InterfaceEndpointsOperations>`
        """
        api_version = self._get_api_version('interface_endpoints')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import InterfaceEndpointsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'interface_endpoints'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ip_allocations(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_03_01.operations.IpAllocationsOperations>`
           * 2020-04-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_04_01.operations.IpAllocationsOperations>`
           * 2020-05-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_05_01.operations.IpAllocationsOperations>`
           * 2020-06-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_06_01.operations.IpAllocationsOperations>`
           * 2020-07-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_07_01.operations.IpAllocationsOperations>`
           * 2020-08-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_08_01.operations.IpAllocationsOperations>`
           * 2020-11-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_11_01.operations.IpAllocationsOperations>`
        """
        api_version = self._get_api_version('ip_allocations')
        if api_version == '2020-03-01':
            from .v2020_03_01.operations import IpAllocationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import IpAllocationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import IpAllocationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import IpAllocationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import IpAllocationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import IpAllocationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import IpAllocationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'ip_allocations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ip_groups(self):
        """Instance depends on the API version:

           * 2019-09-01: :class:`IpGroupsOperations<azure.mgmt.network.v2019_09_01.operations.IpGroupsOperations>`
           * 2019-11-01: :class:`IpGroupsOperations<azure.mgmt.network.v2019_11_01.operations.IpGroupsOperations>`
           * 2019-12-01: :class:`IpGroupsOperations<azure.mgmt.network.v2019_12_01.operations.IpGroupsOperations>`
           * 2020-03-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_03_01.operations.IpGroupsOperations>`
           * 2020-04-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_04_01.operations.IpGroupsOperations>`
           * 2020-05-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_05_01.operations.IpGroupsOperations>`
           * 2020-06-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_06_01.operations.IpGroupsOperations>`
           * 2020-07-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_07_01.operations.IpGroupsOperations>`
           * 2020-08-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_08_01.operations.IpGroupsOperations>`
           * 2020-11-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_11_01.operations.IpGroupsOperations>`
        """
        api_version = self._get_api_version('ip_groups')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import IpGroupsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import IpGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'ip_groups'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_backend_address_pools(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-09-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-10-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_11_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-01-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_01_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-02-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_02_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-04-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_04_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_06_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-07-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_07_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-10-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-12-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-02-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-04-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-07-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-09-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-12-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-03-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-04-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-05-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-07-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancerBackendAddressPoolsOperations>`
        """
        api_version = self._get_api_version('load_balancer_backend_address_pools')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancer_backend_address_pools'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_frontend_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-09-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-10-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_11_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-01-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_01_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-02-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_02_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-04-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_04_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_06_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-07-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_07_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-10-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-12-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-02-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-04-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-07-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-09-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-12-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-03-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-04-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-05-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-07-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
        """
        api_version = self._get_api_version('load_balancer_frontend_ip_configurations')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancer_frontend_ip_configurations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_load_balancing_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-09-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-10-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_11_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-01-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_01_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-02-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_02_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-04-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_04_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_06_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-07-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_07_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-10-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-12-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-02-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-04-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-07-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-09-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-12-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-03-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-04-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-05-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-07-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancerLoadBalancingRulesOperations>`
        """
        api_version = self._get_api_version('load_balancer_load_balancing_rules')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancer_load_balancing_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_network_interfaces(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-09-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-10-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_11_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-01-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_01_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-02-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_02_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-04-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_04_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_06_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-07-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_07_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-10-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2018-12-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-02-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-04-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-07-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-09-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2019-12-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-03-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-04-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-05-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-07-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2020-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancerNetworkInterfacesOperations>`
        """
        api_version = self._get_api_version('load_balancer_network_interfaces')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancer_network_interfaces'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_outbound_rules(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2018-10-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2018-11-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2018-12-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-02-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-04-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-06-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-07-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-08-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-09-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-11-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2019-12-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-03-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-04-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-05-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-06-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-07-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-08-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancerOutboundRulesOperations>`
           * 2020-11-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancerOutboundRulesOperations>`
        """
        api_version = self._get_api_version('load_balancer_outbound_rules')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancerOutboundRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancer_outbound_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_probes(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerProbesOperations>`
           * 2017-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerProbesOperations>`
           * 2017-09-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerProbesOperations>`
           * 2017-10-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerProbesOperations>`
           * 2017-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_11_01.operations.LoadBalancerProbesOperations>`
           * 2018-01-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_01_01.operations.LoadBalancerProbesOperations>`
           * 2018-02-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_02_01.operations.LoadBalancerProbesOperations>`
           * 2018-04-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_04_01.operations.LoadBalancerProbesOperations>`
           * 2018-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_06_01.operations.LoadBalancerProbesOperations>`
           * 2018-07-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_07_01.operations.LoadBalancerProbesOperations>`
           * 2018-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancerProbesOperations>`
           * 2018-10-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancerProbesOperations>`
           * 2018-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancerProbesOperations>`
           * 2018-12-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancerProbesOperations>`
           * 2019-02-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancerProbesOperations>`
           * 2019-04-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancerProbesOperations>`
           * 2019-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancerProbesOperations>`
           * 2019-07-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancerProbesOperations>`
           * 2019-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancerProbesOperations>`
           * 2019-09-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancerProbesOperations>`
           * 2019-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancerProbesOperations>`
           * 2019-12-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancerProbesOperations>`
           * 2020-03-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancerProbesOperations>`
           * 2020-04-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancerProbesOperations>`
           * 2020-05-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancerProbesOperations>`
           * 2020-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancerProbesOperations>`
           * 2020-07-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancerProbesOperations>`
           * 2020-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancerProbesOperations>`
           * 2020-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancerProbesOperations>`
        """
        api_version = self._get_api_version('load_balancer_probes')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancerProbesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancer_probes'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LoadBalancersOperations<azure.mgmt.network.v2015_06_15.operations.LoadBalancersOperations>`
           * 2016-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_09_01.operations.LoadBalancersOperations>`
           * 2016-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_12_01.operations.LoadBalancersOperations>`
           * 2017-03-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_03_01.operations.LoadBalancersOperations>`
           * 2017-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancersOperations>`
           * 2017-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancersOperations>`
           * 2017-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancersOperations>`
           * 2017-10-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancersOperations>`
           * 2017-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_11_01.operations.LoadBalancersOperations>`
           * 2018-01-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_01_01.operations.LoadBalancersOperations>`
           * 2018-02-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_02_01.operations.LoadBalancersOperations>`
           * 2018-04-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_04_01.operations.LoadBalancersOperations>`
           * 2018-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_06_01.operations.LoadBalancersOperations>`
           * 2018-07-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_07_01.operations.LoadBalancersOperations>`
           * 2018-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_08_01.operations.LoadBalancersOperations>`
           * 2018-10-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_10_01.operations.LoadBalancersOperations>`
           * 2018-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_11_01.operations.LoadBalancersOperations>`
           * 2018-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_12_01.operations.LoadBalancersOperations>`
           * 2019-02-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_02_01.operations.LoadBalancersOperations>`
           * 2019-04-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_04_01.operations.LoadBalancersOperations>`
           * 2019-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_06_01.operations.LoadBalancersOperations>`
           * 2019-07-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_07_01.operations.LoadBalancersOperations>`
           * 2019-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_08_01.operations.LoadBalancersOperations>`
           * 2019-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_09_01.operations.LoadBalancersOperations>`
           * 2019-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_11_01.operations.LoadBalancersOperations>`
           * 2019-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_12_01.operations.LoadBalancersOperations>`
           * 2020-03-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_03_01.operations.LoadBalancersOperations>`
           * 2020-04-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_04_01.operations.LoadBalancersOperations>`
           * 2020-05-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_05_01.operations.LoadBalancersOperations>`
           * 2020-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_06_01.operations.LoadBalancersOperations>`
           * 2020-07-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_07_01.operations.LoadBalancersOperations>`
           * 2020-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_08_01.operations.LoadBalancersOperations>`
           * 2020-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_11_01.operations.LoadBalancersOperations>`
        """
        api_version = self._get_api_version('load_balancers')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LoadBalancersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'load_balancers'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def local_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.LocalNetworkGatewaysOperations>`
           * 2016-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.LocalNetworkGatewaysOperations>`
           * 2016-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-03-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_09_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-10-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_10_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_11_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-01-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_01_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-02-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_02_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-04-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_04_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_06_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-07-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_07_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_08_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-10-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_10_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_11_01.operations.LocalNetworkGatewaysOperations>`
           * 2018-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_12_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-02-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-04-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-07-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.LocalNetworkGatewaysOperations>`
           * 2019-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-03-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-04-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-05-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-07-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.LocalNetworkGatewaysOperations>`
           * 2020-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.LocalNetworkGatewaysOperations>`
        """
        api_version = self._get_api_version('local_network_gateways')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import LocalNetworkGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'local_network_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def nat_gateways(self):
        """Instance depends on the API version:

           * 2019-02-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.NatGatewaysOperations>`
           * 2019-04-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.NatGatewaysOperations>`
           * 2019-06-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.NatGatewaysOperations>`
           * 2019-07-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.NatGatewaysOperations>`
           * 2019-08-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.NatGatewaysOperations>`
           * 2019-09-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.NatGatewaysOperations>`
           * 2019-11-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.NatGatewaysOperations>`
           * 2019-12-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.NatGatewaysOperations>`
           * 2020-03-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.NatGatewaysOperations>`
           * 2020-04-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.NatGatewaysOperations>`
           * 2020-05-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.NatGatewaysOperations>`
           * 2020-06-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.NatGatewaysOperations>`
           * 2020-07-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.NatGatewaysOperations>`
           * 2020-08-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.NatGatewaysOperations>`
           * 2020-11-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.NatGatewaysOperations>`
        """
        api_version = self._get_api_version('nat_gateways')
        if api_version == '2019-02-01':
            from .v2019_02_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NatGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NatGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'nat_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def nat_rules(self):
        """Instance depends on the API version:

           * 2020-08-01: :class:`NatRulesOperations<azure.mgmt.network.v2020_08_01.operations.NatRulesOperations>`
           * 2020-11-01: :class:`NatRulesOperations<azure.mgmt.network.v2020_11_01.operations.NatRulesOperations>`
        """
        api_version = self._get_api_version('nat_rules')
        if api_version == '2020-08-01':
            from .v2020_08_01.operations import NatRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NatRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'nat_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-09-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_09_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-10-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_10_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_11_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-01-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_01_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-02-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_02_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-04-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_04_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_06_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-07-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_07_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_08_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-10-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_10_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_11_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-12-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_12_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-02-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_02_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-04-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_04_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_06_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-07-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_07_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_08_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-09-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_09_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_11_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-12-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_12_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-03-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_03_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-04-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_04_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-05-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_05_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_06_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-07-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_07_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_08_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_11_01.operations.NetworkInterfaceIPConfigurationsOperations>`
        """
        api_version = self._get_api_version('network_interface_ip_configurations')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_interface_ip_configurations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_load_balancers(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-09-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_09_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-10-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_10_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_11_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-01-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_01_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-02-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_02_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-04-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_04_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_06_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-07-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_07_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_08_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-10-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_10_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_11_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2018-12-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_12_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-02-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_02_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-04-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_04_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_06_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-07-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_07_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_08_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-09-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_09_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_11_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2019-12-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_12_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-03-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_03_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-04-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_04_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-05-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_05_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_06_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-07-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_07_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_08_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2020-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_11_01.operations.NetworkInterfaceLoadBalancersOperations>`
        """
        api_version = self._get_api_version('network_interface_load_balancers')
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_interface_load_balancers'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_tap_configurations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_08_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2018-10-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_10_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2018-11-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_11_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2018-12-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_12_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-02-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_02_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-04-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_04_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-06-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_06_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-07-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_07_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-08-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_08_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-09-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_09_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-11-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_11_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-12-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_12_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-03-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_03_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-04-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_04_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-05-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_05_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-06-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_06_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-07-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_07_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-08-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_08_01.operations.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-11-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_11_01.operations.NetworkInterfaceTapConfigurationsOperations>`
        """
        api_version = self._get_api_version('network_interface_tap_configurations')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkInterfaceTapConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_interface_tap_configurations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interfaces(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2015_06_15.operations.NetworkInterfacesOperations>`
           * 2016-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_09_01.operations.NetworkInterfacesOperations>`
           * 2016-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_12_01.operations.NetworkInterfacesOperations>`
           * 2017-03-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_03_01.operations.NetworkInterfacesOperations>`
           * 2017-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfacesOperations>`
           * 2017-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfacesOperations>`
           * 2017-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_09_01.operations.NetworkInterfacesOperations>`
           * 2017-10-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_10_01.operations.NetworkInterfacesOperations>`
           * 2017-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_11_01.operations.NetworkInterfacesOperations>`
           * 2018-01-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_01_01.operations.NetworkInterfacesOperations>`
           * 2018-02-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_02_01.operations.NetworkInterfacesOperations>`
           * 2018-04-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_04_01.operations.NetworkInterfacesOperations>`
           * 2018-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_06_01.operations.NetworkInterfacesOperations>`
           * 2018-07-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_07_01.operations.NetworkInterfacesOperations>`
           * 2018-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_08_01.operations.NetworkInterfacesOperations>`
           * 2018-10-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_10_01.operations.NetworkInterfacesOperations>`
           * 2018-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_11_01.operations.NetworkInterfacesOperations>`
           * 2018-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_12_01.operations.NetworkInterfacesOperations>`
           * 2019-02-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_02_01.operations.NetworkInterfacesOperations>`
           * 2019-04-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_04_01.operations.NetworkInterfacesOperations>`
           * 2019-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_06_01.operations.NetworkInterfacesOperations>`
           * 2019-07-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_07_01.operations.NetworkInterfacesOperations>`
           * 2019-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_08_01.operations.NetworkInterfacesOperations>`
           * 2019-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_09_01.operations.NetworkInterfacesOperations>`
           * 2019-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_11_01.operations.NetworkInterfacesOperations>`
           * 2019-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_12_01.operations.NetworkInterfacesOperations>`
           * 2020-03-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_03_01.operations.NetworkInterfacesOperations>`
           * 2020-04-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_04_01.operations.NetworkInterfacesOperations>`
           * 2020-05-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_05_01.operations.NetworkInterfacesOperations>`
           * 2020-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_06_01.operations.NetworkInterfacesOperations>`
           * 2020-07-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_07_01.operations.NetworkInterfacesOperations>`
           * 2020-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_08_01.operations.NetworkInterfacesOperations>`
           * 2020-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_11_01.operations.NetworkInterfacesOperations>`
        """
        api_version = self._get_api_version('network_interfaces')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkInterfacesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_interfaces'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_profiles(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_08_01.operations.NetworkProfilesOperations>`
           * 2018-10-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_10_01.operations.NetworkProfilesOperations>`
           * 2018-11-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_11_01.operations.NetworkProfilesOperations>`
           * 2018-12-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_12_01.operations.NetworkProfilesOperations>`
           * 2019-02-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_02_01.operations.NetworkProfilesOperations>`
           * 2019-04-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_04_01.operations.NetworkProfilesOperations>`
           * 2019-06-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_06_01.operations.NetworkProfilesOperations>`
           * 2019-07-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_07_01.operations.NetworkProfilesOperations>`
           * 2019-08-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_08_01.operations.NetworkProfilesOperations>`
           * 2019-09-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_09_01.operations.NetworkProfilesOperations>`
           * 2019-11-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_11_01.operations.NetworkProfilesOperations>`
           * 2019-12-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_12_01.operations.NetworkProfilesOperations>`
           * 2020-03-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_03_01.operations.NetworkProfilesOperations>`
           * 2020-04-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_04_01.operations.NetworkProfilesOperations>`
           * 2020-05-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_05_01.operations.NetworkProfilesOperations>`
           * 2020-06-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_06_01.operations.NetworkProfilesOperations>`
           * 2020-07-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_07_01.operations.NetworkProfilesOperations>`
           * 2020-08-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_08_01.operations.NetworkProfilesOperations>`
           * 2020-11-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_11_01.operations.NetworkProfilesOperations>`
        """
        api_version = self._get_api_version('network_profiles')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkProfilesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_profiles'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_security_groups(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2015_06_15.operations.NetworkSecurityGroupsOperations>`
           * 2016-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_09_01.operations.NetworkSecurityGroupsOperations>`
           * 2016-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_12_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-03-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_03_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_06_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_08_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_09_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-10-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_10_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_11_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-01-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_01_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-02-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_02_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-04-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_04_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_06_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-07-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_07_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_08_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-10-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_10_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_11_01.operations.NetworkSecurityGroupsOperations>`
           * 2018-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_12_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-02-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_02_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-04-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_04_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_06_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-07-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_07_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_08_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_09_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_11_01.operations.NetworkSecurityGroupsOperations>`
           * 2019-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_12_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-03-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_03_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-04-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_04_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-05-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_05_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_06_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-07-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_07_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_08_01.operations.NetworkSecurityGroupsOperations>`
           * 2020-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_11_01.operations.NetworkSecurityGroupsOperations>`
        """
        api_version = self._get_api_version('network_security_groups')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkSecurityGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_security_groups'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_virtual_appliances(self):
        """Instance depends on the API version:

           * 2019-12-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2019_12_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-03-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_03_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-04-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_04_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-05-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_05_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-06-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_06_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-07-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_07_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-08-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_08_01.operations.NetworkVirtualAppliancesOperations>`
           * 2020-11-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_11_01.operations.NetworkVirtualAppliancesOperations>`
        """
        api_version = self._get_api_version('network_virtual_appliances')
        if api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkVirtualAppliancesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_virtual_appliances'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_watchers(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_09_01.operations.NetworkWatchersOperations>`
           * 2016-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_12_01.operations.NetworkWatchersOperations>`
           * 2017-03-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_03_01.operations.NetworkWatchersOperations>`
           * 2017-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_06_01.operations.NetworkWatchersOperations>`
           * 2017-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_08_01.operations.NetworkWatchersOperations>`
           * 2017-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_09_01.operations.NetworkWatchersOperations>`
           * 2017-10-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_10_01.operations.NetworkWatchersOperations>`
           * 2017-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_11_01.operations.NetworkWatchersOperations>`
           * 2018-01-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_01_01.operations.NetworkWatchersOperations>`
           * 2018-02-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_02_01.operations.NetworkWatchersOperations>`
           * 2018-04-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_04_01.operations.NetworkWatchersOperations>`
           * 2018-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_06_01.operations.NetworkWatchersOperations>`
           * 2018-07-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_07_01.operations.NetworkWatchersOperations>`
           * 2018-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_08_01.operations.NetworkWatchersOperations>`
           * 2018-10-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_10_01.operations.NetworkWatchersOperations>`
           * 2018-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_11_01.operations.NetworkWatchersOperations>`
           * 2018-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_12_01.operations.NetworkWatchersOperations>`
           * 2019-02-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_02_01.operations.NetworkWatchersOperations>`
           * 2019-04-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_04_01.operations.NetworkWatchersOperations>`
           * 2019-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_06_01.operations.NetworkWatchersOperations>`
           * 2019-07-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_07_01.operations.NetworkWatchersOperations>`
           * 2019-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_08_01.operations.NetworkWatchersOperations>`
           * 2019-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_09_01.operations.NetworkWatchersOperations>`
           * 2019-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_11_01.operations.NetworkWatchersOperations>`
           * 2019-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_12_01.operations.NetworkWatchersOperations>`
           * 2020-03-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_03_01.operations.NetworkWatchersOperations>`
           * 2020-04-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_04_01.operations.NetworkWatchersOperations>`
           * 2020-05-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_05_01.operations.NetworkWatchersOperations>`
           * 2020-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_06_01.operations.NetworkWatchersOperations>`
           * 2020-07-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_07_01.operations.NetworkWatchersOperations>`
           * 2020-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_08_01.operations.NetworkWatchersOperations>`
           * 2020-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_11_01.operations.NetworkWatchersOperations>`
        """
        api_version = self._get_api_version('network_watchers')
        if api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import NetworkWatchersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_watchers'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2017-09-01: :class:`Operations<azure.mgmt.network.v2017_09_01.operations.Operations>`
           * 2017-10-01: :class:`Operations<azure.mgmt.network.v2017_10_01.operations.Operations>`
           * 2017-11-01: :class:`Operations<azure.mgmt.network.v2017_11_01.operations.Operations>`
           * 2018-01-01: :class:`Operations<azure.mgmt.network.v2018_01_01.operations.Operations>`
           * 2018-02-01: :class:`Operations<azure.mgmt.network.v2018_02_01.operations.Operations>`
           * 2018-04-01: :class:`Operations<azure.mgmt.network.v2018_04_01.operations.Operations>`
           * 2018-06-01: :class:`Operations<azure.mgmt.network.v2018_06_01.operations.Operations>`
           * 2018-07-01: :class:`Operations<azure.mgmt.network.v2018_07_01.operations.Operations>`
           * 2018-08-01: :class:`Operations<azure.mgmt.network.v2018_08_01.operations.Operations>`
           * 2018-10-01: :class:`Operations<azure.mgmt.network.v2018_10_01.operations.Operations>`
           * 2018-11-01: :class:`Operations<azure.mgmt.network.v2018_11_01.operations.Operations>`
           * 2018-12-01: :class:`Operations<azure.mgmt.network.v2018_12_01.operations.Operations>`
           * 2019-02-01: :class:`Operations<azure.mgmt.network.v2019_02_01.operations.Operations>`
           * 2019-04-01: :class:`Operations<azure.mgmt.network.v2019_04_01.operations.Operations>`
           * 2019-06-01: :class:`Operations<azure.mgmt.network.v2019_06_01.operations.Operations>`
           * 2019-07-01: :class:`Operations<azure.mgmt.network.v2019_07_01.operations.Operations>`
           * 2019-08-01: :class:`Operations<azure.mgmt.network.v2019_08_01.operations.Operations>`
           * 2019-09-01: :class:`Operations<azure.mgmt.network.v2019_09_01.operations.Operations>`
           * 2019-11-01: :class:`Operations<azure.mgmt.network.v2019_11_01.operations.Operations>`
           * 2019-12-01: :class:`Operations<azure.mgmt.network.v2019_12_01.operations.Operations>`
           * 2020-03-01: :class:`Operations<azure.mgmt.network.v2020_03_01.operations.Operations>`
           * 2020-04-01: :class:`Operations<azure.mgmt.network.v2020_04_01.operations.Operations>`
           * 2020-05-01: :class:`Operations<azure.mgmt.network.v2020_05_01.operations.Operations>`
           * 2020-06-01: :class:`Operations<azure.mgmt.network.v2020_06_01.operations.Operations>`
           * 2020-07-01: :class:`Operations<azure.mgmt.network.v2020_07_01.operations.Operations>`
           * 2020-08-01: :class:`Operations<azure.mgmt.network.v2020_08_01.operations.Operations>`
           * 2020-11-01: :class:`Operations<azure.mgmt.network.v2020_11_01.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2017-09-01':
            from .v2017_09_01.operations import Operations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import Operations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import Operations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import Operations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import Operations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import Operations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import Operations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import Operations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import Operations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import Operations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import Operations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import Operations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import Operations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import Operations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import Operations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import Operations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import Operations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import Operations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import Operations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import Operations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import Operations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import Operations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import Operations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import Operations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import Operations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import Operations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def p2_svpn_gateways(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_08_01.operations.P2SVpnGatewaysOperations>`
           * 2018-10-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_10_01.operations.P2SVpnGatewaysOperations>`
           * 2018-11-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_11_01.operations.P2SVpnGatewaysOperations>`
           * 2018-12-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_12_01.operations.P2SVpnGatewaysOperations>`
           * 2019-02-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.P2SVpnGatewaysOperations>`
           * 2019-04-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.P2SVpnGatewaysOperations>`
           * 2019-06-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.P2SVpnGatewaysOperations>`
           * 2019-07-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.P2SVpnGatewaysOperations>`
           * 2019-08-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.P2SVpnGatewaysOperations>`
           * 2019-09-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.P2SVpnGatewaysOperations>`
           * 2019-11-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.P2SVpnGatewaysOperations>`
           * 2019-12-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.P2SVpnGatewaysOperations>`
           * 2020-03-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.P2SVpnGatewaysOperations>`
           * 2020-04-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.P2SVpnGatewaysOperations>`
           * 2020-05-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.P2SVpnGatewaysOperations>`
           * 2020-06-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.P2SVpnGatewaysOperations>`
           * 2020-07-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.P2SVpnGatewaysOperations>`
           * 2020-08-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.P2SVpnGatewaysOperations>`
           * 2020-11-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.P2SVpnGatewaysOperations>`
        """
        api_version = self._get_api_version('p2_svpn_gateways')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import P2SVpnGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'p2_svpn_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def p2_svpn_server_configurations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_08_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2018-10-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_10_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2018-11-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_11_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2018-12-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_12_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2019-02-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_02_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2019-04-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_04_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2019-06-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_06_01.operations.P2SVpnServerConfigurationsOperations>`
           * 2019-07-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_07_01.operations.P2SVpnServerConfigurationsOperations>`
        """
        api_version = self._get_api_version('p2_svpn_server_configurations')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import P2SVpnServerConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'p2_svpn_server_configurations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def packet_captures(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_09_01.operations.PacketCapturesOperations>`
           * 2016-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_12_01.operations.PacketCapturesOperations>`
           * 2017-03-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_03_01.operations.PacketCapturesOperations>`
           * 2017-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_06_01.operations.PacketCapturesOperations>`
           * 2017-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_08_01.operations.PacketCapturesOperations>`
           * 2017-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_09_01.operations.PacketCapturesOperations>`
           * 2017-10-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_10_01.operations.PacketCapturesOperations>`
           * 2017-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_11_01.operations.PacketCapturesOperations>`
           * 2018-01-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_01_01.operations.PacketCapturesOperations>`
           * 2018-02-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_02_01.operations.PacketCapturesOperations>`
           * 2018-04-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_04_01.operations.PacketCapturesOperations>`
           * 2018-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_06_01.operations.PacketCapturesOperations>`
           * 2018-07-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_07_01.operations.PacketCapturesOperations>`
           * 2018-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_08_01.operations.PacketCapturesOperations>`
           * 2018-10-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_10_01.operations.PacketCapturesOperations>`
           * 2018-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_11_01.operations.PacketCapturesOperations>`
           * 2018-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_12_01.operations.PacketCapturesOperations>`
           * 2019-02-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_02_01.operations.PacketCapturesOperations>`
           * 2019-04-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_04_01.operations.PacketCapturesOperations>`
           * 2019-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_06_01.operations.PacketCapturesOperations>`
           * 2019-07-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_07_01.operations.PacketCapturesOperations>`
           * 2019-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_08_01.operations.PacketCapturesOperations>`
           * 2019-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_09_01.operations.PacketCapturesOperations>`
           * 2019-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_11_01.operations.PacketCapturesOperations>`
           * 2019-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_12_01.operations.PacketCapturesOperations>`
           * 2020-03-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_03_01.operations.PacketCapturesOperations>`
           * 2020-04-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_04_01.operations.PacketCapturesOperations>`
           * 2020-05-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_05_01.operations.PacketCapturesOperations>`
           * 2020-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_06_01.operations.PacketCapturesOperations>`
           * 2020-07-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_07_01.operations.PacketCapturesOperations>`
           * 2020-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_08_01.operations.PacketCapturesOperations>`
           * 2020-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_11_01.operations.PacketCapturesOperations>`
        """
        api_version = self._get_api_version('packet_captures')
        if api_version == '2016-09-01':
            from .v2016_09_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PacketCapturesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'packet_captures'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def peer_express_route_circuit_connections(self):
        """Instance depends on the API version:

           * 2018-12-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-02-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-04-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-06-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-07-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-08-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-09-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-11-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-12-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-03-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-04-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-05-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-06-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-07-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-08-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-11-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.PeerExpressRouteCircuitConnectionsOperations>`
        """
        api_version = self._get_api_version('peer_express_route_circuit_connections')
        if api_version == '2018-12-01':
            from .v2018_12_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'peer_express_route_circuit_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_dns_zone_groups(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_03_01.operations.PrivateDnsZoneGroupsOperations>`
           * 2020-04-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_04_01.operations.PrivateDnsZoneGroupsOperations>`
           * 2020-05-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_05_01.operations.PrivateDnsZoneGroupsOperations>`
           * 2020-06-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_06_01.operations.PrivateDnsZoneGroupsOperations>`
           * 2020-07-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_07_01.operations.PrivateDnsZoneGroupsOperations>`
           * 2020-08-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_08_01.operations.PrivateDnsZoneGroupsOperations>`
           * 2020-11-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_11_01.operations.PrivateDnsZoneGroupsOperations>`
        """
        api_version = self._get_api_version('private_dns_zone_groups')
        if api_version == '2020-03-01':
            from .v2020_03_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PrivateDnsZoneGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_dns_zone_groups'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_endpoints(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_04_01.operations.PrivateEndpointsOperations>`
           * 2019-06-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_06_01.operations.PrivateEndpointsOperations>`
           * 2019-07-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_07_01.operations.PrivateEndpointsOperations>`
           * 2019-08-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_08_01.operations.PrivateEndpointsOperations>`
           * 2019-09-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_09_01.operations.PrivateEndpointsOperations>`
           * 2019-11-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_11_01.operations.PrivateEndpointsOperations>`
           * 2019-12-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_12_01.operations.PrivateEndpointsOperations>`
           * 2020-03-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_03_01.operations.PrivateEndpointsOperations>`
           * 2020-04-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_04_01.operations.PrivateEndpointsOperations>`
           * 2020-05-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_05_01.operations.PrivateEndpointsOperations>`
           * 2020-06-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_06_01.operations.PrivateEndpointsOperations>`
           * 2020-07-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_07_01.operations.PrivateEndpointsOperations>`
           * 2020-08-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_08_01.operations.PrivateEndpointsOperations>`
           * 2020-11-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_11_01.operations.PrivateEndpointsOperations>`
        """
        api_version = self._get_api_version('private_endpoints')
        if api_version == '2019-04-01':
            from .v2019_04_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PrivateEndpointsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_endpoints'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_link_services(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_04_01.operations.PrivateLinkServicesOperations>`
           * 2019-06-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_06_01.operations.PrivateLinkServicesOperations>`
           * 2019-07-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_07_01.operations.PrivateLinkServicesOperations>`
           * 2019-08-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_08_01.operations.PrivateLinkServicesOperations>`
           * 2019-09-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_09_01.operations.PrivateLinkServicesOperations>`
           * 2019-11-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_11_01.operations.PrivateLinkServicesOperations>`
           * 2019-12-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_12_01.operations.PrivateLinkServicesOperations>`
           * 2020-03-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_03_01.operations.PrivateLinkServicesOperations>`
           * 2020-04-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_04_01.operations.PrivateLinkServicesOperations>`
           * 2020-05-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_05_01.operations.PrivateLinkServicesOperations>`
           * 2020-06-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_06_01.operations.PrivateLinkServicesOperations>`
           * 2020-07-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_07_01.operations.PrivateLinkServicesOperations>`
           * 2020-08-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_08_01.operations.PrivateLinkServicesOperations>`
           * 2020-11-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_11_01.operations.PrivateLinkServicesOperations>`
        """
        api_version = self._get_api_version('private_link_services')
        if api_version == '2019-04-01':
            from .v2019_04_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PrivateLinkServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_link_services'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def public_ip_addresses(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2015_06_15.operations.PublicIPAddressesOperations>`
           * 2016-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_09_01.operations.PublicIPAddressesOperations>`
           * 2016-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_12_01.operations.PublicIPAddressesOperations>`
           * 2017-03-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_03_01.operations.PublicIPAddressesOperations>`
           * 2017-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_06_01.operations.PublicIPAddressesOperations>`
           * 2017-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_08_01.operations.PublicIPAddressesOperations>`
           * 2017-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_09_01.operations.PublicIPAddressesOperations>`
           * 2017-10-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_10_01.operations.PublicIPAddressesOperations>`
           * 2017-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_11_01.operations.PublicIPAddressesOperations>`
           * 2018-01-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_01_01.operations.PublicIPAddressesOperations>`
           * 2018-02-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_02_01.operations.PublicIPAddressesOperations>`
           * 2018-04-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_04_01.operations.PublicIPAddressesOperations>`
           * 2018-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_06_01.operations.PublicIPAddressesOperations>`
           * 2018-07-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_07_01.operations.PublicIPAddressesOperations>`
           * 2018-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_08_01.operations.PublicIPAddressesOperations>`
           * 2018-10-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_10_01.operations.PublicIPAddressesOperations>`
           * 2018-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_11_01.operations.PublicIPAddressesOperations>`
           * 2018-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_12_01.operations.PublicIPAddressesOperations>`
           * 2019-02-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_02_01.operations.PublicIPAddressesOperations>`
           * 2019-04-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_04_01.operations.PublicIPAddressesOperations>`
           * 2019-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_06_01.operations.PublicIPAddressesOperations>`
           * 2019-07-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_07_01.operations.PublicIPAddressesOperations>`
           * 2019-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_08_01.operations.PublicIPAddressesOperations>`
           * 2019-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_09_01.operations.PublicIPAddressesOperations>`
           * 2019-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_11_01.operations.PublicIPAddressesOperations>`
           * 2019-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_12_01.operations.PublicIPAddressesOperations>`
           * 2020-03-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_03_01.operations.PublicIPAddressesOperations>`
           * 2020-04-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_04_01.operations.PublicIPAddressesOperations>`
           * 2020-05-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_05_01.operations.PublicIPAddressesOperations>`
           * 2020-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_06_01.operations.PublicIPAddressesOperations>`
           * 2020-07-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_07_01.operations.PublicIPAddressesOperations>`
           * 2020-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_08_01.operations.PublicIPAddressesOperations>`
           * 2020-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_11_01.operations.PublicIPAddressesOperations>`
        """
        api_version = self._get_api_version('public_ip_addresses')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PublicIPAddressesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'public_ip_addresses'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def public_ip_prefixes(self):
        """Instance depends on the API version:

           * 2018-07-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_07_01.operations.PublicIPPrefixesOperations>`
           * 2018-08-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_08_01.operations.PublicIPPrefixesOperations>`
           * 2018-10-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_10_01.operations.PublicIPPrefixesOperations>`
           * 2018-11-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_11_01.operations.PublicIPPrefixesOperations>`
           * 2018-12-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_12_01.operations.PublicIPPrefixesOperations>`
           * 2019-02-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_02_01.operations.PublicIPPrefixesOperations>`
           * 2019-04-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_04_01.operations.PublicIPPrefixesOperations>`
           * 2019-06-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_06_01.operations.PublicIPPrefixesOperations>`
           * 2019-07-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_07_01.operations.PublicIPPrefixesOperations>`
           * 2019-08-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_08_01.operations.PublicIPPrefixesOperations>`
           * 2019-09-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_09_01.operations.PublicIPPrefixesOperations>`
           * 2019-11-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_11_01.operations.PublicIPPrefixesOperations>`
           * 2019-12-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_12_01.operations.PublicIPPrefixesOperations>`
           * 2020-03-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_03_01.operations.PublicIPPrefixesOperations>`
           * 2020-04-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_04_01.operations.PublicIPPrefixesOperations>`
           * 2020-05-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_05_01.operations.PublicIPPrefixesOperations>`
           * 2020-06-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_06_01.operations.PublicIPPrefixesOperations>`
           * 2020-07-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_07_01.operations.PublicIPPrefixesOperations>`
           * 2020-08-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_08_01.operations.PublicIPPrefixesOperations>`
           * 2020-11-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_11_01.operations.PublicIPPrefixesOperations>`
        """
        api_version = self._get_api_version('public_ip_prefixes')
        if api_version == '2018-07-01':
            from .v2018_07_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import PublicIPPrefixesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'public_ip_prefixes'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def resource_navigation_links(self):
        """Instance depends on the API version:

           * 2019-02-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_02_01.operations.ResourceNavigationLinksOperations>`
           * 2019-04-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_04_01.operations.ResourceNavigationLinksOperations>`
           * 2019-06-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_06_01.operations.ResourceNavigationLinksOperations>`
           * 2019-07-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_07_01.operations.ResourceNavigationLinksOperations>`
           * 2019-08-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_08_01.operations.ResourceNavigationLinksOperations>`
           * 2019-09-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_09_01.operations.ResourceNavigationLinksOperations>`
           * 2019-11-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_11_01.operations.ResourceNavigationLinksOperations>`
           * 2019-12-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_12_01.operations.ResourceNavigationLinksOperations>`
           * 2020-03-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_03_01.operations.ResourceNavigationLinksOperations>`
           * 2020-04-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_04_01.operations.ResourceNavigationLinksOperations>`
           * 2020-05-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_05_01.operations.ResourceNavigationLinksOperations>`
           * 2020-06-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_06_01.operations.ResourceNavigationLinksOperations>`
           * 2020-07-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_07_01.operations.ResourceNavigationLinksOperations>`
           * 2020-08-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_08_01.operations.ResourceNavigationLinksOperations>`
           * 2020-11-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_11_01.operations.ResourceNavigationLinksOperations>`
        """
        api_version = self._get_api_version('resource_navigation_links')
        if api_version == '2019-02-01':
            from .v2019_02_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ResourceNavigationLinksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'resource_navigation_links'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_filter_rules(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2016_12_01.operations.RouteFilterRulesOperations>`
           * 2017-03-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_03_01.operations.RouteFilterRulesOperations>`
           * 2017-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_06_01.operations.RouteFilterRulesOperations>`
           * 2017-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_08_01.operations.RouteFilterRulesOperations>`
           * 2017-09-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_09_01.operations.RouteFilterRulesOperations>`
           * 2017-10-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_10_01.operations.RouteFilterRulesOperations>`
           * 2017-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_11_01.operations.RouteFilterRulesOperations>`
           * 2018-01-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_01_01.operations.RouteFilterRulesOperations>`
           * 2018-02-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_02_01.operations.RouteFilterRulesOperations>`
           * 2018-04-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_04_01.operations.RouteFilterRulesOperations>`
           * 2018-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_06_01.operations.RouteFilterRulesOperations>`
           * 2018-07-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_07_01.operations.RouteFilterRulesOperations>`
           * 2018-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_08_01.operations.RouteFilterRulesOperations>`
           * 2018-10-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_10_01.operations.RouteFilterRulesOperations>`
           * 2018-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_11_01.operations.RouteFilterRulesOperations>`
           * 2018-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_12_01.operations.RouteFilterRulesOperations>`
           * 2019-02-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_02_01.operations.RouteFilterRulesOperations>`
           * 2019-04-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_04_01.operations.RouteFilterRulesOperations>`
           * 2019-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_06_01.operations.RouteFilterRulesOperations>`
           * 2019-07-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_07_01.operations.RouteFilterRulesOperations>`
           * 2019-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_08_01.operations.RouteFilterRulesOperations>`
           * 2019-09-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_09_01.operations.RouteFilterRulesOperations>`
           * 2019-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_11_01.operations.RouteFilterRulesOperations>`
           * 2019-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_12_01.operations.RouteFilterRulesOperations>`
           * 2020-03-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_03_01.operations.RouteFilterRulesOperations>`
           * 2020-04-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_04_01.operations.RouteFilterRulesOperations>`
           * 2020-05-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_05_01.operations.RouteFilterRulesOperations>`
           * 2020-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_06_01.operations.RouteFilterRulesOperations>`
           * 2020-07-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_07_01.operations.RouteFilterRulesOperations>`
           * 2020-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_08_01.operations.RouteFilterRulesOperations>`
           * 2020-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_11_01.operations.RouteFilterRulesOperations>`
        """
        api_version = self._get_api_version('route_filter_rules')
        if api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import RouteFilterRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'route_filter_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_filters(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2016_12_01.operations.RouteFiltersOperations>`
           * 2017-03-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_03_01.operations.RouteFiltersOperations>`
           * 2017-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_06_01.operations.RouteFiltersOperations>`
           * 2017-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_08_01.operations.RouteFiltersOperations>`
           * 2017-09-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_09_01.operations.RouteFiltersOperations>`
           * 2017-10-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_10_01.operations.RouteFiltersOperations>`
           * 2017-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_11_01.operations.RouteFiltersOperations>`
           * 2018-01-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_01_01.operations.RouteFiltersOperations>`
           * 2018-02-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_02_01.operations.RouteFiltersOperations>`
           * 2018-04-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_04_01.operations.RouteFiltersOperations>`
           * 2018-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_06_01.operations.RouteFiltersOperations>`
           * 2018-07-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_07_01.operations.RouteFiltersOperations>`
           * 2018-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_08_01.operations.RouteFiltersOperations>`
           * 2018-10-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_10_01.operations.RouteFiltersOperations>`
           * 2018-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_11_01.operations.RouteFiltersOperations>`
           * 2018-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_12_01.operations.RouteFiltersOperations>`
           * 2019-02-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_02_01.operations.RouteFiltersOperations>`
           * 2019-04-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_04_01.operations.RouteFiltersOperations>`
           * 2019-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_06_01.operations.RouteFiltersOperations>`
           * 2019-07-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_07_01.operations.RouteFiltersOperations>`
           * 2019-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_08_01.operations.RouteFiltersOperations>`
           * 2019-09-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_09_01.operations.RouteFiltersOperations>`
           * 2019-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_11_01.operations.RouteFiltersOperations>`
           * 2019-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_12_01.operations.RouteFiltersOperations>`
           * 2020-03-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_03_01.operations.RouteFiltersOperations>`
           * 2020-04-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_04_01.operations.RouteFiltersOperations>`
           * 2020-05-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_05_01.operations.RouteFiltersOperations>`
           * 2020-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_06_01.operations.RouteFiltersOperations>`
           * 2020-07-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_07_01.operations.RouteFiltersOperations>`
           * 2020-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_08_01.operations.RouteFiltersOperations>`
           * 2020-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_11_01.operations.RouteFiltersOperations>`
        """
        api_version = self._get_api_version('route_filters')
        if api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import RouteFiltersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'route_filters'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_tables(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RouteTablesOperations<azure.mgmt.network.v2015_06_15.operations.RouteTablesOperations>`
           * 2016-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_09_01.operations.RouteTablesOperations>`
           * 2016-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_12_01.operations.RouteTablesOperations>`
           * 2017-03-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_03_01.operations.RouteTablesOperations>`
           * 2017-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_06_01.operations.RouteTablesOperations>`
           * 2017-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_08_01.operations.RouteTablesOperations>`
           * 2017-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_09_01.operations.RouteTablesOperations>`
           * 2017-10-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_10_01.operations.RouteTablesOperations>`
           * 2017-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_11_01.operations.RouteTablesOperations>`
           * 2018-01-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_01_01.operations.RouteTablesOperations>`
           * 2018-02-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_02_01.operations.RouteTablesOperations>`
           * 2018-04-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_04_01.operations.RouteTablesOperations>`
           * 2018-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_06_01.operations.RouteTablesOperations>`
           * 2018-07-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_07_01.operations.RouteTablesOperations>`
           * 2018-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_08_01.operations.RouteTablesOperations>`
           * 2018-10-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_10_01.operations.RouteTablesOperations>`
           * 2018-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_11_01.operations.RouteTablesOperations>`
           * 2018-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_12_01.operations.RouteTablesOperations>`
           * 2019-02-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_02_01.operations.RouteTablesOperations>`
           * 2019-04-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_04_01.operations.RouteTablesOperations>`
           * 2019-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_06_01.operations.RouteTablesOperations>`
           * 2019-07-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_07_01.operations.RouteTablesOperations>`
           * 2019-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_08_01.operations.RouteTablesOperations>`
           * 2019-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_09_01.operations.RouteTablesOperations>`
           * 2019-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_11_01.operations.RouteTablesOperations>`
           * 2019-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_12_01.operations.RouteTablesOperations>`
           * 2020-03-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_03_01.operations.RouteTablesOperations>`
           * 2020-04-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_04_01.operations.RouteTablesOperations>`
           * 2020-05-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_05_01.operations.RouteTablesOperations>`
           * 2020-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_06_01.operations.RouteTablesOperations>`
           * 2020-07-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_07_01.operations.RouteTablesOperations>`
           * 2020-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_08_01.operations.RouteTablesOperations>`
           * 2020-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_11_01.operations.RouteTablesOperations>`
        """
        api_version = self._get_api_version('route_tables')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import RouteTablesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import RouteTablesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'route_tables'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def routes(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RoutesOperations<azure.mgmt.network.v2015_06_15.operations.RoutesOperations>`
           * 2016-09-01: :class:`RoutesOperations<azure.mgmt.network.v2016_09_01.operations.RoutesOperations>`
           * 2016-12-01: :class:`RoutesOperations<azure.mgmt.network.v2016_12_01.operations.RoutesOperations>`
           * 2017-03-01: :class:`RoutesOperations<azure.mgmt.network.v2017_03_01.operations.RoutesOperations>`
           * 2017-06-01: :class:`RoutesOperations<azure.mgmt.network.v2017_06_01.operations.RoutesOperations>`
           * 2017-08-01: :class:`RoutesOperations<azure.mgmt.network.v2017_08_01.operations.RoutesOperations>`
           * 2017-09-01: :class:`RoutesOperations<azure.mgmt.network.v2017_09_01.operations.RoutesOperations>`
           * 2017-10-01: :class:`RoutesOperations<azure.mgmt.network.v2017_10_01.operations.RoutesOperations>`
           * 2017-11-01: :class:`RoutesOperations<azure.mgmt.network.v2017_11_01.operations.RoutesOperations>`
           * 2018-01-01: :class:`RoutesOperations<azure.mgmt.network.v2018_01_01.operations.RoutesOperations>`
           * 2018-02-01: :class:`RoutesOperations<azure.mgmt.network.v2018_02_01.operations.RoutesOperations>`
           * 2018-04-01: :class:`RoutesOperations<azure.mgmt.network.v2018_04_01.operations.RoutesOperations>`
           * 2018-06-01: :class:`RoutesOperations<azure.mgmt.network.v2018_06_01.operations.RoutesOperations>`
           * 2018-07-01: :class:`RoutesOperations<azure.mgmt.network.v2018_07_01.operations.RoutesOperations>`
           * 2018-08-01: :class:`RoutesOperations<azure.mgmt.network.v2018_08_01.operations.RoutesOperations>`
           * 2018-10-01: :class:`RoutesOperations<azure.mgmt.network.v2018_10_01.operations.RoutesOperations>`
           * 2018-11-01: :class:`RoutesOperations<azure.mgmt.network.v2018_11_01.operations.RoutesOperations>`
           * 2018-12-01: :class:`RoutesOperations<azure.mgmt.network.v2018_12_01.operations.RoutesOperations>`
           * 2019-02-01: :class:`RoutesOperations<azure.mgmt.network.v2019_02_01.operations.RoutesOperations>`
           * 2019-04-01: :class:`RoutesOperations<azure.mgmt.network.v2019_04_01.operations.RoutesOperations>`
           * 2019-06-01: :class:`RoutesOperations<azure.mgmt.network.v2019_06_01.operations.RoutesOperations>`
           * 2019-07-01: :class:`RoutesOperations<azure.mgmt.network.v2019_07_01.operations.RoutesOperations>`
           * 2019-08-01: :class:`RoutesOperations<azure.mgmt.network.v2019_08_01.operations.RoutesOperations>`
           * 2019-09-01: :class:`RoutesOperations<azure.mgmt.network.v2019_09_01.operations.RoutesOperations>`
           * 2019-11-01: :class:`RoutesOperations<azure.mgmt.network.v2019_11_01.operations.RoutesOperations>`
           * 2019-12-01: :class:`RoutesOperations<azure.mgmt.network.v2019_12_01.operations.RoutesOperations>`
           * 2020-03-01: :class:`RoutesOperations<azure.mgmt.network.v2020_03_01.operations.RoutesOperations>`
           * 2020-04-01: :class:`RoutesOperations<azure.mgmt.network.v2020_04_01.operations.RoutesOperations>`
           * 2020-05-01: :class:`RoutesOperations<azure.mgmt.network.v2020_05_01.operations.RoutesOperations>`
           * 2020-06-01: :class:`RoutesOperations<azure.mgmt.network.v2020_06_01.operations.RoutesOperations>`
           * 2020-07-01: :class:`RoutesOperations<azure.mgmt.network.v2020_07_01.operations.RoutesOperations>`
           * 2020-08-01: :class:`RoutesOperations<azure.mgmt.network.v2020_08_01.operations.RoutesOperations>`
           * 2020-11-01: :class:`RoutesOperations<azure.mgmt.network.v2020_11_01.operations.RoutesOperations>`
        """
        api_version = self._get_api_version('routes')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import RoutesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import RoutesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import RoutesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import RoutesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import RoutesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import RoutesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'routes'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_partner_providers(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_03_01.operations.SecurityPartnerProvidersOperations>`
           * 2020-04-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_04_01.operations.SecurityPartnerProvidersOperations>`
           * 2020-05-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_05_01.operations.SecurityPartnerProvidersOperations>`
           * 2020-06-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_06_01.operations.SecurityPartnerProvidersOperations>`
           * 2020-07-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_07_01.operations.SecurityPartnerProvidersOperations>`
           * 2020-08-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_08_01.operations.SecurityPartnerProvidersOperations>`
           * 2020-11-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_11_01.operations.SecurityPartnerProvidersOperations>`
        """
        api_version = self._get_api_version('security_partner_providers')
        if api_version == '2020-03-01':
            from .v2020_03_01.operations import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import SecurityPartnerProvidersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_partner_providers'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_rules(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SecurityRulesOperations<azure.mgmt.network.v2015_06_15.operations.SecurityRulesOperations>`
           * 2016-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_09_01.operations.SecurityRulesOperations>`
           * 2016-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_12_01.operations.SecurityRulesOperations>`
           * 2017-03-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_03_01.operations.SecurityRulesOperations>`
           * 2017-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_06_01.operations.SecurityRulesOperations>`
           * 2017-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_08_01.operations.SecurityRulesOperations>`
           * 2017-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_09_01.operations.SecurityRulesOperations>`
           * 2017-10-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_10_01.operations.SecurityRulesOperations>`
           * 2017-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_11_01.operations.SecurityRulesOperations>`
           * 2018-01-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_01_01.operations.SecurityRulesOperations>`
           * 2018-02-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_02_01.operations.SecurityRulesOperations>`
           * 2018-04-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_04_01.operations.SecurityRulesOperations>`
           * 2018-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_06_01.operations.SecurityRulesOperations>`
           * 2018-07-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_07_01.operations.SecurityRulesOperations>`
           * 2018-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_08_01.operations.SecurityRulesOperations>`
           * 2018-10-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_10_01.operations.SecurityRulesOperations>`
           * 2018-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_11_01.operations.SecurityRulesOperations>`
           * 2018-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_12_01.operations.SecurityRulesOperations>`
           * 2019-02-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_02_01.operations.SecurityRulesOperations>`
           * 2019-04-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_04_01.operations.SecurityRulesOperations>`
           * 2019-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_06_01.operations.SecurityRulesOperations>`
           * 2019-07-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_07_01.operations.SecurityRulesOperations>`
           * 2019-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_08_01.operations.SecurityRulesOperations>`
           * 2019-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_09_01.operations.SecurityRulesOperations>`
           * 2019-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_11_01.operations.SecurityRulesOperations>`
           * 2019-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_12_01.operations.SecurityRulesOperations>`
           * 2020-03-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_03_01.operations.SecurityRulesOperations>`
           * 2020-04-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_04_01.operations.SecurityRulesOperations>`
           * 2020-05-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_05_01.operations.SecurityRulesOperations>`
           * 2020-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_06_01.operations.SecurityRulesOperations>`
           * 2020-07-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_07_01.operations.SecurityRulesOperations>`
           * 2020-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_08_01.operations.SecurityRulesOperations>`
           * 2020-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_11_01.operations.SecurityRulesOperations>`
        """
        api_version = self._get_api_version('security_rules')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import SecurityRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_rules'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_association_links(self):
        """Instance depends on the API version:

           * 2019-02-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_02_01.operations.ServiceAssociationLinksOperations>`
           * 2019-04-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_04_01.operations.ServiceAssociationLinksOperations>`
           * 2019-06-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_06_01.operations.ServiceAssociationLinksOperations>`
           * 2019-07-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_07_01.operations.ServiceAssociationLinksOperations>`
           * 2019-08-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_08_01.operations.ServiceAssociationLinksOperations>`
           * 2019-09-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_09_01.operations.ServiceAssociationLinksOperations>`
           * 2019-11-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_11_01.operations.ServiceAssociationLinksOperations>`
           * 2019-12-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_12_01.operations.ServiceAssociationLinksOperations>`
           * 2020-03-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_03_01.operations.ServiceAssociationLinksOperations>`
           * 2020-04-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_04_01.operations.ServiceAssociationLinksOperations>`
           * 2020-05-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_05_01.operations.ServiceAssociationLinksOperations>`
           * 2020-06-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_06_01.operations.ServiceAssociationLinksOperations>`
           * 2020-07-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_07_01.operations.ServiceAssociationLinksOperations>`
           * 2020-08-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_08_01.operations.ServiceAssociationLinksOperations>`
           * 2020-11-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_11_01.operations.ServiceAssociationLinksOperations>`
        """
        api_version = self._get_api_version('service_association_links')
        if api_version == '2019-02-01':
            from .v2019_02_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ServiceAssociationLinksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'service_association_links'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_endpoint_policies(self):
        """Instance depends on the API version:

           * 2018-07-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_07_01.operations.ServiceEndpointPoliciesOperations>`
           * 2018-08-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_08_01.operations.ServiceEndpointPoliciesOperations>`
           * 2018-10-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_10_01.operations.ServiceEndpointPoliciesOperations>`
           * 2018-11-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_11_01.operations.ServiceEndpointPoliciesOperations>`
           * 2018-12-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_12_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-02-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_02_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-04-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_04_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-06-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_06_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-07-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_07_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-08-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_08_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-09-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_09_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-11-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_11_01.operations.ServiceEndpointPoliciesOperations>`
           * 2019-12-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_12_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-03-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_03_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-04-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_04_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-05-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_05_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-06-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_06_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-07-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_07_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-08-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_08_01.operations.ServiceEndpointPoliciesOperations>`
           * 2020-11-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_11_01.operations.ServiceEndpointPoliciesOperations>`
        """
        api_version = self._get_api_version('service_endpoint_policies')
        if api_version == '2018-07-01':
            from .v2018_07_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ServiceEndpointPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'service_endpoint_policies'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_endpoint_policy_definitions(self):
        """Instance depends on the API version:

           * 2018-07-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_07_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-08-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_08_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-10-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_10_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-11-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_11_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-12-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_12_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-02-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_02_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-04-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_04_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-06-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_06_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-07-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_07_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-08-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_08_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-09-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_09_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-11-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_11_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-12-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_12_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-03-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_03_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-04-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_04_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-05-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_05_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-06-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_06_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-07-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_07_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-08-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_08_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-11-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_11_01.operations.ServiceEndpointPolicyDefinitionsOperations>`
        """
        api_version = self._get_api_version('service_endpoint_policy_definitions')
        if api_version == '2018-07-01':
            from .v2018_07_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'service_endpoint_policy_definitions'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_tags(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_04_01.operations.ServiceTagsOperations>`
           * 2019-06-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_06_01.operations.ServiceTagsOperations>`
           * 2019-07-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_07_01.operations.ServiceTagsOperations>`
           * 2019-08-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_08_01.operations.ServiceTagsOperations>`
           * 2019-09-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_09_01.operations.ServiceTagsOperations>`
           * 2019-11-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_11_01.operations.ServiceTagsOperations>`
           * 2019-12-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_12_01.operations.ServiceTagsOperations>`
           * 2020-03-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_03_01.operations.ServiceTagsOperations>`
           * 2020-04-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_04_01.operations.ServiceTagsOperations>`
           * 2020-05-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_05_01.operations.ServiceTagsOperations>`
           * 2020-06-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_06_01.operations.ServiceTagsOperations>`
           * 2020-07-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_07_01.operations.ServiceTagsOperations>`
           * 2020-08-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_08_01.operations.ServiceTagsOperations>`
           * 2020-11-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_11_01.operations.ServiceTagsOperations>`
        """
        api_version = self._get_api_version('service_tags')
        if api_version == '2019-04-01':
            from .v2019_04_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import ServiceTagsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import ServiceTagsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'service_tags'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def subnets(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SubnetsOperations<azure.mgmt.network.v2015_06_15.operations.SubnetsOperations>`
           * 2016-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_09_01.operations.SubnetsOperations>`
           * 2016-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_12_01.operations.SubnetsOperations>`
           * 2017-03-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_03_01.operations.SubnetsOperations>`
           * 2017-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_06_01.operations.SubnetsOperations>`
           * 2017-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_08_01.operations.SubnetsOperations>`
           * 2017-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_09_01.operations.SubnetsOperations>`
           * 2017-10-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_10_01.operations.SubnetsOperations>`
           * 2017-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_11_01.operations.SubnetsOperations>`
           * 2018-01-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_01_01.operations.SubnetsOperations>`
           * 2018-02-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_02_01.operations.SubnetsOperations>`
           * 2018-04-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_04_01.operations.SubnetsOperations>`
           * 2018-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_06_01.operations.SubnetsOperations>`
           * 2018-07-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_07_01.operations.SubnetsOperations>`
           * 2018-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_08_01.operations.SubnetsOperations>`
           * 2018-10-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_10_01.operations.SubnetsOperations>`
           * 2018-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_11_01.operations.SubnetsOperations>`
           * 2018-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_12_01.operations.SubnetsOperations>`
           * 2019-02-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_02_01.operations.SubnetsOperations>`
           * 2019-04-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_04_01.operations.SubnetsOperations>`
           * 2019-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_06_01.operations.SubnetsOperations>`
           * 2019-07-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_07_01.operations.SubnetsOperations>`
           * 2019-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_08_01.operations.SubnetsOperations>`
           * 2019-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_09_01.operations.SubnetsOperations>`
           * 2019-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_11_01.operations.SubnetsOperations>`
           * 2019-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_12_01.operations.SubnetsOperations>`
           * 2020-03-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_03_01.operations.SubnetsOperations>`
           * 2020-04-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_04_01.operations.SubnetsOperations>`
           * 2020-05-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_05_01.operations.SubnetsOperations>`
           * 2020-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_06_01.operations.SubnetsOperations>`
           * 2020-07-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_07_01.operations.SubnetsOperations>`
           * 2020-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_08_01.operations.SubnetsOperations>`
           * 2020-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_11_01.operations.SubnetsOperations>`
        """
        api_version = self._get_api_version('subnets')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import SubnetsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import SubnetsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'subnets'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def usages(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`UsagesOperations<azure.mgmt.network.v2015_06_15.operations.UsagesOperations>`
           * 2016-09-01: :class:`UsagesOperations<azure.mgmt.network.v2016_09_01.operations.UsagesOperations>`
           * 2016-12-01: :class:`UsagesOperations<azure.mgmt.network.v2016_12_01.operations.UsagesOperations>`
           * 2017-03-01: :class:`UsagesOperations<azure.mgmt.network.v2017_03_01.operations.UsagesOperations>`
           * 2017-06-01: :class:`UsagesOperations<azure.mgmt.network.v2017_06_01.operations.UsagesOperations>`
           * 2017-08-01: :class:`UsagesOperations<azure.mgmt.network.v2017_08_01.operations.UsagesOperations>`
           * 2017-09-01: :class:`UsagesOperations<azure.mgmt.network.v2017_09_01.operations.UsagesOperations>`
           * 2017-10-01: :class:`UsagesOperations<azure.mgmt.network.v2017_10_01.operations.UsagesOperations>`
           * 2017-11-01: :class:`UsagesOperations<azure.mgmt.network.v2017_11_01.operations.UsagesOperations>`
           * 2018-01-01: :class:`UsagesOperations<azure.mgmt.network.v2018_01_01.operations.UsagesOperations>`
           * 2018-02-01: :class:`UsagesOperations<azure.mgmt.network.v2018_02_01.operations.UsagesOperations>`
           * 2018-04-01: :class:`UsagesOperations<azure.mgmt.network.v2018_04_01.operations.UsagesOperations>`
           * 2018-06-01: :class:`UsagesOperations<azure.mgmt.network.v2018_06_01.operations.UsagesOperations>`
           * 2018-07-01: :class:`UsagesOperations<azure.mgmt.network.v2018_07_01.operations.UsagesOperations>`
           * 2018-08-01: :class:`UsagesOperations<azure.mgmt.network.v2018_08_01.operations.UsagesOperations>`
           * 2018-10-01: :class:`UsagesOperations<azure.mgmt.network.v2018_10_01.operations.UsagesOperations>`
           * 2018-11-01: :class:`UsagesOperations<azure.mgmt.network.v2018_11_01.operations.UsagesOperations>`
           * 2018-12-01: :class:`UsagesOperations<azure.mgmt.network.v2018_12_01.operations.UsagesOperations>`
           * 2019-02-01: :class:`UsagesOperations<azure.mgmt.network.v2019_02_01.operations.UsagesOperations>`
           * 2019-04-01: :class:`UsagesOperations<azure.mgmt.network.v2019_04_01.operations.UsagesOperations>`
           * 2019-06-01: :class:`UsagesOperations<azure.mgmt.network.v2019_06_01.operations.UsagesOperations>`
           * 2019-07-01: :class:`UsagesOperations<azure.mgmt.network.v2019_07_01.operations.UsagesOperations>`
           * 2019-08-01: :class:`UsagesOperations<azure.mgmt.network.v2019_08_01.operations.UsagesOperations>`
           * 2019-09-01: :class:`UsagesOperations<azure.mgmt.network.v2019_09_01.operations.UsagesOperations>`
           * 2019-11-01: :class:`UsagesOperations<azure.mgmt.network.v2019_11_01.operations.UsagesOperations>`
           * 2019-12-01: :class:`UsagesOperations<azure.mgmt.network.v2019_12_01.operations.UsagesOperations>`
           * 2020-03-01: :class:`UsagesOperations<azure.mgmt.network.v2020_03_01.operations.UsagesOperations>`
           * 2020-04-01: :class:`UsagesOperations<azure.mgmt.network.v2020_04_01.operations.UsagesOperations>`
           * 2020-05-01: :class:`UsagesOperations<azure.mgmt.network.v2020_05_01.operations.UsagesOperations>`
           * 2020-06-01: :class:`UsagesOperations<azure.mgmt.network.v2020_06_01.operations.UsagesOperations>`
           * 2020-07-01: :class:`UsagesOperations<azure.mgmt.network.v2020_07_01.operations.UsagesOperations>`
           * 2020-08-01: :class:`UsagesOperations<azure.mgmt.network.v2020_08_01.operations.UsagesOperations>`
           * 2020-11-01: :class:`UsagesOperations<azure.mgmt.network.v2020_11_01.operations.UsagesOperations>`
        """
        api_version = self._get_api_version('usages')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import UsagesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import UsagesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import UsagesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import UsagesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import UsagesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import UsagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'usages'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_appliance_sites(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`VirtualApplianceSitesOperations<azure.mgmt.network.v2020_05_01.operations.VirtualApplianceSitesOperations>`
           * 2020-06-01: :class:`VirtualApplianceSitesOperations<azure.mgmt.network.v2020_06_01.operations.VirtualApplianceSitesOperations>`
           * 2020-07-01: :class:`VirtualApplianceSitesOperations<azure.mgmt.network.v2020_07_01.operations.VirtualApplianceSitesOperations>`
           * 2020-08-01: :class:`VirtualApplianceSitesOperations<azure.mgmt.network.v2020_08_01.operations.VirtualApplianceSitesOperations>`
           * 2020-11-01: :class:`VirtualApplianceSitesOperations<azure.mgmt.network.v2020_11_01.operations.VirtualApplianceSitesOperations>`
        """
        api_version = self._get_api_version('virtual_appliance_sites')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualApplianceSitesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualApplianceSitesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualApplianceSitesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualApplianceSitesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualApplianceSitesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_appliance_sites'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_appliance_skus(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`VirtualApplianceSkusOperations<azure.mgmt.network.v2020_05_01.operations.VirtualApplianceSkusOperations>`
           * 2020-06-01: :class:`VirtualApplianceSkusOperations<azure.mgmt.network.v2020_06_01.operations.VirtualApplianceSkusOperations>`
           * 2020-07-01: :class:`VirtualApplianceSkusOperations<azure.mgmt.network.v2020_07_01.operations.VirtualApplianceSkusOperations>`
           * 2020-08-01: :class:`VirtualApplianceSkusOperations<azure.mgmt.network.v2020_08_01.operations.VirtualApplianceSkusOperations>`
           * 2020-11-01: :class:`VirtualApplianceSkusOperations<azure.mgmt.network.v2020_11_01.operations.VirtualApplianceSkusOperations>`
        """
        api_version = self._get_api_version('virtual_appliance_skus')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualApplianceSkusOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualApplianceSkusOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualApplianceSkusOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualApplianceSkusOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualApplianceSkusOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_appliance_skus'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hub_bgp_connection(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`VirtualHubBgpConnectionOperations<azure.mgmt.network.v2020_05_01.operations.VirtualHubBgpConnectionOperations>`
           * 2020-06-01: :class:`VirtualHubBgpConnectionOperations<azure.mgmt.network.v2020_06_01.operations.VirtualHubBgpConnectionOperations>`
           * 2020-07-01: :class:`VirtualHubBgpConnectionOperations<azure.mgmt.network.v2020_07_01.operations.VirtualHubBgpConnectionOperations>`
           * 2020-08-01: :class:`VirtualHubBgpConnectionOperations<azure.mgmt.network.v2020_08_01.operations.VirtualHubBgpConnectionOperations>`
           * 2020-11-01: :class:`VirtualHubBgpConnectionOperations<azure.mgmt.network.v2020_11_01.operations.VirtualHubBgpConnectionOperations>`
        """
        api_version = self._get_api_version('virtual_hub_bgp_connection')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualHubBgpConnectionOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualHubBgpConnectionOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualHubBgpConnectionOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualHubBgpConnectionOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualHubBgpConnectionOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_hub_bgp_connection'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hub_bgp_connections(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`VirtualHubBgpConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.VirtualHubBgpConnectionsOperations>`
           * 2020-06-01: :class:`VirtualHubBgpConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.VirtualHubBgpConnectionsOperations>`
           * 2020-07-01: :class:`VirtualHubBgpConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.VirtualHubBgpConnectionsOperations>`
           * 2020-08-01: :class:`VirtualHubBgpConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.VirtualHubBgpConnectionsOperations>`
           * 2020-11-01: :class:`VirtualHubBgpConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.VirtualHubBgpConnectionsOperations>`
        """
        api_version = self._get_api_version('virtual_hub_bgp_connections')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualHubBgpConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualHubBgpConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualHubBgpConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualHubBgpConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualHubBgpConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_hub_bgp_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hub_ip_configuration(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`VirtualHubIpConfigurationOperations<azure.mgmt.network.v2020_05_01.operations.VirtualHubIpConfigurationOperations>`
           * 2020-06-01: :class:`VirtualHubIpConfigurationOperations<azure.mgmt.network.v2020_06_01.operations.VirtualHubIpConfigurationOperations>`
           * 2020-07-01: :class:`VirtualHubIpConfigurationOperations<azure.mgmt.network.v2020_07_01.operations.VirtualHubIpConfigurationOperations>`
           * 2020-08-01: :class:`VirtualHubIpConfigurationOperations<azure.mgmt.network.v2020_08_01.operations.VirtualHubIpConfigurationOperations>`
           * 2020-11-01: :class:`VirtualHubIpConfigurationOperations<azure.mgmt.network.v2020_11_01.operations.VirtualHubIpConfigurationOperations>`
        """
        api_version = self._get_api_version('virtual_hub_ip_configuration')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualHubIpConfigurationOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualHubIpConfigurationOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualHubIpConfigurationOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualHubIpConfigurationOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualHubIpConfigurationOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_hub_ip_configuration'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hub_route_table_v2_s(self):
        """Instance depends on the API version:

           * 2019-09-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2019_09_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2019-11-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2019_11_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2019-12-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2019_12_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-03-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_03_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-04-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_04_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-05-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_05_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-06-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_06_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-07-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_07_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-08-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_08_01.operations.VirtualHubRouteTableV2SOperations>`
           * 2020-11-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_11_01.operations.VirtualHubRouteTableV2SOperations>`
        """
        api_version = self._get_api_version('virtual_hub_route_table_v2_s')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualHubRouteTableV2SOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_hub_route_table_v2_s'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hubs(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_04_01.operations.VirtualHubsOperations>`
           * 2018-06-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_06_01.operations.VirtualHubsOperations>`
           * 2018-07-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_07_01.operations.VirtualHubsOperations>`
           * 2018-08-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_08_01.operations.VirtualHubsOperations>`
           * 2018-10-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_10_01.operations.VirtualHubsOperations>`
           * 2018-11-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_11_01.operations.VirtualHubsOperations>`
           * 2018-12-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_12_01.operations.VirtualHubsOperations>`
           * 2019-02-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_02_01.operations.VirtualHubsOperations>`
           * 2019-04-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_04_01.operations.VirtualHubsOperations>`
           * 2019-06-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_06_01.operations.VirtualHubsOperations>`
           * 2019-07-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_07_01.operations.VirtualHubsOperations>`
           * 2019-08-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_08_01.operations.VirtualHubsOperations>`
           * 2019-09-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_09_01.operations.VirtualHubsOperations>`
           * 2019-11-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_11_01.operations.VirtualHubsOperations>`
           * 2019-12-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_12_01.operations.VirtualHubsOperations>`
           * 2020-03-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_03_01.operations.VirtualHubsOperations>`
           * 2020-04-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_04_01.operations.VirtualHubsOperations>`
           * 2020-05-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_05_01.operations.VirtualHubsOperations>`
           * 2020-06-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_06_01.operations.VirtualHubsOperations>`
           * 2020-07-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_07_01.operations.VirtualHubsOperations>`
           * 2020-08-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_08_01.operations.VirtualHubsOperations>`
           * 2020-11-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_11_01.operations.VirtualHubsOperations>`
        """
        api_version = self._get_api_version('virtual_hubs')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualHubsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualHubsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_hubs'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_gateway_connections(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-10-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_11_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-01-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_01_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-02-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_02_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-04-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_04_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_06_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-07-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_07_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_08_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-10-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_10_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_11_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-02-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-04-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-07-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-03-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-04-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-05-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-07-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.VirtualNetworkGatewayConnectionsOperations>`
        """
        api_version = self._get_api_version('virtual_network_gateway_connections')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_network_gateway_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworkGatewaysOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkGatewaysOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-10-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_11_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-01-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_01_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-02-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_02_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-04-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_04_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_06_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-07-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_07_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_08_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-10-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_10_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_11_01.operations.VirtualNetworkGatewaysOperations>`
           * 2018-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_12_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-02-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-04-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-07-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.VirtualNetworkGatewaysOperations>`
           * 2019-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-03-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-04-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-05-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-07-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.VirtualNetworkGatewaysOperations>`
           * 2020-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.VirtualNetworkGatewaysOperations>`
        """
        api_version = self._get_api_version('virtual_network_gateways')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_network_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_peerings(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkPeeringsOperations>`
           * 2016-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-03-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-10-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_11_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-01-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_01_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-02-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_02_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-04-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_04_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_06_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-07-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_07_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_08_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-10-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_10_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_11_01.operations.VirtualNetworkPeeringsOperations>`
           * 2018-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_12_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-02-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_02_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-04-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_04_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_06_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-07-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_07_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_08_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_09_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_11_01.operations.VirtualNetworkPeeringsOperations>`
           * 2019-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_12_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-03-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_03_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-04-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_04_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-05-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_05_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_06_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-07-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_07_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_08_01.operations.VirtualNetworkPeeringsOperations>`
           * 2020-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_11_01.operations.VirtualNetworkPeeringsOperations>`
        """
        api_version = self._get_api_version('virtual_network_peerings')
        if api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_network_peerings'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_taps(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_08_01.operations.VirtualNetworkTapsOperations>`
           * 2018-10-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_10_01.operations.VirtualNetworkTapsOperations>`
           * 2018-11-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_11_01.operations.VirtualNetworkTapsOperations>`
           * 2018-12-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_12_01.operations.VirtualNetworkTapsOperations>`
           * 2019-02-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_02_01.operations.VirtualNetworkTapsOperations>`
           * 2019-04-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_04_01.operations.VirtualNetworkTapsOperations>`
           * 2019-06-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_06_01.operations.VirtualNetworkTapsOperations>`
           * 2019-07-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_07_01.operations.VirtualNetworkTapsOperations>`
           * 2019-08-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_08_01.operations.VirtualNetworkTapsOperations>`
           * 2019-09-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_09_01.operations.VirtualNetworkTapsOperations>`
           * 2019-11-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_11_01.operations.VirtualNetworkTapsOperations>`
           * 2019-12-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_12_01.operations.VirtualNetworkTapsOperations>`
           * 2020-03-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_03_01.operations.VirtualNetworkTapsOperations>`
           * 2020-04-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_04_01.operations.VirtualNetworkTapsOperations>`
           * 2020-05-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_05_01.operations.VirtualNetworkTapsOperations>`
           * 2020-06-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_06_01.operations.VirtualNetworkTapsOperations>`
           * 2020-07-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_07_01.operations.VirtualNetworkTapsOperations>`
           * 2020-08-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_08_01.operations.VirtualNetworkTapsOperations>`
           * 2020-11-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_11_01.operations.VirtualNetworkTapsOperations>`
        """
        api_version = self._get_api_version('virtual_network_taps')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualNetworkTapsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_network_taps'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_networks(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworksOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworksOperations>`
           * 2016-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworksOperations>`
           * 2016-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworksOperations>`
           * 2017-03-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworksOperations>`
           * 2017-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworksOperations>`
           * 2017-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworksOperations>`
           * 2017-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworksOperations>`
           * 2017-10-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworksOperations>`
           * 2017-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_11_01.operations.VirtualNetworksOperations>`
           * 2018-01-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_01_01.operations.VirtualNetworksOperations>`
           * 2018-02-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_02_01.operations.VirtualNetworksOperations>`
           * 2018-04-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_04_01.operations.VirtualNetworksOperations>`
           * 2018-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_06_01.operations.VirtualNetworksOperations>`
           * 2018-07-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_07_01.operations.VirtualNetworksOperations>`
           * 2018-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_08_01.operations.VirtualNetworksOperations>`
           * 2018-10-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_10_01.operations.VirtualNetworksOperations>`
           * 2018-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_11_01.operations.VirtualNetworksOperations>`
           * 2018-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_12_01.operations.VirtualNetworksOperations>`
           * 2019-02-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_02_01.operations.VirtualNetworksOperations>`
           * 2019-04-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_04_01.operations.VirtualNetworksOperations>`
           * 2019-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_06_01.operations.VirtualNetworksOperations>`
           * 2019-07-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_07_01.operations.VirtualNetworksOperations>`
           * 2019-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_08_01.operations.VirtualNetworksOperations>`
           * 2019-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_09_01.operations.VirtualNetworksOperations>`
           * 2019-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_11_01.operations.VirtualNetworksOperations>`
           * 2019-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_12_01.operations.VirtualNetworksOperations>`
           * 2020-03-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_03_01.operations.VirtualNetworksOperations>`
           * 2020-04-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_04_01.operations.VirtualNetworksOperations>`
           * 2020-05-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_05_01.operations.VirtualNetworksOperations>`
           * 2020-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_06_01.operations.VirtualNetworksOperations>`
           * 2020-07-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_07_01.operations.VirtualNetworksOperations>`
           * 2020-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_08_01.operations.VirtualNetworksOperations>`
           * 2020-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_11_01.operations.VirtualNetworksOperations>`
        """
        api_version = self._get_api_version('virtual_networks')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualNetworksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_networks'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_router_peerings(self):
        """Instance depends on the API version:

           * 2019-07-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_07_01.operations.VirtualRouterPeeringsOperations>`
           * 2019-08-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_08_01.operations.VirtualRouterPeeringsOperations>`
           * 2019-09-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_09_01.operations.VirtualRouterPeeringsOperations>`
           * 2019-11-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_11_01.operations.VirtualRouterPeeringsOperations>`
           * 2019-12-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_12_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-03-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_03_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-04-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_04_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-05-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_05_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-06-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_06_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-07-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_07_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-08-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_08_01.operations.VirtualRouterPeeringsOperations>`
           * 2020-11-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_11_01.operations.VirtualRouterPeeringsOperations>`
        """
        api_version = self._get_api_version('virtual_router_peerings')
        if api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualRouterPeeringsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_router_peerings'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_routers(self):
        """Instance depends on the API version:

           * 2019-07-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_07_01.operations.VirtualRoutersOperations>`
           * 2019-08-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_08_01.operations.VirtualRoutersOperations>`
           * 2019-09-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_09_01.operations.VirtualRoutersOperations>`
           * 2019-11-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_11_01.operations.VirtualRoutersOperations>`
           * 2019-12-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_12_01.operations.VirtualRoutersOperations>`
           * 2020-03-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_03_01.operations.VirtualRoutersOperations>`
           * 2020-04-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_04_01.operations.VirtualRoutersOperations>`
           * 2020-05-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_05_01.operations.VirtualRoutersOperations>`
           * 2020-06-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_06_01.operations.VirtualRoutersOperations>`
           * 2020-07-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_07_01.operations.VirtualRoutersOperations>`
           * 2020-08-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_08_01.operations.VirtualRoutersOperations>`
           * 2020-11-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_11_01.operations.VirtualRoutersOperations>`
        """
        api_version = self._get_api_version('virtual_routers')
        if api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualRoutersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_routers'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_wans(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VirtualWANsOperations<azure.mgmt.network.v2018_04_01.operations.VirtualWANsOperations>`
           * 2018-06-01: :class:`VirtualWANsOperations<azure.mgmt.network.v2018_06_01.operations.VirtualWANsOperations>`
           * 2018-07-01: :class:`VirtualWANsOperations<azure.mgmt.network.v2018_07_01.operations.VirtualWANsOperations>`
           * 2018-08-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_08_01.operations.VirtualWansOperations>`
           * 2018-10-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_10_01.operations.VirtualWansOperations>`
           * 2018-11-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_11_01.operations.VirtualWansOperations>`
           * 2018-12-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_12_01.operations.VirtualWansOperations>`
           * 2019-02-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_02_01.operations.VirtualWansOperations>`
           * 2019-04-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_04_01.operations.VirtualWansOperations>`
           * 2019-06-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_06_01.operations.VirtualWansOperations>`
           * 2019-07-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_07_01.operations.VirtualWansOperations>`
           * 2019-08-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_08_01.operations.VirtualWansOperations>`
           * 2019-09-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_09_01.operations.VirtualWansOperations>`
           * 2019-11-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_11_01.operations.VirtualWansOperations>`
           * 2019-12-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_12_01.operations.VirtualWansOperations>`
           * 2020-03-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_03_01.operations.VirtualWansOperations>`
           * 2020-04-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_04_01.operations.VirtualWansOperations>`
           * 2020-05-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_05_01.operations.VirtualWansOperations>`
           * 2020-06-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_06_01.operations.VirtualWansOperations>`
           * 2020-07-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_07_01.operations.VirtualWansOperations>`
           * 2020-08-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_08_01.operations.VirtualWansOperations>`
           * 2020-11-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_11_01.operations.VirtualWansOperations>`
        """
        api_version = self._get_api_version('virtual_wans')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualWANsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualWANsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VirtualWANsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VirtualWansOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VirtualWansOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_wans'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_connections(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_04_01.operations.VpnConnectionsOperations>`
           * 2018-06-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_06_01.operations.VpnConnectionsOperations>`
           * 2018-07-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_07_01.operations.VpnConnectionsOperations>`
           * 2018-08-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_08_01.operations.VpnConnectionsOperations>`
           * 2018-10-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_10_01.operations.VpnConnectionsOperations>`
           * 2018-11-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_11_01.operations.VpnConnectionsOperations>`
           * 2018-12-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_12_01.operations.VpnConnectionsOperations>`
           * 2019-02-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_02_01.operations.VpnConnectionsOperations>`
           * 2019-04-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_04_01.operations.VpnConnectionsOperations>`
           * 2019-06-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.VpnConnectionsOperations>`
           * 2019-07-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.VpnConnectionsOperations>`
           * 2019-08-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.VpnConnectionsOperations>`
           * 2019-09-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.VpnConnectionsOperations>`
           * 2019-11-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.VpnConnectionsOperations>`
           * 2019-12-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.VpnConnectionsOperations>`
           * 2020-03-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.VpnConnectionsOperations>`
           * 2020-04-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.VpnConnectionsOperations>`
           * 2020-05-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.VpnConnectionsOperations>`
           * 2020-06-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.VpnConnectionsOperations>`
           * 2020-07-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.VpnConnectionsOperations>`
           * 2020-08-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.VpnConnectionsOperations>`
           * 2020-11-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.VpnConnectionsOperations>`
        """
        api_version = self._get_api_version('vpn_connections')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_gateways(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_04_01.operations.VpnGatewaysOperations>`
           * 2018-06-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_06_01.operations.VpnGatewaysOperations>`
           * 2018-07-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_07_01.operations.VpnGatewaysOperations>`
           * 2018-08-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_08_01.operations.VpnGatewaysOperations>`
           * 2018-10-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_10_01.operations.VpnGatewaysOperations>`
           * 2018-11-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_11_01.operations.VpnGatewaysOperations>`
           * 2018-12-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_12_01.operations.VpnGatewaysOperations>`
           * 2019-02-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_02_01.operations.VpnGatewaysOperations>`
           * 2019-04-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_04_01.operations.VpnGatewaysOperations>`
           * 2019-06-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_06_01.operations.VpnGatewaysOperations>`
           * 2019-07-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_07_01.operations.VpnGatewaysOperations>`
           * 2019-08-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_08_01.operations.VpnGatewaysOperations>`
           * 2019-09-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_09_01.operations.VpnGatewaysOperations>`
           * 2019-11-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_11_01.operations.VpnGatewaysOperations>`
           * 2019-12-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_12_01.operations.VpnGatewaysOperations>`
           * 2020-03-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_03_01.operations.VpnGatewaysOperations>`
           * 2020-04-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_04_01.operations.VpnGatewaysOperations>`
           * 2020-05-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_05_01.operations.VpnGatewaysOperations>`
           * 2020-06-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_06_01.operations.VpnGatewaysOperations>`
           * 2020-07-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_07_01.operations.VpnGatewaysOperations>`
           * 2020-08-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_08_01.operations.VpnGatewaysOperations>`
           * 2020-11-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_11_01.operations.VpnGatewaysOperations>`
        """
        api_version = self._get_api_version('vpn_gateways')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnGatewaysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_gateways'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_link_connections(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.VpnLinkConnectionsOperations>`
           * 2019-07-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.VpnLinkConnectionsOperations>`
           * 2019-08-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.VpnLinkConnectionsOperations>`
           * 2019-09-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.VpnLinkConnectionsOperations>`
           * 2019-11-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.VpnLinkConnectionsOperations>`
           * 2019-12-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.VpnLinkConnectionsOperations>`
           * 2020-03-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.VpnLinkConnectionsOperations>`
           * 2020-04-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.VpnLinkConnectionsOperations>`
           * 2020-05-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.VpnLinkConnectionsOperations>`
           * 2020-06-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.VpnLinkConnectionsOperations>`
           * 2020-07-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.VpnLinkConnectionsOperations>`
           * 2020-08-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.VpnLinkConnectionsOperations>`
           * 2020-11-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.VpnLinkConnectionsOperations>`
        """
        api_version = self._get_api_version('vpn_link_connections')
        if api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnLinkConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_link_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_server_configurations(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_08_01.operations.VpnServerConfigurationsOperations>`
           * 2019-09-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_09_01.operations.VpnServerConfigurationsOperations>`
           * 2019-11-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_11_01.operations.VpnServerConfigurationsOperations>`
           * 2019-12-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_12_01.operations.VpnServerConfigurationsOperations>`
           * 2020-03-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_03_01.operations.VpnServerConfigurationsOperations>`
           * 2020-04-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_04_01.operations.VpnServerConfigurationsOperations>`
           * 2020-05-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_05_01.operations.VpnServerConfigurationsOperations>`
           * 2020-06-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_06_01.operations.VpnServerConfigurationsOperations>`
           * 2020-07-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_07_01.operations.VpnServerConfigurationsOperations>`
           * 2020-08-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_08_01.operations.VpnServerConfigurationsOperations>`
           * 2020-11-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_11_01.operations.VpnServerConfigurationsOperations>`
        """
        api_version = self._get_api_version('vpn_server_configurations')
        if api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnServerConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_server_configurations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_server_configurations_associated_with_virtual_wan(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_08_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2019-09-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_09_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2019-11-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_11_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2019-12-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_12_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-03-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_03_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-04-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_04_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-05-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_05_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-06-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_06_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-07-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_07_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-08-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_08_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-11-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_11_01.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
        """
        api_version = self._get_api_version('vpn_server_configurations_associated_with_virtual_wan')
        if api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_server_configurations_associated_with_virtual_wan'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_site_link_connections(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_06_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2019-07-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_07_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2019-08-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_08_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2019-09-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_09_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2019-11-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_11_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2019-12-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_12_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-03-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_03_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-04-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_04_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-05-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_05_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-06-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_06_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-07-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_07_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-08-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_08_01.operations.VpnSiteLinkConnectionsOperations>`
           * 2020-11-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_11_01.operations.VpnSiteLinkConnectionsOperations>`
        """
        api_version = self._get_api_version('vpn_site_link_connections')
        if api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnSiteLinkConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_site_link_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_site_links(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_06_01.operations.VpnSiteLinksOperations>`
           * 2019-07-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_07_01.operations.VpnSiteLinksOperations>`
           * 2019-08-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_08_01.operations.VpnSiteLinksOperations>`
           * 2019-09-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_09_01.operations.VpnSiteLinksOperations>`
           * 2019-11-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_11_01.operations.VpnSiteLinksOperations>`
           * 2019-12-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_12_01.operations.VpnSiteLinksOperations>`
           * 2020-03-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_03_01.operations.VpnSiteLinksOperations>`
           * 2020-04-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_04_01.operations.VpnSiteLinksOperations>`
           * 2020-05-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_05_01.operations.VpnSiteLinksOperations>`
           * 2020-06-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_06_01.operations.VpnSiteLinksOperations>`
           * 2020-07-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_07_01.operations.VpnSiteLinksOperations>`
           * 2020-08-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_08_01.operations.VpnSiteLinksOperations>`
           * 2020-11-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_11_01.operations.VpnSiteLinksOperations>`
        """
        api_version = self._get_api_version('vpn_site_links')
        if api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnSiteLinksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_site_links'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_sites(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_04_01.operations.VpnSitesOperations>`
           * 2018-06-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_06_01.operations.VpnSitesOperations>`
           * 2018-07-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_07_01.operations.VpnSitesOperations>`
           * 2018-08-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_08_01.operations.VpnSitesOperations>`
           * 2018-10-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_10_01.operations.VpnSitesOperations>`
           * 2018-11-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_11_01.operations.VpnSitesOperations>`
           * 2018-12-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_12_01.operations.VpnSitesOperations>`
           * 2019-02-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_02_01.operations.VpnSitesOperations>`
           * 2019-04-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_04_01.operations.VpnSitesOperations>`
           * 2019-06-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_06_01.operations.VpnSitesOperations>`
           * 2019-07-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_07_01.operations.VpnSitesOperations>`
           * 2019-08-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_08_01.operations.VpnSitesOperations>`
           * 2019-09-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_09_01.operations.VpnSitesOperations>`
           * 2019-11-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_11_01.operations.VpnSitesOperations>`
           * 2019-12-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_12_01.operations.VpnSitesOperations>`
           * 2020-03-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_03_01.operations.VpnSitesOperations>`
           * 2020-04-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_04_01.operations.VpnSitesOperations>`
           * 2020-05-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_05_01.operations.VpnSitesOperations>`
           * 2020-06-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_06_01.operations.VpnSitesOperations>`
           * 2020-07-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_07_01.operations.VpnSitesOperations>`
           * 2020-08-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_08_01.operations.VpnSitesOperations>`
           * 2020-11-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_11_01.operations.VpnSitesOperations>`
        """
        api_version = self._get_api_version('vpn_sites')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnSitesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnSitesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_sites'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_sites_configuration(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_04_01.operations.VpnSitesConfigurationOperations>`
           * 2018-06-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_06_01.operations.VpnSitesConfigurationOperations>`
           * 2018-07-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_07_01.operations.VpnSitesConfigurationOperations>`
           * 2018-08-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_08_01.operations.VpnSitesConfigurationOperations>`
           * 2018-10-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_10_01.operations.VpnSitesConfigurationOperations>`
           * 2018-11-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_11_01.operations.VpnSitesConfigurationOperations>`
           * 2018-12-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_12_01.operations.VpnSitesConfigurationOperations>`
           * 2019-02-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_02_01.operations.VpnSitesConfigurationOperations>`
           * 2019-04-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_04_01.operations.VpnSitesConfigurationOperations>`
           * 2019-06-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_06_01.operations.VpnSitesConfigurationOperations>`
           * 2019-07-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_07_01.operations.VpnSitesConfigurationOperations>`
           * 2019-08-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_08_01.operations.VpnSitesConfigurationOperations>`
           * 2019-09-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_09_01.operations.VpnSitesConfigurationOperations>`
           * 2019-11-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_11_01.operations.VpnSitesConfigurationOperations>`
           * 2019-12-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_12_01.operations.VpnSitesConfigurationOperations>`
           * 2020-03-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_03_01.operations.VpnSitesConfigurationOperations>`
           * 2020-04-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_04_01.operations.VpnSitesConfigurationOperations>`
           * 2020-05-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_05_01.operations.VpnSitesConfigurationOperations>`
           * 2020-06-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_06_01.operations.VpnSitesConfigurationOperations>`
           * 2020-07-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_07_01.operations.VpnSitesConfigurationOperations>`
           * 2020-08-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_08_01.operations.VpnSitesConfigurationOperations>`
           * 2020-11-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_11_01.operations.VpnSitesConfigurationOperations>`
        """
        api_version = self._get_api_version('vpn_sites_configuration')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import VpnSitesConfigurationOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'vpn_sites_configuration'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def web_application_firewall_policies(self):
        """Instance depends on the API version:

           * 2018-12-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2018_12_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-02-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_02_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-04-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_04_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-06-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_06_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-07-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_07_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-08-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_08_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-09-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_09_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-11-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_11_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2019-12-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_12_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-03-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_03_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-04-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_04_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-05-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_05_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-06-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_06_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-07-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_07_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-08-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_08_01.operations.WebApplicationFirewallPoliciesOperations>`
           * 2020-11-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_11_01.operations.WebApplicationFirewallPoliciesOperations>`
        """
        api_version = self._get_api_version('web_application_firewall_policies')
        if api_version == '2018-12-01':
            from .v2018_12_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-07-01':
            from .v2020_07_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import WebApplicationFirewallPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'web_application_firewall_policies'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def web_categories(self):
        """Instance depends on the API version:

           * 2020-07-01: :class:`WebCategoriesOperations<azure.mgmt.network.v2020_07_01.operations.WebCategoriesOperations>`
           * 2020-08-01: :class:`WebCategoriesOperations<azure.mgmt.network.v2020_08_01.operations.WebCategoriesOperations>`
           * 2020-11-01: :class:`WebCategoriesOperations<azure.mgmt.network.v2020_11_01.operations.WebCategoriesOperations>`
        """
        api_version = self._get_api_version('web_categories')
        if api_version == '2020-07-01':
            from .v2020_07_01.operations import WebCategoriesOperations as OperationClass
        elif api_version == '2020-08-01':
            from .v2020_08_01.operations import WebCategoriesOperations as OperationClass
        elif api_version == '2020-11-01':
            from .v2020_11_01.operations import WebCategoriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'web_categories'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    def close(self):
        self._client.close()
    def __enter__(self):
        self._client.__enter__()
        return self
    def __exit__(self, *exc_details):
        self._client.__exit__(*exc_details)
