import logging
from io import IOBase
from typing import IO, Any, Iterator, List, Optional, Tuple

import requests
from botocore import ScalarTypes as ScalarTypes
from botocore.model import OperationModel

logger: logging.Logger

class StreamingBody(IOBase):
    def __init__(self, raw_stream: IO[bytes], content_length: int) -> None: ...
    def set_socket_timeout(self, timeout: float) -> None: ...
    def readable(self) -> bool: ...
    def read(self, amt: Optional[int] = ...) -> bytes: ...
    # FIXME: Signature of "readlines" incompatible with supertype "IOBase"
    def readlines(self) -> List[bytes]: ...  # type: ignore [override]
    def __iter__(self) -> Iterator[bytes]: ...
    def iter_lines(self, chunk_size: int = ..., keepends: bool = ...) -> Iterator[bytes]: ...
    def iter_chunks(self, chunk_size: int = ...) -> Iterator[bytes]: ...
    def tell(self) -> int: ...
    def close(self) -> None: ...
    def next(self) -> bytes: ...

def get_response(
    operation_model: OperationModel, http_response: requests.Response
) -> Tuple[requests.Response, Any]: ...
