In this Project I am Using YoloV4 for object detection. To detect object using YoloV4 and OpenCv you have to write many lines of code, but using this framework you can do this using few lines of code.

## Installation
```
pip install object_detector
```

## Extract Images from a video

Import `ExtractImages` class from `object_detector` Library

```python
>>> from object_detector import ExtractImages
```

Create a object `ext` of `ExtractImages` class

```python
>>> ext = ExtractImages(path=0)
```

`path=0` if you want to extract images from a video, write video path in place of 0.

or you can create object specifing Output path

```python
>>> ext = ExtractImages(path=0,op=MyOutput)
```
By default Output path is <b>Output</b>

### Start Extracting Images.

```python
>>> ext.extract("A","B","C")
```
A, B, C are the path where extracting images collected. Relative path of "A" is `MyOutput/A`

<b>Note:</b> We are extracting Images in multiple path such that we can run our object detection task simultaneously.

## Object Detection

Import `ObjectDetector` class from `object_detector` Library

```python
>>> from object_detector import ObjectDetector
```
Create a object `obj` of class ``ObjectDetector``

```python
>>> obj = ObjectDetector(weights="cars.weights", cfg="yolov4-custom.cfg", classes=['licence'])
```
Object detection is done using YoLo. ``cars.weights`` is the trained file generated by training image dataset by darknet, and we are using ``yolov4-custom.cfg``.

```python
>>> img = obj.detect_object(path)
```
Write path of the image, from which you want to detect object. 
`img` is numpy array of image. To the image from numpy array write

```python
>>> import cv2
>>> cv2.imshow("Image_Name",img)
```

or You can write
```python
>>> import matplotlib.pyplot as plt
>>> plt.imshow(img)
```

If you want image without label write the code as
```python
>>> img = obj.detect_object(path,label=False)
```

If you want to `img` only when obj is detected from image write the code as
```python
>>> img = detect_object(path,detected_only=True)
```
To read text on the image add following code
```python
>>> text = extract_text()
```

## Show or Write objects from a video or camera

Import LiveDetect class and make a object of this class.

```python
l = LiveDetect(weights="cars.weights", cfg="yolov4-custom.cfg", classes=['licence'])
```

Save images when object detect on video.
```python
l.write_from_video(path="Traffic.mp4")
```

Show images when object detect on video.
```python
l.show_from_video(path="Traffic.mp4")
```

Save images when object detect on the dir.
```python
l.write_from_dir(path="Traffic.mp4")
```

Show images when object detect on the dir.
```python
l.show_from_dir(path="Traffic.mp4")
```
