# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from paypalserversdk.configuration import Configuration
from paypalserversdk.controllers.base_controller import BaseController
from paypalserversdk.configuration import Environment
from paypalserversdk.http.auth.o_auth_2 import OAuth2
from paypalserversdk.controllers.orders_controller import OrdersController
from paypalserversdk.controllers.payments_controller import PaymentsController
from paypalserversdk.controllers.vault_controller import VaultController
from paypalserversdk.controllers.o_auth_authorization_controller\
    import OAuthAuthorizationController


class PaypalserversdkClient(object):
    @LazyProperty
    def orders(self):
        return OrdersController(self.global_configuration)

    @LazyProperty
    def payments(self):
        return PaymentsController(self.global_configuration)

    @LazyProperty
    def vault(self):
        return VaultController(self.global_configuration)

    @LazyProperty
    def o_auth_authorization(self):
        return OAuthAuthorizationController(self.global_configuration)

    @property
    def oauth_2(self):
        return self.auth_managers['Oauth2']

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=None, retry_methods=None,
                 logging_configuration=None, environment=Environment.SANDBOX,
                 client_credentials_auth_credentials=None, config=None):
        self.config = config or Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            logging_configuration=logging_configuration,
            environment=environment,
            client_credentials_auth_credentials=client_credentials_auth_credentials)

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())

        self.auth_managers = {key: None for key in ['Oauth2']}
        self.auth_managers['Oauth2'] = OAuth2(
            self.config.client_credentials_auth_credentials,
            self.global_configuration)
        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

