# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.address import Address
from paypalserversdk.models.name import Name
from paypalserversdk.models.phone_number import PhoneNumber
from paypalserversdk.models.venmo_wallet_attributes_response import VenmoWalletAttributesResponse


class VenmoWalletResponse(object):

    """Implementation of the 'Venmo Wallet Response' model.

    Venmo wallet response.

    Attributes:
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        account_id (str): The PayPal payer ID, which is a masked version of
            the PayPal account number intended for use with third parties. The
            account number is reversibly encrypted and a proprietary variant
            of Base32 is used to encode the result.
        user_name (str): The Venmo user name chosen by the user, also know as
            a Venmo handle.
        name (Name): The name of the party.
        phone_number (PhoneNumber): The phone number in its canonical
            international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en).
        address (Address): The portable international postal address. Maps to
            [AddressValidationMetadata](https://github.com/googlei18n/libaddres
            sinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling
            form controls: the autocomplete
            attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-
            form-controls-the-autocomplete-attribute).
        attributes (VenmoWalletAttributesResponse): Additional attributes
            associated with the use of a Venmo Wallet.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "email_address": 'email_address',
        "account_id": 'account_id',
        "user_name": 'user_name',
        "name": 'name',
        "phone_number": 'phone_number',
        "address": 'address',
        "attributes": 'attributes'
    }

    _optionals = [
        'email_address',
        'account_id',
        'user_name',
        'name',
        'phone_number',
        'address',
        'attributes',
    ]

    def __init__(self,
                 email_address=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 user_name=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 phone_number=APIHelper.SKIP,
                 address=APIHelper.SKIP,
                 attributes=APIHelper.SKIP):
        """Constructor for the VenmoWalletResponse class"""

        # Initialize members of the class
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if user_name is not APIHelper.SKIP:
            self.user_name = user_name 
        if name is not APIHelper.SKIP:
            self.name = name 
        if phone_number is not APIHelper.SKIP:
            self.phone_number = phone_number 
        if address is not APIHelper.SKIP:
            self.address = address 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        account_id = dictionary.get("account_id") if dictionary.get("account_id") else APIHelper.SKIP
        user_name = dictionary.get("user_name") if dictionary.get("user_name") else APIHelper.SKIP
        name = Name.from_dictionary(dictionary.get('name')) if 'name' in dictionary.keys() else APIHelper.SKIP
        phone_number = PhoneNumber.from_dictionary(dictionary.get('phone_number')) if 'phone_number' in dictionary.keys() else APIHelper.SKIP
        address = Address.from_dictionary(dictionary.get('address')) if 'address' in dictionary.keys() else APIHelper.SKIP
        attributes = VenmoWalletAttributesResponse.from_dictionary(dictionary.get('attributes')) if 'attributes' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(email_address,
                   account_id,
                   user_name,
                   name,
                   phone_number,
                   address,
                   attributes)
