# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.venmo_wallet_additional_attributes import VenmoWalletAdditionalAttributes
from paypalserversdk.models.venmo_wallet_experience_context import VenmoWalletExperienceContext


class VenmoWalletRequest(object):

    """Implementation of the 'Venmo Wallet Request' model.

    Information needed to pay using Venmo.

    Attributes:
        vault_id (str): The PayPal-generated ID for the vaulted payment
            source. This ID should be stored on the merchant's server so the
            saved payment source can be used for future transactions.
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        experience_context (VenmoWalletExperienceContext): Customizes the
            buyer experience during the approval process for payment with
            Venmo.<blockquote><strong>Note:</strong> Partners and Marketplaces
            might configure <code>shipping_preference</code> during partner
            account setup, which overrides the request values.</blockquote>
        attributes (VenmoWalletAdditionalAttributes): Additional attributes
            associated with the use of this Venmo Wallet.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "vault_id": 'vault_id',
        "email_address": 'email_address',
        "experience_context": 'experience_context',
        "attributes": 'attributes'
    }

    _optionals = [
        'vault_id',
        'email_address',
        'experience_context',
        'attributes',
    ]

    def __init__(self,
                 vault_id=APIHelper.SKIP,
                 email_address=APIHelper.SKIP,
                 experience_context=APIHelper.SKIP,
                 attributes=APIHelper.SKIP):
        """Constructor for the VenmoWalletRequest class"""

        # Initialize members of the class
        if vault_id is not APIHelper.SKIP:
            self.vault_id = vault_id 
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if experience_context is not APIHelper.SKIP:
            self.experience_context = experience_context 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        vault_id = dictionary.get("vault_id") if dictionary.get("vault_id") else APIHelper.SKIP
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        experience_context = VenmoWalletExperienceContext.from_dictionary(dictionary.get('experience_context')) if 'experience_context' in dictionary.keys() else APIHelper.SKIP
        attributes = VenmoWalletAdditionalAttributes.from_dictionary(dictionary.get('attributes')) if 'attributes' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(vault_id,
                   email_address,
                   experience_context,
                   attributes)
