# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class VenmoWalletExperienceContext(object):

    """Implementation of the 'Venmo Wallet Experience Context' model.

    Customizes the buyer experience during the approval process for payment
    with Venmo.<blockquote><strong>Note:</strong> Partners and Marketplaces
    might configure <code>shipping_preference</code> during partner account
    setup, which overrides the request values.</blockquote>

    Attributes:
        brand_name (str): The business name of the merchant. The pattern is
            defined by an external party and supports Unicode.
        shipping_preference (ShippingPreference): The location from which the
            shipping address is derived.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "brand_name": 'brand_name',
        "shipping_preference": 'shipping_preference'
    }

    _optionals = [
        'brand_name',
        'shipping_preference',
    ]

    def __init__(self,
                 brand_name=APIHelper.SKIP,
                 shipping_preference='GET_FROM_FILE'):
        """Constructor for the VenmoWalletExperienceContext class"""

        # Initialize members of the class
        if brand_name is not APIHelper.SKIP:
            self.brand_name = brand_name 
        self.shipping_preference = shipping_preference 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        brand_name = dictionary.get("brand_name") if dictionary.get("brand_name") else APIHelper.SKIP
        shipping_preference = dictionary.get("shipping_preference") if dictionary.get("shipping_preference") else 'GET_FROM_FILE'
        # Return an object of this model
        return cls(brand_name,
                   shipping_preference)
