# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class VaultInstructionBase(object):

    """Implementation of the 'Vault Instruction Base' model.

    Basic vault instruction specification that can be extended by specific
    payment sources that supports vaulting.

    Attributes:
        store_in_vault (StoreInVaultInstruction): Defines how and when the
            payment source gets vaulted.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "store_in_vault": 'store_in_vault'
    }

    _optionals = [
        'store_in_vault',
    ]

    def __init__(self,
                 store_in_vault=APIHelper.SKIP):
        """Constructor for the VaultInstructionBase class"""

        # Initialize members of the class
        if store_in_vault is not APIHelper.SKIP:
            self.store_in_vault = store_in_vault 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        store_in_vault = dictionary.get("store_in_vault") if dictionary.get("store_in_vault") else APIHelper.SKIP
        # Return an object of this model
        return cls(store_in_vault)
