# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class VaultExperienceContext(object):

    """Implementation of the 'Vault Experience Context' model.

    Customizes the Vault creation flow experience for your customers.

    Attributes:
        brand_name (str): The label that overrides the business name in the
            PayPal account on the PayPal site. The pattern is defined by an
            external party and supports Unicode.
        locale (str): The [language
            tag](https://tools.ietf.org/html/bcp47#section-2) for the language
            in which to localize the error-related strings, such as messages,
            issues, and suggested actions. The tag is made up of the [ISO
            639-2 language
            code](https://www.loc.gov/standards/iso639-2/php/code_list.php),
            the optional [ISO-15924 script
            tag](https://www.unicode.org/iso15924/codelists.html), and the
            [ISO-3166 alpha-2 country
            code](/api/rest/reference/country-codes/) or [M49 region
            code](https://unstats.un.org/unsd/methodology/m49/).
        return_url (str): The URL where the customer is redirected after
            customer approves leaves the flow. It is a required field for
            contingency flows like PayPal wallet, 3DS.
        cancel_url (str): The URL where the customer is redirected after
            customer cancels or leaves the flow. It is a required field for
            contingency flows like PayPal wallet, 3DS.
        shipping_preference (str): The shipping preference. This only applies
            to PayPal payment source.
        vault_instruction (str): Vault Instruction on action to be performed
            after a successful payer approval.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "brand_name": 'brand_name',
        "locale": 'locale',
        "return_url": 'return_url',
        "cancel_url": 'cancel_url',
        "shipping_preference": 'shipping_preference',
        "vault_instruction": 'vault_instruction'
    }

    _optionals = [
        'brand_name',
        'locale',
        'return_url',
        'cancel_url',
        'shipping_preference',
        'vault_instruction',
    ]

    def __init__(self,
                 brand_name=APIHelper.SKIP,
                 locale=APIHelper.SKIP,
                 return_url=APIHelper.SKIP,
                 cancel_url=APIHelper.SKIP,
                 shipping_preference='GET_FROM_FILE',
                 vault_instruction='ON_CREATE_PAYMENT_TOKENS'):
        """Constructor for the VaultExperienceContext class"""

        # Initialize members of the class
        if brand_name is not APIHelper.SKIP:
            self.brand_name = brand_name 
        if locale is not APIHelper.SKIP:
            self.locale = locale 
        if return_url is not APIHelper.SKIP:
            self.return_url = return_url 
        if cancel_url is not APIHelper.SKIP:
            self.cancel_url = cancel_url 
        self.shipping_preference = shipping_preference 
        self.vault_instruction = vault_instruction 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        brand_name = dictionary.get("brand_name") if dictionary.get("brand_name") else APIHelper.SKIP
        locale = dictionary.get("locale") if dictionary.get("locale") else APIHelper.SKIP
        return_url = dictionary.get("return_url") if dictionary.get("return_url") else APIHelper.SKIP
        cancel_url = dictionary.get("cancel_url") if dictionary.get("cancel_url") else APIHelper.SKIP
        shipping_preference = dictionary.get("shipping_preference") if dictionary.get("shipping_preference") else 'GET_FROM_FILE'
        vault_instruction = dictionary.get("vault_instruction") if dictionary.get("vault_instruction") else 'ON_CREATE_PAYMENT_TOKENS'
        # Return an object of this model
        return cls(brand_name,
                   locale,
                   return_url,
                   cancel_url,
                   shipping_preference,
                   vault_instruction)
