# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class ThreeDSecureAuthenticationResponse(object):

    """Implementation of the 'Three-D Secure Authentication Response' model.

    Results of 3D Secure Authentication.

    Attributes:
        authentication_status (PAResStatus): Transactions status result
            identifier. The outcome of the issuer's authentication.
        enrollment_status (EnrollmentStatus): Status of Authentication
            eligibility.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "authentication_status": 'authentication_status',
        "enrollment_status": 'enrollment_status'
    }

    _optionals = [
        'authentication_status',
        'enrollment_status',
    ]

    def __init__(self,
                 authentication_status=APIHelper.SKIP,
                 enrollment_status=APIHelper.SKIP):
        """Constructor for the ThreeDSecureAuthenticationResponse class"""

        # Initialize members of the class
        if authentication_status is not APIHelper.SKIP:
            self.authentication_status = authentication_status 
        if enrollment_status is not APIHelper.SKIP:
            self.enrollment_status = enrollment_status 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        authentication_status = dictionary.get("authentication_status") if dictionary.get("authentication_status") else APIHelper.SKIP
        enrollment_status = dictionary.get("enrollment_status") if dictionary.get("enrollment_status") else APIHelper.SKIP
        # Return an object of this model
        return cls(authentication_status,
                   enrollment_status)
