# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money


class ShippingOption(object):

    """Implementation of the 'Shipping Option' model.

    The options that the payee or merchant offers to the payer to ship or pick
    up their items.

    Attributes:
        id (str): A unique ID that identifies a payer-selected shipping
            option.
        label (str): A description that the payer sees, which helps them
            choose an appropriate shipping option. For example, `Free
            Shipping`, `USPS Priority Shipping`, `Expédition prioritaire
            USPS`, or `USPS yōuxiān fā huò`. Localize this description to the
            payer's locale.
        mtype (ShippingType): A classification for the method of purchase
            fulfillment.
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        selected (bool): If the API request sets `selected = true`, it
            represents the shipping option that the payee or merchant expects
            to be pre-selected for the payer when they first view the
            `shipping.options` in the PayPal Checkout experience. As part of
            the response if a `shipping.option` contains `selected=true`, it
            represents the shipping option that the payer selected during the
            course of checkout with PayPal. Only one `shipping.option` can be
            set to `selected=true`.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "label": 'label',
        "selected": 'selected',
        "mtype": 'type',
        "amount": 'amount'
    }

    _optionals = [
        'mtype',
        'amount',
    ]

    def __init__(self,
                 id=None,
                 label=None,
                 selected=None,
                 mtype=APIHelper.SKIP,
                 amount=APIHelper.SKIP):
        """Constructor for the ShippingOption class"""

        # Initialize members of the class
        self.id = id 
        self.label = label 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        self.selected = selected 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else None
        label = dictionary.get("label") if dictionary.get("label") else None
        selected = dictionary.get("selected") if "selected" in dictionary.keys() else None
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   label,
                   selected,
                   mtype,
                   amount)
