# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.pay_pal_payment_token import PayPalPaymentToken
from paypalserversdk.models.setup_token_response_card import SetupTokenResponseCard
from paypalserversdk.models.venmo_payment_token import VenmoPaymentToken


class SetupTokenResponsePaymentSource(object):

    """Implementation of the 'Setup Token Response Payment Source' model.

    The setup payment method details.

    Attributes:
        card (SetupTokenResponseCard): TODO: type description here.
        paypal (PayPalPaymentToken): TODO: type description here.
        venmo (VenmoPaymentToken): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card',
        "paypal": 'paypal',
        "venmo": 'venmo'
    }

    _optionals = [
        'card',
        'paypal',
        'venmo',
    ]

    def __init__(self,
                 card=APIHelper.SKIP,
                 paypal=APIHelper.SKIP,
                 venmo=APIHelper.SKIP):
        """Constructor for the SetupTokenResponsePaymentSource class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 
        if paypal is not APIHelper.SKIP:
            self.paypal = paypal 
        if venmo is not APIHelper.SKIP:
            self.venmo = venmo 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = SetupTokenResponseCard.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        paypal = PayPalPaymentToken.from_dictionary(dictionary.get('paypal')) if 'paypal' in dictionary.keys() else APIHelper.SKIP
        venmo = VenmoPaymentToken.from_dictionary(dictionary.get('venmo')) if 'venmo' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(card,
                   paypal,
                   venmo)
