# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.customer_request import CustomerRequest
from paypalserversdk.models.link_description import LinkDescription
from paypalserversdk.models.setup_token_response_payment_source import SetupTokenResponsePaymentSource


class SetupTokenResponse(object):

    """Implementation of the 'Setup Token Response' model.

    Minimal representation of a cached setup token.

    Attributes:
        id (str): The PayPal-generated ID for the vault token.
        ordinal (int): Ordinal number for sorting.
        customer (CustomerRequest): Customer in merchant's or partner's system
            of records.
        status (str): The status of the payment token.
        payment_source (SetupTokenResponsePaymentSource): The setup payment
            method details.
        links (List[LinkDescription]): An array of related [HATEOAS
            links](/api/rest/responses/#hateoas).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "ordinal": 'ordinal',
        "customer": 'customer',
        "status": 'status',
        "payment_source": 'payment_source',
        "links": 'links'
    }

    _optionals = [
        'id',
        'ordinal',
        'customer',
        'status',
        'payment_source',
        'links',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 ordinal=APIHelper.SKIP,
                 customer=APIHelper.SKIP,
                 status='CREATED',
                 payment_source=APIHelper.SKIP,
                 links=APIHelper.SKIP):
        """Constructor for the SetupTokenResponse class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if ordinal is not APIHelper.SKIP:
            self.ordinal = ordinal 
        if customer is not APIHelper.SKIP:
            self.customer = customer 
        self.status = status 
        if payment_source is not APIHelper.SKIP:
            self.payment_source = payment_source 
        if links is not APIHelper.SKIP:
            self.links = links 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        ordinal = dictionary.get("ordinal") if dictionary.get("ordinal") else APIHelper.SKIP
        customer = CustomerRequest.from_dictionary(dictionary.get('customer')) if 'customer' in dictionary.keys() else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else 'CREATED'
        payment_source = SetupTokenResponsePaymentSource.from_dictionary(dictionary.get('payment_source')) if 'payment_source' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [LinkDescription.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   ordinal,
                   customer,
                   status,
                   payment_source,
                   links)
