# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.setup_token_request_card import SetupTokenRequestCard
from paypalserversdk.models.vault_pay_pal_wallet_request import VaultPayPalWalletRequest
from paypalserversdk.models.vault_token_request import VaultTokenRequest
from paypalserversdk.models.vault_venmo_request import VaultVenmoRequest


class SetupTokenRequestPaymentSource(object):

    """Implementation of the 'Setup Token Request Payment Source' model.

    The payment method to vault with the instrument details.

    Attributes:
        card (SetupTokenRequestCard): A Resource representing a request to
            vault a Card.
        paypal (VaultPayPalWalletRequest): A resource representing a request
            to vault PayPal Wallet.
        venmo (VaultVenmoRequest): TODO: type description here.
        token (VaultTokenRequest): The Tokenized Payment Source representing a
            Request to Vault a Token.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card',
        "paypal": 'paypal',
        "venmo": 'venmo',
        "token": 'token'
    }

    _optionals = [
        'card',
        'paypal',
        'venmo',
        'token',
    ]

    def __init__(self,
                 card=APIHelper.SKIP,
                 paypal=APIHelper.SKIP,
                 venmo=APIHelper.SKIP,
                 token=APIHelper.SKIP):
        """Constructor for the SetupTokenRequestPaymentSource class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 
        if paypal is not APIHelper.SKIP:
            self.paypal = paypal 
        if venmo is not APIHelper.SKIP:
            self.venmo = venmo 
        if token is not APIHelper.SKIP:
            self.token = token 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = SetupTokenRequestCard.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        paypal = VaultPayPalWalletRequest.from_dictionary(dictionary.get('paypal')) if 'paypal' in dictionary.keys() else APIHelper.SKIP
        venmo = VaultVenmoRequest.from_dictionary(dictionary.get('venmo')) if 'venmo' in dictionary.keys() else APIHelper.SKIP
        token = VaultTokenRequest.from_dictionary(dictionary.get('token')) if 'token' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(card,
                   paypal,
                   venmo,
                   token)
