# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.address import Address
from paypalserversdk.models.setup_token_card_experience_context import SetupTokenCardExperienceContext


class SetupTokenRequestCard(object):

    """Implementation of the 'Setup Token Request Card' model.

    A Resource representing a request to vault a Card.

    Attributes:
        name (str): The card holder's name as it appears on the card.
        number (str): The primary account number (PAN) for the payment card.
        expiry (str): The year and month, in ISO-8601 `YYYY-MM` date format.
            See [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6).
        security_code (str): The three- or four-digit security code of the
            card. Also known as the CVV, CVC, CVN, CVE, or CID. This parameter
            cannot be present in the request when
            `payment_initiator=MERCHANT`.
        brand (CardBrand): The card network or brand. Applies to credit,
            debit, gift, and payment cards.
        billing_address (Address): The portable international postal address.
            Maps to
            [AddressValidationMetadata](https://github.com/googlei18n/libaddres
            sinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling
            form controls: the autocomplete
            attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-
            form-controls-the-autocomplete-attribute).
        verification_method (str): The verification method of the card.
        experience_context (SetupTokenCardExperienceContext): Customizes the
            Vault creation flow experience for your customers.
        network_transaction_reference (object): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "number": 'number',
        "expiry": 'expiry',
        "security_code": 'security_code',
        "brand": 'brand',
        "billing_address": 'billing_address',
        "verification_method": 'verification_method',
        "experience_context": 'experience_context',
        "network_transaction_reference": 'network_transaction_reference'
    }

    _optionals = [
        'name',
        'number',
        'expiry',
        'security_code',
        'brand',
        'billing_address',
        'verification_method',
        'experience_context',
        'network_transaction_reference',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 number=APIHelper.SKIP,
                 expiry=APIHelper.SKIP,
                 security_code=APIHelper.SKIP,
                 brand=APIHelper.SKIP,
                 billing_address=APIHelper.SKIP,
                 verification_method=APIHelper.SKIP,
                 experience_context=APIHelper.SKIP,
                 network_transaction_reference=APIHelper.SKIP):
        """Constructor for the SetupTokenRequestCard class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if number is not APIHelper.SKIP:
            self.number = number 
        if expiry is not APIHelper.SKIP:
            self.expiry = expiry 
        if security_code is not APIHelper.SKIP:
            self.security_code = security_code 
        if brand is not APIHelper.SKIP:
            self.brand = brand 
        if billing_address is not APIHelper.SKIP:
            self.billing_address = billing_address 
        if verification_method is not APIHelper.SKIP:
            self.verification_method = verification_method 
        if experience_context is not APIHelper.SKIP:
            self.experience_context = experience_context 
        if network_transaction_reference is not APIHelper.SKIP:
            self.network_transaction_reference = network_transaction_reference 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        number = dictionary.get("number") if dictionary.get("number") else APIHelper.SKIP
        expiry = dictionary.get("expiry") if dictionary.get("expiry") else APIHelper.SKIP
        security_code = dictionary.get("security_code") if dictionary.get("security_code") else APIHelper.SKIP
        brand = dictionary.get("brand") if dictionary.get("brand") else APIHelper.SKIP
        billing_address = Address.from_dictionary(dictionary.get('billing_address')) if 'billing_address' in dictionary.keys() else APIHelper.SKIP
        verification_method = dictionary.get("verification_method") if dictionary.get("verification_method") else APIHelper.SKIP
        experience_context = SetupTokenCardExperienceContext.from_dictionary(dictionary.get('experience_context')) if 'experience_context' in dictionary.keys() else APIHelper.SKIP
        network_transaction_reference = dictionary.get("network_transaction_reference") if dictionary.get("network_transaction_reference") else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   number,
                   expiry,
                   security_code,
                   brand,
                   billing_address,
                   verification_method,
                   experience_context,
                   network_transaction_reference)
