# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class SellerProtection(object):

    """Implementation of the 'Seller Protection' model.

    The level of protection offered as defined by [PayPal Seller Protection
    for
    Merchants](https://www.paypal.com/us/webapps/mpp/security/seller-protection
    ).

    Attributes:
        status (SellerProtectionStatus): Indicates whether the transaction is
            eligible for seller protection. For information, see [PayPal
            Seller Protection for
            Merchants](https://www.paypal.com/us/webapps/mpp/security/seller-pr
            otection).
        dispute_categories (List[DisputeCategory]): An array of conditions
            that are covered for the transaction.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "dispute_categories": 'dispute_categories'
    }

    _optionals = [
        'status',
        'dispute_categories',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 dispute_categories=APIHelper.SKIP):
        """Constructor for the SellerProtection class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if dispute_categories is not APIHelper.SKIP:
            self.dispute_categories = dispute_categories 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        dispute_categories = dictionary.get("dispute_categories") if dictionary.get("dispute_categories") else APIHelper.SKIP
        # Return an object of this model
        return cls(status,
                   dispute_categories)
