# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money
from paypalserversdk.models.net_amount_breakdown_item import NetAmountBreakdownItem
from paypalserversdk.models.platform_fee import PlatformFee


class SellerPayableBreakdown(object):

    """Implementation of the 'Seller Payable Breakdown' model.

    The breakdown of the refund.

    Attributes:
        gross_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        paypal_fee (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        paypal_fee_in_receivable_currency (Money): The currency and amount for
            a financial transaction, such as a balance or payment due.
        net_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        net_amount_in_receivable_currency (Money): The currency and amount for
            a financial transaction, such as a balance or payment due.
        platform_fees (List[PlatformFee]): An array of platform or partner
            fees, commissions, or brokerage fees for the refund.
        net_amount_breakdown (List[NetAmountBreakdownItem]): An array of
            breakdown values for the net amount. Returned when the currency of
            the refund is different from the currency of the PayPal account
            where the payee holds their funds.
        total_refunded_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "gross_amount": 'gross_amount',
        "paypal_fee": 'paypal_fee',
        "paypal_fee_in_receivable_currency": 'paypal_fee_in_receivable_currency',
        "net_amount": 'net_amount',
        "net_amount_in_receivable_currency": 'net_amount_in_receivable_currency',
        "platform_fees": 'platform_fees',
        "net_amount_breakdown": 'net_amount_breakdown',
        "total_refunded_amount": 'total_refunded_amount'
    }

    _optionals = [
        'gross_amount',
        'paypal_fee',
        'paypal_fee_in_receivable_currency',
        'net_amount',
        'net_amount_in_receivable_currency',
        'platform_fees',
        'net_amount_breakdown',
        'total_refunded_amount',
    ]

    def __init__(self,
                 gross_amount=APIHelper.SKIP,
                 paypal_fee=APIHelper.SKIP,
                 paypal_fee_in_receivable_currency=APIHelper.SKIP,
                 net_amount=APIHelper.SKIP,
                 net_amount_in_receivable_currency=APIHelper.SKIP,
                 platform_fees=APIHelper.SKIP,
                 net_amount_breakdown=APIHelper.SKIP,
                 total_refunded_amount=APIHelper.SKIP):
        """Constructor for the SellerPayableBreakdown class"""

        # Initialize members of the class
        if gross_amount is not APIHelper.SKIP:
            self.gross_amount = gross_amount 
        if paypal_fee is not APIHelper.SKIP:
            self.paypal_fee = paypal_fee 
        if paypal_fee_in_receivable_currency is not APIHelper.SKIP:
            self.paypal_fee_in_receivable_currency = paypal_fee_in_receivable_currency 
        if net_amount is not APIHelper.SKIP:
            self.net_amount = net_amount 
        if net_amount_in_receivable_currency is not APIHelper.SKIP:
            self.net_amount_in_receivable_currency = net_amount_in_receivable_currency 
        if platform_fees is not APIHelper.SKIP:
            self.platform_fees = platform_fees 
        if net_amount_breakdown is not APIHelper.SKIP:
            self.net_amount_breakdown = net_amount_breakdown 
        if total_refunded_amount is not APIHelper.SKIP:
            self.total_refunded_amount = total_refunded_amount 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        gross_amount = Money.from_dictionary(dictionary.get('gross_amount')) if 'gross_amount' in dictionary.keys() else APIHelper.SKIP
        paypal_fee = Money.from_dictionary(dictionary.get('paypal_fee')) if 'paypal_fee' in dictionary.keys() else APIHelper.SKIP
        paypal_fee_in_receivable_currency = Money.from_dictionary(dictionary.get('paypal_fee_in_receivable_currency')) if 'paypal_fee_in_receivable_currency' in dictionary.keys() else APIHelper.SKIP
        net_amount = Money.from_dictionary(dictionary.get('net_amount')) if 'net_amount' in dictionary.keys() else APIHelper.SKIP
        net_amount_in_receivable_currency = Money.from_dictionary(dictionary.get('net_amount_in_receivable_currency')) if 'net_amount_in_receivable_currency' in dictionary.keys() else APIHelper.SKIP
        platform_fees = None
        if dictionary.get('platform_fees') is not None:
            platform_fees = [PlatformFee.from_dictionary(x) for x in dictionary.get('platform_fees')]
        else:
            platform_fees = APIHelper.SKIP
        net_amount_breakdown = None
        if dictionary.get('net_amount_breakdown') is not None:
            net_amount_breakdown = [NetAmountBreakdownItem.from_dictionary(x) for x in dictionary.get('net_amount_breakdown')]
        else:
            net_amount_breakdown = APIHelper.SKIP
        total_refunded_amount = Money.from_dictionary(dictionary.get('total_refunded_amount')) if 'total_refunded_amount' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(gross_amount,
                   paypal_fee,
                   paypal_fee_in_receivable_currency,
                   net_amount,
                   net_amount_in_receivable_currency,
                   platform_fees,
                   net_amount_breakdown,
                   total_refunded_amount)
