# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class RelatedIdentifiers(object):

    """Implementation of the 'Related Identifiers' model.

    Identifiers related to a specific resource.

    Attributes:
        order_id (str): Order ID related to the resource.
        authorization_id (str): Authorization ID related to the resource.
        capture_id (str): Capture ID related to the resource.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "order_id": 'order_id',
        "authorization_id": 'authorization_id',
        "capture_id": 'capture_id'
    }

    _optionals = [
        'order_id',
        'authorization_id',
        'capture_id',
    ]

    def __init__(self,
                 order_id=APIHelper.SKIP,
                 authorization_id=APIHelper.SKIP,
                 capture_id=APIHelper.SKIP):
        """Constructor for the RelatedIdentifiers class"""

        # Initialize members of the class
        if order_id is not APIHelper.SKIP:
            self.order_id = order_id 
        if authorization_id is not APIHelper.SKIP:
            self.authorization_id = authorization_id 
        if capture_id is not APIHelper.SKIP:
            self.capture_id = capture_id 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        order_id = dictionary.get("order_id") if dictionary.get("order_id") else APIHelper.SKIP
        authorization_id = dictionary.get("authorization_id") if dictionary.get("authorization_id") else APIHelper.SKIP
        capture_id = dictionary.get("capture_id") if dictionary.get("capture_id") else APIHelper.SKIP
        # Return an object of this model
        return cls(order_id,
                   authorization_id,
                   capture_id)
