# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money
from paypalserversdk.models.refund_payment_instruction import RefundPaymentInstruction


class RefundRequest(object):

    """Implementation of the 'Refund Request' model.

    Refunds a captured payment, by ID. For a full refund, include an empty
    request body. For a partial refund, include an <code>amount</code> object
    in the request body.

    Attributes:
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        custom_id (str): The API caller-provided external ID. Used to
            reconcile API caller-initiated transactions with PayPal
            transactions. Appears in transaction and settlement reports. The
            pattern is defined by an external party and supports Unicode.
        invoice_id (str): The API caller-provided external invoice ID for this
            order. The pattern is defined by an external party and supports
            Unicode.
        note_to_payer (str): The reason for the refund. Appears in both the
            payer's transaction history and the emails that the payer
            receives. The pattern is defined by an external party and supports
            Unicode.
        payment_instruction (RefundPaymentInstruction): Any additional
            payments instructions during refund payment processing. This
            object is only applicable to merchants that have been enabled for
            PayPal Commerce Platform for Marketplaces and Platforms
            capability. Please speak to your account manager if you want to
            use this capability.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "amount": 'amount',
        "custom_id": 'custom_id',
        "invoice_id": 'invoice_id',
        "note_to_payer": 'note_to_payer',
        "payment_instruction": 'payment_instruction'
    }

    _optionals = [
        'amount',
        'custom_id',
        'invoice_id',
        'note_to_payer',
        'payment_instruction',
    ]

    def __init__(self,
                 amount=APIHelper.SKIP,
                 custom_id=APIHelper.SKIP,
                 invoice_id=APIHelper.SKIP,
                 note_to_payer=APIHelper.SKIP,
                 payment_instruction=APIHelper.SKIP):
        """Constructor for the RefundRequest class"""

        # Initialize members of the class
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if custom_id is not APIHelper.SKIP:
            self.custom_id = custom_id 
        if invoice_id is not APIHelper.SKIP:
            self.invoice_id = invoice_id 
        if note_to_payer is not APIHelper.SKIP:
            self.note_to_payer = note_to_payer 
        if payment_instruction is not APIHelper.SKIP:
            self.payment_instruction = payment_instruction 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        custom_id = dictionary.get("custom_id") if dictionary.get("custom_id") else APIHelper.SKIP
        invoice_id = dictionary.get("invoice_id") if dictionary.get("invoice_id") else APIHelper.SKIP
        note_to_payer = dictionary.get("note_to_payer") if dictionary.get("note_to_payer") else APIHelper.SKIP
        payment_instruction = RefundPaymentInstruction.from_dictionary(dictionary.get('payment_instruction')) if 'payment_instruction' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(amount,
                   custom_id,
                   invoice_id,
                   note_to_payer,
                   payment_instruction)
