# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.refund_platform_fee import RefundPlatformFee


class RefundPaymentInstruction(object):

    """Implementation of the 'Refund Payment Instruction' model.

    Any additional payments instructions during refund payment processing.
    This object is only applicable to merchants that have been enabled for
    PayPal Commerce Platform for Marketplaces and Platforms capability. Please
    speak to your account manager if you want to use this capability.

    Attributes:
        platform_fees (List[RefundPlatformFee]): Specifies the amount that the
            API caller will contribute to the refund being processed. The
            amount needs to be lower than platform_fees amount originally
            captured or the amount that is remaining if multiple refunds have
            been processed. This field is only applicable to merchants that
            have been enabled for PayPal Commerce Platform for Marketplaces
            and Platforms capability. Please speak to your account manager if
            you want to use this capability.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "platform_fees": 'platform_fees'
    }

    _optionals = [
        'platform_fees',
    ]

    def __init__(self,
                 platform_fees=APIHelper.SKIP):
        """Constructor for the RefundPaymentInstruction class"""

        # Initialize members of the class
        if platform_fees is not APIHelper.SKIP:
            self.platform_fees = platform_fees 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        platform_fees = None
        if dictionary.get('platform_fees') is not None:
            platform_fees = [RefundPlatformFee.from_dictionary(x) for x in dictionary.get('platform_fees')]
        else:
            platform_fees = APIHelper.SKIP
        # Return an object of this model
        return cls(platform_fees)
