# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.link_description import LinkDescription
from paypalserversdk.models.money import Money
from paypalserversdk.models.payee_base import PayeeBase
from paypalserversdk.models.refund_status_details import RefundStatusDetails
from paypalserversdk.models.seller_payable_breakdown import SellerPayableBreakdown


class Refund(object):

    """Implementation of the 'Refund' model.

    The refund information.

    Attributes:
        status (RefundStatus): The status of the refund.
        status_details (RefundStatusDetails): The details of the refund
            status.
        id (str): The PayPal-generated ID for the refund.
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        invoice_id (str): The API caller-provided external invoice number for
            this order. Appears in both the payer's transaction history and
            the emails that the payer receives.
        custom_id (str): The API caller-provided external ID. Used to
            reconcile API caller-initiated transactions with PayPal
            transactions. Appears in transaction and settlement reports.
        acquirer_reference_number (str): Reference ID issued for the card
            transaction. This ID can be used to track the transaction across
            processors, card brands and issuing banks.
        note_to_payer (str): The reason for the refund. Appears in both the
            payer's transaction history and the emails that the payer
            receives.
        seller_payable_breakdown (SellerPayableBreakdown): The breakdown of
            the refund.
        payer (PayeeBase): The details for the merchant who receives the funds
            and fulfills the order. The merchant is also known as the payee.
        links (List[LinkDescription]): An array of related [HATEOAS
            links](/docs/api/reference/api-responses/#hateoas-links).
        create_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        update_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "status_details": 'status_details',
        "id": 'id',
        "amount": 'amount',
        "invoice_id": 'invoice_id',
        "custom_id": 'custom_id',
        "acquirer_reference_number": 'acquirer_reference_number',
        "note_to_payer": 'note_to_payer',
        "seller_payable_breakdown": 'seller_payable_breakdown',
        "payer": 'payer',
        "links": 'links',
        "create_time": 'create_time',
        "update_time": 'update_time'
    }

    _optionals = [
        'status',
        'status_details',
        'id',
        'amount',
        'invoice_id',
        'custom_id',
        'acquirer_reference_number',
        'note_to_payer',
        'seller_payable_breakdown',
        'payer',
        'links',
        'create_time',
        'update_time',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 status_details=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 invoice_id=APIHelper.SKIP,
                 custom_id=APIHelper.SKIP,
                 acquirer_reference_number=APIHelper.SKIP,
                 note_to_payer=APIHelper.SKIP,
                 seller_payable_breakdown=APIHelper.SKIP,
                 payer=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 create_time=APIHelper.SKIP,
                 update_time=APIHelper.SKIP):
        """Constructor for the Refund class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if status_details is not APIHelper.SKIP:
            self.status_details = status_details 
        if id is not APIHelper.SKIP:
            self.id = id 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if invoice_id is not APIHelper.SKIP:
            self.invoice_id = invoice_id 
        if custom_id is not APIHelper.SKIP:
            self.custom_id = custom_id 
        if acquirer_reference_number is not APIHelper.SKIP:
            self.acquirer_reference_number = acquirer_reference_number 
        if note_to_payer is not APIHelper.SKIP:
            self.note_to_payer = note_to_payer 
        if seller_payable_breakdown is not APIHelper.SKIP:
            self.seller_payable_breakdown = seller_payable_breakdown 
        if payer is not APIHelper.SKIP:
            self.payer = payer 
        if links is not APIHelper.SKIP:
            self.links = links 
        if create_time is not APIHelper.SKIP:
            self.create_time = create_time 
        if update_time is not APIHelper.SKIP:
            self.update_time = update_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        status_details = RefundStatusDetails.from_dictionary(dictionary.get('status_details')) if 'status_details' in dictionary.keys() else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        invoice_id = dictionary.get("invoice_id") if dictionary.get("invoice_id") else APIHelper.SKIP
        custom_id = dictionary.get("custom_id") if dictionary.get("custom_id") else APIHelper.SKIP
        acquirer_reference_number = dictionary.get("acquirer_reference_number") if dictionary.get("acquirer_reference_number") else APIHelper.SKIP
        note_to_payer = dictionary.get("note_to_payer") if dictionary.get("note_to_payer") else APIHelper.SKIP
        seller_payable_breakdown = SellerPayableBreakdown.from_dictionary(dictionary.get('seller_payable_breakdown')) if 'seller_payable_breakdown' in dictionary.keys() else APIHelper.SKIP
        payer = PayeeBase.from_dictionary(dictionary.get('payer')) if 'payer' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [LinkDescription.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        create_time = dictionary.get("create_time") if dictionary.get("create_time") else APIHelper.SKIP
        update_time = dictionary.get("update_time") if dictionary.get("update_time") else APIHelper.SKIP
        # Return an object of this model
        return cls(status,
                   status_details,
                   id,
                   amount,
                   invoice_id,
                   custom_id,
                   acquirer_reference_number,
                   note_to_payer,
                   seller_payable_breakdown,
                   payer,
                   links,
                   create_time,
                   update_time)
