# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money


class ReauthorizeRequest(object):

    """Implementation of the 'Reauthorize Request' model.

    Reauthorizes an authorized PayPal account payment, by ID. To ensure that
    funds are still available, reauthorize a payment after its initial
    three-day honor period expires. You can reauthorize a payment only once
    from days four to 29.<br/><br/>If 30 days have transpired since the date
    of the original authorization, you must create an authorized payment
    instead of reauthorizing the original authorized payment.<br/><br/>A
    reauthorized payment itself has a new honor period of three
    days.<br/><br/>You can reauthorize an authorized payment once. The allowed
    amount depends on context and geography, for example in US it is up to
    115% of the original authorized amount, not to exceed an increase of $75
    USD.<br/><br/>Supports only the `amount` request
    parameter.<blockquote><strong>Note:</strong> This request is currently not
    supported for Partner use cases.</blockquote>

    Attributes:
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "amount": 'amount'
    }

    _optionals = [
        'amount',
    ]

    def __init__(self,
                 amount=APIHelper.SKIP):
        """Constructor for the ReauthorizeRequest class"""

        # Initialize members of the class
        if amount is not APIHelper.SKIP:
            self.amount = amount 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(amount)
